<?php $__env->startSection('title', 'Evaluation par matière'); ?>
<?php $__env->startSection('link'); ?>
<!-- Data Table Css -->
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/css/buttons.dataTables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="//cdn.jsdelivr.net/npm/alertifyjs@1.13.1/build/css/alertify.min.css"/>
<link rel="stylesheet" href="//cdn.jsdelivr.net/npm/alertifyjs@1.13.1/build/css/themes/default.min.css"/>
<style>
    .dataTables_length label{
        display: none;
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="pcoded-inner-content">
    <?php echo $__env->make('includes._alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <form action="<?php echo e(route('moyenne.submit')); ?>" method="post" id="myForm">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="cutting" value="<?php echo e($cutting->id); ?>">
                                <input type="hidden" name="classe" value="<?php echo e($classe->id); ?>">
                                <div class="card-header">
                                    <div class="d-flex justify-content-between">
                                        <h4>Elèves Non Classés - <?php echo e(ucfirst($cutting->cutting->libelle)); ?></h4>
                                        <span class="form-control-variant" style="font-size: 15px">
                                            <strong class="mr-2"><?php echo e($classe['libelle']); ?> - <?php echo e($nombre <= 9 ? '0'.$nombre:$nombre); ?>/<?php echo e(count($datas) <= 9 ? '0'.count($datas):count($datas)); ?></strong>
                                        </span>
                                        <span>
                                            <button id="btnValid" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-1" title="Valider" data-toggle="modal" data-target="#validModal"><i class="fab fa-vaadin mx-0"></i></button>
                                            <a href="<?php echo e(route('moyenne.show',$classe['id'])); ?>" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-1" title="Return Back"><i class="fas fa-reply mx-0"></i></a>
                                        </span>
                                    </div>
                                </div>
                                <hr class="mx-3 my-0">
                                <div class="card-block">
                                    <div class="dt-responsive table-responsive">
                                        <div class="tab-content card-block">
                                            <table id="basic-col-reorder" class="table table-striped table-bordered nowrap">
                                                <thead>
                                                    <tr>
                                                        <th class="text-center" style="width: 3%">N°</th>
                                                        <th class="text-center">Nom</th>
                                                        <th class="text-center">Prénoms</th>
                                                        <th class="text-center">Sexe</th>
                                                        <th class="text-center">Matricule</th>
                                                        <th class="text-center">Statut</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $i = 1; ?>
                                                    <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <th class="text-center"><?php echo e($i <= 9 ? '0'.$i++:$i++); ?></th>
                                                        <td class="text-left"><?php echo e(Str::limit($item['first_name'], 30, '...')); ?></td>
                                                        <td class="text-left"><?php echo e(Str::limit($item['last_name'], 30, '...')); ?></td>
                                                        <td class="text-center"><?php echo e($item['sexe']); ?></td>
                                                        <td class="text-center"><?php echo e($item['matricule']); ?></td>
                                                        <th class="text-center">
                                                            <input type="checkbox" name="tags[]" id="<?php echo e($item['id']); ?>" value="<?php echo e($item['id']); ?>" <?php echo e($item['moyen'] == 'nc' ? 'checked disabled':null); ?>>
                                                        </th>
                                                    </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                            </table>
                                        </div> 
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Modal Delete Evaluation-->
<div class="modal fade" id="validModal" tabindex="-1" role="dialog" aria-labelledby="validModalTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header bg-dark py-2">
                <h5 class="modal-title" id="validModalLongTitle">Confirmed</h5>
                <h5 style="font-style: 17px"><?php echo e(ucfirst($cutting->cutting->libelle)); ?></h5>
            </div>
            <div class="modal-body py-3 text-center">
                <strong style="font-size: 16px">Mettre les élèves cochés non classés !</strong>
                <p class="text-center">Voulez-vous vraiment Valider ?</p>
            </div>
            <div class="modal-footer mt-1">
                <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</button>
                <button type="submit" id="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <!-- data-table js -->
    <script src="<?php echo e(asset('bower_components/datatables.net/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')); ?>"></script>
    <!-- Custom js -->
    <script src="//cdn.jsdelivr.net/npm/alertifyjs@1.13.1/build/alertify.min.js"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/colreorder/js/colreorder-custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pcoded.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vartical-layout.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.mCustomScrollbar.concat.min.js')); ?>"></script>
    <script>
        $(document).ready(function(){
            let table = $('#saving-reorder').DataTable();

            $('#btnValid').on('click', function(e) {
                e.preventDefault(); // Empêche l'envoi par défaut
            });

            $('#submit').click(function(){
                let tags = [];
                $('input[name="tags[]"]:checked').each(function() {
                    tags.push($(this).val());
                });
                if(tags.length){
                    // Rendre tous les éléments visibles temporairement pour que les champs soient inclus dans le formulaire
                    table.rows().every(function(rowIdx, tableLoop, rowLoop) {
                        var row = this.node();
                        if (!$(row).is(':visible')) {
                            $(row).find('input, select, textarea').each(function() {
                                var name = $(this).attr('name');
                                var value = $(this).val();
                                $('<input>').attr({
                                    type: 'hidden',
                                    name: name,
                                    value: value
                                }).appendTo('#myForm');
                            });
                        }
                    });

                    // Soumet le formulaire
                    $('#myForm').submit();
                }
                else{
                    alertify.error('Une erreur est survenue.');
                    $('div#validModal').modal('toggle');
                }
                
            })
        })
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\EDUCAS\Desktop\AppS\V4_001\resources\views\pages\moyenne\unclassified.blade.php ENDPATH**/ ?>