<?php $__env->startSection('title', 'School detail'); ?>
<?php $__env->startSection('link'); ?>
    <style>
        #fa-expand {
            font-size: 100px;
            animation: heartbeat 1s infinite;
            color: rgb(136, 134, 134) !important
        }

        @keyframes heartbeat {
            0% {
                transform: scale(1);
            }
            25% {
                transform: scale(1.2);
            }
            50% {
                transform: scale(1);
            }
            75% {
                transform: scale(1.1);
            }
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="pcoded-inner-content">
    <?php echo $__env->make('includes._alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="container">
                    <div class="card">
                        <?php if($school): ?>
                        <div class="card-block">
                            <div class="row invoice-contac px-2 py-4">
                                <div class="col-sm-2 text-center py-5">
                                    <h5 class="my-3">Logo</h5>
                                    <?php if($school->image): ?>
                                    <img src="<?php echo e(asset($school->logoUrl())); ?>" class="m-b-10 w-100" alt="Logo établissement">
                                    <?php else: ?>
                                    <span >Pas de logo</span>
                                    <?php endif; ?>
                                    <strong><?php echo e(ucfirst($school->getDren->libelle)); ?></strong>
                                </div>
                                <div class="col-sm-10">
                                    <div class="table-responsive">
                                        <table class="table table-bordered">
                                            <thead>
                                                <tr>
                                                    <th class="text-center">
                                                        <h4><?php echo e(ucfirst($school->school->name_school)); ?></h4>
                                                    </th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <table class="table table-striped table-bordered mt-0">
                                                        <tbody>
                                                            
                                                            <tr>
                                                                <td style="width: 350px"><span style="font-size: 14px">Code établissement</span></td>
                                                                <td><strong><?php echo e(ucfirst($school->school->code_school)); ?></strong></td>
                                                            </tr>
                                                            <tr>
                                                                <td style="width: 350px"><span style="font-size: 14px">Numéro autorisation</span></td>
                                                                <td><strong><?php echo e(ucfirst($school->school->num_autorisation)); ?></strong></td>
                                                            </tr>
                                                            <tr>
                                                                <td style="width: 350px"><span style="font-size: 14px">Adresse E-mail</span></td>
                                                                <td><strong><?php echo e($school->address_email); ?></strong></td>
                                                            </tr>
                                                            <tr>
                                                                <td style="width: 350px"><span style="font-size: 14px">Boîte postale</span></td>
                                                                <td><strong><?php echo e($school->addres_postal); ?></strong></td>
                                                            </tr>
                                                            <tr>
                                                                <td style="width: 350px"><span style="font-size: 14px">Téléphone</span></td>
                                                                <td><strong><?php echo e($school->phon_school); ?></strong></td>
                                                            </tr>
                                                            <?php if($school->address_iep): ?>
                                                            <tr>
                                                                <td style="width: 350px"><span style="font-size: 14px">EIP</span></td>
                                                                <td><strong><?php echo e($school->address_iep); ?></strong></td>
                                                            </tr>
                                                            <?php endif; ?>
                                                            <?php if($school->addictive_matter): ?>
                                                            <tr>
                                                                <td style="width: 350px"><span style="font-size: 14px">Matière addictionnel</span></td>
                                                                <td><strong>Oui</strong></td>
                                                            </tr>
                                                            <?php endif; ?>
                                                            <?php if($school->addictive_matter): ?>
                                                            <tr>
                                                                <td style="width: 350px"><span style="font-size: 14px">Classe avec des lettree</span></td>
                                                                <td><strong>Oui</strong></td>
                                                            </tr>
                                                            <?php endif; ?>
                                                            <?php if($school->transport): ?>
                                                            <tr>
                                                                <td style="width: 350px"><span style="font-size: 14px">Bus pour les élèves</span></td>
                                                                <td><strong>Oui</strong></td>
                                                            </tr>
                                                            <?php endif; ?>
                                                            <?php if($school->canteen): ?>
                                                            <tr>
                                                                <td style="width: 350px"><span style="font-size: 14px">Cantine scolaire</span></td>
                                                                <td><strong>Oui</strong></td>
                                                            </tr>
                                                            <?php endif; ?>
                                                            <tr>
                                                                <td style="width: 350px"><span style="font-size: 14px">Type d'enseignment</span></td>
                                                                <td><strong><?php echo e(getAffiche($school->school->typeEnseignements)); ?></strong></td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <!-- Invoice card end -->
                            <div class="row text-center">
                                <div class="col-sm-12 invoice-btn-group text-center">
                                    <a href="<?php echo e(route('setting.edit',$school->id)); ?>" class="btn btn-inverse btn-outline-inverse py-1"> <i class="fas fa-edit"></i> Modifications</a>
                                </div>
                            </div>
                        </div>
                        <?php else: ?>
                         <div class="text-center py-5">
                            <p class="text-center">
                                <i class="fas fa-expand" id="fa-expand"></i>
                            </p>
                            <h5 class="my-3">Passez au parametrage</h5>
                            <a href="<?php echo e(route('setting.create')); ?>" class="btn btn-inverse btn-outline-inverse py-1">Paramètrage</a>
                         </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script src="<?php echo e(asset('assets/js/pcoded.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/vartical-layout.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/jquery.mCustomScrollbar.concat.min.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\EDUCAS\Desktop\AppS\V4_001\resources\views/pages/setting/index.blade.php ENDPATH**/ ?>