<?php $__env->startSection('title', 'Detail parent eleve'); ?>
<?php $__env->startSection('content'); ?>
<div class="pcoded-inner-content">
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <?php echo $__env->make('includes._alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header mb-0 pb-0">
                                <div class="d-flex justify-content-between mb-2">
                                    <h4>Détail parent élève</h4>
                                    <span>
                                        <a href="<?php echo e(route('parent.index')); ?>" class="btn btn-inverse btn-outline-inverse  btn-sm py-1" title="Return back"><i class="fas fa-reply mx-0"></i></a>
                                    </span>
                                </div>
                            </div>
                            <hr class="my-0 mx-3">
                            <div class="card-body">
                                <div class="row py-3">
                                    <div class="col-sm-5 text-center pt-md-5">
                                        <i class="fas fa-user-tie" style="font-size: 80px"></i>
                                        <h4 class="mb-1 mt-2"><?php echo e(ucfirst($data->first_name).' '.ucfirst($data->last_name)); ?></h4>
                                        <p class="text-muted"><strong><?php echo e(ucfirst($data->profession)); ?></strong></p>
                                        <a href="<?php echo e(route('parent.edit',$data->id)); ?>" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 my-1"> <i class="fas fa-edit"></i> Editer</a>
                                    </div>
                                    <div class="col-sm-7">
                                        <div class="text-start mt-3">
                                            <table class="table table-bordered mt-0">
                                                <tbody>
                                                    <tr>
                                                        <td style="width: 250px"><span style="font-size: 14px">Nom</span></td>
                                                        <td><strong><?php echo e(mb_strtoupper($data->first_name)); ?></strong></td>
                                                    </tr>
                                                    <tr>
                                                        <td style="width: 250px"><span style="font-size: 14px">Prénoms</span></td>
                                                        <td><strong><?php echo e(ucfirst($data->last_name)); ?></strong></td>
                                                    </tr>
                                                    <tr>
                                                        <td style="width: 250px"><span style="font-size: 14px">Sexe</span></td>
                                                        <td><strong><?php echo e(ucfirst($data->sexe == 'H' ? 'Homme':'Femme')); ?></strong></td>
                                                    </tr>
                                                    <tr>
                                                        <td style="width: 250px"><span style="font-size: 14px">Profession</span></td>
                                                        <td><strong><?php echo e(ucfirst($data->profession)); ?></strong></td>
                                                    </tr>
                                                    <tr>
                                                        <td style="width: 250px"><span style="font-size: 14px">Numéro de téléphones</span></td>
                                                        <td><strong><?php echo e($data->telephon1); ?><?php echo e($data->telephon2 ? '/'.$data->telephon2:null); ?></strong></td>
                                                    </tr>
                                                    <tr>
                                                        <td style="width: 250px"><span style="font-size: 14px">Messagerie</span></td>
                                                        <td><strong><?php echo e(ucfirst($data->messagerie ? 'Oui':'Non')); ?></strong></td>
                                                    </tr>
                                                    <tr>
                                                        <td style="width: 250px"><span style="font-size: 14px">Disponibilité </span></td>
                                                        <td><strong><?php echo e(ucfirst($data->status ? 'Oui':'Non')); ?></strong></td>
                                                    </tr>
                                                   
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <h5 class="fs-10 text-uppercase">Elèves du parent</h5>
                                        <table class="table table-bordered mt-0">
                                            <thead>
                                                <tr>
                                                    <th class="text-center" style="width:15px">N°</th>
                                                    <th>Matricule</th>
                                                    <th>Nom</th>
                                                    <th>Prénoms</th>
                                                    <th>Genre</th>
                                                    <th>Cycle</th>
                                                    <th>Année arrivée</th>
                                                    <th>Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $i = 1; ?>
                                                <?php $__currentLoopData = $data->students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <th class="text-center"><?php echo e($i <= 9 ? '0'.$i++:$i++); ?></th>
                                                    <td><?php echo e($item->matricule); ?></td>
                                                    <td><?php echo e(ucwords($item->first_name)); ?></td>
                                                    <td><?php echo e(ucwords($item->last_name)); ?></td>
                                                    <td><?php echo e($item->sexe == 'F' ? ucfirst('Feminin'):ucfirst('Masculin')); ?></td>
                                                    <td><?php echo e(ucfirst($item->type)); ?></td>
                                                    <td><?php echo e($item->schoolYear->school_year); ?></td>
                                                    <td>
                                                        <div class="card-block remove-label m-0 p-0 text-center">
                                                            <a href="<?php echo e(route('student.show',$item->id)); ?>" class="btn btn-sm btn-primary text-center px-2" title="Detail élève"><i class="fas fa-ellipsis-h"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script src="<?php echo e(asset('assets/js/pcoded.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/vartical-layout.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/jquery.mCustomScrollbar.concat.min.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\EDUCAS\Desktop\AppS\V4_001\resources\views\pages\parent\detail.blade.php ENDPATH**/ ?>