<?php $__env->startSection('title', 'Evaluation par matière'); ?>
<?php $__env->startSection('link'); ?>
<!-- Data Table Css -->
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/css/buttons.dataTables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')); ?>">
<style>
    .dataTables_length label{
        display: none;
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="pcoded-inner-content">
    <?php echo $__env->make('includes._alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header">
                                <div class="d-flex justify-content-between">
                                    <h4>Détail des moyennes</h4>
                                    <span class="form-control-variant" style="font-size: 15px">
                                        <strong class="mr-2"><?php echo e($classe['libelle']); ?></strong>[<?php echo e($enseignant ? ($enseignant->user->sexe == "F" ? 'Mde. ':'Mr. ').strtoupper($enseignant->user->first_name).' '.ucwords($enseignant->user->last_name):'Non défini'); ?>]
                                    </span>
                                    <span>
                                        <button class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mx-1" id="btnEdit" title="Edit moyen..." data-toggle="modal" data-target="#editModal"><i class="fab fa-cloudsmith mx-0"></i></button>
                                        <a href="#" id="unclassified" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mx-1" title="unclassified"><i class="fab fa-sith mx-0"></i></a>
                                        <a href="#" id="download" target="_blank" class="btn btn-inverse btn-outline-inverse btn-sm py-1" title="Download pdf"><i class="fas fa-download mx-0"></i> </a>
                                        <a href="<?php echo e(route('moyenne.index')); ?>" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mx-1" title="Return Back"><i class="fas fa-reply mx-0"></i></a>
                                    </span>
                                </div>
                            </div>
                            <div class="card-block">
                                <div class="dt-responsive table-responsive">
                                    <ul class="nav nav-tabs md-tabs" role="tablist">
                                        <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="nav-item" style="width: 18%">
                                            <a class="nav-link text-left <?php echo e($item['actif'] == 1 ? 'active':''); ?>" data-lib="<?php echo e($item['libelle']); ?>" id="<?php echo e($item['actif'] == 1 ? 'active':'inactif'); ?>" data-actif="<?php echo e($item['actif']); ?>" data-id="<?php echo e($item['id']); ?>" data-toggle="tab" href="#home<?php echo e($item['id']); ?>" role="tab" aria-selected="true">
                                                <i class="icofont icofont-home"></i><?php echo e(ucfirst($item['libelle'])); ?>

                                            </a>
                                            <div class="slide" style="width: 16%"></div>
                                        </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                    <!-- Tab panes -->
                                    <div class="tab-content card-block">
                                        <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="tab-pane <?php echo e($item['actif'] == 1 ? 'active':''); ?>" id="home<?php echo e($item['id']); ?>" role="tabpanel">
                                            <table id="<?php echo e($item['tab']); ?>" class="table table-striped table-bordered nowrap">
                                                <thead>
                                                    <tr>
                                                        <th class="text-center" style="width: 3%">N°</th>
                                                        <th class="text-center">Nom & Prénoms</th>
                                                        <th class="text-center">Sexe</th>
                                                        <th class="text-center">Matricule</th>
                                                        <?php $__currentLoopData = $matters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $matter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <th class="text-center" title="<?php echo e($matter['libelle']); ?>"><?php echo e($matter['abbreviated'] ?? $matter['libelle']); ?></th>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        <th class="text-center" title="Moyenne">Moy</th>
                                                        <th class="text-center">Rang</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $i = 1; ?>
                                                    <?php $__currentLoopData = $item['data']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <th class="text-center"><?php echo e($i <= 9 ? '0'.$i++:$i++); ?></th>
                                                        <td class="text-left" title="<?php echo e($data['name']); ?>"><?php echo e(Str::limit($data['name'], 17, '...')); ?></td>
                                                        <td class="text-center"><?php echo e($data['sexe']); ?></td>
                                                        <td class="text-center"><?php echo e($data['matricule']); ?></td>
                                                        <?php $__currentLoopData = $data['moyens']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $moyen): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <td class="text-center"><?php echo e($moyen ? $moyen['moyenne']:'nc'); ?></td>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        <th class="text-center"><?php echo e($data['moyen']); ?></th>
                                                        <td class="text-center"><?php echo e($data['rang']); ?></td>
                                                    </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                            </table>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div> 
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<!-- Modal Delete Evaluation-->
<div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="editModalTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <form action="<?php echo e(route('moyenne.edit')); ?>" method="post">
            <?php echo csrf_field(); ?>
            <?php echo method_field('get'); ?>
            <div class="modal-header bg-dark py-2">
                <h5 class="modal-title" id="editModalLongTitle">Select one matter</h5>
                <span style="font-style: 17px" id="editTitle"></span>
            </div>
            <div class="modal-body py-3">
                <label for="matter">Select matter<span class="text-danger">*</span> :</label>
                <select name="matter" id="matter" class="form-control"required>
                    <option value="">Select one option</option>
                </select>
                <input type="hidden" name="cutting" value="" id="idCutting">
                <input type="hidden" name="classe" value="<?php echo e($classe['id']); ?>" id="idClasse">
            </div>
            <div class="modal-footer mt-2">
                <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</button>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
      </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <!-- data-table js -->
    <script src="<?php echo e(asset('bower_components/datatables.net/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')); ?>"></script>
    <!-- Custom js -->
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/colreorder/js/colreorder-custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pcoded.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vartical-layout.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.mCustomScrollbar.concat.min.js')); ?>"></script>
    <script>
        $(document).ready(function(){

            var url = window.location.href;
            const myArray = url.split("detail");

            $('#idCutting').val($("#active").data('id'));
            let vals = $('#idClasse').val()+'_'+$("#active").data('id');
            $('#download').attr('href', myArray[0]+'file/'+vals);
            $('#unclassified').attr('href', myArray[0]+'unclassified/'+vals);
            
            $('.nav-link').on('click', function(){
                $('#idCutting').val($(this).data('id'));
                let vals = $('#idClasse').val()+'_'+$(this).data('id');
                $('#download').attr('href', myArray[0]+'file/'+vals);
                $('#unclassified').attr('href', myArray[0]+'unclassified/'+vals);
            });


            $('#btnEdit').on('click', function() {
                $idClass = $('#idClasse').val(); $idCtting = $('#idCutting').val();
                $('.matters').remove();
                if($idClass && $idCtting){
                    $.ajax({
                        url: '<?php echo e(route('moyenne.matter')); ?>',
                        method: 'GET',
                        data: {
                            idClasse: $idClass,
                            idCutting: $idCtting
                        },
                        success: function(data){
                            $('#editTitle').text(data['cutting']);
                            console.log(data);
                            $i = 0;
                            while ($i < data['matters'].length) {
                                $mats = data['matters'][$i].abbreviated ?  (data['matters'][$i].abbreviated).toUpperCase():data['matters'][$i].libelle;
                                $('#matter').append('<option class="matters" value="'+data['matters'][$i].id+'" title="'+data['matters'][$i].libelle+'">'+$mats+'</option>');
                                $i++;
                            }
                        }
                    });
                }
            });
        })
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\EDUCAS\Desktop\AppS\V4_001\resources\views/pages/moyenne/detail.blade.php ENDPATH**/ ?>