<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Rapport De Rentree <?php echo e($year->school_year); ?></title>
</head>
<style type="text/css">
    @page {
        margin: 1.5cm 1cm 0.5cm 1cm; /* haut droite bas gauche */
    }
    body {
        margin: 0cm;
        padding: 0cm;
        font-family: sans-serif;
        font-size: 12px
    }
    footer{
        position: fixed;
        bottom: -30px;
        border-top: 2px solid gray;
        left: 0;
        right: 0;
        height: 50px;
        text-align: right;
        font-size: 12px;
        color: #555;
    }
</style>
<body>
    <header style="margin-top: 0%; margin-bottom: 30%">
        <table>
            <tbody>
                <tr>
                    <td>
                        <div class="bloc1" style="width: 70%; text-align: center;">
                            <p style="font-size: 14px; margin-bottom: 0%"><strong>MINISTERE DE L’EDUCATION NATIONALE ET DE L’ALPHABETISATION</strong></p>
                            <p style="margin-top:0%">....................</p>
                            <p style="font-size: 12px; margin-bottom: 0%"><?php echo e($school->school->name_school); ?></p>
                            <p style="margin-top:0%">....................................</p>

                            <p style="margin: 0%">
                                <img src="<?php echo e(public_path($school->logoUrl())); ?>" class="m-b-10 w-100" alt="Logo établissement" style="height: 55px;"><br>
                                <span><?php echo e($school->addres_postal); ?> (Cote d'Ivoire)</span><br>
                                <span>+225 <?php echo e($school->phon_school); ?></span><br>
                                <span><?php echo e($school->address_email); ?></span><br>
                            </p>
                        </div>
                    </td>

                    <td>
                        <div class="bloc2" style="width: 100%; text-align: center; padding-top: 30%">
                            <p>REPUBLIQUE DE COTE D'IVOIRE</p>
                            <p>Union - Discipline - Travail</p>
                            <img src="<?php echo e(public_path('assets/images/armoiries.png')); ?>" class="m-b-10 w-100" alt="armoirie ivoirienne" style="height: 55px;">
                            <p style="font-size: 15px; text-decoration: underline;">
                                <b>Année Scolaire <?php echo e($year->school_year); ?></b>
                            </p>
                        </div>
                    </td>
                </tr>
            </tbody>
        </table>
    </header>
    <section style="margin-top: 15%">
        <div style="margin: 1px auto; width: 90%; height: 70px; background: rgb(232, 233, 233); text-align:center; border: 1px solid grey; border-radius: 5px">
            <strong style="font-size: 50px; height: 100px; line-height: 1.3;">RAPPORT DE RENTREE</strong>
        </div>
    </section>
    <div style="margin-top: 30%">
        <div style="float: right; width: 350px; height: 150px; text-align:center">
            <p style="margin-bottom: 50px">
                <strong style="font-size: 17px; text-decoration: underline;">DIRECTEUR DES ETUDES</strong>
            </p>
            <p style="margin-top: 25%; font-size: 14px">
                <b><?php echo e($personnel['name_directeur']); ?></b>
            </p>
        </div>
    </div>
    <footer></footer>
</body>
</html>


<!--  2eme page du document -->
<!DOCTYPE html>
<html lang="fr">
<head>
   <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
</head>
<style type="text/css">
    @page {
        margin: 1.5cm 1cm 0.5cm 1cm; /* haut droite bas gauche */
    }
    body {
        margin: 0cm;
        padding: 0cm;
        font-family: sans-serif;
        font-size: 12px
    }
    footer{
        position: fixed;
        bottom: -30px;
        border-top: 2px solid gray;
        left: 0;
        right: 0;
        height: 50px;
        text-align: right;
        font-size: 12px;
        color: #555;
    }
</style>
<body>
    <header style="margin-top: 0%; margin-bottom: 30%">
        <div style="margin: 16px auto; padding: 7px; width: 250px; border: 2px solid; border-radius: 2px; text-align: center; line-height: 1.5;">
            <strong style="font-size: 30px">SOMMAIRE </strong>
        </div>
    </header>
    <section style="margin-top: 10%; margin-left: 3%; padding-right: 5px">
        <p style="font-size: 18px; font-weight: bold;">1- IDENTIFICATION...................................................................................................3</p>
        <p style="font-size: 18px; font-weight: bold; margin-top: 3%;">2- ORGANISATION MATERIELLE............................................................................4</p>
        <p style="font-size: 18px; font-weight: bold; margin-top: 3%;">3- STATUT DES ELEVES..........................................................................................4</p>
        <p style="font-size: 18px; font-weight: bold; margin-top: 3%;">4- EFFECTIFS DES ENSEIGNANTS PAR DISCIPLINE ET PAR GENRE...............4</p>
        <p style="font-size: 18px; font-weight: bold; margin-top: 3%;">5- ACTIVITES PARASCOLAIRES.............................................................................6</p>
        <p style="font-size: 18px; font-weight: bold; margin-top: 3%;">6- DOUBLE VACATION.............................................................................................6</p>
        <p style="font-size: 18px; font-weight: bold; margin-top: 3%;">7- PYRAMIDE ET EFFECTIFS PAR NIVEAU............................................................6</p>
        <p style="font-size: 18px; font-weight: bold; margin-top: 3%;">8- RECAPITULATIF DES ELEVES PAR NATIONALITE..........................................7</p>
        <p style="font-size: 18px; font-weight: bold; margin-top: 3%;">9- RÉSULTATS AUX EXAMENS...............................................................................8</p>
    </section>
    <footer>2</footer>
</body>
</html>


<!--  3eme page du document -->
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
</head>
<style type="text/css">
    @page {
        margin: 2cm 1cm 0.5cm 1cm; /* haut droite bas gauche */
    }
    body {
        margin: 0cm;
        padding: 0cm;
        font-family: sans-serif;
        font-size: 12px
    }
    footer{
        position: fixed;
        bottom: -30px;
        border-top: 2px solid gray;
        left: 0;
        right: 0;
        height: 50px;
        text-align: right;
        font-size: 12px;
        color: #555;
    }
</style>
<body>
    <h1 style="font-weight: bold; height: 50px; margin-left: 100px">1- <span style="text-decoration: underline;">IDENTIFICATION</span></h1>
    <p style="margin-top: 10px;">
        <h3 style="margin-left: 110px">&#x2022; IDENTIFICATION DE L’ETABLISSEMENT </h3>
        <table border="2" cellpadding="10" cellspacing="0" style="border-collapse: collapse; width: 100%; border: 1px solid black;">
            <tbody>
                <tr>
                    <th style="width: 40%; text-align: left; padding: 5px;">DRENA</th>
                    <td style="width: 60%; text-align: left; padding: 5px; font-size: 15px"><?php echo e(ucwords($school->getDren->libelle) ?? 'NEANT'); ?></td>
                </tr>
                <tr>
                    <th style="width: 40%; text-align: left; padding: 5px;">NOM DE L’ETABLISSEMENT</th>
                    <td style="width: 60%; text-align: left; padding: 5px; font-size: 13px"><?php echo e(ucwords($school->school->name_school) ?? 'NEANT'); ?></td>
                </tr>
                <tr>
                    <th style="width: 40%; text-align: left; padding: 5px;">NUMÉRO DE TÉLÉPHONE</th>
                    <td style="width: 60%; text-align: left; padding: 5px; font-size: 13px"><?php echo e('+225 '.$school->phon_school ?? 'NEANT'); ?></td>
                </tr>
                <tr>
                    <th style="width: 40%; text-align: left; padding: 5px;">ADRESSE POSTALE</th>
                    <td style="width: 60%; text-align: left; padding: 5px; font-size: 13px"><?php echo e($school->addres_postal ?? null); ?></td>
                </tr>
                <tr>
                    <th style="width: 40%; text-align: left; padding: 5px;">COURRIEL</th>
                    <td style="width: 60%; text-align: left; padding: 5px; font-size: 13px"><?php echo e($school->address_email ?? 'NEANT'); ?></td>
                </tr>
                <tr>
                    <th style="width: 40%; text-align: left; padding: 5px;">CODE ETABLISSEMENT</th>
                    <td style="width: 60%; text-align: left; padding: 5px; font-size: 13px"><?php echo e($school->school->code_school ?? 'NEANT'); ?></td>
                </tr>
                <tr>
                    <th style="width: 40%; text-align: left; padding: 5px;">DATE DE CREATION</th>
                    <td style="width: 60%; text-align: left; padding: 5px; font-size: 13px"><?php echo e($school->create_school ? date('d/m/Y', strtotime($school->create_school)):'NEANT'); ?></td>
                </tr>
                <tr>
                    <th style="width: 40%; text-align: left; padding: 5px;">DATE D’OUVERTURE</th>
                    <td style="width: 60%; text-align: left; padding: 5px; font-size: 13px"><?php echo e($school->open_school ? date('d/m/Y', strtotime($school->open_school)):'NEANT'); ?></td>
                </tr>
                <tr>
                    <th style="width: 40%; text-align: left; padding: 5px;">DATE D’HOMOLOGATION 1er CYCLE</th>
                    <td style="width: 60%; text-align: left; padding: 5px; font-size: 13px"><?php echo e($personnel->homologation_1 ? date('d/m/Y', strtotime($personnel->homologation_1)):'NEANT'); ?></td>
                </tr>
                <tr>
                    <th style="width: 40%; text-align: left; padding: 5px;">DATE D’HOMOLOGATION 2nd CYCLE</th>
                    <td style="width: 60%; text-align: left; padding: 5px; font-size: 13px"><?php echo e($personnel->homologation_2 ? date('d/m/Y', strtotime($personnel->homologation_2)):'NEANT'); ?></td>
                </tr>
            </tbody>
        </table>
    </p>

    <p style="margin-top: 6%;">
        <h3 style="margin-left: 110px">&#x2022; IDENTIFICATION DU PERSONNEL ADMINISTRATIF, D’ENCADREMENT ET DE SERVICE </h3>
        <table border="2" cellpadding="10" cellspacing="0" style="border-collapse: collapse; width: 100%; border: 1px solid gray;">
            <thead>
                <tr style="background-color: #ddd">
                    <th style="padding: 5px;">POSTE</th>
                    <th style="padding: 5px;">NOM ET PRENOMS </th>
                    <th style="padding: 5px;">CONTACTS</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <th style="width: 25%; text-align: left; padding: 5px;">DIRECTEUR DES ÉTUDES </th>
                    <td style="width: 55%; text-align: left; padding: 5px;"><?php echo e($personnel->name_directeur ?? 'NEANT'); ?></td>
                    <td style="width: 20%; text-align: left; padding: 5px;"><?php echo e($personnel->phon_directeur ?? 'NEANT'); ?></td>
                </tr>
                <tr>
                    <th style="width: 25%; text-align: left; padding: 5px;">DIRECTEUR ADJOINT</th>
                    <td style="width: 55%; text-align: left; padding: 5px;"><?php echo e($personnel->name_adjoint ?? 'NEANT'); ?></td>
                    <td style="width: 20%; text-align: left; padding: 5px;"><?php echo e($personnel->phon_adjoint ?? 'NEANT'); ?></td>
                </tr>
                <tr>
                    <th style="width: 25%; text-align: left; padding: 5px;">SECRÉTAIRE</th>
                    <td style="width: 55%; text-align: left; padding: 5px;"><?php echo e($personnel->name_secretaire ?? 'NEANT'); ?></td>
                    <td style="width: 20%; text-align: left; padding: 5px;"><?php echo e($personnel->phon_secretaire ?? 'NEANT'); ?></td>
                </tr>
                <tr>
                    <th style="width: 25%; text-align: left;">ÉDUCATEURS</th>
                    <?php if(count($educateur) == 1): ?>
                    <td style="width: 55%; text-align: left; padding: 5px;"><?php echo e($educateur[0]['name'] ?? 'NEANT'); ?></td>
                    <td style="width: 20%; text-align: left; padding: 5px;"><?php echo e($educateur[0]['phon'] ?? 'NEANT'); ?></td>    
                    <?php else: ?>
                    <td style="width: 55%; text-align: left;  padding: 0%;">
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <tbody>
                                <?php $__currentLoopData = $educateur; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $educ): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td style="margin: 0%;  padding: 5px;"><?php echo e($educ->name ?? 'NEANT'); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </td>
                    <td style="width: 20%; text-align: left; padding: 0%;">
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <tbody>
                                <?php $__currentLoopData = $educateur; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $educ): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td style="margin: 0%;  padding: 5px;"><?php echo e($educ->phon ?? 'NEANT'); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </td>
                    <?php endif; ?>
                </tr>
                <tr>
                    <th style="width: 25%; text-align: left; padding: 5px;">CORRESPONDANT FICHIER</th>
                    <td style="width: 55%; text-align: left; padding: 5px;"><?php echo e($personnel->name_fichier ?? 'NEANT'); ?></td>
                    <td style="width: 20%; text-align: left; padding: 5px;"><?php echo e($personnel->phon_fichier ?? 'NEANT'); ?></td>
                </tr>
                <tr>
                    <th style="width: 25%; text-align: left; padding: 5px;">COMPTABLE</th>
                    <td style="width: 55%; text-align: left; padding: 5px;"><?php echo e($personnel->name_comptable ?? 'NEANT'); ?></td>
                    <td style="width: 20%; text-align: left; padding: 5px;"><?php echo e($personnel->phon_comptable ?? 'NEANT'); ?></td>
                </tr>
                <tr>
                    <th style="width: 25%; text-align: left; padding: 5px;">AGENTS DE SÉCURITÉ</th>
                    <?php if(count($securites) == 1): ?>
                    <td style="width: 55%; text-align: left; padding: 5px;"><?php echo e($securites[0]['name'] ?? 'NEANT'); ?></td>
                    <td style="width: 20%; text-align: left; padding: 5px;"><?php echo e($securites[0]['phon'] ?? 'NEANT'); ?></td>
                    <?php else: ?>
                    <td style="width: 55%; text-align: left;  padding: 0%;">
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <tbody>
                                <?php $__currentLoopData = $securites; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item1): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td style="margin: 0%;  padding: 5px;"><?php echo e($item1->name ?? 'NEANT'); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </td>
                    <td style="width: 20%; text-align: left; padding: 0%;">
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <tbody>
                                <?php $__currentLoopData = $securites; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item1): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td style="margin: 0%;  padding: 5px;"><?php echo e($item1->phon ?? 'NEANT'); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </td>
                    <?php endif; ?>
                </tr>
                <tr>
                    <th style="width: 25%; text-align: left; padding: 5px;">AGENT D’ENTRETIEN</th>
                    <?php if(count($entretien) == 1): ?>
                    <td style="width: 55%; text-align: left; padding: 5px;"><?php echo e($entretien[0]['name'] ?? 'NEANT'); ?></td>
                    <td style="width: 20%; text-align: left; padding: 5px;"><?php echo e($entretien[0]['phon'] ?? 'NEANT'); ?></td>
                    <?php else: ?>
                    <td style="width: 55%; text-align: left;  padding: 0%;">
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <tbody>
                                <?php $__currentLoopData = $entretien; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item3): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td style="margin: 0%;  padding: 5px;"><?php echo e($item3->name ?? 'NEANT'); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </td>
                    <td style="width: 20%; text-align: left; padding: 0%;">
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <tbody>
                                <?php $__currentLoopData = $entretien; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item3): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td style="margin: 0%;  padding: 5px;"><?php echo e($item3->phon ?? 'NEANT'); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </td>
                    <?php endif; ?>
                </tr>
                <tr>
                    <th style="width: 25%; text-align: left; padding: 5px;">AUTRES AGENTS</th>
                    <?php if(count($autres) == 1): ?>
                    <td style="width: 55%; text-align: left; padding: 5px;"><?php echo e($autres[0]['name'] ?? 'NEANT'); ?></td>
                    <td style="width: 20%; text-align: left; padding: 5px;"><?php echo e($autres[0]['phon'] ?? 'NEANT'); ?></td>
                    <?php else: ?>
                    <td style="width: 55%; text-align: left;  padding: 0%;">
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <tbody>
                                <?php $__currentLoopData = $autres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $autres): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td style="margin: 0%;  padding: 5px;"><?php echo e($autre->name ?? 'NEANT'); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </td>
                    <td style="width: 20%; text-align: left; padding: 0%;">
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <tbody>
                                <?php $__currentLoopData = $autres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $autre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td style="margin: 0%;  padding: 5px;"><?php echo e($autre->phon ?? 'NEANT'); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </td>
                    <?php endif; ?>
                </tr>
            </tbody>
        </table>
    </p>
    <footer>3</footer>
</body>
</html>


<!--  4eme page du document -->
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <style type="text/css">
        @page {
            margin: 2cm 1cm 0.5cm 1cm; /* haut droite bas gauche */
        }
        body {
            margin: 0cm;
            padding: 0cm;
            font-family: sans-serif;
            font-size: 12px
        }
        footer{
            position: fixed;
            bottom: -30px;
            border-top: 2px solid gray;
            left: 0;
            right: 0;
            height: 50px;
            text-align: right;
            font-size: 12px;
            color: #555;
        }
    </style>
</head>
<body>
    <h1 style="font-weight: bold; height: 50px; margin-left: 100px">2- <span style="text-decoration: underline;">ORGANISATION MATERIELLE</span></h1>
    <table border="2" cellpadding="10" cellspacing="0" style="border-collapse: collapse; width: 100%; border: 1px solid black;">
        <thead>
            <tr>
                <th></th>
                <td>Salles de classes ordinaires</td>
                <td>Laboratoires de Sciences </td>
                <td>Salle Informatique</td>
                <td>Bibliothèque</td>
                <td>Infirmerie</td>
                <th>TOTAL</th>
            </tr>
        </thead>
        <tbody>
            <?php $tables = ['Existant', 'Besoin']; $i = 0; ?>
            <?php $__empty_1 = true; $__currentLoopData = $materiels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mtls): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr style="font-size: 11px">
                    <th style="padding-top: 2px; padding-bottom: 2px"><?php echo e(ucfirst($tables[$i])); ?></th>
                    <th style="padding: 4px"><?php echo e(is_int((int)$mtls['col1']) ? ($mtls['col1'] <= 9 ? '0'.$mtls['col1']:$mtls['col1']):ucfirst($mtls['col1'])); ?></th>
                    <th style="padding: 4px"><?php echo e(is_int((int)$mtls['col2']) ? ($mtls['col2'] <= 9 ? '0'.$mtls['col2']:$mtls['col2']):ucfirst($mtls['col2'])); ?></th>
                    <th style="padding: 4px"><?php echo e(is_int((int)$mtls['col3']) ? ($mtls['col3'] <= 9 ? '0'.$mtls['col3']:$mtls['col3']):ucfirst($mtls['col3'])); ?></th>
                    <th style="padding: 4px"><?php echo e(is_int((int)$mtls['col4']) ? ($mtls['col4'] <= 9 ? '0'.$mtls['col4']:$mtls['col4']):ucfirst($mtls['col4'])); ?></th>
                    <th style="padding: 4px"><?php echo e(is_int((int)$mtls['col5']) ? ($mtls['col5'] <= 9 ? '0'.$mtls['col5']:$mtls['col5']):ucfirst($mtls['col5'])); ?></th>
                    <th style="padding: 4px"><?php echo e(calculTtlMls([$mtls['col1'], $mtls['col2'], $mtls['col3'], $mtls['col4'], $mtls['col5']])); ?></th>
                </tr> 
                <?php $i++;  ?> 
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <th colspan="7">Données Introuvables</th>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <div style="margin-top: 6%">
        <h1 style="font-weight: bold; height: 50px; margin-left: 100px">3- <span style="text-decoration: underline;">STATUT DES ELEVES</span></h1>
        <table border="2" cellpadding="10" cellspacing="0" style="border-collapse: collapse; width: 100%; border: 1px solid black;">
            <thead>
                <tr>
                    <th style="width: 10%"></th>
                    <th style="width: 30%; padding: 0%;"><span style="visibility: hidden">AFFECTES</span> <br> AFFECTES
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <thead style="padding: 0%; margin:0%;">
                                <tr style="padding: 0%; margin:0%;">
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:40%">Garçons</th>
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">Filles</th>
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">Total</th>
                                </tr>
                            </thead>
                        </table>
                    </th>
                    <th style="width: 30%; padding: 0%;"><span style="visibility: hidden">NON-AFFECTES</span> <br>NON-AFFECTES
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <thead style="padding: 0%; margin:0%;">
                                <tr style="padding: 0%; margin:0%;">
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:40%">Garçons</th>
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">Filles</th>
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">Total</th>
                                </tr>
                            </thead>
                        </table>
                    </th>
                    <th style="width: 30%; padding: 0%;">TOTAL AFFECTES ET <br> NON- AFFECTES 
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <thead style="padding: 0%; margin:0%;">
                                <tr style="padding: 0%; margin:0%;">
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:40%">Garçons</th>
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">Filles</th>
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">Total</th>
                                </tr>
                            </thead>
                        </table>
                    </th>
                </tr>
            </thead>
            <tbody>
                <?php $tables = ['6eme', '5eme', '4eme', '3eme', 'Cycle 1', '2nde', '1ere', 'Tle', 'Cycle 2', 'Total']; $i = 0; ?>
                <?php $__empty_1 = true; $__currentLoopData = $statuts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $statut): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr style="background-color: <?php echo e((($tables[$i] == 'Cycle 1') || ($tables[$i] == 'Cycle 2')) ? '#ddd;':''); ?>; font-size: 15px">
                    <th style="padding-top:0%; padding-bottom:0%; padding-left: 10%; text-align:left"><?php echo e($tables[$i]); ?></th>
                    <th style="padding: 0%;">
                       <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <body style="padding: 0%; margin:0%;">
                                <tr style="padding: 0%; margin:0%;">
                                    <th style="padding: 5px 0px 5px 0px; width:40%"><?php echo e($statut[0] <= 9 ? '0'.$statut[0]:$statut[0]); ?></th>
                                    <th style="padding: 5px 0px 5px 0px; width:30%"><?php echo e($statut[1] <= 9 ? '0'.$statut[1]:$statut[1]); ?></th>
                                    <th style="padding: 5px 0px 5px 0px; width:30%"><?php echo e(calculTtlMls([$statut[0],$statut[1]])); ?></th>
                                </tr>
                            </body>
                        </table>
                    </th>
                    <th style="padding: 0%;">
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <body style="padding: 0%; margin:0%;">
                                <tr style="padding: 0%; margin:0%;">
                                    <th style="padding: 5px 0px 5px 0px; width:40%"><?php echo e($statut[2] <= 9 ? '0'.$statut[2]:$statut[2]); ?></th>
                                    <th style="padding: 5px 0px 5px 0px; width:30%"><?php echo e($statut[3] <= 9 ? '0'.$statut[3]:$statut[3]); ?></th>
                                    <th style="padding: 5px 0px 5px 0px; width:30%"><?php echo e(calculTtlMls([$statut[2],$statut[3]])); ?></th>
                                </tr>
                            </body>
                        </table>
                    </th>
                    <th style="padding: 0%;">
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <body style="padding: 0%; margin:0%;">
                                <tr style="padding: 0%; margin:0%;">
                                    <th style="padding: 5px 0px 5px 0px; width:40%"><?php echo e(calculTtlMls([$statut[0],$statut[2]])); ?></th>
                                    <th style="padding: 5px 0px 5px 0px; width:30%"><?php echo e(calculTtlMls([$statut[1],$statut[3]])); ?></th>
                                    <th style="padding: 5px 0px 5px 0px; width:30%"><?php echo e(calculTtlMls([$statut[0],$statut[1], $statut[2],$statut[3]])); ?></th>
                                </tr>
                            </body>
                        </table>
                    </th>
                </tr>
                <?php $i++; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <th colspan="5">Données Non Parametrées</th>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <div style="margin-top: 6%">
        <h1 style="font-weight: bold; height: 50px; margin-left: 100px">4- <span style="text-decoration: underline;">EFFECTIFS DES ENSEIGNANTS PAR DISCIPLINE ET PAR GENRE</span></h1>
        <p style="margin-top: 10px;">
            <h3 style="margin-left: 110px">&#x2022; UNIVERS SOCIAL</h3>
            <table border="2" cellpadding="10" cellspacing="0" style="border-collapse: collapse; width: 100%; border: 1px solid black;">
                <thead style="padding: 0%; margin:0%;">
                    <tr style="padding: 0%; margin:0%;">
                        <th style="padding: 0%; margin:0%; width:32%"></th>
                        <th style="padding: 0%; margin:0%; width:20%">Philo
                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                <thead style="padding: 0%; margin:0%;">
                                    <tr style="padding: 0%; margin:0%;">
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%">H</th>
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%">F</th>
                                    </tr>
                                </thead>
                            </table>
                        </th>
                        <th style="padding: 0%; margin:0%; width:20%">Hist - Géo
                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                <thead style="padding: 0%; margin:0%;">
                                    <tr style="padding: 0%; margin:0%;">
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%">H</th>
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%">F</th>
                                    </tr>
                                </thead>
                            </table>
                        </th>
                        <th style="padding: 0%; margin:0%; width:20%">EDHC
                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                <thead style="padding: 0%; margin:0%;">
                                    <tr style="padding: 0%; margin:0%;">
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%">H</th>
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%">F</th>
                                    </tr>
                                </thead>
                            </table>
                        </th>
                        <th style="padding: 0%; margin:0%; width:20%">TOTAL
                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                <thead style="padding: 0%; margin:0%;">
                                    <tr style="padding: 0%; margin:0%;">
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">H</th>
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">F</th>
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:40%">T</th>
                                    </tr>
                                </thead>
                            </table>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <?php $table = ['Permanents', 'Vacataires fonctionnaires', 'Vacataires non fonctionnaires', 'Total']; $i = 0; ?>
                    <?php $__currentLoopData = $socials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $social): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr style="background-color: <?php echo e(($table[$i] == 'Total') ? '#ddd;':''); ?>; font-size: 12px">
                        <th style="padding-top:0%; padding-bottom: 0%; padding-left: 5px; margin:0%; text-align:left"><?php echo e(ucfirst($table[$i])); ?></th>
                        <td style="padding: 0%; margin:0%;">
                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                <head>
                                    <tr style="padding: 0%; margin:0%;">
                                        <td style="padding: 5px 0px 5px 0px; margin:0%; text-align:center"><?php echo e($social['col_1_h'] <= 9 ? '0'.$social['col_1_h']:$social['col_1_h']); ?></td>
                                        <td style="padding: 5px 0px 5px 0px; margin:0%; text-align:center"><?php echo e($social['col_2_f'] <= 9 ? '0'.$social['col_2_f']:$social['col_2_f']); ?></td>
                                    </tr>
                                </head>
                            </table>
                        </td>
                        <td style="padding: 0%; margin:0%;">
                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                <head style="padding: 0%; margin:0%;">
                                    <tr style="padding: 0%; margin:0%;">
                                        <td style="padding: 5px 0px 5px 0px; margin:0%; text-align:center"><?php echo e($social['col_3_h'] <= 9 ? '0'.$social['col_3_h']:$social['col_3_h']); ?></td>
                                        <td style="padding: 5px 0px 5px 0px; margin:0%; text-align:center"><?php echo e($social['col_4_f'] <= 9 ? '0'.$social['col_4_f']:$social['col_4_f']); ?></td>
                                    </tr>
                                </head>
                            </table>
                        </td>
                        <td style="padding: 0%; margin:0%;">
                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                <head style="padding: 0%; margin:0%;">
                                    <tr style="padding: 0%; margin:0%;">
                                        <td style="padding: 5px 0px 5px 0px; margin:0%; text-align:center"><?php echo e($social['col_5_h'] <= 9 ? '0'.$social['col_5_h']:$social['col_5_h']); ?></td>
                                        <td style="padding: 5px 0px 5px 0px; margin:0%; text-align:center"><?php echo e($social['col_6_f'] <= 9 ? '0'.$social['col_6_f']:$social['col_6_f']); ?></td>
                                    </tr>
                                </head>
                            </table>
                        </td>
                        <td style="padding: 0%; margin:0%;">
                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                <tbody style="padding: 0%; margin:0%;">
                                    <tr>
                                        <td style="padding: 5px 0px 5px 0px; margin:0%; width:30%; text-align:center"><?php echo e($social['total_h']); ?></td>
                                        <td style="padding: 5px 0px 5px 0px; margin:0%; width:30%; text-align:center"><?php echo e($social['total_f']); ?></td>
                                        <td style="padding: 5px 0px 5px 0px; margin:0%; width:40%; text-align:center"><?php echo e(($social['total_h'] + $social['total_f']) <= 9 ? '0'.($social['total_h'] + $social['total_f']):($social['total_h'] + $social['total_f'])); ?></td>
                                    </tr>
                                </tbody>
                            </table>
                        </td>
                    </tr> <?php $i++; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </p>
    </div>

    <footer>4</footer>
</body>
</html>


<!--  5eme page du document -->
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
</head>
<style type="text/css">
    @page {
        margin: 2cm 1cm 0.5cm 1cm; /* haut droite bas gauche */
    }
    body {
        margin: 0cm;
        padding: 0cm;
        font-family: sans-serif;
        font-size: 12px
    }
    footer{
        position: fixed;
        bottom: -30px;
        border-top: 2px solid gray;
        left: 0;
        right: 0;
        height: 50px;
        text-align: right;
        font-size: 12px;
        color: #555;
    }
</style>
<body>
    <p style="margin-top: 0%;">
        <h3 style="margin-left: 110px">&#x2022; LANGUES</h3>
        <table border="2" cellpadding="10" cellspacing="0" style="border-collapse: collapse; width: 100%; border: 1px solid black;">
            <thead style="padding: 0%; margin:0%;">
                <tr style="padding: 0%; margin:0%;">
                    <th style="padding: 0%; margin:0%; width:40%"></th>
                    <th style="padding: 0%; margin:0%; width:20%">Fran
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <thead style="padding: 0%; margin:0%;">
                                <tr style="padding: 0%; margin:0%;">
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%">H</th>
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%">F</th>
                                </tr>
                            </thead>
                        </table>
                    </th>
                    <th style="padding: 0%; margin:0%; width:20%">Angl
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <thead style="padding: 0%; margin:0%;">
                                <tr style="padding: 0%; margin:0%;">
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%">H</th>
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%">F</th>
                                </tr>
                            </thead>
                        </table>
                    </th>
                    <th style="padding: 0%; margin:0%; width:20%">All
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <thead style="padding: 0%; margin:0%;">
                                <tr style="padding: 0%; margin:0%;">
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%">H</th>
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%">F</th>
                                </tr>
                            </thead>
                        </table>
                    </th>
                    <th style="padding: 0%; margin:0%; width:20%">Esp
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <thead style="padding: 0%; margin:0%;">
                                <tr style="padding: 0%; margin:0%;">
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%">H</th>
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%">F</th>
                                </tr>
                            </thead>
                        </table>
                    </th>
                    <th style="padding: 0%; margin:0%; width:20%">TOTAL
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <thead style="padding: 0%; margin:0%;">
                                <tr style="padding: 0%; margin:0%;">
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">H</th>
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">F</th>
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:40%">T</th>
                                </tr>
                            </thead>
                        </table>
                    </th>
                </tr>
            </thead>
            <tbody>
                <?php $table = ['Permanents', 'Vacataires fonctionnaires', 'Vacataires non fonctionnaires', 'Total']; $i = 0; ?>
                <?php $__currentLoopData = $langues; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $langue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr style="background-color: <?php echo e(($table[$i] == 'Total') ? '#ddd;':''); ?>; font-size: 12px">
                    <th style="padding-top:0%; padding-bottom: 0%; padding-left: 5px; margin:0%; text-align:left"><?php echo e(ucfirst($table[$i])); ?></th>
                    <td style="padding: 0%; margin:0%;">
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <head>
                                <tr style="padding: 0%; margin:0%;">
                                    <td style="padding: 5px 0px 5px 0px; margin:0%; text-align:center"><?php echo e($langue['col_1_h'] <= 9 ? '0'.$langue['col_1_h']:$langue['col_1_h']); ?></td>
                                    <td style="padding: 5px 0px 5px 0px; margin:0%; text-align:center"><?php echo e($langue['col_2_f'] <= 9 ? '0'.$langue['col_2_f']:$langue['col_2_f']); ?></td>
                                </tr>
                            </head>
                        </table>
                    </td>
                    <td style="padding: 0%; margin:0%;">
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <head style="padding: 0%; margin:0%;">
                                <tr style="padding: 0%; margin:0%;">
                                    <td style="padding: 5px 0px 5px 0px; margin:0%; text-align:center"><?php echo e($langue['col_3_h'] <= 9 ? '0'.$langue['col_3_h']:$langue['col_3_h']); ?></td>
                                    <td style="padding: 5px 0px 5px 0px; margin:0%; text-align:center"><?php echo e($langue['col_4_f'] <= 9 ? '0'.$langue['col_4_f']:$langue['col_4_f']); ?></td>
                                </tr>
                            </head>
                        </table>
                    </td>
                    <td style="padding: 0%; margin:0%;">
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <head style="padding: 0%; margin:0%;">
                                <tr style="padding: 0%; margin:0%;">
                                    <td style="padding: 5px 0px 5px 0px; margin:0%; text-align:center"><?php echo e($langue['col_5_h'] <= 9 ? '0'.$langue['col_5_h']:$langue['col_5_h']); ?></td>
                                    <td style="padding: 5px 0px 5px 0px; margin:0%; text-align:center"><?php echo e($langue['col_6_f'] <= 9 ? '0'.$langue['col_6_f']:$langue['col_6_f']); ?></td>
                                </tr>
                            </head>
                        </table>
                    </td>
                    <td style="padding: 0%; margin:0%;">
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <head style="padding: 0%; margin:0%;">
                                <tr style="padding: 0%; margin:0%;">
                                    <td style="padding: 5px 0px 5px 0px; margin:0%; text-align:center"><?php echo e($langue['col_7_h'] <= 9 ? '0'.$langue['col_7_h']:$langue['col_7_h']); ?></td>
                                    <td style="padding: 5px 0px 5px 0px; margin:0%; text-align:center"><?php echo e($langue['col_8_f'] <= 9 ? '0'.$langue['col_8_f']:$langue['col_8_f']); ?></td>
                                </tr>
                            </head>
                        </table>
                    </td>
                    <td style="padding: 0%; margin:0%;">
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <tbody style="padding: 0%; margin:0%;">
                                <tr>
                                    <td style="padding: 5px 0px 5px 0px; margin:0%; width:30%; text-align:center"><?php echo e($langue['total_h']); ?></td>
                                    <td style="padding: 5px 0px 5px 0px; margin:0%; width:30%; text-align:center"><?php echo e($langue['total_f']); ?></td>
                                    <td style="padding: 5px 0px 5px 0px; margin:0%; width:40%; text-align:center"><?php echo e(($langue['total_h'] + $langue['total_f']) <= 9 ? '0'.($langue['total_h'] + $langue['total_f']):($langue['total_h'] + $langue['total_f'])); ?></td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                </tr> <?php $i++; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </p>

    <p style="margin-top: 8%;">
        <h3 style="margin-left: 110px">&#x2022; SCIENCES ET TECHNOLOGIE</h3>
        <table border="2" cellpadding="10" cellspacing="0" style="border-collapse: collapse; width: 100%; border: 1px solid black;">
            <thead style="padding: 0%; margin:0%;">
                <tr style="padding: 0%; margin:0%;">
                    <th style="padding: 0%; margin:0%; width:40%"></th>
                    <th style="padding: 0%; margin:0%; width:20%">Maths
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <thead style="padding: 0%; margin:0%;">
                                <tr style="padding: 0%; margin:0%;">
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%">H</th>
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%">F</th>
                                </tr>
                            </thead>
                        </table>
                    </th>
                    <th style="padding: 0%; margin:0%; width:20%">Phy-Chi
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <thead style="padding: 0%; margin:0%;">
                                <tr style="padding: 0%; margin:0%;">
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%">H</th>
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%">F</th>
                                </tr>
                            </thead>
                        </table>
                    </th>
                    <th style="padding: 0%; margin:0%; width:20%">SVT
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <thead style="padding: 0%; margin:0%;">
                                <tr style="padding: 0%; margin:0%;">
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%">H</th>
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%">F</th>
                                </tr>
                            </thead>
                        </table>
                    </th>
                    <th style="padding: 0%; margin:0%; width:20%">TICE
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <thead style="padding: 0%; margin:0%;">
                                <tr style="padding: 0%; margin:0%;">
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%">H</th>
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%">F</th>
                                </tr>
                            </thead>
                        </table>
                    </th>
                    <th style="padding: 0%; margin:0%; width:20%">TOTAL
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <thead style="padding: 0%; margin:0%;">
                                <tr style="padding: 0%; margin:0%;">
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">H</th>
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">F</th>
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:40%">T</th>
                                </tr>
                            </thead>
                        </table>
                    </th>
                </tr>
            </thead>
            <tbody>
                <?php $table = ['Permanents', 'Vacataires fonctionnaires', 'Vacataires non fonctionnaires', 'Total']; $i = 0; ?>
                <?php $__currentLoopData = $sciences; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $science): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr style="background-color: <?php echo e(($table[$i] == 'Total') ? '#ddd;':''); ?>; font-size: 12px">
                    <th style="padding-top:0%; padding-bottom: 0%; padding-left: 5px; margin:0%; text-align:left"><?php echo e(ucfirst($table[$i])); ?></th>
                    <td style="padding: 0%; margin:0%;">
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <head>
                                <tr style="padding: 0%; margin:0%;">
                                    <td style="padding: 5px 0px 5px 0px; margin:0%; text-align:center"><?php echo e($science['col_1_h'] <= 9 ? '0'.$science['col_1_h']:$science['col_1_h']); ?></td>
                                    <td style="padding: 5px 0px 5px 0px; margin:0%; text-align:center"><?php echo e($science['col_2_f'] <= 9 ? '0'.$science['col_2_f']:$science['col_2_f']); ?></td>
                                </tr>
                            </head>
                        </table>
                    </td>
                    <td style="padding: 0%; margin:0%;">
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <head style="padding: 0%; margin:0%;">
                                <tr style="padding: 0%; margin:0%;">
                                    <td style="padding: 5px 0px 5px 0px; margin:0%; text-align:center"><?php echo e($science['col_3_h'] <= 9 ? '0'.$science['col_3_h']:$science['col_3_h']); ?></td>
                                    <td style="padding: 5px 0px 5px 0px; margin:0%; text-align:center"><?php echo e($science['col_4_f'] <= 9 ? '0'.$science['col_4_f']:$science['col_4_f']); ?></td>
                                </tr>
                            </head>
                        </table>
                    </td>
                    <td style="padding: 0%; margin:0%;">
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <head style="padding: 0%; margin:0%;">
                                <tr style="padding: 0%; margin:0%;">
                                    <td style="padding: 5px 0px 5px 0px; margin:0%; text-align:center"><?php echo e($science['col_5_h'] <= 9 ? '0'.$science['col_5_h']:$science['col_5_h']); ?></td>
                                    <td style="padding: 5px 0px 5px 0px; margin:0%; text-align:center"><?php echo e($science['col_6_f'] <= 9 ? '0'.$science['col_6_f']:$science['col_6_f']); ?></td>
                                </tr>
                            </head>
                        </table>
                    </td>
                    <td style="padding: 0%; margin:0%;">
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <head style="padding: 0%; margin:0%;">
                                <tr style="padding: 0%; margin:0%;">
                                    <td style="padding: 5px 0px 5px 0px; margin:0%; text-align:center"><?php echo e($science['col_7_h'] <= 9 ? '0'.$science['col_7_h']:$science['col_7_h']); ?></td>
                                    <td style="padding: 5px 0px 5px 0px; margin:0%; text-align:center"><?php echo e($science['col_8_f'] <= 9 ? '0'.$science['col_8_f']:$science['col_8_f']); ?></td>
                                </tr>
                            </head>
                        </table>
                    </td>
                    <td style="padding: 0%; margin:0%;">
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <tbody style="padding: 0%; margin:0%;">
                                <tr>
                                    <td style="padding: 5px 0px 5px 0px; margin:0%; width:30%; text-align:center"><?php echo e($science['total_h']); ?></td>
                                    <td style="padding: 5px 0px 5px 0px; margin:0%; width:30%; text-align:center"><?php echo e($science['total_f']); ?></td>
                                    <td style="padding: 5px 0px 5px 0px; margin:0%; width:40%; text-align:center"><?php echo e(($science['total_h'] + $science['total_f']) <= 9 ? '0'.($science['total_h'] + $science['total_f']):($science['total_h'] + $science['total_f'])); ?></td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                </tr> <?php $i++; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody> 
        </table>
    </p>

    <p style="margin-top: 8%;">
        <h3 style="margin-left: 110px">&#x2022; AUTRES DISCIPLINES</h3>
        <table border="2" cellpadding="10" cellspacing="0" style="border-collapse: collapse; width: 100%; border: 1px solid black;">
            <thead style="padding: 0%; margin:0%;">
                <tr style="padding: 0%; margin:0%;">
                    <th style="padding: 0%; margin:0%; width:40%"></th>
                    <th style="padding: 0%; margin:0%; width:20%">Art.plas
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <thead style="padding: 0%; margin:0%;">
                                <tr style="padding: 0%; margin:0%;">
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%">H</th>
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%">F</th>
                                </tr>
                            </thead>
                        </table>
                    </th>
                    <th style="padding: 0%; margin:0%; width:20%">Musiq
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <thead style="padding: 0%; margin:0%;">
                                <tr style="padding: 0%; margin:0%;">
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%">H</th>
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%">F</th>
                                </tr>
                            </thead>
                        </table>
                    </th>
                    <th style="padding: 0%; margin:0%; width:20%">EPS
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <thead style="padding: 0%; margin:0%;">
                                <tr style="padding: 0%; margin:0%;">
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%">H</th>
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%">F</th>
                                </tr>
                            </thead>
                        </table>
                    </th>
                    <th style="padding: 0%; margin:0%; width:20%">Religion
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <thead style="padding: 0%; margin:0%;">
                                <tr style="padding: 0%; margin:0%;">
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%">H</th>
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%">F</th>
                                </tr>
                            </thead>
                        </table>
                    </th>
                    <th style="padding: 0%; margin:0%; width:20%">TOTAL
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <thead style="padding: 0%; margin:0%;">
                                <tr style="padding: 0%; margin:0%;">
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">H</th>
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">F</th>
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:40%">T</th>
                                </tr>
                            </thead>
                        </table>
                    </th>
                </tr>
            </thead>
            <tbody>
                <?php $table = ['Permanents', 'Vacataires fonctionnaires', 'Vacataires non fonctionnaires', 'Total']; $i = 0; ?>
                <?php $__currentLoopData = $autres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $autre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr style="background-color: <?php echo e(($table[$i] == 'Total') ? '#ddd;':''); ?>; font-size: 12px">
                    <th style="padding-top:0%; padding-bottom: 0%; padding-left: 5px; margin:0%; text-align:left"><?php echo e(ucfirst($table[$i])); ?></th>
                    <td style="padding: 0%; margin:0%;">
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <head>
                                <tr style="padding: 0%; margin:0%;">
                                    <td style="padding: 5px 0px 5px 0px; margin:0%; text-align:center"><?php echo e($autre['col_1_h'] <= 9 ? '0'.$autre['col_1_h']:$autre['col_1_h']); ?></td>
                                    <td style="padding: 5px 0px 5px 0px; margin:0%; text-align:center"><?php echo e($autre['col_2_f'] <= 9 ? '0'.$autre['col_2_f']:$autre['col_2_f']); ?></td>
                                </tr>
                            </head>
                        </table>
                    </td>
                    <td style="padding: 0%; margin:0%;">
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <head style="padding: 0%; margin:0%;">
                                <tr style="padding: 0%; margin:0%;">
                                    <td style="padding: 5px 0px 5px 0px; margin:0%; text-align:center"><?php echo e($autre['col_3_h'] <= 9 ? '0'.$autre['col_3_h']:$autre['col_3_h']); ?></td>
                                    <td style="padding: 5px 0px 5px 0px; margin:0%; text-align:center"><?php echo e($autre['col_4_f'] <= 9 ? '0'.$autre['col_4_f']:$autre['col_4_f']); ?></td>
                                </tr>
                            </head>
                        </table>
                    </td>
                    <td style="padding: 0%; margin:0%;">
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <head style="padding: 0%; margin:0%;">
                                <tr style="padding: 0%; margin:0%;">
                                    <td style="padding: 5px 0px 5px 0px; margin:0%; text-align:center"><?php echo e($autre['col_5_h'] <= 9 ? '0'.$autre['col_5_h']:$autre['col_5_h']); ?></td>
                                    <td style="padding: 5px 0px 5px 0px; margin:0%; text-align:center"><?php echo e($autre['col_6_f'] <= 9 ? '0'.$autre['col_6_f']:$autre['col_6_f']); ?></td>
                                </tr>
                            </head>
                        </table>
                    </td>
                    <td style="padding: 0%; margin:0%;">
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <head style="padding: 0%; margin:0%;">
                                <tr style="padding: 0%; margin:0%;">
                                    <td style="padding: 5px 0px 5px 0px; margin:0%; text-align:center"><?php echo e($autre['col_7_h'] <= 9 ? '0'.$autre['col_7_h']:$autre['col_7_h']); ?></td>
                                    <td style="padding: 5px 0px 5px 0px; margin:0%; text-align:center"><?php echo e($autre['col_8_f'] <= 9 ? '0'.$autre['col_8_f']:$autre['col_8_f']); ?></td>
                                </tr>
                            </head>
                        </table>
                    </td>
                    <td style="padding: 0%; margin:0%;">
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <tbody style="padding: 0%; margin:0%;">
                                <tr>
                                    <td style="padding: 5px 0px 5px 0px; margin:0%; width:30%; text-align:center"><?php echo e($autre['total_h']); ?></td>
                                    <td style="padding: 5px 0px 5px 0px; margin:0%; width:30%; text-align:center"><?php echo e($autre['total_f']); ?></td>
                                    <td style="padding: 5px 0px 5px 0px; margin:0%; width:40%; text-align:center"><?php echo e(($autre['total_h'] + $autre['total_f']) <= 9 ? '0'.($autre['total_h'] + $autre['total_f']):($autre['total_h'] + $autre['total_f'])); ?></td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                </tr> <?php $i++; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </p>

    <p style="margin-top: 8%;">
        <h3 style="margin-left: 110px">&#x2022; TOTAL ENSEIGNANT</h3>
        <table border="2" cellpadding="10" cellspacing="0" style="border-collapse: collapse; width: 100%; border: 1px solid black;">
            <thead style="padding: 0%; margin:0%;">
                <tr style="padding: 0%; margin:0%;">
                    <th style="padding: 0%; margin:0%; width:40%"></th>
                    <th style="padding: 0%; margin:0%; width:20%">Univers <br> Social
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <thead style="padding: 0%; margin:0%;">
                                <tr style="padding: 0%; margin:0%;">
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%">H</th>
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%">F</th>
                                </tr>
                            </thead>
                        </table>
                    </th>
                    <th style="padding: 0%; margin:0%; width:20%">Langues <br> <span style="visibility: hidden">Langues</span>
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <thead style="padding: 0%; margin:0%;">
                                <tr style="padding: 0%; margin:0%;">
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%">H</th>
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%">F</th>
                                </tr>
                            </thead>
                        </table>
                    </th>
                    <th style="padding: 0%; margin:0%; width:20%">Sciences Et Technologies
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <thead style="padding: 0%; margin:0%;">
                                <tr style="padding: 0%; margin:0%;">
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%">H</th>
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%">F</th>
                                </tr>
                            </thead>
                        </table>
                    </th>
                    <th style="padding: 0%; margin:0%; width:20%">Autres Disciplines
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <thead style="padding: 0%; margin:0%;">
                                <tr style="padding: 0%; margin:0%;">
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%">H</th>
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%">F</th>
                                </tr>
                            </thead>
                        </table>
                    </th>
                    <th style="padding: 0%; margin:0%; width:20%">Total <br> <span style="visibility: hidden">Total</span>
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <thead style="padding: 0%; margin:0%;">
                                <tr style="padding: 0%; margin:0%;">
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">H</th>
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">F</th>
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:40%">T</th>
                                </tr>
                            </thead>
                        </table>
                    </th>
                </tr>
            </thead>
            <tbody>
                <?php $table = ['Permanents', 'Vacataires fonctionnaires', 'Vacataires non fonctionnaires', 'Total']; $i = 0; ?>
                <?php $__currentLoopData = $totals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $total): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr style="background-color: <?php echo e(($table[$i] == 'Total') ? '#ddd;':''); ?>; font-size: 12px">
                    <th style="padding-top:0%; padding-bottom: 0%; padding-left: 5px; margin:0%; text-align:left"><?php echo e(ucfirst($table[$i])); ?></th>
                    <td style="padding: 0%; margin:0%;">
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <head>
                                <tr style="padding: 0%; margin:0%;">
                                    <td style="padding: 5px 0px 5px 0px; margin:0%; text-align:center"><?php echo e($total['total_1_h']); ?></td>
                                    <td style="padding: 5px 0px 5px 0px; margin:0%; text-align:center"><?php echo e($total['total_2_f']); ?></td>
                                </tr>
                            </head>
                        </table>
                    </td>
                    <td style="padding: 0%; margin:0%;">
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <head style="padding: 0%; margin:0%;">
                                <tr style="padding: 0%; margin:0%;">
                                    <td style="padding: 5px 0px 5px 0px; margin:0%; text-align:center"><?php echo e($total['total_3_h']); ?></td>
                                    <td style="padding: 5px 0px 5px 0px; margin:0%; text-align:center"><?php echo e($total['total_4_f']); ?></td>
                                </tr>
                            </head>
                        </table>
                    </td>
                    <td style="padding: 0%; margin:0%;">
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <head style="padding: 0%; margin:0%;">
                                <tr style="padding: 0%; margin:0%;">
                                    <td style="padding: 5px 0px 5px 0px; margin:0%; text-align:center"><?php echo e($total['total_5_h']); ?></td>
                                    <td style="padding: 5px 0px 5px 0px; margin:0%; text-align:center"><?php echo e($total['total_6_f']); ?></td>
                                </tr>
                            </head>
                        </table>
                    </td>
                    <td style="padding: 0%; margin:0%;">
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <head style="padding: 0%; margin:0%;">
                                <tr style="padding: 0%; margin:0%;">
                                    <td style="padding: 5px 0px 5px 0px; margin:0%; text-align:center"><?php echo e($total['total_7_h']); ?></td>
                                    <td style="padding: 5px 0px 5px 0px; margin:0%; text-align:center"><?php echo e($total['total_8_f']); ?></td>
                                </tr>
                            </head>
                        </table>
                    </td>
                    <td style="padding: 0%; margin:0%;">
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <tbody style="padding: 0%; margin:0%;">
                                <tr>
                                    <td style="padding: 5px 0px 5px 0px; margin:0%; width:30%; text-align:center"><?php echo e($total['total_h']); ?></td>
                                    <td style="padding: 5px 0px 5px 0px; margin:0%; width:30%; text-align:center"><?php echo e($total['total_f']); ?></td>
                                    <td style="padding: 5px 0px 5px 0px; margin:0%; width:40%; text-align:center"><?php echo e(($total['total_h'] + $total['total_f']) <= 9 ? '0'.($total['total_h'] + $total['total_f']):($total['total_h'] + $total['total_f'])); ?></td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                </tr> <?php $i++; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </p>

    <footer>5</footer>
</body>
</html>

<!--  6eme page du document -->
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
</head>
<style type="text/css">
    @page {
        margin: 2cm 1cm 0.5cm 1cm; /* haut droite bas gauche */
    }
    body {
        margin: 0cm;
        padding: 0cm;
        font-family: sans-serif;
        font-size: 12px
    }
    footer{
        position: fixed;
        bottom: -30px;
        border-top: 2px solid gray;
        left: 0;
        right: 0;
        height: 50px;
        text-align: right;
        font-size: 12px;
        color: #555;
    }
</style>
<body>
    <div style="margin-top: 0%">
        <h1 style="font-weight: bold; height: 50px; margin-left: 100px">5- <span style="text-decoration: underline;">ACTIVITÉS PARASCOLAIRES</span></h1>
        <table border="2" cellpadding="10" cellspacing="0" style="border-collapse: collapse; width: 100%; border: 1px solid black;">
            <thead>
                <tr>
                    <th style="width: 35%"></th>
                    <th style="width: 20%">OUI</th>
                    <th style="width: 20%">NON</th>
                    <th style="width: 20%">FONCTIONNEL</th>
                    <th style="width: 25%">NON-FONCTIONNEL</th>
                </tr>
            </thead>
            <tbody>
                <?php $tables = ['Infirmerie', 'Bibliothèque', 'Foyer', 'Coopérative', 'Théâtre', 'Club (Santé, VIH-SIDA, etc...)', 'Musique/Art Plastique']; $i = 0; ?>
                <?php $__empty_1 = true; $__currentLoopData = $extrats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $extrat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <th style="text-align: left; padding: 5px"><?php echo e(ucfirst($tables[$i])); ?></th>
                        <td style="text-align: center; padding: 5px 0px 5px 0px;"><?php echo e($extrat['exists'] ? 'X':null); ?></td>
                        <td style="text-align: center; padding: 5px 0px 5px 0px;"><?php echo e($extrat['exists'] ? null:'X'); ?></td>
                        <td style="text-align: center; padding: 5px 0px 5px 0px;"><?php echo e($extrat['functional'] ? 'X':null); ?></td>
                        <td style="text-align: center; padding: 5px 0px 5px 0px;"><?php echo e($extrat['functional'] ? null:'X'); ?></td>
                    </tr>
                    <?php $i++; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <th style="text-align: center" colspan="5">Données Introuvables</th>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
        <span style="margin-top: 10%; font-size: 14px">*La case correspondante cochée*</span>
    </div>
    
    <div style="margin-top: 5%">
        <h1 style="font-weight: bold; height: 50px; margin-left: 100px">6- <span style="text-decoration: underline;">DOUBLE VACATION</span></h1>
        <p style="margin-top: 10px;">
            <table border="2" cellpadding="10" cellspacing="0" style="border-collapse: collapse; width: 100%; border: 1px solid black;">
                <tbody>
                    <tr>
                        <th style="text-align: left"></th>
                        <td style="text-align: center">6eme</td>
                        <td style="text-align: center">5eme</td>
                        <td style="text-align: center">4eme</td>
                        <td style="text-align: center">3eme</td>
                        <td style="text-align: center">2ndeA</td>
                        <td style="text-align: center">2ndeC</td>
                        <td style="text-align: center">1ereA</td>
                        <td style="text-align: center">1ereC</td>
                        <td style="text-align: center">1ereD</td>
                        <td style="text-align: center">TleA</td>
                        <td style="text-align: center">TleC</td>
                        <td style="text-align: center">TleD</td>
                    </tr>
                    <?php if($vacation): ?>
                        <tr>
                            <th style="text-align: left">DOUBLE VACATION</th>
                            <td style="text-align: center"><?php echo e($vacation['col_1'] <= 9 ? '0'.$vacation['col_1']:$vacation['col_1']); ?></td>
                            <td style="text-align: center"><?php echo e($vacation['col_2'] <= 9 ? '0'.$vacation['col_2']:$vacation['col_2']); ?></td>
                            <td style="text-align: center"><?php echo e($vacation['col_3'] <= 9 ? '0'.$vacation['col_3']:$vacation['col_3']); ?></td>
                            <td style="text-align: center"><?php echo e($vacation['col_4'] <= 9 ? '0'.$vacation['col_4']:$vacation['col_4']); ?></td>
                            <td style="text-align: center"><?php echo e($vacation['col_5'] <= 9 ? '0'.$vacation['col_5']:$vacation['col_5']); ?></td>
                            <td style="text-align: center"><?php echo e($vacation['col_6'] <= 9 ? '0'.$vacation['col_6']:$vacation['col_6']); ?></td>
                            <td style="text-align: center"><?php echo e($vacation['col_7'] <= 9 ? '0'.$vacation['col_7']:$vacation['col_7']); ?></td>
                            <td style="text-align: center"><?php echo e($vacation['col_8'] <= 9 ? '0'.$vacation['col_8']:$vacation['col_8']); ?></td>
                            <td style="text-align: center"><?php echo e($vacation['col_9'] <= 9 ? '0'.$vacation['col_9']:$vacation['col_9']); ?></td>
                            <td style="text-align: center"><?php echo e($vacation['col_10'] <= 9 ? '0'.$vacation['col_10']:$vacation['col_10']); ?></td>
                            <td style="text-align: center"><?php echo e($vacation['col_11'] <= 9 ? '0'.$vacation['col_11']:$vacation['col_11']); ?></td>
                            <td style="text-align: center"><?php echo e($vacation['col_12'] <= 9 ? '0'.$vacation['col_1']:$vacation['col_1']); ?></td>
                        </tr>
                    <?php else: ?>
                        
                    <?php endif; ?>
                    
                </tbody>
            </table>
        </p>
    </div>

    <div style="margin-top: 5%">
        <h1 style="font-weight: bold; height: 50px; margin-left: 100px">7- <span style="text-decoration: underline;">PYRAMIDE ET EFFECTIFS PAR NIVEAU</span></h1>
        <p style="margin-top: 5px;">
            <h3 style="margin-left: 110px">&#x2022; Premier cycle</h3>
            <table border="2" cellpadding="10" cellspacing="0" style="border-collapse: collapse; width: 100%; border: 1px solid black;">
                <thead>
                    <tr>
                        <th style="width: 25%"></th>
                        <th style="width: 15%; font-size: 12px">6eme</th>
                        <th style="width: 15%; font-size: 12px">5eme</th>
                        <th style="width: 15%; font-size: 12px">4eme</th>
                        <th style="width: 15%; font-size: 12px">3eme</th>
                        <th style="width: 15%; font-size: 12px">Total</th>
                    </tr>
                </thead>
                <tbody>
                    <tr style="background-color: #ddd; font-size: 12px">
                        <th style="padding: 5px 0px 5px 0px; margin:0%;">Nombre de classes</th>
                        <th style="padding: 5px 0px 5px 0px; margin:0%;"><?php echo e($nbreClsCl1[0] <= 9 ? '0'.$nbreClsCl1[0]:$nbreClsCl1[0]); ?></th>
                        <th style="padding: 5px 0px 5px 0px; margin:0%;"><?php echo e($nbreClsCl1[1] <= 9 ? '0'.$nbreClsCl1[1]:$nbreClsCl1[1]); ?></th>
                        <th style="padding: 5px 0px 5px 0px; margin:0%;"><?php echo e($nbreClsCl1[2] <= 9 ? '0'.$nbreClsCl1[2]:$nbreClsCl1[2]); ?></th>
                        <th style="padding: 5px 0px 5px 0px; margin:0%;"><?php echo e($nbreClsCl1[3] <= 9 ? '0'.$nbreClsCl1[3]:$nbreClsCl1[3]); ?></th>
                        <th style="padding: 5px 0px 5px 0px; margin:0%;"><?php echo e(calculTtlMls([$nbreClsCl1[0], $nbreClsCl1[1], $nbreClsCl1[2], $nbreClsCl1[3]])); ?></th>
                    </tr>
                    <tr style="font-size: 12px">
                        <th style="padding:0%">
                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                <body style="padding: 0%; margin:0%;">
                                    <tr style="padding: 0%; margin:0%;">
                                        <th style="padding: 0%; margin:0%; width: 65%; font-size: 12px">Eleves non-redoublants</th>
                                        <th style="padding: 0%; margin:0%; width: 35%">
                                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                                <body style="padding: 0%; margin:0%;">
                                                    <tr style="padding: 0%; margin:0%; font-size: 12px">
                                                        <th style="padding: 5px 0px 5px 5px; margin:0%; width:40%; text-align:left">Garçons</th>
                                                    </tr>
                                                    <tr style="padding: 0%; margin:0%; font-size: 12px">
                                                        <th style="padding: 5px 0px 5px 5px; margin:0%; width:40%; text-align:left">Filles</th>
                                                    </tr>
                                                    <tr style="padding: 0%; margin:0%; background-color: #ddd; font-size: 12px">
                                                        <th style="padding: 5px 0px 5px 5px; margin:0%; width:40%; text-align:left">Total</th>
                                                    </tr>
                                                </body>
                                            </table>
                                        </th>
                                    </tr>
                                </body>
                            </table>
                        </th>
                        <?php $__currentLoopData = $pyramideNonRoubant1; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <td style="padding:0%">
                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                <body style="padding: 0%; margin:0%;">
                                    <tr style="padding: 0%; margin:0%; font-size: 12px">
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:40%"><?php echo e($item[0] <= 9 ? '0'.$item[0]:$item[0]); ?></th>
                                    </tr>
                                    <tr style="padding: 0%; margin:0%; font-size: 12px">
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:40%"><?php echo e($item[1] <= 9 ? '0'.$item[1]:$item[1]); ?></th>
                                    </tr>
                                    <tr style="padding: 0%; margin:0%; background-color: #ddd; font-size: 14px">
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:40%"><?php echo e($item[2] <= 9 ? '0'.$item[2]:$item[2]); ?></th>
                                    </tr>
                                </body>
                            </table>
                        </td>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tr>


                    <tr>
                        <th style="padding:0%">
                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                <body style="padding: 0%; margin:0%;">
                                    <tr style="padding: 0%; margin:0%;">
                                        <th style="padding: 0%; margin:0%; width: 65%; font-size: 12px">Eleves redoublants</th>
                                        <th style="padding: 0%; margin:0%; width: 35%">
                                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                                <body style="padding: 0%; margin:0%;">
                                                    <tr style="padding: 0%; margin:0%; font-size: 12px">
                                                        <th style="padding: 5px 0px 5px 5px; margin:0%; width:40%; text-align:left">Garçons</th>
                                                    </tr>
                                                    <tr style="padding: 0%; margin:0%; font-size: 12px">
                                                        <th style="padding: 5px 0px 5px 5px; margin:0%; width:40%; text-align:left">Filles</th>
                                                    </tr>
                                                    <tr style="padding: 0%; margin:0%; background-color: #ddd; font-size: 12px">
                                                        <th style="padding: 5px 0px 5px 5px; margin:0%; width:40%; text-align:left">Total</th>
                                                    </tr>
                                                </body>
                                            </table>
                                        </th>
                                    </tr>
                                </body>
                            </table>
                        </th>
                        <?php $__currentLoopData = $pyramideRoubant1; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <td style="padding:0%">
                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                <body style="padding: 0%; margin:0%;">
                                    <tr style="padding: 0%; margin:0%; font-size: 12px">
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:40%"><?php echo e($item[0] <= 9 ? '0'.$item[0]:$item[0]); ?></th>
                                    </tr>
                                    <tr style="padding: 0%; margin:0%; font-size: 12px">
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:40%"><?php echo e($item[1] <= 9 ? '0'.$item[1]:$item[1]); ?></th>
                                    </tr>
                                    <tr style="padding: 0%; margin:0%; background-color: #ddd; font-size: 13px">
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:40%"><?php echo e($item[2] <= 9 ? '0'.$item[2]:$item[2]); ?></th>
                                    </tr>
                                </body>
                            </table>
                        </td>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tr>
                </tbody>
            </table>
        </p>
    </div>
    <footer>6</footer>
</body>
</html>


<!--  7eme page du document -->
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
</head>
<style type="text/css">
    @page {
        margin: 2cm 1cm 0.5cm 1cm; /* haut droite bas gauche */
    }
    body {
        margin: 0cm;
        padding: 0cm;
        font-family: sans-serif;
        font-size: 12px
    }
    footer{
        position: fixed;
        bottom: -30px;
        border-top: 2px solid gray;
        left: 0;
        right: 0;
        height: 50px;
        text-align: right;
        font-size: 12px;
        color: #555;
    }
</style>
<body>
    <div style="margin-top: 0%">
        <p style="margin-top: 5px;">
            <h3 style="margin-left: 110px">&#x2022; Second cycle</h3>
            <table border="2" cellpadding="10" cellspacing="0" style="border-collapse: collapse; width: 100%; border: 1px solid black;">
                <thead>
                    <tr>
                        <th style="padding:0%; margin:0%; widht: 15%"></th>
                        <th style="padding:0%; margin:0%; widht: 21%">2nde
                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                <thead style="padding: 0%; margin:0%;">
                                    <tr style="padding: 0%; margin:0%;">
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%">A</th>
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%">C</th>
                                    </tr>
                                </thead>
                            </table>
                        </th>
                        <th style="padding:0%; margin:0%; widht: 27%">1ere
                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                <thead style="padding: 0%; margin:0%;">
                                    <tr style="padding: 0%; margin:0%;">
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:35%">A</th>
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:35%">C</th>
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">D</th>
                                    </tr>
                                </thead>
                            </table>
                        </th>
                        <th style="padding: 0%; margin:0%; widht: 27%">Tle
                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                <thead style="padding: 0%; margin:0%;">
                                    <tr style="padding: 0%; margin:0%;">
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:35%">A</th>
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:35%">C</th>
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">D</th>
                                    </tr>
                                </thead>
                            </table>
                        </th>
                        <th style="width: 10%; padding:0px; margin:0%;">Total</th>
                    </tr>
                </thead>
                <tbody>
                    <tr style="background-color: #ddd; font-size: 12px">
                        <th style="padding: 5px 0px 5px 0px; margin:0%;">Nombre de classes</th>
                        <th style="padding: 0px; margin:0%;">
                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                <thead style="padding: 0%; margin:0%;">
                                    <tr style="padding: 0%; margin:0%;">
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%"><?php echo e($nbreClsCl2[0] <= 9 ? '0'.$nbreClsCl2[0]:$nbreClsCl2[0]); ?></th>
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%"><?php echo e($nbreClsCl2[1] <= 9 ? '0'.$nbreClsCl2[1]:$nbreClsCl2[1]); ?></th>
                                    </tr>
                                </thead>
                            </table>
                        </th>
                        <th style="padding: 0%; margin:0%;">
                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                <thead style="padding: 0%; margin:0%;">
                                    <tr style="padding: 0%; margin:0%;">
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:35%"><?php echo e($nbreClsCl2[2] <= 9 ? '0'.$nbreClsCl2[2]:$nbreClsCl2[2]); ?></th>
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:35%"><?php echo e($nbreClsCl2[3] <= 9 ? '0'.$nbreClsCl2[3]:$nbreClsCl2[3]); ?></th>
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%"><?php echo e($nbreClsCl2[4] <= 9 ? '0'.$nbreClsCl2[4]:$nbreClsCl2[4]); ?></th>
                                    </tr>
                                </thead>
                            </table>
                        </th>
                        <th style="padding: 0%; margin:0%;">
                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                <thead style="padding: 0%; margin:0%;">
                                    <tr style="padding: 0%; margin:0%;">
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:35%"><?php echo e($nbreClsCl2[5] <= 9 ? '0'.$nbreClsCl2[5]:$nbreClsCl2[5]); ?></th>
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:35%"><?php echo e($nbreClsCl2[6] <= 9 ? '0'.$nbreClsCl2[6]:$nbreClsCl2[6]); ?></th>
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%"><?php echo e($nbreClsCl2[7] <= 9 ? '0'.$nbreClsCl2[7]:$nbreClsCl2[7]); ?></th>
                                    </tr>
                                </thead>
                            </table>
                        </th>
                        <th style="padding: 5px 0px 5px 0px;margin:0%;"><?php echo e($nbreClsCl2[8] <= 9 ? '0'.$nbreClsCl2[8]:$nbreClsCl2[8]); ?></th>
                    </tr>
                    <tr>
                        <th style="padding:0%">
                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                <body style="padding: 0%; margin:0%;">
                                    <tr style="padding: 0%; margin:0%;">
                                        <th style="padding: 0%; margin:0%; width: 65%; font-size: 12px">Eleves non-redoublants</th>
                                        <th style="padding: 0%; margin:0%; width: 35%">
                                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                                <body style="padding: 0%; margin:0%;">
                                                    <tr style="padding: 0%; margin:0%; font-size: 12px">
                                                        <th style="padding: 5px 0px 5px 5px; margin:0%; width:40%; text-align:left">Garçons</th>
                                                    </tr>
                                                    <tr style="padding: 0%; margin:0%; font-size: 12px">
                                                        <th style="padding: 5px 0px 5px 5px; margin:0%; width:40%; text-align:left">Filles</th>
                                                    </tr>
                                                    <tr style="padding: 0%; margin:0%; background-color: #ddd; font-size: 12px">
                                                        <th style="padding: 5px 0px 5px 5px; margin:0%; width:40%; text-align:left">Total</th>
                                                    </tr>
                                                </body>
                                            </table>
                                        </th>
                                    </tr>
                                </body>
                            </table>
                        </th>

                        <td style="padding:0%">
                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                <body style="padding: 0%; margin:0%;">
                                    <tr style="padding: 0%; margin:0%; font-size: 12px">
                                        <th style="padding: 0%; margin:0%;">
                                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                                <thead style="padding: 0%; margin:0%;">
                                                    <tr style="padding: 0%; margin:0%;">
                                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%"><?php echo e($NonRoubant2[0][0] <= 9 ? '0'.$NonRoubant2[0][0]:$NonRoubant2[0][0]); ?></th>
                                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%"><?php echo e($NonRoubant2[1][0] <= 9 ? '0'.$NonRoubant2[1][0]:$NonRoubant2[1][0]); ?></th>
                                                    </tr>
                                                </thead>
                                            </table>
                                        </th>
                                    </tr>
                                    <tr style="padding: 0%; margin:0%; font-size: 12px">
                                        <th style="padding: 0%; margin:0%;">
                                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                                <thead style="padding: 0%; margin:0%;">
                                                    <tr style="padding: 0%; margin:0%;">
                                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%"><?php echo e($NonRoubant2[0][1] <= 9 ? '0'.$NonRoubant2[0][1]:$NonRoubant2[0][1]); ?></th>
                                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%"><?php echo e($NonRoubant2[1][1] <= 9 ? '0'.$NonRoubant2[1][1]:$NonRoubant2[1][1]); ?></th>
                                                    </tr>
                                                </thead>
                                            </table>
                                        </th>
                                    </tr>
                                    <tr style="padding: 0%; margin:0%; background-color: #ddd; font-size: 13px">
                                        <th style="padding: 0%; margin:0%;">
                                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                                <thead style="padding: 0%; margin:0%;">
                                                    <tr style="padding: 0%; margin:0%;">
                                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%"><?php echo e($NonRoubant2[0][2] <= 9 ? '0'.$NonRoubant2[0][2]:$NonRoubant2[0][2]); ?></th>
                                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%"><?php echo e($NonRoubant2[1][2] <= 9 ? '0'.$NonRoubant2[1][2]:$NonRoubant2[1][2]); ?></th>
                                                    </tr>
                                                </thead>
                                            </table>
                                        </th>
                                    </tr>
                                </body>
                            </table>
                        </td>

                        <td style="padding:0%">
                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                <body style="padding: 0%; margin:0%;">
                                    <tr style="padding: 0%; margin:0%; font-size: 12px">
                                        <th style="padding: 0%; margin:0%;">
                                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                                <thead style="padding: 0%; margin:0%;">
                                                    <tr style="padding: 0%; margin:0%;">
                                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:35%"><?php echo e($NonRoubant2[2][0] <= 9 ? '0'.$NonRoubant2[2][0]:$NonRoubant2[2][0]); ?></th>
                                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:35%"><?php echo e($NonRoubant2[3][0] <= 9 ? '0'.$NonRoubant2[3][0]:$NonRoubant2[3][0]); ?></th>
                                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%"><?php echo e($NonRoubant2[4][0] <= 9 ? '0'.$NonRoubant2[4][0]:$NonRoubant2[4][0]); ?></th>
                                                    </tr>
                                                </thead>
                                            </table>
                                        </th>
                                    </tr>
                                    <tr style="padding: 0%; margin:0%; font-size: 12px">
                                        <th style="padding: 0%; margin:0%;">
                                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                                <thead style="padding: 0%; margin:0%;">
                                                    <tr style="padding: 0%; margin:0%;">
                                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:35%"><?php echo e($NonRoubant2[2][1] <= 9 ? '0'.$NonRoubant2[2][1]:$NonRoubant2[2][1]); ?></th>
                                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:35%"><?php echo e($NonRoubant2[3][1] <= 9 ? '0'.$NonRoubant2[3][1]:$NonRoubant2[3][1]); ?></th>
                                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%"><?php echo e($NonRoubant2[4][1] <= 9 ? '0'.$NonRoubant2[4][1]:$NonRoubant2[4][1]); ?></th>
                                                    </tr>
                                                </thead>
                                            </table>
                                        </th>
                                    </tr>
                                    <tr style="padding: 0%; margin:0%; background-color: #ddd; font-size: 13px">
                                        <th style="padding: 0%; margin:0%;">
                                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                                <thead style="padding: 0%; margin:0%;">
                                                    <tr style="padding: 0%; margin:0%;">
                                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:35%"><?php echo e($NonRoubant2[2][2] <= 9 ? '0'.$NonRoubant2[2][2]:$NonRoubant2[2][2]); ?></th>
                                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:35%"><?php echo e($NonRoubant2[3][2] <= 9 ? '0'.$NonRoubant2[3][2]:$NonRoubant2[3][2]); ?></th>
                                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%"><?php echo e($NonRoubant2[4][2] <= 9 ? '0'.$NonRoubant2[4][2]:$NonRoubant2[4][2]); ?></th>
                                                    </tr>
                                                </thead>
                                            </table>
                                        </th>
                                    </tr>
                                </body>
                            </table>
                        </td>

                        <td style="padding:0%">
                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                <body style="padding: 0%; margin:0%;">
                                    <th style="padding: 0%; margin:0%;">
                                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                            <thead style="padding: 0%; margin:0%;">
                                                <tr style="padding: 0%; margin:0%;">
                                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:35%"><?php echo e($NonRoubant2[5][0] <= 9 ? '0'.$NonRoubant2[5][0]:$NonRoubant2[5][0]); ?></th>
                                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:35%"><?php echo e($NonRoubant2[6][0] <= 9 ? '0'.$NonRoubant2[6][0]:$NonRoubant2[6][0]); ?></th>
                                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%"><?php echo e($NonRoubant2[7][0] <= 9 ? '0'.$NonRoubant2[7][0]:$NonRoubant2[7][0]); ?></th>
                                                </tr>
                                            </thead>
                                        </table>
                                    </th>
                                    <tr style="padding: 0%; margin:0%;">
                                        <th style="padding: 0%; margin:0%;">
                                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                                <thead style="padding: 0%; margin:0%;">
                                                    <tr style="padding: 0%; margin:0%;">
                                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:35%"><?php echo e($NonRoubant2[5][1] <= 9 ? '0'.$NonRoubant2[5][1]:$NonRoubant2[5][1]); ?></th>
                                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:35%"><?php echo e($NonRoubant2[6][1] <= 9 ? '0'.$NonRoubant2[6][1]:$NonRoubant2[6][1]); ?></th>
                                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%"><?php echo e($NonRoubant2[7][1] <= 9 ? '0'.$NonRoubant2[7][1]:$NonRoubant2[7][1]); ?></th>
                                                    </tr>
                                                </thead>
                                            </table>
                                        </th>
                                    </tr>
                                    <tr style="padding: 0%; margin:0%; background-color: #ddd; font-size: 13px">
                                        <th style="padding: 0%; margin:0%;">
                                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                                <thead style="padding: 0%; margin:0%;">
                                                    <tr style="padding: 0%; margin:0%;">
                                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:35%"><?php echo e($NonRoubant2[5][2] <= 9 ? '0'.$NonRoubant2[5][2]:$NonRoubant2[5][2]); ?></th>
                                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:35%"><?php echo e($NonRoubant2[6][2] <= 9 ? '0'.$NonRoubant2[6][2]:$NonRoubant2[6][2]); ?></th>
                                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%"><?php echo e($NonRoubant2[7][2] <= 9 ? '0'.$NonRoubant2[7][2]:$NonRoubant2[7][2]); ?></th>
                                                    </tr>
                                                </thead>
                                            </table>
                                        </th>
                                    </tr>
                                </body>
                            </table>
                        </td>

                        <th style="padding: 0%; margin:0%;">
                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                <body style="padding: 0%; margin:0%;">
                                    <tr style="padding: 0%; margin:0%; font-size: 12px">
                                        <th style="padding: 5px 0px 5px 0px; margin:0%;"><?php echo e($totalNonRoubant2[0] <= 9 ? '0'.$totalNonRoubant2[0]:$totalNonRoubant2[0]); ?></th>
                                    </tr>
                                    <tr style="padding: 0%; margin:0%; font-size: 12px">
                                        <th style="padding: 5px 0px 5px 0px; margin:0%;"><?php echo e($totalNonRoubant2[1] <= 9 ? '0'.$totalNonRoubant2[1]:$totalNonRoubant2[1]); ?></th>
                                    </tr>
                                    <tr style="padding: 0%; margin:0%; background-color: #ddd; font-size: 13px">
                                        <th style="padding: 5px 0px 5px 0px; margin:0%;"><?php echo e($totalNonRoubant2[2] <= 9 ? '0'.$totalNonRoubant2[2]:$totalNonRoubant2[2]); ?></th>
                                    </tr>
                                </body>
                            </table>
                        </th>
                    </tr>
                    <tr>
                        <th style="padding:0%">
                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                <body style="padding: 0%; margin:0%;">
                                    <tr style="padding: 0%; margin:0%;">
                                        <th style="padding: 0%; margin:0%; width: 65%; font-size: 12px">Eleves redoublants</th>
                                        <th style="padding: 0%; margin:0%; width: 35%">
                                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                                <body style="padding: 0%; margin:0%;">
                                                    <tr style="padding: 0%; margin:0%; font-size: 12px">
                                                        <th style="padding: 5px 0px 5px 5px; margin:0%; width:40%; text-align:left">Garçons</th>
                                                    </tr>
                                                    <tr style="padding: 0%; margin:0%; font-size: 12px">
                                                        <th style="padding: 5px 0px 5px 5px; margin:0%; width:40%; text-align:left">Filles</th>
                                                    </tr>
                                                    <tr style="padding: 0%; margin:0%; background-color: #ddd; font-size: 12px">
                                                        <th style="padding: 5px 0px 5px 5px; margin:0%; width:40%; text-align:left">Total</th>
                                                    </tr>
                                                </body>
                                            </table>
                                        </th>
                                    </tr>
                                </body>
                            </table>
                        </th>

                        <td style="padding:0%">
                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                <body style="padding: 0%; margin:0%;">
                                    <tr style="padding: 0%; margin:0%; font-size: 12px">
                                        <th style="padding: 0%; margin:0%;">
                                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                                <thead style="padding: 0%; margin:0%;">
                                                    <tr style="padding: 0%; margin:0%;">
                                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%"><?php echo e($Roubant2[0][0] <= 9 ? '0'.$Roubant2[0][0]:$Roubant2[0][0]); ?></th>
                                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%"><?php echo e($Roubant2[1][0] <= 9 ? '0'.$Roubant2[1][0]:$Roubant2[1][0]); ?></th>
                                                    </tr>
                                                </thead>
                                            </table>
                                        </th>
                                    </tr>
                                    <tr style="padding: 0%; margin:0%; font-size: 12px">
                                        <th style="padding: 0%; margin:0%;">
                                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                                <thead style="padding: 0%; margin:0%;">
                                                    <tr style="padding: 0%; margin:0%;">
                                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%"><?php echo e($Roubant2[0][1] <= 9 ? '0'.$Roubant2[0][1]:$Roubant2[0][1]); ?></th>
                                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%"><?php echo e($Roubant2[1][1] <= 9 ? '0'.$Roubant2[1][1]:$Roubant2[1][1]); ?></th>
                                                    </tr>
                                                </thead>
                                            </table>
                                        </th>
                                    </tr>
                                    <tr style="padding: 0%; margin:0%; background-color: #ddd; font-size: 13px">
                                        <th style="padding: 0%; margin:0%;">
                                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                                <thead style="padding: 0%; margin:0%;">
                                                    <tr style="padding: 0%; margin:0%;">
                                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%"><?php echo e($Roubant2[0][2] <= 9 ? '0'.$Roubant2[0][2]:$Roubant2[0][2]); ?></th>
                                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:50%"><?php echo e($Roubant2[1][2] <= 9 ? '0'.$Roubant2[1][2]:$Roubant2[1][2]); ?></th>
                                                    </tr>
                                                </thead>
                                            </table>
                                        </th>
                                    </tr>
                                </body>
                            </table>
                        </td>

                        <td style="padding:0%">
                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                <body style="padding: 0%; margin:0%;">
                                    <tr style="padding: 0%; margin:0%; font-size: 12px">
                                        <th style="padding: 0%; margin:0%;">
                                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                                <thead style="padding: 0%; margin:0%;">
                                                    <tr style="padding: 0%; margin:0%;">
                                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:35%"><?php echo e($Roubant2[2][0] <= 9 ? '0'.$Roubant2[2][0]:$Roubant2[2][0]); ?></th>
                                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:35%"><?php echo e($Roubant2[3][0] <= 9 ? '0'.$Roubant2[3][0]:$Roubant2[3][0]); ?></th>
                                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%"><?php echo e($Roubant2[4][0] <= 9 ? '0'.$Roubant2[4][0]:$Roubant2[4][0]); ?></th>
                                                    </tr>
                                                </thead>
                                            </table>
                                        </th>
                                    </tr>
                                    <tr style="padding: 0%; margin:0%; font-size: 12px">
                                        <th style="padding: 0%; margin:0%;">
                                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                                <thead style="padding: 0%; margin:0%;">
                                                    <tr style="padding: 0%; margin:0%;">
                                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:35%"><?php echo e($Roubant2[2][1] <= 9 ? '0'.$Roubant2[2][1]:$Roubant2[2][1]); ?></th>
                                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:35%"><?php echo e($Roubant2[3][1] <= 9 ? '0'.$Roubant2[3][1]:$Roubant2[3][1]); ?></th>
                                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%"><?php echo e($Roubant2[4][1] <= 9 ? '0'.$Roubant2[4][1]:$Roubant2[4][1]); ?></th>
                                                    </tr>
                                                </thead>
                                            </table>
                                        </th>
                                    </tr>
                                    <tr style="padding: 0%; margin:0%; background-color: #ddd; font-size: 13px">
                                        <th style="padding: 0%; margin:0%;">
                                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                                <thead style="padding: 0%; margin:0%;">
                                                    <tr style="padding: 0%; margin:0%;">
                                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:35%"><?php echo e($Roubant2[2][2] <= 9 ? '0'.$Roubant2[2][2]:$Roubant2[2][2]); ?></th>
                                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:35%"><?php echo e($Roubant2[3][2] <= 9 ? '0'.$Roubant2[3][2]:$Roubant2[3][2]); ?></th>
                                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%"><?php echo e($Roubant2[4][2] <= 9 ? '0'.$Roubant2[4][2]:$Roubant2[4][2]); ?></th>
                                                    </tr>
                                                </thead>
                                            </table>
                                        </th>
                                    </tr>
                                </body>
                            </table>
                        </td>

                        <td style="padding:0%">
                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                <body style="padding: 0%; margin:0%;">
                                    <th style="padding: 0%; margin:0%;">
                                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                            <thead style="padding: 0%; margin:0%;">
                                                <tr style="padding: 0%; margin:0%;">
                                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:35%"><?php echo e($Roubant2[5][0] <= 9 ? '0'.$Roubant2[5][0]:$Roubant2[5][0]); ?></th>
                                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:35%"><?php echo e($Roubant2[6][0] <= 9 ? '0'.$Roubant2[6][0]:$Roubant2[6][0]); ?></th>
                                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%"><?php echo e($Roubant2[7][0] <= 9 ? '0'.$Roubant2[7][0]:$Roubant2[7][0]); ?></th>
                                                </tr>
                                            </thead>
                                        </table>
                                    </th>
                                    <tr style="padding: 0%; margin:0%;">
                                        <th style="padding: 0%; margin:0%;">
                                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                                <thead style="padding: 0%; margin:0%;">
                                                    <tr style="padding: 0%; margin:0%;">
                                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:35%"><?php echo e($Roubant2[5][1] <= 9 ? '0'.$Roubant2[5][1]:$Roubant2[5][1]); ?></th>
                                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:35%"><?php echo e($Roubant2[6][1] <= 9 ? '0'.$Roubant2[6][1]:$Roubant2[6][1]); ?></th>
                                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%"><?php echo e($Roubant2[7][1] <= 9 ? '0'.$Roubant2[7][1]:$Roubant2[7][1]); ?></th>
                                                    </tr>
                                                </thead>
                                            </table>
                                        </th>
                                    </tr>
                                    <tr style="padding: 0%; margin:0%; background-color: #ddd; font-size: 13px">
                                        <th style="padding: 0%; margin:0%;">
                                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                                <thead style="padding: 0%; margin:0%;">
                                                    <tr style="padding: 0%; margin:0%;">
                                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:35%"><?php echo e($Roubant2[5][2] <= 9 ? '0'.$Roubant2[5][2]:$Roubant2[5][2]); ?></th>
                                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:35%"><?php echo e($Roubant2[6][2] <= 9 ? '0'.$Roubant2[6][2]:$Roubant2[6][2]); ?></th>
                                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%"><?php echo e($Roubant2[7][2] <= 9 ? '0'.$Roubant2[7][2]:$Roubant2[7][2]); ?></th>
                                                    </tr>
                                                </thead>
                                            </table>
                                        </th>
                                    </tr>
                                </body>
                            </table>
                        </td>

                        <th style="padding: 0%; margin:0%;">
                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                <body style="padding: 0%; margin:0%;">
                                    <tr style="padding: 0%; margin:0%; font-size: 12px">
                                        <th style="padding: 5px 0px 5px 0px; margin:0%;"><?php echo e($totalRoubant2[0] <= 9 ? '0'.$totalRoubant2[0]:$totalRoubant2[0]); ?></th>
                                    </tr>
                                    <tr style="padding: 0%; margin:0%; font-size: 12px">
                                        <th style="padding: 5px 0px 5px 0px; margin:0%;"><?php echo e($totalRoubant2[1] <= 9 ? '0'.$totalRoubant2[1]:$totalRoubant2[1]); ?></th>
                                    </tr>
                                    <tr style="padding: 0%; margin:0%; background-color: #ddd; font-size: 13px">
                                        <th style="padding: 5px 0px 5px 0px; margin:0%;"><?php echo e($totalRoubant2[2] <= 9 ? '0'.$totalRoubant2[2]:$totalRoubant2[2]); ?></th>
                                    </tr>
                                </body>
                            </table>
                        </th>
                    </tr>
                </tbody>
            </table>
        </p>
    </div>

    <div style="margin-top: 15%">
        <h1 style="font-weight: bold; height: 50px; margin-left: 100px">8- <span style="text-decoration: underline;">RECAPITULATIF DES ELEVES PAR NATIONALITE</span></h1>
        <p style="margin-top: 15px;">
            <table border="2" cellpadding="10" cellspacing="0" style="border-collapse: collapse; width: 100%; border: 1px solid black;">
                <thead>
                    <tr>
                        <th style="width: 10%; padding:0%"></th>
                        <th style="width: 30%; padding:0%">
                            <p style="margin:1%; font-size: 17px">Ivoiriens</p>
                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                <thead style="padding: 0%; margin:0%;">
                                    <tr style="padding: 0%; margin:0%;">
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">Garçon</th>
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">Fille</th>
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:40%">Total</th>
                                    </tr>
                                </thead>
                            </table>
                        </th>
                        <th style="width: 30%; padding:0%">
                            <p style="margin:1%; font-size: 17px">Etrangers-Africains </p>
                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                <thead style="padding: 0%; margin:0%;">
                                    <tr style="padding: 0%; margin:0%;">
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">Garçon</th>
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">Fille</th>
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:40%">Total</th>
                                    </tr>
                                </thead>
                            </table>
                        </th>
                        <th style="width: 30%; padding:0%">
                            <p style="margin:1%; font-size: 17px">Etrangers Non-Africains</p>
                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                <thead style="padding: 0%; margin:0%;">
                                    <tr style="padding: 0%; margin:0%;">
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">Garçon</th>
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">Fille</th>
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:40%">Total</th>
                                    </tr>
                                </thead>
                            </table>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <?php $tables = ['6eme', '5eme', '4eme', '3eme', 'Cycle 1', '2nde', '1ere', 'Tle', 'Cycle 2', 'Total']; $i = 0; ?>
                        <?php $__empty_1 = true; $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $nbre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr style="background-color: <?php echo e((($tables[$i] == 'Cycle 1') || ($tables[$i] == 'Cycle 2')) ? '#ddd;':''); ?>; font-size: 15px">
                            <th style="text-align: left; padding: 0%;">
                                <p style="margin:0%; padding-left: 5%"><?php echo e(ucfirst($tables[$i])); ?></p>
                            </th>
                            <td style="text-align: center; padding: 0%;">
                                <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                    <thead style="padding: 0%; margin:0%;">
                                        <tr style="padding: 0%; margin:0%;">
                                            <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">
                                                <p style="margin:1%;"><?php echo e($nbre['col_g_1'] <= 9 ? '0'.$nbre['col_g_1']:$nbre['col_g_1']); ?></p>
                                            </th>
                                            <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">
                                                <p style="margin:1%;"><?php echo e($nbre['col_f_2'] <= 9 ? '0'.$nbre['col_f_2']:$nbre['col_f_2']); ?></p>
                                            </th>
                                            <th style="padding: 5px 0px 5px 0px; margin:0%; width:40%">
                                                <p style="margin:1%;"><?php echo e(calculTtlMls([$nbre['col_g_1'], $nbre['col_f_2']])); ?></p>
                                            </th>
                                        </tr>
                                    </thead>
                                </table>
                            </td>
                            <td style="text-align: center; padding: 0%;">
                                <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                    <thead style="padding: 0%; margin:0%;">
                                        <tr style="padding: 0%; margin:0%;">
                                            <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">
                                                <p style="margin:1%;"><?php echo e($nbre['col_g_3'] <= 9 ? '0'.$nbre['col_g_3']:$nbre['col_g_3']); ?></p>
                                            </th>
                                            <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">
                                                <p style="margin:1%;"><?php echo e($nbre['col_f_4'] <= 9 ? '0'.$nbre['col_f_4']:$nbre['col_f_4']); ?></p>
                                            </th>
                                            <th style="padding: 5px 0px 5px 0px; margin:0%; width:40%">
                                                <p style="margin:1%;"><?php echo e(calculTtlMls([$nbre['col_g_3'], $nbre['col_f_4']])); ?></p>
                                            </th>
                                        </tr>
                                    </thead>
                                </table>
                            </td>
                            <td style="text-align: center; padding: 0%;">
                                <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                    <thead style="padding: 0%; margin:0%;">
                                        <tr style="padding: 0%; margin:0%;">
                                            <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">
                                                <p style="margin:1%;"><?php echo e($nbre['col_g_5'] <= 9 ? '0'.$nbre['col_g_5']:$nbre['col_g_5']); ?></p>
                                            </th>
                                            <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">
                                                <p style="margin:1%;"><?php echo e($nbre['col_f_6'] <= 9 ? '0'.$nbre['col_f_6']:$nbre['col_f_6']); ?></p>
                                            </th>
                                            <th style="padding: 5px 0px 5px 0px; margin:0%; width:40%">
                                                <p style="margin:1%;"><?php echo e(calculTtlMls([$nbre['col_g_5'], $nbre['col_f_6']])); ?></p>
                                            </th>
                                        </tr>
                                    </thead>
                                </table>
                            </td>
                        </tr>
                            <?php $i++; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <th style="text-align: center" colspan="5">Données Introuvables</th>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </p>

    </div>

    <footer>7</footer>
</body>
</html>


<!--  8eme page du document -->
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
</head>
<style type="text/css">
    @page {
        margin: 2cm 1cm 0.5cm 1cm; /* haut droite bas gauche */
    }
    body {
        margin: 0cm;
        padding: 0cm;
        font-family: sans-serif;
        font-size: 12px
    }
    footer{
        position: fixed;
        bottom: -30px;
        border-top: 2px solid gray;
        left: 0;
        right: 0;
        height: 50px;
        text-align: right;
        font-size: 12px;
        color: #555;
    }
</style>
<body>
    <div style="margin-top: 0%">
        <h3 style="margin-left: 110px">&#x2022; TOTAL GENERAL</h3>
        <table border="2" cellpadding="10" cellspacing="0" style="border-collapse: collapse; width: 100%; border: 1px solid black;">
            <thead style="padding: 0%; margin:0%;">
                <tr>
                    <th style="width: 10%; padding:0%"></th>
                    <th style="width: 30%; padding:0%">
                        <p style="margin:1%; font-size: 17px">TOTAL Général </p>
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <thead style="padding: 0%; margin:0%;">
                                <tr style="padding: 0%; margin:0%;">
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">Garçon</th>
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">Fille</th>
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:40%">Total</th>
                                </tr>
                            </thead>
                        </table>
                    </th>
                </tr>
            </thead>
            <tbody>
                <?php $tables = ['6eme', '5eme', '4eme', '3eme', 'Cycle 1', '2nde', '1ere', 'Tle', 'Cycle 2', 'Total']; $i = 0; ?>
                <?php $__currentLoopData = $bilans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $nbre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr style="background-color: <?php echo e((($tables[$i] == 'Cycle 1') || ($tables[$i] == 'Cycle 2')) ? '#ddd;':''); ?>; font-size: 15px">
                    <th style="text-align: left; padding: 0%;">
                        <p style="margin:0%; padding-left: 5%"><?php echo e(ucfirst($tables[$i])); ?></p>
                    </th>
                    <td style="text-align: center; padding: 0%;">
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <thead style="padding: 0%; margin:0%;">
                                <tr style="padding: 0%; margin:0%;">
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">
                                        <p style="margin:1%;"><?php echo e($nbre['col_g_7']); ?></p>
                                    </th>
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">
                                        <p style="margin:1%;"><?php echo e($nbre['col_f_8']); ?></p>
                                    </th>
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:40%">
                                        <p style="margin:1%;"><?php echo e(calculTtlMls([$nbre['col_g_7'], $nbre['col_f_8']])); ?></p>
                                    </th>
                                </tr>
                            </thead>
                        </table>
                    </td>
                </tr> <?php $i++; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>

        <p style="margin-top: 15%;">
            <h1 style="font-weight: bold; height: 50px; margin-left: 100px">9- <span style="text-decoration: underline;">RESULTATS AUX EXAMENS </span></h1>
            <h3 style="margin-left: 110px; margin-top: 5%">&#x2022; NOMBRE DE CANDIDATS</h3>
            <table border="2" cellpadding="10" cellspacing="0" style="border-collapse: collapse; width: 100%; border: 1px solid black;">
                <thead>
                    <tr>
                        <th style="width: 20%; padding:0%"></th>
                        <th style="width: 40%; padding:0%">
                            <p style="margin:1%; font-size: 17px">Ivoiriens</p>
                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                <thead style="padding: 0%; margin:0%;">
                                    <tr style="padding: 0%; margin:0%;">
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">Garçon</th>
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">Fille</th>
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:40%">Total</th>
                                    </tr>
                                </thead>
                            </table>
                        </th>
                        <th style="width: 40%; padding:0%">
                            <p style="margin:1%; font-size: 17px">Etrangers</p>
                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                <thead style="padding: 0%; margin:0%;">
                                    <tr style="padding: 0%; margin:0%;">
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">Garçon</th>
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">Fille</th>
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:40%">Total</th>
                                    </tr>
                                </thead>
                            </table>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <?php $tables = ['BEPC', 'BAC A1', 'BAC A2', 'BAC C ', 'BAC D ', 'Total BAC']; $i = 0; ?>
                    <?php $__empty_1 = true; $__currentLoopData = $nbreCndts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $nbre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr style="background-color: <?php echo e((($tables[$i] == 'BEPC') || ($tables[$i] == 'Total BAC')) ? '#ddd;':''); ?>; font-size: 15px">
                            <th style="text-align: left; padding: 0%;">
                                <p style="margin:0%; padding-left: 5%"><?php echo e(ucfirst($tables[$i])); ?></p>
                            </th>
                            <td style="text-align: center; padding: 0%;">
                                <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                    <thead style="padding: 0%; margin:0%;">
                                        <tr style="padding: 0%; margin:0%;">
                                            <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">
                                                <p style="margin:1%;"><?php echo e($nbre['ivoirien_g'] <= 9 ? '0'.$nbre['ivoirien_g']:$nbre['ivoirien_g']); ?></p>
                                            </th>
                                            <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">
                                                <p style="margin:1%;"><?php echo e($nbre['ivoirien_f'] <= 9 ? '0'.$nbre['ivoirien_f']:$nbre['ivoirien_f']); ?></p>
                                            </th>
                                            <th style="padding: 5px 0px 5px 0px; margin:0%; width:40%">
                                                <p style="margin:1%;"><?php echo e(calculTtlMls([$nbre['ivoirien_g'], $nbre['ivoirien_f']])); ?></p>
                                            </th>
                                        </tr>
                                    </thead>
                                </table>
                            </td>
                            <td style="text-align: center; padding: 0%;">
                                <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                    <thead style="padding: 0%; margin:0%;">
                                        <tr style="padding: 0%; margin:0%;">
                                            <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">
                                                <p style="margin:1%;"><?php echo e($nbre['etranger_g'] <= 9 ? '0'.$nbre['etranger_g']:$nbre['etranger_g']); ?></p>
                                            </th>
                                            <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">
                                                <p style="margin:1%;"><?php echo e($nbre['etranger_f'] <= 9 ? '0'.$nbre['etranger_f']:$nbre['etranger_f']); ?></p>
                                            </th>
                                            <th style="padding: 5px 0px 5px 0px; margin:0%; width:40%">
                                                <p style="margin:1%;"><?php echo e(calculTtlMls([$nbre['etranger_g'], $nbre['etranger_f']])); ?></p>
                                            </th>
                                        </tr>
                                    </thead>
                                </table>
                            </td>
                        </tr>
                        <?php $i++; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <th style="text-align: center" colspan="5">Données Introuvables</th>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </p>

    </div>

    <footer>8</footer>
</body>
</html>



<!--  9eme page du document -->
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
</head>
<style type="text/css">
    @page {
        margin: 2cm 1cm 0.5cm 1cm; /* haut droite bas gauche */
    }
    body {
        margin: 0cm;
        padding: 0cm;
        font-family: sans-serif;
        font-size: 12px
    }
    footer{
        position: fixed;
        bottom: -30px;
        border-top: 2px solid gray;
        left: 0;
        right: 0;
        height: 50px;
        text-align: right;
        font-size: 12px;
        color: #555;
    }
</style>
<body>
    <div style="margin-top: 0%">
        <h3 style="margin-left: 110px">&#x2022; NOMBRE D’ADMIS</h3>
        <table border="2" cellpadding="10" cellspacing="0" style="border-collapse: collapse; width: 100%; border: 1px solid black;">
            <thead>
                <tr>
                    <th style="width: 20%; padding:0%"></th>
                    <th style="width: 40%; padding:0%">
                        <p style="margin:1%; font-size: 17px">Ivoiriens</p>
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <thead style="padding: 0%; margin:0%;">
                                <tr style="padding: 0%; margin:0%;">
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">Garçon</th>
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">Fille</th>
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:40%">Total</th>
                                </tr>
                            </thead>
                        </table>
                    </th>
                    <th style="width: 40%; padding:0%">
                        <p style="margin:1%; font-size: 17px">Etrangers</p>
                        <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                            <thead style="padding: 0%; margin:0%;">
                                <tr style="padding: 0%; margin:0%;">
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">Garçon</th>
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">Fille</th>
                                    <th style="padding: 5px 0px 5px 0px; margin:0%; width:40%">Total</th>
                                </tr>
                            </thead>
                        </table>
                    </th>
                </tr>
            </thead>
            <tbody>
                <?php $tables = ['BEPC', 'BAC A1', 'BAC A2', 'BAC C ', 'BAC D ', 'Total BAC']; $i = 0; ?>
                <?php $__empty_1 = true; $__currentLoopData = $adminCndts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $nbre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr style="background-color: <?php echo e((($tables[$i] == 'BEPC') || ($tables[$i] == 'Total BAC')) ? '#ddd;':''); ?>; font-size: 15px">
                        <th style="text-align: left; padding: 0%;">
                            <p style="margin:0%; padding-left: 5%"><?php echo e(ucfirst($tables[$i])); ?></p>
                        </th>
                        <td style="text-align: center; padding: 0%;">
                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                <thead style="padding: 0%; margin:0%;">
                                    <tr style="padding: 0%; margin:0%;">
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">
                                            <p style="margin:1%;"><?php echo e($nbre['ivoirien_g_ad'] <= 9 ? '0'.$nbre['ivoirien_g_ad']:$nbre['ivoirien_g_ad']); ?></p>
                                        </th>
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">
                                            <p style="margin:1%;"><?php echo e($nbre['ivoirien_f_ad'] <= 9 ? '0'.$nbre['ivoirien_f_ad']:$nbre['ivoirien_f_ad']); ?></p>
                                        </th>
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:40%">
                                            <p style="margin:1%;"><?php echo e(calculTtlMls([$nbre['ivoirien_g_ad'], $nbre['ivoirien_f_ad']])); ?></p>
                                        </th>
                                    </tr>
                                </thead>
                            </table>
                        </td>
                        <td style="text-align: center; padding: 0%;">
                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                <thead style="padding: 0%; margin:0%;">
                                    <tr style="padding: 0%; margin:0%;">
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">
                                            <p style="margin:1%;"><?php echo e($nbre['etranger_g_ad'] <= 9 ? '0'.$nbre['etranger_g_ad']:$nbre['etranger_g_ad']); ?></p>
                                        </th>
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">
                                            <p style="margin:1%;"><?php echo e($nbre['etranger_f_ad'] <= 9 ? '0'.$nbre['etranger_f_ad']:$nbre['etranger_f_ad']); ?></p>
                                        </th>
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:40%">
                                            <p style="margin:1%;"><?php echo e(calculTtlMls([$nbre['etranger_g_ad'], $nbre['etranger_f_ad']])); ?></p>
                                        </th>
                                    </tr>
                                </thead>
                            </table>
                        </td>
                    </tr>
                    <?php $i++; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <th style="text-align: center" colspan="5">Données Introuvables</th>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>

        <p style="margin-top: 10%">
            <h3 style="margin-left: 110px">&#x2022; POURCENTAGE D’ADMISSION </h3>
            <table border="2" cellpadding="10" cellspacing="0" style="border-collapse: collapse; width: 100%; border: 1px solid black;">
                <thead>
                    <tr>
                        <th style="width: 20%; padding:0%"></th>
                        <th style="width: 40%; padding:0%">
                            <p style="margin:1%; font-size: 17px">Ivoiriens</p>
                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                <thead style="padding: 0%; margin:0%;">
                                    <tr style="padding: 0%; margin:0%;">
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">Garçon</th>
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">Fille</th>
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:40%">Total</th>
                                    </tr>
                                </thead>
                            </table>
                        </th>
                        <th style="width: 40%; padding:0%">
                            <p style="margin:1%; font-size: 17px">Etrangers</p>
                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                <thead style="padding: 0%; margin:0%;">
                                    <tr style="padding: 0%; margin:0%;">
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">Garçon</th>
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">Fille</th>
                                        <th style="padding: 5px 0px 5px 0px; margin:0%; width:40%">Total</th>
                                    </tr>
                                </thead>
                            </table>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <?php $tables = ['BEPC', 'BAC A1', 'BAC A2', 'BAC C ', 'BAC D ', 'Total BAC']; $i = 0; ?>
                    <?php $__empty_1 = true; $__currentLoopData = $admins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $nbre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr style="background-color: <?php echo e((($tables[$i] == 'BEPC') || ($tables[$i] == 'Total BAC')) ? '#ddd;':''); ?>; font-size: 15px">
                            <th style="text-align: left; padding: 0%;">
                                <p style="margin:0%; padding-left: 5%"><?php echo e(ucfirst($tables[$i])); ?></p>
                            </th>
                            <td style="text-align: center; padding: 0%;">
                                <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                    <thead style="padding: 0%; margin:0%;">
                                        <tr style="padding: 0%; margin:0%;">
                                            <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">
                                                <p style="margin:1%;"><?php echo e($nbre['ivoirien_g_pr']); ?></p>
                                            </th>
                                            <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">
                                                <p style="margin:1%;"><?php echo e($nbre['ivoirien_f_pr']); ?></p>
                                            </th>
                                            <th style="padding: 5px 0px 5px 0px; margin:0%; width:40%">
                                                <p style="margin:1%;"><?php echo e($nbre['ivoirien_t_pr']); ?></p>
                                            </th>
                                        </tr>
                                    </thead>
                                </table>
                            </td>
                            <td style="text-align: center; padding: 0%;">
                                <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 11px; margin:0%">
                                    <thead style="padding: 0%; margin:0%;">
                                        <tr style="padding: 0%; margin:0%;">
                                            <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">
                                                <p style="margin:1%;"><?php echo e($nbre['etranger_g_pr']); ?></p>
                                            </th>
                                            <th style="padding: 5px 0px 5px 0px; margin:0%; width:30%">
                                                <p style="margin:1%;"><?php echo e($nbre['etranger_f_pr']); ?></p>
                                            </th>
                                            <th style="padding: 5px 0px 5px 0px; margin:0%; width:40%">
                                                <p style="margin:1%;"><?php echo e($nbre['etranger_t_pr']); ?></p>
                                            </th>
                                        </tr>
                                    </thead>
                                </table>
                            </td>
                        </tr>
                        <?php $i++; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <th style="text-align: center" colspan="5">Données Introuvables</th>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </p>
    </div>

    <div style="margin-top: 15%; margin-right: 1%">
        <section style="float: right">
            <p style="font-size: 14px; margin-bottom: 0.2%">
                Fait à <?php echo e(ucwords($school['school_city'])); ?>, le <b><?php echo e(date('d/m/Y')); ?></b>
            </p><br>
            <strong style="font-size: 17px; margin-top: 0%">
                <u>LE DIRECTEUR DES ETUDES</u>
            </strong>
            <br>
            <p style="text-align: center; font-size: 14px; margin-top: 27%">
                <b><?php echo e($personnel['name_directeur']); ?></b>
            </p>
        </section>
    </div>

    <footer>9</footer>
</body>
</html><?php /**PATH C:\Users\EDUCAS\Desktop\AppS\V4_001\resources\views/pdf/rapport1.blade.php ENDPATH**/ ?>