@extends('app')
@section('title', 'Detail user')
@section('content')
<div class="pcoded-inner-content">
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                @include('includes._alert')
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header mb-0 pb-0">
                                <div class="d-flex justify-content-between pb-2">
                                    <h4>Détail {{$user->role->role == 'enseignant' ? 'Enseignant':'Utilisateur'}}</h4>
                                    <span>
                                        <a href="{{route($user->role->role == 'enseignant' ? 'user.index':'user.index1')}}" class="btn btn-inverse btn-outline-inverse  btn-sm py-1" title="Return Back"><i class="fas fa-reply mx-0"></i></a>
                                    </span>
                                </div>
                            </div>
                            <hr class="my-0 mx-3">
                            <div class="card-body">
                                <div class="row py-3">
                                    <div class="col-sm-5 text-center pt-md-5">
                                        @if ($user->photo)
                                        <img src="{{asset('storage/'.$user->photo)}}" class="img-radius mx-0 w-25" alt="profile-image">
                                        @else
                                        <i class="fas fa-user-tie" style="font-size: 80px"></i>
                                        @endif
                                        <h6 class="mb-0 mt-2" style="font-weight: bold;">{{($user->sexe == 'F' ? 'Mde ':'M. ').strtoupper($user->first_name)}}</h6>
                                        <p class="my-0" style="font-size: 17px">{{ucwords($user->last_name)}}</p>
                                        <p class="text-muted my-1">{{ucwords($user->role->role)}}</p>
                                        @if (auth()->user()->role->role == 'admin')
                                        <a href="{{route('user.edit',$user->id)}}" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 my-1"><i class="fas fa-edit"></i> Editer</a>
                                        @endif

                                        @if($user['matter_users'])
                                        <p class="mt-3">
                                            @php $i = 1 @endphp
                                            @foreach ($user['matter_users'] as $mat)
                                                {{ ucwords($mat->matter->abbreviated ?? $mat->matter->libelle).($i < count($user['matter_users']) ? ' -':null) }}
                                                @php $i+=1 @endphp
                                            @endforeach
                                        </p>
                                        @endif
                                    </div>
                                    <div class="col-sm-7">
                                        <div class="text-start mt-3">
                                            <table class="table table-bordered mt-0">
                                                <thead>
                                                    <tr>
                                                        <th class="text-center" colspan="2">
                                                            <h5>{{ucfirst($user->role->role)}} {{$user->typeEnseignant ? '['.ucfirst($user->typeEnseignant).']':null}}</h5>
                                                        </th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr>
                                                        <td style="width: 250px"><span style="font-size: 14px">Nom</span></td>
                                                        <td><strong>{{ucfirst($user->first_name)}}</strong></td>
                                                    </tr>
                                                    <tr>
                                                        <td style="width: 250px"><span style="font-size: 14px">Prénoms</span></td>
                                                        <td><strong>{{ucfirst($user->last_name)}}</strong></td>
                                                    </tr>
                                                    <tr>
                                                        <td style="width: 250px"><span style="font-size: 14px">Sexe</span></td>
                                                        <td><strong>{{ucfirst($user->sexe = 'H' ? 'Homme':'Femme')}}</strong></td>
                                                    </tr>
                                                    <tr>
                                                        <td style="width: 250px"><span style="font-size: 14px">Situation matrimoniale</span></td>
                                                        <td><strong>{{$user->matrimoniale ? ucfirst($user->matrimoniale):'...'}}</strong></td>
                                                    </tr>
                                                    <tr>
                                                        <td style="width: 250px"><span style="font-size: 14px">Adresse E-mai</span></td>
                                                        <td><strong>{{ucfirst($user->email)}}</strong></td>
                                                    </tr>
                                                    <tr>
                                                        <td style="width: 250px"><span style="font-size: 14px">Numéro de téléphone</span></td>
                                                        <td><strong>{{ucfirst($user->telephon)}}</strong></td>
                                                    </tr>
                                                    <tr>
                                                        <td style="width: 250px"><span style="font-size: 14px">Type d'embauche</span></td>
                                                        <td><strong>{{$user->embauche ? ucfirst($user->embauche):'...'}}</strong></td>
                                                    </tr>
                                                    <tr>
                                                        <td style="width: 250px"><span style="font-size: 14px">Disponibilité </span></td>
                                                        <td><strong>{{ucfirst($user->status ? 'Oui':'Non')}}</strong></td>
                                                    </tr>
                                                   
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
<script src="{{asset('assets/js/pcoded.min.js')}}"></script>
<script src="{{asset('assets/js/vartical-layout.min.js')}}"></script>
<script src="{{asset('assets/js/jquery.mCustomScrollbar.concat.min.js')}}"></script>
@endsection