@extends('app')
@section('title', 'Gestion des classes')
@section('link')
<!-- Data Table Css -->
@endsection
@section('content')
<div class="pcoded-inner-content">
    @include('includes._alert')
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header mb-0 pb-0">
                                <div class="d-flex justify-content-between pb-2">
                                    {{-- <div></div> --}}
                                    <h4 class="m-0">Emploi du temps</h4>
                                    <h4 style="text-decoration: underline">
                                        <strong>{{$class['libelle']}}</strong>
                                    </h4>
                                    <div class="right">
                                        {{-- <span id="addBtn">Année Scolaire <strong>{{$class['schoolYear']['school_year']}}</strong></span> --}}
                                        <span style="float: right">
                                            <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" id="enseignant" data-info="{{$class['id'].'_'.$class['libelle'].'_'.$string}}" title="List Teacher" data-toggle="modal" data-target="#enseignantModal"> <i class="fas fa-user-alt m-0"></i></button>
                                            @if ($existe)
                                            <a href="{{route('time.pdf',$class->id)}}" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mr-2" title="Download pdf"> <i class="fas fa-download m-0"></i></a>
                                            @endif
                                            <a href="{{route('time.classe',$string)}}" class="btn btn-inverse btn-outline-inverse  btn-sm py-1" title="Return Back"><i class="fas fa-reply m-0"></i></a>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <hr class="my-0 mx-3">
                            <div class="card-block">
                                <div class="dt-responsive table-responsive">
                                    <table id="simpletable" class="table table-striped table-bordered nowrap">
                                        <thead>
                                            <tr style="background: rgb(237, 236, 236)">
                                                <th class="text-center" style="width: 100px">Horaires</th>
                                                @foreach ($days as $day)
                                                <th class="text-center" style="width: 100px">{{ucfirst($day['day'])}}</th>
                                                @endforeach
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($morning as $mrg)
                                            <tr>
                                                <td class="text-center">{{$mrg['debut']}} - {{$mrg['fin']}}</td>
                                                @for ($i = 0; $i < count($days); $i++)
                                                <td class="text-center">
                                                    @foreach ($dtsMrg as $item)
                                                        {{$item['ligne'] == $i+1 ? ($item['morning_time_id'] == $mrg['id'] ? $item->matter['abbreviated'] ?? $item->matter['libelle']:null):null}}
                                                    @endforeach
                                                </td>
                                                @endfor
                                            </tr> 
                                            @endforeach
                                            <tr style="background: rgb(209, 217, 221); letter-spacing: 1rem; font-size: 15px">
                                                <th colspan="{{count($days)+1}}" class="text-center py-2">APRES - MIDI</th>
                                            </tr>
                                            @foreach ($after as $atr)
                                            <tr>
                                                <td class="text-center">{{$atr['debut']}} - {{$atr['fin']}}</td>
                                                @for ($i = 0; $i < count($days); $i++)
                                                <td class="text-center">
                                                    @foreach ($dtsAfter as $item)
                                                        {{$item['ligne'] == $i+1 ? ($item['after_noon_time_id'] == $atr['id'] ? $item->matter['abbreviated'] ?? $item->matter['libelle']:null):null}}
                                                    @endforeach
                                                </td>
                                                @endfor
                                            </tr> 
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                <div class="row text-center">
                                    <div class="col-sm-12 invoice-btn-group text-center">
                                        <a href="{{route('time.create',$class->id.'_'.$string)}}" class="btn btn-inverse btn-outline-inverse py-1"> <i class="fas fa-edit"></i> Edit emploi du temps</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- @Modal -->
<div class="modal fade" id="enseignantModal" tabindex="-1" role="dialog" aria-labelledby="enseignantModalTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
      <div class="modal-content">
        <div class="modal-header bg-dark py-2">
          <h5 class="modal-title" id="enseignantModalTitle">Liste d'enseignant</h5>
          <span id="libelle" style="font-size: 18px"></span>
        </div>
        <div class="modal-body">
            <div class="dt-responsive table-responsive">
                <table id="modalEnseignant" class="table table-striped table-bordered nowrap">
                    <thead>
                        <tr>
                            <th class="text-center" style="width: 5%">N°</th>
                            <th class="text-center" style="width: 100px">Enseignant</th>
                            <th class="text-center" style="width: 70px">Discipline</th>
                        </tr>
                    </thead>
                    <tbody>
                        {{-- Contenu Table --}}
                    </tbody>
                </table>
                <span class="my-0 py-0" style="font-size: 12px" style="display: none" id="ppDiv"><u>NB</u> : Professeur Principal <strong class="text-danger">*</strong></span>
            </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</button>
          <a href="#" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" id="formUrl">Editer</a>
        </div>
      </div>
    </div>
</div>
@endsection
@section('script')
    <script src="{{asset('assets/js/pcoded.min.js')}}"></script>
    <script src="{{asset('assets/js/vartical-layout.min.js')}}"></script>
    <script src="{{asset('assets/js/jquery.mCustomScrollbar.concat.min.js')}}"></script>
    <script>
        $(document).ready(function(){

            var currentUrl = window.location.href;
            let debutUrl = currentUrl.split("classe");
           $('#enseignant').click(function() {
                $('#classe').remove();
                $('.addRow').remove();
                let val = $(this).data('info');
                $('#formUrl').attr('href', debutUrl[0]+'classe/add_teacher/'+(val.split('_'))[0]+'_'+(val.split('_'))[2]);
                $('#libelle').append('<strong id="classe">'+(val.split('_'))[1]+'</strong>');

                // Affichage des données
                $.ajax({
                    url: '{{ route('time.show_teacher') }}',
                    method: 'GET',
                    data: {
                        id: (val.split('_'))[0]
                    },
                    success: function(data){
                        console.log(data);
                        if(data.length){
                            $('#ppDiv').show();
                            $i = 0;
                            while($i < data.length){
                                $num = $i <= 9 ? '0'+($i+1):$i+1;
                                $pp = data[$i].pp == '1' ? ' <strong class="text-danger">*</strong>':'';
                                $('#modalEnseignant tbody').append('<tr class="addRow">'+
                                '<td class="text-center">'+$num+'</td>'+
                                '<td>'+data[$i].name+$pp+'</td>'+
                                '<td>'+data[$i].mat+'</td>'+
                                '</tr>');
                                $i++;
                            }
                        }
                        else{
                            $('#ppDiv').hide();
                            $('#modalEnseignant tbody').append('<tr class="addRow">'+
                                '<td class="text-center" colspan="5">Aucun enseignant disponible pour cette classe</td>'+
                            '</tr>');
                        }
                    }
                });

            });
        })
    </script>
@endsection