@extends('app')
@section('title', 'Gestion des appels')
@section('link')
<!-- Data Table Css -->
<link rel="stylesheet" href="{{asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')}}">
<link rel="stylesheet" href="{{asset('assets/pages/data-table/css/buttons.dataTables.min.css')}}">
<link rel="stylesheet" href="{{asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')}}">
<style>
    .dataTables_length label{
        display: none;
    }
</style>
@endsection
@section('content')
<div class="pcoded-inner-content">
    @include('includes._alert')
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header mb-0 pb-0">
                                <div class="d-flex justify-content-between pb-2">
                                    <h4>Cantine</h4>
                                    <span>
                                        <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-toggle="modal" data-target="#addModal" title="Add New scolarity Fee"><i class="fas fa-exchange-alt m-0"></i></button>
                                        <a href="#" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" title="Menu Canteen"><i class="fas fa-project-diagram m-0"></i></a>
                                    </span>                                
                                </div>
                            </div>
                            <hr class="my-0 mx-3">
                            <div class="card-block">
                                <div class="dt-responsive table-responsive">
                                    <table id="realtime-reorder" class="table table-striped table-bordered nowrap">
                                        <thead>
                                            <tr>
                                                <th class="text-center">N°</th>
                                                <th class="text-center">Libelle</th>
                                                <th class="text-center">Montant</th>
                                                <th class="text-center" style="width: 20%">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php $i = 1; @endphp
                                            @foreach ($data as $item)
                                            <tr>
                                                <th class="text-center">{{$i <= 9 ? '0'.$i++:$i++}}</th>
                                                <td>{{typeCenserneCanteen($item->primaire, $item->secondaire, $item->technique, $item->superieur)}}</td>
                                                <td class="text-center">{{formatMontant($item->amount->montant)}} FR CFA</td>
                                                <td style="width: 20%" class="py-1">
                                                    <div class="card-block remove-label m-0 p-0 text-center">
                                                        <button class="getDelet btn btn-sm btn-danger text-white text-center px-2 ml-1" title="Delete" data-id="{{$item->id}}" data-amount="{{$item->amount->montant}}" data-toggle="modal" data-target="#deleteModal"><i class="far fa-trash-alt"></i></button>
                                                    </div>
                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- @Modal Add -->
<div class="modal fade" id="addModal" tabindex="-1" role="dialog" aria-labelledby="addModalTitle" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
        <div class="modal-header bg-dark py-2">
            <h5 class="modal-title" id="addModalLongTitle">Canteen Prices</h5>
            <span style="font-size: 17px" id="vals">{{$year['school_year']}}</span>
        </div>
        <form action="{{route('canteen.store')}}" method="post">
            @csrf
            <div class="modal-body py-3">
                <input type="hidden" name="year" value="{{$year['id']}}">
               <div class="form-group pt-2">
                    <label for="amount" class="form-label">Montant par mois<span class="text-danger">*</span> :</label>
                    <input type="text" id="amount" name="amount" class="form-control" placeholder="Entrez le montant ..." required>
                </div>

                <div class="form-group pt-2">
                    <label class="form-label">Type conserné :</label><br>
                     @foreach ($valeurs as $item)
                    <span class="mx-2">
                        <input type="checkbox" name="type[]" id="{{changeVal($item['libelle'])}}" value="{{changeVal($item['libelle']) == 'supérieur' ? 'superieur':changeVal($item['libelle'])}}" checked>
                        <label for="{{changeVal($item['libelle'])}}" class="form-label">{{ucwords(changeVal($item['libelle']))}}</label>
                    </span>
                    @endforeach
                </div>

            </div>
            <div class="modal-footer">
                <a href="#" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</a>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
    </div>
  </div>
</div>
<!-- @Modal Add -->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalTitle" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
        <div class="modal-header bg-dark py-2">
            <h5 class="modal-title" id="deleteModalLongTitle">Delete Price</h5>
            <span style="font-size: 17px" id="valDelete"></span>
        </div>
        <form action="{{route('canteen.destroy')}}" method="post">
            @csrf
            <div class="modal-body py-3 text-center">
                <strong id="delete"></strong> FR CFA
                <p>Confirmez le supression.</p>
                <input type="hidden" id="idDelete" name="id">
            </div>
            <div class="modal-footer">
                <a href="#" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</a>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
    </div>
  </div>
</div>
@endsection
@section('script')
    <!-- data-table js -->
    <script src="{{asset('bower_components/datatables.net/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')}}"></script>
    <!-- Custom js -->
    <!-- Select2 JS -->
    <script src="{{asset('assets/pages/data-table/extensions/colreorder/js/colreorder-custom.js')}}"></script>
    <script src="{{asset('assets/js/pcoded.min.js')}}"></script>
    <script src="{{asset('assets/js/vartical-layout.min.js')}}"></script>
    <script src="{{asset('assets/js/jquery.mCustomScrollbar.concat.min.js')}}"></script>
    <script>
        $(document).ready(function(){

            $('#amount').on('input', function () {
                let value = $(this).val().replace(/\s/g, '');
                value = value.replace(/\D/g, '');
                let formatted = value.replace(/\B(?=(\d{3})+(?!\d))/g, ' ');
                $(this).val(formatted);
            });


            $('.getDelet').on('click', function() {
                $('#delete').text(formatVal($(this).data('amount')));
                $('#idDelete').val($(this).data('id'));
            });


            function formatVal($val){
                return $val.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ' ');
            }
        })
    </script>
@endsection