@extends('app')
@section('title', 'Gestion des appels')
@section('link')
<!-- Data Table Css -->
<link rel="stylesheet" href="{{asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')}}">
<link rel="stylesheet" href="{{asset('assets/pages/data-table/css/buttons.dataTables.min.css')}}">
<link rel="stylesheet" href="{{asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')}}">
<style>
    .dataTables_length label{
        display: none;
    }

    .form-control:focus {
    box-shadow: none !important;
    border-color: #ccc !important; /* ou une couleur de ton choix */
}
</style>
@endsection
@section('content')
<div class="pcoded-inner-content">
    @include('includes._alert')
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header">
                                <div class="d-flex justify-content-between">
                                    <div style="font-size: 18px">Appels du {{$cutting->cutting->libelle}}</div>
                                    <div class="text-center text-muted" style="font-size: 17px">{{strtoupper($inscris->student->first_name).' '.ucwords(limitCaracts($inscris->student->last_name,25))}} - {{$inscris->classe->libelle}}</div>
                                    <span>
                                        <a href="{{route('appel.return', $matter->matter_id.'_'.$inscris->classe->id)}}" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mr-3" title="Return Back"><i class="fas fa-reply mx-0"></i></a>
                                    </span>
                                </div>
                            </div>
                            <div class="card-block">
                                <hr>
                                <div class="dt-responsive table-responsive">
                                    <table class="table table-striped table-bordered nowrap" id="saving-reorder">
                                        <thead>
                                            <tr>
                                                <th class="text-center" style="width: 5%">N°</th>
                                                <th class="text-center" style="width: 35%">Date d'absence</th>
                                                <th class="text-center" style="width: 20%">Heure</th>
                                                <th class="text-center" style="width: 20%">statut</th>
                                                <th class="text-center" style="width: 20%">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php $i = 1; @endphp
                                            @foreach ($data as $item)
                                            @php $val1 = $item['period'] == 1 ? 'time_morning':'time_after'; $val2 = $item['period'] == 1 ? 'morning_time':'after_noon_time';@endphp
                                            <tr>
                                                <th class="text-center">{{$i <= 9 ? '0'.$i++:$i++}}</th>
                                                <td class="text-center">{{date('d-m-Y', strtotime($item['dateAbsence']))}}</td>
                                                <td class="text-center">{{$item->$val1->$val2->debut.' à '.$item->$val1->$val2->fin}}</td>
                                                <td class="text-center" title="">
                                                    <label class="label label-{{$item['justified'] ? 'success':'danger'}}" {{$item['justified'] ? '':''}} data-toggle="tooltip" title="" data-original-title="{{$item['motifs'] ? 'Motif : '.$item['motifs']:''}}">{{$item['justified'] ? 'Justifié':'Non justifié'}}</label>
                                                </td>
                                                <td style="width: 15%" class="py-1">
                                                    <div class="card-block remove-label m-0 p-0 text-center">
                                                        <button class="editAbs btn btn-sm btn-info text-center px-2 ml-2" data-id="{{$item['id']}}" data-just="{{$item['justified']}}" title="Edition" data-toggle="modal" data-target="#editAppelModal" {{$cutting->status == 2 ? 'disabled':''}}><i class="fas fa-edit m-0"></i></button>
                                                    </div>
                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Modal Add New Appel -->
<div class="modal fade" id="editAppelModal" tabindex="-1" role="dialog" aria-labelledby="editAppelModalTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header bg-dark py-2">
          <h5 class="modal-title" id="editAppelModalLongTitle">Justificatif d'absence</h5>
        </div>
        <form action="{{route('appel.update')}}" method="post">
            @csrf
            @method('put')
            <input type="hidden" name="absId" id="absenceId" value="">
            <input type="hidden" name="string" value="{{$matter->matter_id.'_'.$inscris->classe->id}}">
            <input type="hidden" name="typeEnseig" value="{{$inscris->classe->type}}">
            <div class="modal-body">
                <div class="m-b-30 mt-3">
                    <span class="mx-3" id="divAutre">
                        <input type="radio" name="type" class="type" id="autre" value="1">
                        <label for="autre">Autre</label>
                    </span>
                    <span class="mx-3">
                        <input type="radio" name="type" class="type" id="annule" value="2">
                        <label for="annule">Annulé l'absence</label>
                    </span>
                </div>
                <div class="mt-3" id="divMotif">
                    <label for="motif">Motif de justificatif<span class="text-danger">*</span> : </label>
                    <textarea name="motif" class="form-control" id="motif" rows="3" style="resize: none;" required></textarea>
                </div>
                <div class="mt-1 text-center" id="testJust" style="display: none">
                    Absence justifiée.
                </div>
            </div>
            <div class="modal-footer">
                <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</button>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
      </div>
    </div>
</div>
@endsection
@section('script')
    <!-- data-table js -->
    <script src="{{asset('bower_components/datatables.net/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')}}"></script>
    <!-- Custom js -->
    <script src="{{asset('assets/pages/data-table/extensions/colreorder/js/colreorder-custom.js')}}"></script>
    <script src="{{asset('assets/js/pcoded.min.js')}}"></script>
    <script src="{{asset('assets/js/vartical-layout.min.js')}}"></script>
    <script src="{{asset('assets/js/jquery.mCustomScrollbar.concat.min.js')}}"></script>
    <script>
        $(document).ready(function(){

            $(document).on('click', '.editAbs', function() {
                $('#absenceId').val($(this).data('id'));
                $(this).data('just') == 1 ? $('#divAutre').slideUp():$('#divAutre').slideDown();
                $(this).data('just') == 1 ? $('#divMotif').slideUp():$('#divMotif').slideDown();
                $(this).data('just') == 1 ? $('#autre').attr('checked', false):$('#autre').attr('checked', true);
                $(this).data('just') == 1 ? $('#annule').attr('checked', true):$('#annule').attr('checked', false);
                $(this).data('just') == 1 ? $('#testJust').slideDown():$('#testJust').slideUp();
            });


            $(document).on('click', '.type', function() {
                $(this).val() == 2 ? $('#divMotif').slideUp():$('#divMotif').slideDown();
                $(this).val() == 2 ? $('#motif').prop('required', false):$('#motif').prop('required', true);
            });

        })
    </script>
@endsection