@extends('auth')
@section('title', 'forgot password')
@section('content')
<form method="post" action="{{route('password.email')}}" class="md-float-material form-material">
    @csrf
    <div class="text-center">
        <img src="{{asset('assets/images/logo.png')}}" alt="logo.png">
    </div>
    <div class="auth-box card">
        <div class="card-block">
            <div class="row m-b-20">
                <div class="col-md-12">
                    <h3 class="text-left">Recover your password</h3>
                </div>
            </div>

            @error('email')
                <div class="alert alert-danger background-danger">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <i class="icofont icofont-close-line-circled text-white"></i>
                    </button>
                    <span class="form-bar" role="alert">
                        {{$message}}
                    </span>
                </div>
            @enderror

            @if (session('status'))
                <div class="alert alert-success background-success">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <i class="icofont icofont-close-line-circled text-white"></i>
                    </button>
                    <span class="form-bar" role="alert">
                        {{ session('status') }}
                    </span>
                </div>
            @endif

            <div class="form-group form-primary">
                <label for="email">Adresse mail : </label>
                <input type="email" name="email" id="email" class="form-control" value="{{ old('email') }}" placeholder="Votre adresse E-mail">
            </div>
            <div class="row">
                <div class="col-md-12 mt-2">
                    <button type="submit" class="btn btn-primary btn-md btn-block waves-effect text-center m-b-20">Reset Password</button>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12 text-center">
                    <span class="text-inverse m-b-0">Thank you, back to</span>
                    <span class="text-inverse"><a href="{{route('login')}}"><b class="f-w-600">Login.</b></a></span>
                </div>
            </div>
        </div>
    </div>
</form>
@endsection