<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
use Illuminate\Support\Facades\DB;

class ListClassStudentNoteExport implements FromView
{
    protected $class;
    protected $eval;

    public function __construct($class, $eval)
    {
        $this->classe_id = $class;
        $this->eval_id = $eval;
    }

    /**
    * @return \Illuminate\Support\Collection
    */
    public function view(): View
    {
        $data = DB::table('students')
        ->join('inscriptions', 'students.id', '=', 'inscriptions.student_id')
        ->select('inscriptions.id', 'students.first_name', 'students.last_name', 'students.matricule', 'students.sexe')
        ->where('inscriptions.classe_id', '=', $this->classe_id)
        ->orderBy('students.first_name')->orderBy('students.last_name')
        ->get();

        return view('exports.listClassStudentNote', [
            'data' => $data,
            'class' => $this->classe_id,
            'eval' => $this->eval_id
        ]);
    }
}
