@extends('app')
@section('title', 'Gestion des appels')
@section('link')
<!-- Data Table Css -->
<link rel="stylesheet" href="{{asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')}}">
<link rel="stylesheet" href="{{asset('assets/pages/data-table/css/buttons.dataTables.min.css')}}">
<link rel="stylesheet" href="{{asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')}}">
<style>
    .dataTables_length label{
        display: none;
    }
</style>
@endsection
@section('content')
<div class="pcoded-inner-content">
    @include('includes._alert')
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header">
                                <div class="d-flex justify-content-between">
                                    <h4>Gestion des zone</h4>
                                    <span>
                                        <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-toggle="modal" data-target="#addFraisModal" title="Add New Zone"><i class="fas fa-exchange-alt m-0"></i></button>
                                        <a href="{{route('transport.index')}}" class="btn btn-inverse btn-outline-inverse  btn-sm py-1" title="Return Back"><i class="fas fa-reply mx-0"></i></a>                                    
                                    </span>                                
                                </div>
                            </div>
                            <hr class="my-1 mx-3">
                            <div class="card-block">
                                <div class="dt-responsive table-responsive">
                                    <div class="tab-content card-block">
                                        <table id="realtime-reorder" class="table table-striped table-bordered nowrap">
                                            <thead>
                                                <tr>
                                                    <th class="text-center">N°</th>
                                                    <th class="text-center">Zones</th>
                                                    <th class="text-center" style="width: 20%">Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @php $i = 1; @endphp
                                                @foreach ($data as $item)
                                                <tr>
                                                    <th class="text-center">{{$i <= 9 ? '0'.$i++:$i++}}</th>
                                                    <td class="text-left pl-3">{{ucwords($item->zone->libelle)}}</td>
                                                    <td style="width: 20%" class="py-1">
                                                        <div class="card-block remove-label m-0 p-0 text-center">
                                                            <button class="getDelet btn btn-sm btn-danger text-white text-center px-2" title="Delete" data-id="{{$item->id}}" data-libelle="{{ucwords($item->zone->libelle)}}" data-toggle="modal" data-target="#deleteModal"><i class="far fa-trash-alt"></i></button>
                                                        </div>
                                                    </td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div> 
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- @Modal -->
<div class="modal fade" id="addFraisModal" tabindex="-1" role="dialog" aria-labelledby="addFraisModalTitle" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
        <div class="modal-header bg-dark py-2">
            <h5 class="modal-title" id="addFraisModalLongTitle">Add New Zone</h5>
        </div>
        <form action="{{route('transport.add_zone')}}" method="post">
            @csrf
            <div class="modal-body py-3">
                <div class="form-group pt-2">
                    <label for="libelle" class="form-label">Nouvelle Zone<span class="text-danger">*</span> :</label>
                    <input type="text" id="libelle" name="libelle" class="form-control" placeholder="Entrez la zone ..." required>
                </div>
            </div>
            <div class="modal-footer">
                <a href="#" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</a>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
    </div>
  </div>
</div>

<!-- @Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalTitle" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
        <div class="modal-header bg-dark py-2">
            <h5 class="modal-title" id="deleteModalLongTitle">Delete Zone</h5>
        </div>
        <form action="{{route('transport.delete')}}" method="post">
            @csrf
            <div class="modal-body py-3">
                <div class="form-group pt-2 text-center">
                    <strong id="delete"></strong>
                    <p>Confirmez le supression.</p>
                    <input type="hidden" id="id" name="id" value="">
                </div>
            </div>
            <div class="modal-footer">
                <a href="#" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</a>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
    </div>
  </div>
</div>
@endsection
@section('script')
    <!-- data-table js -->
    <script src="{{asset('bower_components/datatables.net/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')}}"></script>
    <!-- Custom js -->
    <script src="{{asset('assets/pages/data-table/extensions/colreorder/js/colreorder-custom.js')}}"></script>
    <script src="{{asset('assets/js/pcoded.min.js')}}"></script>
    <script src="{{asset('assets/js/vartical-layout.min.js')}}"></script>
    <script src="{{asset('assets/js/jquery.mCustomScrollbar.concat.min.js')}}"></script>
    <script>
        $(document).ready(function(){
            $('.getDelet').on('click', function (){
                $('#delete').text($(this).data('libelle'));
                $('#id').val($(this).data('id'));
            })
        })
    </script>
@endsection