@extends('app')
@section('title','List student')
@section('link')
    <!-- Data Table Css -->
    <link rel="stylesheet" href="{{asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/pages/data-table/css/buttons.dataTables.min.css')}}">
    <link rel="stylesheet" href="{{asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/pages/data-table/extensions/autofill/css/autoFill.dataTables.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/pages/data-table/extensions/autofill/css/select.dataTables.min.css')}}">
    <style>
        .dataTables_length label{
            display: none;
        }
    </style>
@endsection
@section('content')
<div class="pcoded-inner-content">
    @include('includes._alert')
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header mb-0 pb-0">
                                <div class="d-flex justify-content-between mb-0 pb-0">
                                    <h4>Parents - [{{count($parents) <= 9 ? '0'.count($parents):count($parents)}}]</h4>
                                    <span>
                                        <a href="{{route('student.index')}}" class="btn btn-inverse btn-outline-inverse  btn-sm py-1" title="Return Back"><i class="fas fa-reply mx-0"></i></a>
                                    </span>
                                </div>
                            </div>
                            <hr class="mx-3 my-0">
                            <div class="card-block my-0">
                                <div class="dt-responsive table-responsive">
                                    <div class="tab-content card-block">
                                        <table class="table table-striped table-bordered nowrap dataTable" id="myTable">
                                            <thead>
                                                <tr>
                                                    <th class="text-center" style="width: 5%"></th>
                                                    <th class="py-2">Nom</th>
                                                    <th>Prénoms</th>
                                                    <th>Sexe</th>
                                                    <th>Profession</th>
                                                    <th>Téléphone</th>
                                                    <th>Nbre Enfant</th>
                                                    <th>Message</th>
                                                    <th class="text-center">Actions</th>
                                                </tr>
                                            </thead>
                                            <!-- Content Table -->
                                        </table>
                                    </div> 
                                </div> 
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <form action="{{ route('parent.destroy') }}" method="post">
                @csrf
                <div class="modal-header bg-dark py-2">
                    <h5 class="modal-title" id="deleteModalLongTitle">Delete Parent</h5>
                    <span style="font-size: 15px" id="created"></span>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <input type="hidden" name="id" id="idDelete">
                        <div class="col-12 text-center">
                            <div class="divInfo">
                                <h5 class="mb-1 mt-2">
                                    <strong id="firstName"></strong> <br>
                                    <span class="m-0" id="lastName"></span>
                                </h5>
                                <p class="text-muted" style="font-size: 15px">Nombre d'élève: <strong id="nombre"></strong></p>
                            </div>
                            <strong>Il s'agit d'une suppression définitive.</strong><br>
                            <span>Confirmer la suppression !</span>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <a href="#" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</a>
                    <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
@section('script')
    <!-- data-table js -->
    <script src="{{asset('bower_components/datatables.net/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/js/jszip.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/js/pdfmake.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/js/vfs_fonts.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/extensions/autofill/js/dataTables.select.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')}}"></script>

    <!-- Custom js -->
    <script src="{{asset('assets/pages/data-table/extensions/autofill/js/extensions-custom.js')}}"></script>
    <script src="{{asset('assets/js/pcoded.min.js')}}"></script>
    <script src="{{asset('assets/js/vartical-layout.min.js')}}"></script>
    <script src="{{asset('assets/js/jquery.mCustomScrollbar.concat.min.js')}}"></script>
    <script>
        $(document).ready(function(){

            $('#myTable').DataTable({
                processing: true,
                serverSide: true,
                ajax: '{{ route('parent.data') }}',
                columns: [
                    { data: 'counter', className: "text-center fw-bold py-1", orderable: false, searchable: false},
                    { data: 'firstName', className: "py-1" },
                    { data: 'lastName', className: "py-1" },
                    { data: 'sexe', className: "text-center py-1" },
                    { data: 'profession', className: "text-center py-1" },
                    { data: 'telephon', className: "text-center py-1"},
                    { data: 'nombre', className: "text-center py-1"},
                    { data: 'message', className: "text-center py-1"},
                    { data: 'action', className: "text-center py-1", orderable: false, searchable: false}
                ],
                pageLength: 10,
                language: {
                    url: "//cdn.datatables.net/plug-ins/1.13.6/i18n/fr-FR.json"
                }
            });

            
            // Delete Parent ................................ 
            $(document).on('click', '.deleteBtn', function() {
                $.ajax({
                    url: '{{ route('parent.search') }}',
                    method: 'GET',
                    data: { 
                        id: $(this).data('id')
                    },
                    success: function(data){
                        if(data){
                            $('#idDelete').val(data.id);
                            $('#created').text(data.created);
                            $('#firstName').text(data.first);
                            $('#lastName').text(data.last);
                            $('#nombre').text(data.nombre);
                            $("#deleteModal").modal("show"); // Affiche Modal Delete ....................
                        }
                    }
                });
            });
        })
    </script>
@endsection