@extends('app')
@section('title', 'Add note')
@section('link')
<!-- Data Table Css -->
<link rel="stylesheet" href="{{asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')}}">
<link rel="stylesheet" href="{{asset('assets/pages/data-table/css/buttons.dataTables.min.css')}}">
<link rel="stylesheet" href="{{asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')}}">
<style>
    .dataTables_length label{
        display: none;
    }
</style>
@endsection
@section('content')
<div class="pcoded-inner-content">
    @include('includes._alert')
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <form action="{{route('evaluation.note',$evaluation->id)}}" method="post" id="myForm">
                                @csrf
                                <input type="hidden" name="evalId" value="{{$evaluation->id}}">
                                <div class="card-header mb-0 pb-0">
                                    <div class="d-flex justify-content-between">
                                        <h4>{{ $catching ? 'Rattrapage ':null }}Note -
                                            <strong style="font-size: 19px">
                                                {{ucfirst($evaluation->levelMatter->matter->abbreviated ?? $evaluation->levelMatter->matter->libelle)}}
                                                {{$evaluation->sub_matter_id ? ' ['.$evaluation->subMatter->abbreviated.']':''}}
                                            </strong>
                                        </h4>
                                        <span class="form-control-variant" style="font-size: 15px">
                                            <strong class="mr-2">{{ucfirst($evaluation->evaluationType->type)}} du {{date('d/m/Y', strtotime($evaluation['date_create']))}}</strong>
                                        </span>
                                        <span>
                                            <button id="btnValid" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-1" {{ count($students) ? '':'disabled' }}  title="Valider" data-toggle="modal" data-target="#validModal"><i class="fas fa-check mx-0"></i></button> 
                                            @if (!$catching)
                                            <a href="#" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-toggle="modal" data-target="#upload" title="Loading file"> <i class="fas fa-ellipsis-h mx-0"></i></a>
                                            @endif
                                            <a href="{{route('evaluation.show', $evaluation->id)}}" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 ml-1" title="Return Back"><i class="fas fa-reply mx-0"></i></a>
                                        </span>
                                    </div>
                                </div>
                                <hr class="mx-3 mt-0">
                                <div class="card-block">
                                    <div class="dt-responsive table-responsive px-lg-3">
                                        <table id="saving-reorder" class="table table-bordered">
                                            <thead>
                                                <tr>
                                                    <th class="text-center" style="width: 6%"></th>
                                                    <th class="text-uppercase" style="width: 20px">Matricule</th>
                                                    <th class="text-uppercase" style="width: 70px">Nom</th>
                                                    <th class="text-uppercase" style="width: 80px">Prénoms</th>
                                                    <th class="text-uppercase" style="width: 10px">Genre</th>
                                                    <th class="text-center text-uppercase" style="width: 30px">Note</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @php $i = 1; @endphp
                                                @foreach ($students as $student)
                                                <tr class="py-0">
                                                    <th class="text-center py-1">
                                                        <img src="{{ asset($student->sexe == 'F' ? 'assets/images/admin_woman.png':'assets/images/admin_man.png') }}" class="img-radius m-0 p-0" alt="Photo Stuedent" style="height: 40px; width: 40px; border: 1px solid grey">
                                                    </th>
                                                    <td>{{ $student->matricule }}</td>
                                                    <td>{{ strtoupper($student->first_name) }}</td>
                                                    <td title="{{ ucwords($student->last_name) }}">{{ Str::limit(ucwords($student->last_name), '17', '...') }}</td>
                                                    <td>{{ ucfirst($student->sexe == 'F' ? 'Féminin':'Masculin') }}</td>
                                                    <td class="text-center p-0">
                                                        <span class="d-flex mx-0 pt-1">
                                                            <input type="hidden" name="student[]" value="{{$student->id}}">
                                                            <input type="text" name="note[]" class="form-control mx-0 my-0 text-center myInput" data-vals="{{$evaluation['notee'] * 20}}" value="" maxlength="5" placeholder="---" style="width: 60%; font-weight: 600; border:none">
                                                            <strong class="mx-0 mt-2" style="font-size: 17px; font-weight: 500;">/ {{$evaluation['notee'] * 20}}</strong>
                                                        </span>
                                                    </td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Modal -->
<div class="modal fade" id="upload" tabindex="-1" role="dialog" aria-labelledby="uploadLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header bg-dark py-2">
          <h5 class="modal-title" id="uploadLabel">Importion fiche de note</h5>
        </div>
        <form action="{{route('evaluation.import',$evaluation->id.'_'.$evaluation->classe_id)}}" method="post" enctype="multipart/form-data">
            @csrf
            <div class="modal-body px-3 py-4">
                <div class="form-group mt-2">
                    <span class="d-flex justify-content-between mb-2">
                        <label for="files">Charger la fiche<span class="text-danger">*</span> : </label>
                        <a href="{{route('evaluation.export',$evaluation->id.'_'.$evaluation->classe_id)}}" class="btn btn-inverse btn-outline-inverse btn-sm py-1" title="Exemplaire du fichier"><i class="fas fa-download mx-0"></i></a>
                    </span>
                    <input type="file" name="files" id="files" class="form-control" placeholder="Importer le fichier format Excel">
                </div>
            </div>
            <div class="modal-footer">
                <a href="#" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</a>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
      </div>
    </div>
</div>
<!-- Modal Valider Note -->
<div class="modal fade" id="validModal" tabindex="-1" role="dialog" aria-labelledby="validModalTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header bg-dark py-2">
                <h5 class="modal-title" id="validModalLongTitle">Confirmed</h5>
                <h5 style="font-style: 13px">{{date('d/m/Y', strtotime($evaluation['date_create']))}}</h5>
            </div>
            <div class="modal-body py-3 text-center">
                <strong style="font-size: 16px">Validation des notes </br> {{$evaluation->levelMatter->matter->libelle}}</strong>
                <p class="text-center">Voulez-vous vraiment Valider ?</p>
            </div>
            <div class="modal-footer mt-1">
                <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</button>
                <button type="submit" id="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
    <!-- data-table js -->
    <script src="{{asset('bower_components/datatables.net/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')}}"></script>
    <!-- Custom js -->
    <script src="{{asset('assets/pages/data-table/extensions/colreorder/js/colreorder-custom.js')}}"></script>
    <script src="{{asset('assets/js/pcoded.min.js')}}"></script>
    <script src="{{asset('assets/js/vartical-layout.min.js')}}"></script>
    <script src="{{asset('assets/js/jquery.mCustomScrollbar.concat.min.js')}}"></script>
    <script>
        $(document).ready(function(){
            let table = $('#saving-reorder').DataTable();

            $('.myInput').keyup(function() {
                if($(this).val() > $(this).data('vals')){
                    $(this).val(null);
                }
            });

            // Autoriser les touches numériques (0-9) et la touche backspace (code 8)
            $('.myInput').on('keypress', function(e) {
                var key = e.which || e.keyCode;
                if ((key >= 48 && key <= 57) || key === 8 || key === 46 || key === 127) {
                    return true;
                } else {
                    e.preventDefault();
                }
            });


            $('#btnValid').on('click', function(e) {
                e.preventDefault(); // Empêche l'envoi par défaut
            });


            $('#submit').click(function(){
                // Rendre tous les éléments visibles temporairement pour que les champs soient inclus dans le formulaire
                table.rows().every(function(rowIdx, tableLoop, rowLoop) {
                    var row = this.node();
                    if (!$(row).is(':visible')) {
                        $(row).find('input, select, textarea').each(function() {
                            var name = $(this).attr('name');
                            var value = $(this).val();
                            $('<input>').attr({
                                type: 'hidden',
                                name: name,
                                value: value
                            }).appendTo('#myForm');
                        });
                    }
                });

                // Soumet le formulaire
                $('#myForm').submit();
            })
        })
    </script>
@endsection