@extends('app')
@section('title', 'Devoir Create')
@section('content')
<div class="pcoded-inner-content">
    @include('includes._alert')
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header mb-0 pb-0">
                                <div class="d-flex justify-content-between">
                                    <h4>Nouveau Devoirs</h4>
                                    <strong style="font-size: 17px">{{ $classe['libelle']. ' [ '.ucwords($cutting->cutting->libelle).']' }}</strong>
                                    <span>
                                        <a href="{{route('program.index')}}" class="btn btn-inverse btn-outline-inverse  btn-sm py-1" title="Return Back"><i class="fas fa-reply mx-0"></i></a>
                                    </span>
                                </div>
                            </div>
                            <hr class="mt-0 mx-3">
                            <div class="card-block mx-lg-3 pt-lg-3">
                                <form action="{{ route('program.store') }}" method="post">
                                    @csrf
                                    <div class="table-responsive">
                                        <table class="table table-bordered nowrap mb-1" id="myTable">
                                            <thead>
                                                <tr>
                                                    <th></th>
                                                    <th class="text-center" style="width: 25%">Matière</th>
                                                    <th class="text-center" style="width: 25%">Date</th>
                                                    <th class="text-center" style="width: 25%">Heure</th>
                                                    <th class="text-center" style="width: 20%">Période</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <th class="text-center pb-0">1</th>
                                                    <td class="p-0">
                                                        <select name="matters[]" class="form-control my-0" id="level">
                                                            <option value=" ">Matière ...</option>
                                                            @foreach ($matters as $matter)
                                                                <option value="{{ $matter['id'] }}" title="{{ ucfirst($matter['libelle']) }}">{{ ucfirst($matter['abbreviated']) }}</option>
                                                            @endforeach
                                                        </select>
                                                    </td>
                                                    <td class="p-0">
                                                        <input type="date" name="dates[]" class="form-control my-0">
                                                    </td>
                                                    <td class="p-0">
                                                        <div class="d-flex justify-content-between my-0">
                                                            <input type="time" name="debuts[]" class="form-control my-0">
                                                            <input type="time" name="fins[]" class="form-control my-0">
                                                        </div>
                                                    </td>
                                                    <td class="p-0 text-center">
                                                        <div class="radio-inline mt-2">
                                                            <label>
                                                                <input type="radio" name="period" value="1" checked>
                                                                <i class="helper"></i>Matin
                                                            </label>
                                                        </div>
                                                        <div class="radio-inline mt-2">
                                                            <label>
                                                                <input type="radio" name="period" value="2">
                                                                <i class="helper"></i>Après midi
                                                            </label>
                                                        </div>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <div class="float-right my-0">
                                            <button type="button" class="btn btn-inverse btn-outline-inverse btn-sm py-1" id="addRow">➕</button>
                                            {{-- <button type="button" class="btn btn-inverse btn-outline-inverse btn-sm py-1" id="deletRow">➖</button> --}}
                                        </div>
                                    </div>
                                    <hr class="text-center">
                                    <input type="hidden" name="choix" id="hidden-choix">
                                    <input type="hidden" name="class" value="{{ $classe['id'] }}">
                                    <input type="hidden" name="cutting" value="{{ $cutting->id }}">
                                    <div class="text-center">
                                        <button type="submit" class="btn btn-inverse btn-outline-inverse py-2 w-25" id="valider">Valider</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
<script src="{{asset('assets/pages/data-table/extensions/colreorder/js/colreorder-custom.js')}}"></script>
<script src="{{asset('assets/js/pcoded.min.js')}}"></script>
<script src="{{asset('assets/js/vartical-layout.min.js')}}"></script>
<script src="{{asset('assets/js/jquery.mCustomScrollbar.concat.min.js')}}"></script>
<script>
    $(document).ready(function() {
        // Ajouter une ligne
        $i = 1; // Compte le nombre de lignes ajoutées
        $("#addRow").on('click', function() {

            let newRow = `
            <tr>
                <th class="text-center pb-0">`+($i+=1)+`</th>
                <td class="p-0">
                    <select name="matters[]" class="form-control my-0" id="level">
                        <option value=" ">Matière ...</option>
                        @foreach ($matters as $matter)
                            <option value="{{ $matter['id'] }}" title="{{ ucfirst($matter['libelle']) }}">{{ ucfirst($matter['abbreviated']) }}</option>
                        @endforeach
                    </select>
                </td>
                <td class="p-0">
                    <input type="date" name="dates[]" class="form-control my-0">
                </td>
                <td class="p-0">
                    <div class="d-flex justify-content-between my-0">
                        <input type="time" name="debuts[]" class="form-control my-0" id="debuts">
                        <input type="time" name="fins[]" class="form-control my-0" id="fins">
                    </div>
                </td>
                <td class="p-0 text-center">
                    <div class="radio-inline mt-2">
                        <label>
                            <input type="radio" class="radio" name="period`+$i+`" value="1" checked>
                            <i class="helper"></i>Matin
                        </label>
                    </div>
                    <div class="radio-inline mt-2">
                        <label>
                            <input type="radio" class="radio" name="period`+$i+`" value="2">
                            <i class="helper"></i>Après midi
                        </label>
                    </div>
                </td>
            </tr>`;
            
            $("#myTable tbody").append(newRow);
        });


        // Récupérer les valeurs des radios cochées
        $('#valider').on('click', function() {
            let valeurs = [];

            // Pour chaque groupe de radio
            $('#myTable tr').each(function() {
            let checked = $(this).find('input[type=radio]:checked').val();
                if (checked) {
                    valeurs.push(checked);
                }
            });

            // Mettre dans le champ caché (format JSON ou liste)
            $('#hidden-choix').val(valeurs);
            console.log('Valeurs choisies :', valeurs);
        });
    })
</script>
@endsection