@extends('app')
@section('title', 'List school year')
@section('link')
    <!-- Data Table Css -->
    <link rel="stylesheet" href="{{asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/pages/data-table/css/buttons.dataTables.min.css')}}">
    <link rel="stylesheet" href="{{asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/pages/data-table/extensions/autofill/css/autoFill.dataTables.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/pages/data-table/extensions/autofill/css/select.dataTables.min.css')}}">
    <style>
        .dataTables_length{
            display: none;
        }
    </style>
@endsection
@section('content')
<div class="pcoded-inner-content">
    <div class="main-body">
        @include('includes._alert')
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header mb-0 pb-0">
                                <div class="d-flex justify-content-between pb-2">
                                    <h4>Enseignement {{ucfirst($item)}}</h4>
                                    <span>
                                        @if (!count($datas))
                                        <a href="{{route('decoupage.create',$item)}}" class="btn btn-inverse btn-outline-inverse  btn-sm py-1"><i class="fas fa-plus mx-0"></i></a>
                                        @endif
                                    </span>
                                </div>
                            </div>
                            <hr class="my-0 mx-3">
                            <div class="card-block">
                                <div class="dt-responsive table-responsive">
                                    <table id="autofill" class="table table-striped table-bordered nowrap">
                                        <thead>
                                            <tr>
                                                <th class="text-center" style="width:15px">N°</th>
                                                <th>Libellé</th>
                                                <th>Date debut</th>
                                                <th>Date fin</th>
                                                <th>Status</th>
                                                <th class="text-center">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php $i = 1; @endphp
                                            @foreach ($datas as $items)
                                            <tr>
                                                <th class="text-center">{{$i <= 9 ? '0'.$i++:$i++}}</th>
                                                <td>{{ucwords($items->cutting->libelle)}}</td>
                                                <td>{{$items->start_date}}</td>
                                                <td>{{$items->end_date}}</td>
                                                <td>
                                                    <label class="label label-{{$items->status ? ($items->status == 2 ? 'danger':'success'):'warning'}}" style="font-size: 13px">
                                                        {{$items->status ? ($items->status == 2 ? 'Terminé':'En cours'):'En attente'}}
                                                    </label>
                                                </td>
                                                <td class="py-1">
                                                    <div class="card-block remove-label m-0 p-0 text-center">
                                                        <a href="{{route('decoupage.edit',['str' => $item, 'id' => $items->cutting_id])}}" class="btn btn-sm btn-info text-center px-2" title="Edit"><i class="fas fa-edit mx-0"></i></a>
                                                        <button class="getIdButton btn btn-sm btn-danger text-white text-center px-2" title="Delete" data-div="{{$items->cutting_id}}" data-toggle="modal" data-target="#exampleModalCenter" {{$items->status ? 'disabled':''}}><i class="far fa-trash-alt mx-0"></i></button>
                                                    </div>
                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table> 
                                </div> 
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Modal -->
@include('includes._modal_simple')
@endsection
@section('script')
<script src="{{asset('bower_components/datatables.net/js/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')}}"></script>
<script src="{{asset('assets/pages/data-table/js/jszip.min.js')}}"></script>
<script src="{{asset('assets/pages/data-table/js/pdfmake.min.js')}}"></script>
<script src="{{asset('assets/pages/data-table/js/vfs_fonts.js')}}"></script>
<script src="{{asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')}}"></script>
<script src="{{asset('assets/pages/data-table/extensions/autofill/js/dataTables.select.min.js')}}"></script>
<script src="{{asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')}}"></script>
<script src="{{asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')}}"></script>
<script src="{{asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')}}"></script>
<script src="{{asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')}}"></script>
<script src="{{asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')}}"></script>

<script src="{{asset('assets/pages/data-table/extensions/autofill/js/extensions-custom.js')}}"></script>
<script src="{{asset('assets/js/pcoded.min.js')}}"></script>
<script src="{{asset('assets/js/vartical-layout.min.js')}}"></script>
<script src="{{asset('assets/js/jquery.mCustomScrollbar.concat.min.js')}}"></script>
<script>
    $('docemnt').ready(function(){
        var url = window.location.href;
        let val = url.split("decoupage");

        // Récupérer la valeur de l'attribut 'data-div' de l'élément cliqué
        $('.getIdButton').click(function() {
            var div = $(this).data('div');
            $('#myForm').attr('action', val[0]+'decoupage/'+val[val.length - 1]+'/destroy/'+div);
        });

        var url = window.location.href; // Récupère l'URL actuelle
        var motRecherche = 'decoupage';
        if (url.indexOf(motRecherche) !== -1) {
            $('#idDecoup').addClass('pcoded-trigger')
        } 
    });
</script>
@endsection