@extends('app')
@section('title', 'Gestion des appels')
@section('link')
<!-- Data Table Css -->
<link rel="stylesheet" href="{{asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')}}">
<link rel="stylesheet" href="{{asset('assets/pages/data-table/css/buttons.dataTables.min.css')}}">
<link rel="stylesheet" href="{{asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')}}">
<style>
    .dataTables_length label{
        display: none;
    }
</style>
@endsection
@section('content')
<div class="pcoded-inner-content">
    @include('includes._alert')
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header mb-0 pb-0">
                                <div class="d-flex justify-content-between mb-0 pb-0">
                                    <h4>{{$cndte->matter->libelle}}</h4>
                                    <p class="m-0" style="font-size: 17px"><strong>{{$classe['libelle']}}</strong></p>
                                    <div class="right">
                                        <span style="float: right">
                                            <button type="button" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mr-1" id="modalBtn" data-toggle="modal" data-target="#getModal" title="Approuvé"><i class="fas fa-thumbs-up mx-0"></i></button>
                                            <a href="{{route('sanction.show', $classe->id)}}" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 ml-1" title="Return Back"><i class="fas fa-reply mx-0"></i></a>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <hr class="mx-3 my-0">
                            <div class="card-block">
                                <div class="dt-responsive table-responsive">
                                    <ul class="nav nav-tabs md-tabs" role="tablist">
                                        @foreach ($data as $item)
                                        <li class="nav-item" style="width: 18%">
                                            <a class="nav-link text-left {{$item['actif'] == 1 ? 'active':''}} menuStep" data-lib="{{$item['libelle']}}" id="{{$item['actif'] == 1 ? 'active':'inactif'}}" data-actif="{{$item['actif']}}" data-id="{{$item['id']}}" data-approved="{{$item['approved']}}" data-toggle="tab" href="#home{{$item['id']}}" role="tab" aria-selected="true">
                                               {{ucfirst($item['libelle'])}}
                                            </a>
                                            <div class="slide" style="width: 16%"></div>
                                        </li>
                                        @endforeach
                                    </ul>
                                    <!-- Tab panes -->
                                    <div class="tab-content card-block">
                                        @foreach ($data as $item)
                                        <div class="tab-pane {{$item['actif'] == 1 ? 'active':''}}" id="home{{$item['id']}}" role="tabpanel">
                                            <table id="{{$item['tab']}}" class="table table-striped table-bordered nowrap">
                                                <thead>
                                                    <tr>
                                                        <th class="text-center" style="width: 5%"></th>
                                                        <th class="text-center" style="width: 10%">Matricule</th>
                                                        <th class="text-center" style="width: 25%">Nom & Prenoms</th>
                                                        <th class="text-center" style="width: 7%">Sexe</th>
                                                        <th class="text-center" style="width: 10%">Assiduité</th>
                                                        <th class="text-center" style="width: 10%">Discipline</th>
                                                        <th class="text-center" style="width: 10%">Moralite</th>
                                                        <th class="text-center" style="width: 10%">Tenue</th>
                                                        <th class="text-center" style="width: 8%">Moyenne</th>
                                                        <th class="text-center" style="width: 5%">Rang</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach ($item['data'] as $val)
                                                    <tr>
                                                        <th class="text-center py-1">
                                                            <img src="{{ asset($val['sexe'] == 'F' ? 'assets/images/admin_woman.png':'assets/images/admin_man.png') }}" class="img-radius m-0 p-0" alt="Photo Stuedent" style="height: 40px; width: 40px; border: 1px solid grey">
                                                        </th>
                                                        <td class="text-center">{{$val['matricule']}}</td>
                                                        <td class="px-3" title="{{ $val['name'] }}">
                                                            {{ Str::limit($val['name'], '27', '...') }} <strong class="text-danger" style="display: {{$val['conseil'] ? 'online':'none'}}">*</strong>
                                                        </td>
                                                        <td class="text-center">{{$val['sexe']}}</td>
                                                        <td class="text-center">{{$val['assiduite'] <= 9 ? '0'.$val['assiduite']:$val['assiduite']}}</td>
                                                        <td class="text-center">{{$val['discipline'] <= 9 ? '0'.$val['discipline']:$val['discipline']}}</td>
                                                        <td class="text-center">{{$val['moralite'] <= 9 ? '0'.$val['moralite']:$val['moralite']}}</td>
                                                        <td class="text-center">{{$val['tenue'] <= 9 ? '0'.$val['tenue']:$val['tenue']}}</td>
                                                        <td class="text-center">{{$val['moyen']}}</td>
                                                        <td class="text-center">{{$val['rang']}}</td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                        @endforeach
                                    </div> 
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Modal -->
<div class="modal fade" id="getModal" tabindex="-1" role="dialog" aria-labelledby="getModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header bg-dark py-2">
                <h5 class="modal-title" id="getModalLongTitle">Moyenne Conduite</h5>
            </div>
            <form action="{{route('conduite.store')}}" method="post" id="formEvaluats">
                @csrf
                <div class="modal-body">
                    <p class="text-center">Validation des moyennes de conduites</p>
                    <div class="text-center" style="font-weight: 800;" id="libelle"></div>
                    <input type="hidden" name="classe" value="{{$classe->id}}">
                    <input type="hidden" name="cutting" value="" id="cutting">
                    <input type="hidden" name="matter" value="{{$cndte->id}}">
                </div>
                <div class="modal-footer">
                    <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</button>
                    <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
@section('script')
    <!-- data-table js -->
    <script src="{{asset('bower_components/datatables.net/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')}}"></script>
    <!-- Custom js -->
    <script src="{{asset('assets/pages/data-table/extensions/colreorder/js/colreorder-custom.js')}}"></script>
    <script src="{{asset('assets/js/pcoded.min.js')}}"></script>
    <script src="{{asset('assets/js/vartical-layout.min.js')}}"></script>
    <script src="{{asset('assets/js/jquery.mCustomScrollbar.concat.min.js')}}"></script>
    <script>
        $(document).ready(function(){
            $('.dataTables_length').append('<span class="my-0 mx-2"><strong class="text-danger">*</strong> Elève traduit en conseil de discipline !</span>');

            $val = $('#active').data('id');
            $('#active').data('approved') ? $('#modalBtn').css('visibility', 'hidden'):$('#modalBtn').css('visibility', 'visible');
            $('#cutting').val($val);
            $('.nav-link').on('click', function(){
                $val = $(this).data('id');
                $('#cutting').val($val);
                $(this).data('approved') ? $('#modalBtn').css('visibility', 'hidden'):$('#modalBtn').css('visibility', 'visible');
            });

            $('#modalBtn').on('click', function() {
                $val = $('#cutting').val();
                if($val){
                    $.ajax({
                        url: '{{route('conduite.search')}}',
                        method: 'GET',
                        data: {
                            id: $val
                        },
                        success: function(data){
                            $('#libelle').text(data);
                        }
                    });
                }
            })
            
        })
    </script>
@endsection