<?php

namespace App\Models;
use Illuminate\Support\Facades\Storage;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    /** @use HasFactory<\Database\Factories\UserFactory> */
    use HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */
    // protected $fillable = [
    //     'first_name',
    //     'last_name',
    //     'email',
    //     'phon',
    //     'role',
    //     'school_id',
    //     'password',
    // ];


    protected $guarded = [];

    public function role(){
        return  $this->belongsTo(Role::class);
    }

    public function school(){
        return  $this->belongsTo(School::class);
    }


    public function level(){
        return  $this->belongsTo(Level::class);
    }


    public function typeEnseignement(){
        return $this->belongsTo(TypeEnseignement::class);
    }


    public function matter_users(){
        return $this->hasMany(MatterUser::class);
    }


    public function urlUser(){
        return Storage::url($this->photo);
    }


    /**
     * The attributes that should be hidden for serialization.
     *
     * @var list<string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
        ];
    }
}
