<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Classe;
use App\Models\Setting;
use App\Models\Absence;
use App\Models\SubMatter;
use App\Models\SchoolYear;
use App\Models\Inscription;
use App\Models\MoyenneBilan;
use App\Models\ResultatClasse;
use App\Models\MoyenneSubMatter;
use App\Models\ClasseEnseignant;
use App\Models\MoyenneTrimestrielle;
use App\Models\MoyenneDecoupageMatiere;
use App\Models\CuttingSchoolYear;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use PDF;

class ResultatController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        try{
            $data = Setting::where('school_id', auth()->user()->school_id)->first();
            return view('pages.resultats.index',[
                'data' => $this->typeEnseignement($data)
            ]);
        }
        catch(\Exception $e){
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue !'
            ]);
        }
    }


    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        try{
            $type = ['secondaire' => 'general', 'technique' => 'technique', 'superieur' => 'superieur'];
            $class = Classe::find($id);
            $cutting = CuttingSchoolYear::where('type', $type[$class['type']])->where('school_year_id', $class['school_year_id'])->get();
            return view('pages.resultats.detail',[
                'classe' => $class,
                'enseignant' => $this->profPrincipal($id),
                'datas' => $this->getCutting($cutting, $class)
            ]);
        }
        catch(\Exception $e){
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue !'
            ]);
        }
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $str)
    {
        try{
            $val = explode('_', $str); 
            $class = Classe::find($val[0]);
            $prof = ClasseEnseignant::where('classe_id', $val[0])->where('prof_prl', '1')->first();
            return view('pages.resultats.list_classe',[
                'classe' => $class,
                'prof' => $prof,
                'cutting' => CuttingSchoolYear::find($val[1]),
                'data' => $this->getStudentsClass($class, $val[1])
            ]);
        }
        catch(\Exception $e){
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue !'
            ]);
        }
    }

    /**
     * File pdf the specified resource in storage.
     */
    public function generate(Request $request)
    {
        try{
            $val = $request->validate([
                'tags' => 'required|array',
                'classe' => 'required|string',
                'cutting' => 'required|string',
            ]);
            $classe = Classe::find($val['classe']);

            $datas = $this->getResultStudent($val['tags'], $val['classe'], $val['cutting']);
            $pdf = PDF::loadView(('pdf.bulletins.'.$this->getLienBulletin($val['cutting'])),['datas' => $datas, 'classe' => $classe]);

            $pdf->setPaper('A4', 'portrait');
            return $pdf->stream('bulletin_'.$classe['libelle'].time().'.pdf');
        }
        catch(\Exception $e){
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue !'
            ]);
        }
    }

    /**
     * Get data class the specified resource from storage.
     */
    protected function getResultStudent($students, $class, $cutting)
    {
        $data = [];
        $classe = Classe::find($class);
        $decoup = CuttingSchoolYear::find($cutting);
        // $verify = explode(' ', $decoup->cutting->libelle);
        foreach($students as $item){
            $moyenne = MoyenneTrimestrielle::where('inscription_id', $item)->where('cutting_school_year_id', $cutting)->first();
            if($moyenne['moyenne'] != 'nc'){
                $data[] = [
                    'resultat' => $moyenne,
                    'cutting' => $decoup,
                    'school' => Setting::where('school_id', auth()->user()->school_id)->first(),
                    'student' => $this->studentGet($item, $class),
                    'infosLts' => $this->verifyLevel($classe['level_id']) ? array_merge($this->subMatterLevel($item, $cutting), $this->getMoyenneStudent($item, $class, $cutting, 1)):$this->getMoyenneStudent($item, $class, $cutting, 1),
                    'infosSns' => $this->getMoyenneStudent($item, $class, $cutting, 2),
                    'infosAts' => $this->getMoyenneStudent($item, $class, $cutting, 3),
                    'bilanLts' => $this->getBilanMatiere($item, 1, $cutting), // Bilan Lettres
                    'bilanSns' => $this->getBilanMatiere($item, 2, $cutting), // Bilan Sciences
                    'bilanAts' => $this->getBilanMatiere($item, 3, $cutting), // Autres Bilan
                    'absence_justified' => $this->getAbsences($item, $class, 0), // Absence justifiee ....
                    'absence_no_justified' => $this->getAbsences($item, $class, 1), // Absence justifiee ....
                    'result_classe' => $this->resultClasse($class, $cutting), // Resultat de la classe .......
                    'profs' => $this->profPrincipal($class), // Professeur principal
                    'directeur' => $this->directeurEtude(),
                    'trim1' => $this->resultatFin($item, $class, 1),
                    'trim2' => $this->resultatFin($item, $class, 2),
                    'trim3' => $this->resultatFin($item, $class, 3),
                    'libelle' => $this->getTypeStudent($cutting)
                ];
            }
        }
        return $data ?? [];
    }

    /**
     * Get data class the specified resource from storage.
     */
    protected function studentGet($item, $classe){
        $val = Inscription::where('id', $item)->where('classe_id', $classe)->where('school_id', auth()->user()->school_id)->first();
        return $val;
    }

    /**
     * Get data class the specified resource from storage.
     */
    protected function typeEnseignement($dts)
    {
        $tab = []; $i = 0; $primaire = 0; $cycle = 0;
        $school = auth()->user()->school_id;
        $year = $this->yearActif();
        $data = [1 => 'realtime-reorder', 2 => 'basic-col-reorder', 3 => 'saving-reorder', 4 => 'predefine-reorder', 5 => null];
        foreach ($dts->school->typeEnseignements as $item) {
            if(!$primaire && ($item['id'] == 1 || $item['id'] == 2)){
                $tab[] = [
                    'nbre' => $i+=1, 
                    'tab' => $data[$i], 
                    'libelle' => verifyPrimaire($dts->school->typeEnseignements),
                    'data' => Classe::where('type', 'primaire')->where('school_year_id', $year['id'])->where('status', '1')->where('school_id', $school)->orderBy('level_id')->get()
                ];$primaire++;
            }
            elseif(!$cycle && ($item['id'] == 3 || $item['id'] == 4)){
                $tab[] = [
                    'nbre' => $i+=1,
                    'tab' => $data[$i], 
                    'libelle' => verifySeconde($dts->school->typeEnseignements),
                    'data' => Classe::where('type', 'secondaire')->where('school_year_id', $year['id'])->where('status', '1')->where('school_id', $school)->orderBy('level_id')->get(),
                ];$cycle++;
            }
            elseif($item['id'] == 5){
                $val = $item['type_enseignement'];
                $tab[] =[
                    'nbre' => $i+=1, 
                    'tab' => $data[$i], 
                    'libelle' => $val,
                    'data' => Classe::where('type', 'technique')->where('school_year_id', $year['id'])->where('status', '1')->where('school_id', $school)->orderBy('level_id')->get(),
                ];
            }
            elseif($item['id'] == 6){
                $val = $item['type_enseignement'];
                $tab[] =[
                    'nbre' => $i+=1, 
                    'tab' => $data[$i], 
                    'libelle' => $val,
                    'data' => Classe::where('type', 'superieur')->where('school_year_id', $year['id'])->where('status', '1')->where('school_id', $school)->orderBy('level_id')->get(),
                ];
            }
        }
        return $tab;
    }


    /**
     * Gestion the cutting school year the specified resource from storage.
     */
    protected function getCutting($cutting, $class)
    {
        $tabs = []; $i = 1;
        $data = [1 => 'realtime-reorder', 2 => 'basic-col-reorder', 3 => 'saving-reorder', 4 => 'predefine-reorder', 5 => null];
        foreach($cutting as $item){
            $tabs[] = [
                'id' => $item->id,
                'libelle' => $item->cutting['libelle'],
                'actif' => $item->status,
                'tab' => $data[$i], 
                // 'sexeF10' => $this->calculPourcentagePlus($class, $item->id, 'F'),
                // 'sexeM10' => $this->calculPourcentagePlus($class, $item->id, 'M'),
                // 'sexeF9' => $this->calculPourcentageMoins($class, $item->id, 'M'),
                // 'sexeM9' => $this->calculPourcentageMoins($class, $item->id, 'M'),
                'plus' => $this->calculPourcentageTotal($class, $item->id, 'plus'),
                // 'moins' => $this->calculPourcentageTotal($class, $item->id, 'moins'),
                'data' => $this->bestStudentsClass($class, $item->id),
                'resultat' => ResultatClasse::where('classe_id', $class['id'])->where('cutting_school_year_id', $item->id)->first()
            ];
            $i++;
        }
        return $tabs;
    }


    protected function countStudentSexe($class, $cutting, $sexe)
    {
        $result = DB::table('moyenne_trimestrielles')
        ->join('inscriptions', 'inscriptions.id', '=', 'moyenne_trimestrielles.inscription_id')
        ->join('students', 'students.id', '=', 'inscriptions.student_id')
        ->where('moyenne_trimestrielles.cutting_school_year_id', '=', $cutting)
        ->where('inscriptions.classe_id', '=', $class->id)->where('students.sexe', '=', $sexe)->count();
        return $result;
    }


    protected function countMoyenneSuperieura10($class, $cutting, $sexe)
    {
        $result = DB::table('moyenne_trimestrielles')
        ->join('inscriptions', 'inscriptions.id', '=', 'moyenne_trimestrielles.inscription_id')
        ->join('students', 'students.id', '=', 'inscriptions.student_id')
        ->where('moyenne_trimestrielles.cutting_school_year_id', '=', $cutting)
        ->where('moyenne_trimestrielles.moyenne', '>=', '10')
        ->where('inscriptions.classe_id', '=', $class->id)->where('students.sexe', '=', $sexe)->count();
        return $result;
    }


    protected function calculPourcentagePlus($class, $cutting, $sexe)
    {
        $total = $this->countStudentSexe($class, $cutting, $sexe);
        $dispo = $this->countMoyenneSuperieura10($class, $cutting, $sexe);

        $vals = $dispo ? round(($dispo/$total)*100):00;
        return $vals ? ($vals < 10 ? '0'.$vals:$vals):$vals;
    }


    protected function calculPourcentageMoins($class, $cutting, $sexe)
    {
        $total = $this->countStudentSexe($class, $cutting, $sexe);
        $dispo = $this->countMoyenneSuperieura10($class, $cutting, $sexe);
        $nbreMoins = $total - $dispo;

        $vals = $nbreMoins ? round(($nbreMoins/$total)*100):00;
        return $vals ? ($vals < 10 ? '0'.$vals:$vals):$vals;
    }


    protected function calculPourcentageTotal($class, $cutting, $statut)
    {
        $sexeF = $this->countStudentSexe($class, $cutting, 'F');
        $dispF = $this->countMoyenneSuperieura10($class, $cutting, 'F');
        $sexeM = $this->countStudentSexe($class, $cutting, 'M');
        $dispM = $this->countMoyenneSuperieura10($class, $cutting, 'M');

        if($statut == 'plus'){
            $vals = ($sexeF + $sexeM) ? round((($dispF + $dispM) / ($sexeF + $sexeM))*100):00;
        }
        elseif($statut == 'moins'){
            $moins = ($sexeF + $sexeM) - ($dispF + $dispM);
            $vals = ($sexeF + $sexeM) ? round(($moins / ($sexeF + $sexeM))*100):00;
        }
        return $vals ? ($vals < 10 ? '0'.$vals:$vals):$vals;
    }


    protected function bestStudentsClass($class, $cutting)
    {
        $result = DB::table('moyenne_trimestrielles')
        ->join('inscriptions', 'inscriptions.id', '=', 'moyenne_trimestrielles.inscription_id')
        ->join('students', 'students.id', '=', 'inscriptions.student_id')
        ->select('moyenne_trimestrielles.moyenne', 'moyenne_trimestrielles.rang', 'students.first_name', 'students.last_name', 'students.sexe', 'students.photo')
        ->where('moyenne_trimestrielles.cutting_school_year_id', '=', $cutting)
        ->where('moyenne_trimestrielles.moyenne', '!=', 'nc')
        ->where('inscriptions.classe_id', '=', $class->id)
        ->orderByDesc('moyenne_trimestrielles.moyenne')->take(3)->get();

        return json_decode($result, true);
    }


    protected function getStudentsClass($class, $cutting)
    {
        $result = DB::table('moyenne_trimestrielles')
        ->join('inscriptions', 'inscriptions.id', '=', 'moyenne_trimestrielles.inscription_id')
        ->join('students', 'students.id', '=', 'inscriptions.student_id')
        ->where('moyenne_trimestrielles.cutting_school_year_id', '=', $cutting)
        ->where('inscriptions.classe_id', '=', $class->id)
        ->orderBy('students.first_name')->orderBy('students.last_name')
        ->get();
        return json_decode($result, true);
    }


    protected function getBilanMatiere($student, $bilan, $cutting)
    {
        $vals = MoyenneBilan::where('inscription_id', $student)->where('libelle_bilan_id', $bilan)->where('cutting_school_year_id', $cutting)->first();
        return $vals;
    }


    protected function subMatterLevel($student, $cutting){

        $matters = SubMatter::get(['id', 'abbreviated', 'libelle']);
        $vals = [];
        foreach($matters as $item){
            $moyens = MoyenneSubMatter::where('inscription_id', $student)->where('sub_matter_id', $item['id'])->where('cutting_school_year_id', $cutting)->first();
            $vals[] = [
                'libelle' => $item['libelle'],
                'coef' => $moyens ? $moyens['coefficient']:'nc',
                'moyenne' => $moyens ? $moyens['moyenne']:'nc',
                'rang' => $moyens ? $moyens['rang']:'nc',
                'prof' => '---'
            ];
        }
        return $vals;
    }


    protected function verifyLevel($val)
    {
        return in_array($val, [10,11,12,13]);
    }

    /**
     * Get school year actif the specified resource from storage.
     */
    protected function getMoyenneStudent($student, $class, $cutting, $bilan)
    {
        $class = Classe::find($class);
        $datas = $this->getMatiereStris($class, $bilan);
        $vals = [];
        foreach($datas as $item){
            if($class['type'] == 'secondaire' && $item['libelle'] == 'LV2'){
                $lv2 = Inscription::where('id', $student)->first('lv2');
                $moyens = $this->moyenneStudentLv2($student, $cutting, $class, $lv2['lv2']);
                $vals[] = [
                    'libelle' => $item['libelle'],
                    'coef' => $moyens ? $moyens['coef']:'nc',
                    'moyenne' => $moyens ? $moyens['moyen']['moyenne']:'nc',
                    'rang' => $moyens ? $moyens['moyen']['rang']:'nc',
                    'prof' => $moyens ? $this->profMatiere($class['id'], $item['matter_id']):'---'
                ];
            }
            else{
                $moyens = MoyenneDecoupageMatiere::where('inscription_id', $student)->where('level_matter_id', $item['id'])->where('cutting_school_year_id', $cutting)->first();
                $vals[] = [
                    'libelle' => $item['libelle'],
                    'coef' => $moyens ? $item['valeur']:'nc',
                    'moyenne' => $moyens ? $moyens['moyenne']:'nc',
                    'rang' => $moyens ? $moyens['rang']:'nc',
                    'prof' => $moyens ? $this->profMatiere($class['id'], $item['matter_id']):'---'
                ];
            }
        }
        return $vals; // .....................................
    }

    // Gestion des matières avec art plistaque et musique
    protected function getMatiereStris($class, $bilan){
        $dtas = $this->getMatieres($class['level_id'], $class['type'], $bilan, $class['lv2'], $class['serie_id']);
        if($class['additif']){
            $additif = $class['additif'] == 'AP' ? 'Mus':'AP';
            $matters = $dtas->where('abbreviated', '!=', $additif);
        }
        else{
            $matters = $dtas->where('libelle', '!=','Arts plastique')->where('libelle', '!=','Musique');
        }
        return json_decode($matters, true);
    }


    // Recupperation des matières selon le niveau de la classe ......................................
    protected function getMatieres($level, $type, $bilan, $lv2 = null, $serie = null)
    {
        if($lv2){
            $matters =  DB::table('matters')
            ->join('level_matter', 'matters.id', '=', 'level_matter.matter_id')
            ->join('libelle_bilan_matter', 'matters.id', '=', 'libelle_bilan_matter.matter_id')
            ->join('coefficients', 'coefficients.id', '=', 'level_matter.coefficient_id')
            ->select('level_matter.id', 'level_matter.matter_id', 'matters.libelle', 'matters.abbreviated', 'coefficients.valeur', DB::raw("IF(libelle = 'Mixte', 'LV2', libelle) as libelle"))
            ->where('level_matter.school_id', '=', auth()->user()->school_id)
            ->where('level_matter.level_id', '=', $level)
            ->where('level_matter.type', '=', $type)
            ->where('level_matter.serie_id', '=', $serie)
            ->where('matters.libelle', '!=', 'Allemand')
            ->where('matters.libelle', '!=', 'Espagnol')
            ->where('libelle_bilan_matter.libelle_bilan_id', '=', $bilan)
            ->orderBy('libelle_bilan_matter.bilan')->get();
        }
        else{
            $matters =  DB::table('matters')
            ->join('level_matter', 'matters.id', '=', 'level_matter.matter_id')
            ->join('libelle_bilan_matter', 'matters.id', '=', 'libelle_bilan_matter.matter_id')
            ->join('coefficients', 'coefficients.id', '=', 'level_matter.coefficient_id')
            ->select('level_matter.id', 'level_matter.matter_id', 'matters.libelle', 'matters.abbreviated', 'coefficients.valeur')
            ->where('level_matter.school_id', '=', auth()->user()->school_id)
            ->where('level_matter.level_id', '=', $level)
            ->where('level_matter.type', '=', $type)
            ->where('level_matter.serie_id', '=', $serie)
            ->where('matters.libelle', '!=', 'Mixte')
            ->where('matters.libelle', '!=', 'Allemand')
            ->where('matters.libelle', '!=', 'Espagnol')
            ->where('libelle_bilan_matter.libelle_bilan_id', '=', $bilan)
            ->orderBy('libelle_bilan_matter.bilan')->get();
        }
        return $matters;
    }

    // Recupperation de la moyenne de l'élève pour LV2 ............................................
    protected function moyenneStudentLv2($student, $cutting, $class, $lv2)
    {
        $matter =  DB::table('matters')
        ->join('level_matter', 'matters.id', '=', 'level_matter.matter_id')
        ->join('coefficients', 'coefficients.id', '=', 'level_matter.coefficient_id')
        ->select('level_matter.id', 'coefficients.valeur')
        ->where('level_matter.school_id', '=', auth()->user()->school_id)
        ->where('level_matter.level_id', '=', $class['level_id'])
        ->where('level_matter.type', '=', $class['type'])
        ->where('level_matter.serie_id', '=', $class['serie_id'])
        ->where('matters.libelle', '=', ucfirst($lv2))
        ->orderBy('matters.libelle')->first();
        if($matter){
            $moyen = MoyenneDecoupageMatiere::where('inscription_id', $student)->where('level_matter_id', $matter->id)->where('cutting_school_year_id', $cutting)->first();
        }
        return $moyen ? ['coef' => $matter->valeur, 'moyen' => $moyen]:null;
    }


    // Recuperation des moyennes des sous matieres en français .........................
    protected function subMatterMoyenne($student, $cutting)
    {
        $matters = SubMatter::get(['id', 'abbreviated', 'libelle']);
        $data = [];
        foreach($matters as $item){
            $data[] = MoyenneSubMatter::where('inscription_id', $student)->where('sub_matter_id', $item['id'])->where('cutting_school_year_id', $cutting)->first();
        }
        return $data;
    }


    protected function resultClasse($classe, $cutting)
    {
        $data = ResultatClasse::where('classe_id', $classe)->where('cutting_school_year_id', $cutting)->first();
        return $data;
    }



    protected function getAbsences($student, $cutting, $item)
    {
        $nbres = Absence::where('inscription_id', $student)->where('cutting_school_year_id', $cutting)->where('justified', $item)->count();
        return $nbres <= 9 ? '0'.$nbres:$nbres;
    }


    protected function directeurEtude()
    {
        $user = User::where('school_id', auth()->user()->school_id)->where('role_id', '4')->first();
        return $user ? ($user->sexe == 'F' ? 'Mme '.strtoupper($user->first_name).' '.ucwords($user->last_name):'M. '.strtoupper($user->first_name).' '.ucwords($user->last_name)):'---';
    }

    protected function profPrincipal($classe)
    {
        $prof = ClasseEnseignant::where('classe_id', $classe)->where('prof_prl', '1')->first();
        return $prof ? ($prof->user->sexe == 'F' ? 'Mme '.strtoupper($prof->user->first_name).' '.ucwords($prof->user->last_name):'M. '.strtoupper($prof->user->first_name).' '.ucwords($prof->user->last_name)):'---';
    }


    protected function profMatiere($classe, $matter)
    {
        $prof = ClasseEnseignant::where('classe_id', $classe)->where('matter_id', $matter)->first();
        $val = $prof ? explode(' ', $prof->user->last_name):null;
        return $prof ? ($prof->user->sexe == 'F' ? 'Mme '.strtoupper($prof->user->first_name).' '.ucwords(substr($val[0], 0, 1)).' '.ucwords(substr($val[1], 0, 1)):'M. '.strtoupper($prof->user->first_name).' '.ucwords(substr($val[0], 0, 1)).' '.ucwords(substr($val[1], 0, 1))):null;
    }


    protected function resultatFin($student, $id, $val)
    {
        $type = ['secondaire' => 'general', 'technique' => 'technique', 'superieur' => 'superieur'];
        $class = Classe::find($id);
        $dts = CuttingSchoolYear::where('type', $type[$class['type']])->where('school_year_id', $class['school_year_id'])->orderBy('cutting_id', 'ASC')->get();
        $data = [];
        foreach($dts as $item){
            $data[] = MoyenneTrimestrielle::where('inscription_id', $student)->where('cutting_school_year_id', $item['id'])->first();
        }
        return $data[--$val];
    }

    protected function getLienBulletin($id = 1){
        $tables = ['bulletin_1', 'bulletin_2', 'bulletin_3'];
        $cutting = CuttingSchoolYear::find($id);
        $year = SchoolYear::find($cutting['school_year_id']);
        $libelle = explode(' ', $cutting['cutting']['libelle']);
        if(($year['decoupage'] == 'trimestre') && ($cutting['type'] == 'general')){
           $lien = $tables[$libelle[1]-1];
        }
        else{
           $lien =  ($libelle[1] == 2) ? $tables[$libelle[1]]:$tables[$libelle[1]-1]; 
        }
        return $lien;
    }

    protected function getTypeStudent($id){
        $cutting = CuttingSchoolYear::find($id);
        $year = SchoolYear::find($cutting['school_year_id']);
        return (($year['decoupage'] == 'trimestre') && ($cutting['type'] == 'general')) ? 'Trim':'Sem'; 
    }

    /**
     * Get school year actif the specified resource from storage.
     */
    protected function yearActif(){
        $dts = SchoolYear::where('status', '1')->first();
        return $dts;
    }
}