
<?php $__env->startSection('title', 'rapport de rentree'); ?>
<?php $__env->startSection('link'); ?>
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('bower_components/jquery.steps/demo/css/jquery.steps.css')); ?>">
<style>
    .user-card2 .risk-rate .span:after {
        background: rgb(168, 168, 168)
    }

    #disabled-link {
        pointer-events: none;   /* Désactive le clic */
        color: gray;            /* Grise le texte */
        text-decoration: none;  /* Optionnel : enlève le soulignement */
        cursor: default;        /* Change le curseur */
        opacity: 0.6;           /* Optionnel : rend le lien un peu transparent */
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="pcoded-inner-content">
    <?php echo $__env->make('includes._alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12"> 
                        <div class="card">
                            <div class="card-header mb-0 pb-0">
                                <div class="d-flex justify-content-between">
                                    <h4>Rapport de rentrée</h4>
                                    <span>
                                        <button class="btn btn-inverse btn-outline-inverse  btn-sm py-1 ml-2" data-toggle="modal" data-target="#addModal" title="Parametre">
                                            <i class="fa fa fa-gavel mx-0"></i>
                                        </button>
                                    </span> 
                                </div>
                            </div>
                            <hr class="mx-3 mt-0">
                            <div class="card-block">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="card feed-card">
                                            <div class="card-header">
                                                <div class="d-flex justify-content-between">
                                                    <h5><b>Options De Paramètrages</b></h5>
                                                    <h5><b>Statut</b></h5>
                                                </div>
                                                <hr class="my-1 mx-3">
                                            </div>
                                            <div class="card-block">
                                                <div class="row m-b-30">
                                                    <div class="col-auto p-r-0">1</div>
                                                    <div class="col">
                                                        <h6 class="m-b-5">Personnels Administratifs <span class="pcoded-badge label label-<?php echo e($personnel ? 'success':'danger'); ?> f-right f-10"><?php echo e($personnel ? 'Actif':'Inactif'); ?></span>
                                                        </h6>
                                                    </div>
                                                </div>
                                                <div class="row m-b-30">
                                                    <div class="col-auto p-r-0">2</div>
                                                    <div class="col">
                                                        <h6 class="m-b-5">Effectif des Enseignants par Discipline <span class="pcoded-badge label label-<?php echo e($discipline ? 'success':'danger'); ?> f-right f-10"><?php echo e($discipline ? 'Actif':'Inactif'); ?></span>
                                                        </h6>
                                                    </div>
                                                </div>
                                                <div class="row m-b-30">
                                                    <div class="col-auto p-r-0">3</div>
                                                    <div class="col">
                                                        <h6 class="m-b-5">Organisation Matérielle <span class="pcoded-badge label label-<?php echo e($materiel ? 'success':'danger'); ?> f-right f-10"><?php echo e($materiel ? 'Actif':'Inactif'); ?></span>
                                                        </h6>
                                                    </div>
                                                </div>
                                                <div class="row m-b-20">
                                                    <div class="col-auto p-r-0">4</div>
                                                    <div class="col">
                                                        <h6 class="m-b-5">Activités Parascolaires <span class="pcoded-badge label label-<?php echo e($activity ? 'success':'danger'); ?> f-right f-10"><?php echo e($activity ? 'Actif':'Inactif'); ?></span>
                                                        </h6>
                                                    </div>
                                                </div>
                                                <div class="row m-b-20">
                                                    <div class="col-auto p-r-0">5</div>
                                                    <div class="col">
                                                        <h6 class="m-b-5">Recapitulatif des Elèves par Nationalité <span class="pcoded-badge label label-<?php echo e($student ? 'success':'danger'); ?> f-right f-10"><?php echo e($student ? 'Actif':'Inactif'); ?></span>
                                                        </h6>
                                                    </div>
                                                </div>
                                                <div class="row m-b-20">
                                                    <div class="col-auto p-r-0">6</div>
                                                    <div class="col">
                                                        <h6 class="m-b-5">Double Vacation <span class="pcoded-badge label label-<?php echo e($vacation ? 'success':'danger'); ?> f-right f-10"><?php echo e($vacation ? 'Actif':'Inactif'); ?></span>
                                                        </h6>
                                                    </div>
                                                </div>
                                                <div class="row m-b-20">
                                                    <div class="col-auto p-r-0">7</div>
                                                    <div class="col">
                                                        <h6 class="m-b-5">Résultat aux Examens <span class="pcoded-badge label label-<?php echo e($examen ? 'success':'danger'); ?> f-right f-10"><?php echo e($examen ? 'Actif':'Inactif'); ?></span>
                                                        </h6>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="row">
                                            <div class="col-md-8 offset-md-2 pt-md-5">
                                                <div class="card user-card2 mt-md-5">
                                                    <div class="card-block text-center">
                                                        <h6 class="m-b-5">Téléchargez votre rapport ici ...</h6>
                                                        <hr class="my-2">
                                                        <div class="risk-rate">
                                                            <span class="span" id="style">
                                                                <?php
                                                                    $total = ($personnel ? 1:0) + ($discipline ? 1:0) + ($materiel ? 1:0) + ($activity ? 1:0) + ($student ? 1:0) + ($vacation ? 1:0) + ($examen ? 1:0);
                                                                ?>
                                                                <b id="total" data-total="<?php echo e($total); ?>"><?php echo e('0'.$total); ?></b>
                                                            </span>
                                                        </div>
                                                        <h6 class="m-b-10 m-t-10">Get Download Pdf</h6>
                                                    </div>
                                                    <a href="<?php echo e(route('report1.pdf')); ?>" target="_blank" class="btn btn-block text-white p-t-10 p-b-10" id="disabled-link" style="background: #404E67">Download Overall Report</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal Delete Classe -->
    <div class="modal fade" id="addModal" tabindex="-1" role="dialog" aria-labelledby="addModalTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header bg-dark py-2">
                <h5 class="modal-title" id="addModalTitle">Add New</h5>
                </div>
                <form action="<?php echo e(route('report1.create')); ?>" method="get">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body p-3">
                        <div class="form-group">
                            <label class="block" for="select">Select<span class="text-danger">*</span> :</label>
                            <select name="select" id="select" class="form-control">
                                <option value="">Select one option</option>
                                <option value="1">Personnels</option>
                                <option value="7">Disciplines</option>
                                <option value="2">Materielles</option>
                                <option value="3">Activité Parascolaire</option>
                                <option value="5">Origine Elèves</option>
                                <option value="6">Double Vacation</option>
                                <option value="4">Resultat Examen</option>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <a href="#" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</a>
                        <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>

    <!-- Custom js -->
    <script src="<?php echo e(asset('assets/js/pcoded.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vartical-layout.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.mCustomScrollbar.concat.min.js')); ?>"></script>
    <script>
        $(document).ready(function() {

            $val = $('#total').data('total');
            switch(true){
                case ($val == 7): 
                    (
                        $('#disabled-link').removeAttr('id'),
                        $('.risk-rate span').css({
                            'border-left-color': '#0ac282',
                            'border-top-color': '#0ac282',
                            'border-right-color': '#0ac282'
                        })
                    );
                    break; 
                case (($val < 7) && ($val >= 4)):
                    (
                        $('.risk-rate span').css({
                            'border-left-color': '#0ac282',
                            'border-top-color': '#0ac282',
                            'border-right-color': '#fe909d'
                        })
                    );
                    break;
                case (($val < 4) && ($val >= 2 )):
                    (
                        $('.risk-rate span').css({
                            'border-left-color': '#0ac282',
                            'border-top-color': '#fe909d',
                            'border-right-color': '#fe909d'
                        })
                    );
                    break;
                default:
                    (
                        $('.risk-rate span').css({
                            'border-left-color': '#fe909d',
                            'border-top-color': '#fe909d',
                            'border-right-color': '#fe909d'
                        })
                    );
            }
            
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\EDUCAS\Desktop\AppS\V4_001\resources\views\pages\rapport\index.blade.php ENDPATH**/ ?>