<?php $__env->startSection('title', 'Add new matter'); ?>
<?php $__env->startSection('content'); ?>
<?php $__env->startSection('link'); ?>
<style>
    .barrer {text-decoration: line-through;}
</style>
<?php $__env->stopSection(); ?>
<div class="pcoded-inner-content">
    <?php echo $__env->make('includes._alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="card">
                    <div class="card-header mb-0 pb-0">
                        <div class="d-flex justify-content-between pb-1">
                            <h4>Config Disciplines</h4>
                            <div class="text-center" title="Niveau <?php echo e(ucfirst($level['level'])); ?>" style="font-size: 17px">
                                <?php echo e(ucfirst($valeur)); ?> - <u><?php echo e(ucfirst($level['code'] ?? $level['level'])); ?> <?php echo e($serie['serie'] ?? null); ?></u>
                                <span>Pour chaque discipline cochée, son coefficient Sinon Décochée.</span>
                            </div>
                            <span>
                                <a href="<?php echo e(route('matiere.index')); ?>" class="btn btn-inverse btn-outline-inverse  btn-sm py-1" title="Return Back"><i class="fas fa-reply mx-0"></i></a>
                            </span>
                        </div>
                    </div>
                    <hr class="mx-3 my-0">
                    <div class="card-block mx-3">
                        <div class="text-center my-2">
                            
                        </div>
                        <form action="<?php echo e(route('getMatter.store')); ?>" method="post">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" value="<?php echo e($valeur); ?>" name="type">
                            <input type="hidden" value="<?php echo e($level['id'].'_'.ucfirst($level['code'] ?? $level['level'])); ?>" name="typeId">
                            <input type="hidden" name="serie" value="<?php echo e($serie['id'] ?? null); ?>">
                            <div class="row">
                                <div class="col-12">
                                    <div class="row my-2">
                                        <?php $__currentLoopData = $matters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $matter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="col-12 col-md-4 col-lg-3">
                                            <table class="table table-bordered">
                                                <tbody>
                                                    <tr>
                                                        <td class="w-25" title="<?php echo e($matter['libelle']); ?>">
                                                            <div class="d-flex justify-content-between m-0 pt-2">
                                                                <span>
                                                                    <input type="checkbox" name="matter[]" class="checkbox" data-id="<?php echo e($matter['id']); ?>" value="<?php echo e($matter['id']); ?>" id="matter_<?php echo e($matter['id']); ?>" checked>
                                                                    <label for="matter_<?php echo e($matter['id']); ?>" id="lib_<?php echo e($matter['id']); ?>"><?php echo e(ucfirst($matter['abbreviated'] ?? $matter['libelle'])); ?></label>
                                                                </span>
                                                                <?php if($coeff): ?>
                                                                <span class="d-flex">
                                                                    <label for="coef_<?php echo e($matter['id']); ?>">Coefficeint :</label>
                                                                    <input type="number " name="coef[]" class="form-control my-0 py-1 text-center myInput mx-2" id="coef_<?php echo e($matter['id']); ?>" min="1" maxlength="2" required placeholder="--" style="width: 60px; height: 27px">
                                                                </span>
                                                                <?php endif; ?>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                        
                            <hr class="text-center mt-3">
                            <div class="text-center">
                                <button type="submit" class="btn btn-inverse btn-outline-inverse py-2"> <i class="fas fa-check-circle"></i> Valider les informations</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script src="<?php echo e(asset('assets/js/pcoded.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/vartical-layout.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/jquery.mCustomScrollbar.concat.min.js')); ?>"></script>

<script>
    $(document).ready(function(){
        $('.checkbox').on('click', function() {
            let valId = 'matter_'+$(this).val();
            let coefId = '#coef_'+$(this).val();
            $lib = '#lib_'+$(this).val()
            // alert(valId);
            if(document.getElementById(valId).checked){
                $(coefId).attr('name', 'coef[]');
                $(coefId).prop('disabled', false);
                $($lib).attr('class', '');
            }
            else{
                $(coefId).attr('name', '');
                $(coefId).val(null);
                $(coefId).prop('disabled', true);
                $($lib).attr('class', 'barrer');
            }
        });


        // Autoriser les touches numériques (0-9) et la touche backspace (code 8)
        $('.myInput').on('keypress', function(e) {
            var key = e.which || e.keyCode;
            if ((key >= 48 && key <= 57) || key === 8 || key === 46 || key === 127) {
                return true;
            } else {
                e.preventDefault();
            }
        });
    })
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\EDUCAS\Desktop\AppS\V4_001\resources\views\pages\matters\create_get.blade.php ENDPATH**/ ?>