<?php $__env->startSection('title', 'Gestion des évaluations'); ?>
<?php $__env->startSection('link'); ?>
<!-- Data Table Css -->
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/css/buttons.dataTables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')); ?>">
<style>
    .dataTables_length label{
        display: none;
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="pcoded-inner-content">
    <?php echo $__env->make('includes._alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header mb-0 pb-0">
                                <div class="d-flex justify-content-between">
                                    <h4>Gestion des évaluations</h4>
                                    <span id="sectionPrimary" style="display: none">
                                        <button class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mr-1" title="List composed" data-toggle="modal" data-target="#ListModal"><i class="fa fa-list mx-0"></i></button>
                                        <button class="btn btn-inverse btn-outline-inverse  btn-sm py-1 ml-1" id="AddCompo" title="Add Composed" data-toggle="modal" data-target="#addCompoModal"><i class="fa fa-plus mx-0"></i></button>
                                    </span>
                                </div>
                            </div>
                            <hr class="mt-0 mx-3">
                            <div class="card-block">
                                <div class="dt-responsive table-responsive">
                                    <ul class="nav nav-tabs md-tabs" role="tablist">
                                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="nav-item" style="width: 18%">
                                            <a class="nav-link text-left <?php echo e(session('lib') ? (session('lib') == $item['libelle'] ? 'active':'' ):($item['nbre'] == 1 ? 'active':'')); ?> menuStep" id="<?php echo e(session('lib') ? (session('lib') == $item['libelle'] ? 'active':'' ):($item['nbre'] == 1 ? 'active':'')); ?>" data-lib="<?php echo e($item['libelle']); ?>" data-toggle="tab" href="#home<?php echo e($item['nbre']); ?>" role="tab" aria-selected="true">
                                                <i class="icofont icofont-home"></i><?php echo e(ucfirst($item['libelle'])); ?> [<?php echo e(count($item['data']) <= 9 ? '0'.count($item['data']):count($item['data'])); ?>]
                                            </a>
                                            <div class="slide" style="width: 16%"></div>
                                        </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                    <!-- Tab panes -->
                                    <div class="tab-content card-block">
                                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="tab-pane <?php echo e(session('lib') ? (session('lib') == $item['libelle'] ? 'active':'' ):($item['nbre'] == 1 ? 'active':'')); ?>" id="home<?php echo e($item['nbre']); ?>" role="tabpanel">
                                            <table id="<?php echo e($item['tab']); ?>" class="table table-striped table-bordered nowrap">
                                                <thead>
                                                    <tr>
                                                        <th class="text-center" style="width: 5%">N°</th>
                                                        <th class="text-center">Classe</th>
                                                        <th class="text-center">Effectif</th>
                                                        <th class="text-center" style="width: 20%">Actions</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $i = 1; ?>
                                                    <?php $__currentLoopData = $item['data']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <th class="text-center"><?php echo e($i <= 9 ? '0'.$i++:$i++); ?></th>
                                                        <td class="text-center">
                                                            <?php echo e(ucfirst($val['libelle'])); ?>

                                                        </td>
                                                        <td class="text-center"><?php echo e($val['inscrits'] <= 9 ? '0'.$val['inscrits']:$val['inscrits']); ?>/<?php echo e($val['effectif'] <= 9 ? '0'.$val['effectif']:$val['effectif']); ?></td>
                                                        <td style="width: 20%" class="py-1">
                                                            <div class="card-block remove-label m-0 p-0 text-center">
                                                                <button class="btn btn-sm btn-warning text-center px-2 getEvaluation" title="Veiw list" data-val="<?php echo e($val['id'].'_'.$val['level_id']); ?>"><i class="fas fa-paste m-0"></i></button>
                                                                <?php if($val['type'] == 'secondaire'): ?>
                                                                <a href="<?php echo e(route('evaluation.devoir', $val['id'])); ?>" class="btn btn-sm btn-instagram text-center px-2 ml-2" title="Devoir Program"><i class="fas fa-location-arrow m-0"></i></a>
                                                                <?php endif; ?>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                            </table>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div> 
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- @Modal -->
<div class="modal fade" id="matierModal" tabindex="-1" role="dialog" aria-labelledby="matierModalTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header bg-dark py-2">
          <h5 class="modal-title" id="matierModalLongTitle">Choise Selected</h5>
        </div>
        <form action="#" method="post" id="formEvaluats">
            <?php echo csrf_field(); ?>
            <?php echo method_field('get'); ?>
            <div class="modal-body">
                <div class="m-b-30">
                    <label for="seletMatter">Select One Option<span class="text-danger">*</span> : </label>
                    <select name="select" class="form-control" id="seletMatter">
                        
                    </select>
                </div>
            </div>
            <div class="modal-footer">
                <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</button>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
      </div>
    </div>
</div>

<!-- @Modal New composition -->
<div class="modal fade" id="addCompoModal" tabindex="-1" aria-labelledby="addCompoModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header bg-dark py-2">
          <h5 class="modal-title fs-5" id="addCompoModalLabel">Nouvelle composition</h5>
        </div>
        <form action="<?php echo e(route('composition.store')); ?>" method="post">
            <?php echo csrf_field(); ?>
            <div class="modal-body pb-0">
                <div class="m-b-30">
                    <label for="seletTypeEval">Type Evaluation<span class="text-danger">*</span> : </label>
                    <select name="typeEval" class="form-control" id="seletTypeEval">
                        <option value="1">Select One option</option>
                        <option value="composition">Composition</option>
                        <option value="examen blanc">Examen Blanc</option>
                        <option value="examen final">Examen Final</option>
                    </select>
                </div>

                <div class="m-b-30">
                    <label for="dateEval">Date Evaluation<span class="text-danger">*</span> : </label>
                    <input type="date" name="dateEval" class="form-control" id="dateEval">
                </div>

                <div class="mb-0" id="divLevel" style="display: none">
                    <label for="seletTypeEval">Niveaux concernés<span class="text-danger">*</span> : </label>
                    <p id="section1">
                        <samp class="prescolaire" style="display: none">
                            <span class="mr-4" title="Petite Section">
                                <input type="checkbox" class="composition" name="ps" id="ps" value="1">
                                <label for="ps" class="mx-1">PS</label>
                            </span>
                            <span class="mr-4" title="Moyenne Section">
                                <input type="checkbox" class="composition" name="ms" id="ms" value="1">
                                <label for="ms" class="mx-1">MS</label>
                            </span>
                            <span class="mr-4" title="Grande Section">
                                <input type="checkbox" class="composition" name="gs" id="gs" value="1">
                                <label for="gs" class="mx-1">GS</label>
                            </span>
                        </samp>
                        <span class="primaire" style="display: none">
                            <span class="mr-4" title="CP1">
                                <input type="checkbox" class="composition" name="cp1" id="cp1" value="1">
                                <label for="cp1" class="mx-1">CP1</label>
                            </span>
                            <span class="mr-0" title="CP2">
                                <input type="checkbox" class="composition" name="cp2" id="cp2" value="1">
                                <label for="cp2" class="mx-1">CP2</label>
                            </span>
                        </span>
                    </p>
                    <p id="section2" class="primaire" style="display: none">
                        <span class="mr-4" title="CE1">
                            <input type="checkbox" class="composition" name="ce1" id="ce1" value="1">
                            <label for="ce1" class="mx-1">CE1</label>
                        </span>
                        <span class="mr-4" title="CE2">
                            <input type="checkbox" class="composition" name="ce2" id="ce2" value="1">
                            <label for="ce2" class="mx-1">CE2</label>
                        </span>
                    
                        <span class="mr-4" title="CM1">
                            <input type="checkbox" class="composition" name="cm1" id="cm1" value="1">
                            <label for="cm1" class="mx-1">CM1</label>
                        </span>
                        <span class="mr-0" title="CM2">
                            <input type="checkbox" class="examen" name="cm2" id="cm2" value="1">
                            <label for="cm2" class="mx-1">CM2</label>
                        </span>
                    </p>
                </div>
            </div>
            <div class="modal-footer">
                <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</button>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
      </div>
    </div>
</div>

<!-- @Modal List Composition-->
<div class="modal fade" id="ListModal" tabindex="-1" role="dialog" aria-labelledby="ListModalTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
      <div class="modal-content">
        <div class="modal-header bg-dark py-2">
          <h5 class="modal-title" id="ListModalTitle">Liste des compositions</h5>
          <span id="libelle" style="font-size: 18px"><?php echo e($date); ?></span>
        </div>
        <div class="modal-body">
            <div class="dt-responsive table-responsive">
                <table id="modalEnseignant" class="table table-striped table-bordered nowrap">
                    <thead>
                        <tr>
                            <th class="text-center" style="width: 5%">N°</th>
                            <th class="text-center" style="width: 80px">Libelle</th>
                            <th class="text-center" style="width: 50px">Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tbody>
                            <?php $i = 1; ?>
                            <?php $__empty_1 = true; $__currentLoopData = $compos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $compo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <th class="text-center"><?php echo e($i <= 9 ? '0'.$i++:$i++); ?></th>
                                <td class="mx-3"><?php echo e(ucfirst($compo->evaluated->libelle)); ?> </td>
                                <td class="text-center"><?php echo e(date('d-m-Y', strtotime($compo->evaluated->date))); ?></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="3" class="text-center">Données introuvables</td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Fermer</button>
          
        </div>
      </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <!-- data-table js -->
    <script src="<?php echo e(asset('bower_components/datatables.net/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')); ?>"></script>
    <!-- Custom js -->
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/colreorder/js/colreorder-custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pcoded.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vartical-layout.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.mCustomScrollbar.concat.min.js')); ?>"></script>
    <script>
        $(document).ready(function(){

            $actif = $("#active").data('lib');
            if($actif == 'Prescolaire - Primaire' || $actif == 'Primaire' ||  $actif == 'Prescolaire'){
                $('#sectionPrimary').slideDown()
            }
            else{
                $('#sectionPrimary').slideUp()
            }

            $('.nav-link').on('click', function() {
                $actif = $(this).data('lib');
                if($actif == 'Prescolaire - Primaire' || $actif == 'Primaire' ||  $actif == 'Prescolaire'){
                    $('#sectionPrimary').slideDown()
                }
                else{
                    $('#sectionPrimary').slideUp()
                }
            });


            $('#AddCompo').on('click', function() {
                $('.periode').remove();
                $.ajax({
                    url: '<?php echo e(route('composition.create')); ?>',
                    method: 'GET',
                    success: function(data){
                       data['prescolaire'] ? $('.prescolaire').slideDown():$('.prescolaire').slideUp();
                       data['primaire'] ? $('.primaire').slideDown():$('.primaire').slideUp();
                    }
                });
            });


            $('#seletTypeEval').on('change', function() {
                $val = $(this).val();
                $val != 1 ? $('#divLevel').slideDown():$('#divLevel').slideUp();
                if($val == 'composition'){
                    $('.composition, .examen').prop('checked', true);
                }
                else{
                    $('.composition').prop('checked', false);
                    $('.examen').prop('checked', true);
                }
            });


            // Get list Compositions Or Matters ...................
            $(document).on('click', '.getEvaluation', function() {
                $('.matter').remove();
                $val = ($(this).data('val')).split('_');
                $('#formEvaluats').attr('action', $val[1] > 9 ? '<?php echo e(route('evaluation.matiere_evaluee')); ?>':'<?php echo e(route('composition.index')); ?>')
                if($(this).data('val')){
                    $.ajax({
                        url: $val[1] > 9 ? '<?php echo e(route('evaluation.matiere')); ?>':'<?php echo e(route('composition.show')); ?>',
                        method: 'GET',
                        data: {
                            id: $val[0],
                            level: $val[1]
                        },
                        success: function(data){
                            if(data.length){
                                $i = 0;
                                while ($i < data.length) {
                                    $('#seletMatter').append('<option value="'+data[$i].id+'_'+$val[0]+'" class="matter" title="'+data[$i].libelle+'">'+data[$i].abbreviated+'</option>');
                                    $i++;
                                }
                            }
                            else{
                                $('#seletMatter').append('<option class="matter">Donnée non disponible !</option>');
                            }
                            const editModal = new bootstrap.Modal(document.getElementById('matierModal'));
                            editModal.show();
                        }
                    });
                }
            });
        })
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\EDUCAS\Desktop\AppS\V4_001\resources\views\pages\evaluations\index.blade.php ENDPATH**/ ?>