<?php $__env->startSection('title', 'Gestion des levele'); ?>
<?php $__env->startSection('link'); ?>
<!-- Data Table Css -->
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/css/buttons.dataTables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')); ?>">
<style>
    .dataTables_length label{
        display: none;
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="pcoded-inner-content">
    <?php echo $__env->make('includes._alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header">
                                <div class="d-flex justify-content-between">
                                    <h4>Gestion des niveaux</h4>
                                    <span id="addBtn">
                                        <button class="btn btn-inverse btn-outline-inverse  btn-sm py-1" id="technique" data-toggle="modal" data-target="#serieModal" style="display: none" title="Add New Série"><i class="fas fa-plus mx-0"></i></button>
                                        <button class="btn btn-inverse btn-outline-inverse  btn-sm py-1" id="superieur" data-toggle="modal" data-target="#filiereModal" style="display: none" title="Add New Filière"> <i class="fas fa-plus mx-0"></i></button>
                                    </span>
                                </div>
                            </div>
                            <div class="card-block">
                                <div class="dt-responsive table-responsive">
                                    <ul class="nav nav-tabs md-tabs" role="tablist">
                                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="nav-item" style="width: 18%">
                                            <a class="nav-link text-left <?php echo e(session('string') ? (session('string') == $item['libelle'] ? 'active':'' ):($item['nbre'] == 1 ? 'active':'')); ?> menuStep" id="<?php echo e(session('string') ? (session('string') == $item['libelle'] ? 'active':'' ):($item['nbre'] == 1 ? 'active':'')); ?>" data-id="<?php echo e($item['libelle']); ?>" data-toggle="tab" href="#home<?php echo e($item['nbre']); ?>" role="tab" aria-selected="true">
                                                <i class="icofont icofont-home"></i><?php echo e(ucfirst($item['libelle'])); ?> [<?php echo e(count($item['data']) <= 9 ? '0'.count($item['data']):count($item['data'])); ?>]
                                            </a>
                                            <div class="slide" style="width: 16%"></div>
                                        </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                    
                                    <!-- Tab panes -->
                                    <div class="tab-content card-block">
                                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="tab-pane <?php echo e(session('string') ? (session('string') == $item['libelle'] ? 'active':'' ):($item['nbre'] == 1 ? 'active':'')); ?>" id="home<?php echo e($item['nbre']); ?>" role="tabpanel">
                                            <table id="<?php echo e($item['tab']); ?>" class="table table-striped table-bordered nowrap">
                                                <thead>
                                                    <tr>
                                                        <th class="text-center">N°</th>
                                                        <th>Libelle</th>
                                                        <th>Abréviation</th>
                                                        <th class="text-center">Actions</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $i = 1; ?>
                                                    <?php $__currentLoopData = $item['data']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <th class="text-center"><?php echo e($i <= 9 ? '0'.$i++:$i++); ?></th>
                                                        <td><?php echo e(ucfirst($val->level)); ?></td>
                                                        <td>
                                                            <?php echo e($val->code ?? '---'); ?>

                                                            <?php if($val->level == 'séconde'): ?>
                                                            <span class="ml-1"><?php echo e(formatAffichage($item['2nd']) ? '['.formatAffichage($item['2nd']).']':''); ?></span>
                                                            <?php elseif($val->level == 'première'): ?>
                                                            <span class="ml-1"><?php echo e(formatAffichage($item['2nd']) ? '['.formatAffichage($item['1ere']).']':''); ?></span>
                                                            <?php elseif($val->level == 'terminale'): ?>
                                                            <span class="ml-1"><?php echo e(formatAffichage($item['2nd']) ? '['.formatAffichage($item['tle']).']':''); ?></span>
                                                            <?php endif; ?>
                                                        </td>
                                                        <td class="py-1">
                                                            <div class="card-block remove-label m-0 p-0 text-center">
                                                                <?php if($val->id > 13): ?>
                                                                <button type="button" class="getSieres btn btn-sm btn-warning text-center px-2  mx-2" data-div="<?php echo e($val->id.'_'.$val->code); ?>" data-lib="<?php echo e($item['libelle']); ?>" data-toggle="modal" data-target="#myModal"><i class="far fa fa-list mx-0"></i></button>
                                                                <?php else: ?>
                                                                <button class="getList btn btn-sm btn-warning text-center px-2  mx-2" data-div="<?php echo e($val->id); ?>" data-toggle="modal" data-target="#listModal" title="List matière"><i class="far fa fa-list mx-0"></i></button>
                                                                <?php endif; ?>
                                                                <button class="getEdit btn btn-sm btn-info text-center px-2" data-div="<?php echo e($val->id); ?>" data-toggle="modal" data-target="#editFiliereModal" title="Edité la filière"><i class="far fa-edit"></i></button>
                                                                <button class="getDelet btn btn-sm btn-danger text-white text-center px-2 mx-2" title="Désactivé cette option" data-div="<?php echo e($val->id.'_'.ucfirst($val->level)); ?>" data-toggle="modal" data-target="#deleteModalCenter"><i class="far fa-trash-alt"></i></button>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                            </table>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div> 
                                </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- @Modal désactif discipline -->
<div class="modal fade" id="deleteModalCenter" tabindex="-1" role="dialog" aria-labelledby="deleteModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header bg-dark py-2">
            <h5 class="modal-title" id="deleteModalLongTitle">Désactivation</h5>
            </div>
            <div class="modal-body">
            <div class="row">
                <div class="col-12 text-center">
                    <p id="addVal"></p>
                    <p class="my-0">
                        <strong>Vous êtes sur de le désactiver !</strong>
                    </p>
                    <span>Cliquez sur 'Valider'.</span>
                </div>
            </div>
            </div>
            <form method="post" id="myDelete">
                <?php echo csrf_field(); ?>
                <?php echo method_field('put'); ?>
                <div class="modal-footer">
                    <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</button>
                    <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- @Modal pour ajouter des filières pour l'enseignement superieur -->
<div class="modal fade" id="filiereModal" tabindex="-1" role="dialog" aria-labelledby="filiereModalLabel" aria-hidden="true">
    <div class="modal-dialog  modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header bg-dark py-2">
          <h5 class="modal-title" id="filiereModalLabel">Nouvelle Filière</h5>
        </div>
        <form action="<?php echo e(route('level.filiere')); ?>" method="post">
            <?php echo csrf_field(); ?>
            <div class="modal-body">
                <div class="form-group">
                    <label for="name" class="col-form-label">Nom de la filière<span class="text-danger">*</span> :</label>
                    <input type="text" name="name" class="form-control" id="name" placeholder="Entrez le nom de la filière">
                </div>
                <div class="form-group">
                    <label for="abrege" class="col-form-label">Nom abrégé de la filière :</label>
                    <input type="text" name="abrege" id="abrege" class="form-control" placeholder="Entrez le nom abrégé de la filière">
                </div>
            </div>
            <div class="modal-footer">
                <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</button>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
      </div>
    </div>
</div>

<!-- @Modal pour edition de filières pour l'enseignement superieur -->
<div class="modal fade" id="editFiliereModal" tabindex="-1" role="dialog" aria-labelledby="editFiliereModalLabel" aria-hidden="true">
    <div class="modal-dialog  modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header bg-dark py-2">
          <h5 class="modal-title" id="editFiliereModalLabel">Edit Level</h5>
          <span id="libLevel" style="font-size: 17px"></span>
        </div>
        <form method="post" id="myEditFiliere">
            <?php echo csrf_field(); ?>
            <?php echo method_field('put'); ?>
            <div class="modal-body">
                <div class="form-group">
                    <label for="libelle1" class="col-form-label">Libellé<span class="text-danger">*</span> :</label>
                    <input type="text" name="libelle1" class="form-control" id="libelle1">
                </div>
                <div class="form-group">
                    <label for="libelle2" class="col-form-label">Libellé abrégé :</label>
                    <input type="text" name="libelle2" id="libelle2" class="form-control">
                </div>
            </div>
            <div class="modal-footer">
                <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</button>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
      </div>
    </div>
</div>

<!-- @Modal pour ajouter des séries pour l'enseignement Technique -->
<div class="modal fade" id="serieModal" tabindex="-1" role="dialog" aria-labelledby="serieModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header bg-dark py-2">
          <h5 class="modal-title" id="serieModalLabel">Nouvelles Série</h5>
        </div>
        <form action="<?php echo e(route('level.serie')); ?>" method="post">
            <?php echo csrf_field(); ?>
            <div class="modal-body">
                <div class="form-group">
                    <label for="getSerie" class="col-form-label">Entrez la série<span class="text-danger">*</span> :</label>
                    <input type="text" name="getSerie" id="getSerie" class="form-control" placeholder="Entre la série ici ....">
                </div>
                <div class="form-group row">
                    <label class="col-sm-3">Niveaux : </label>
                    <div class="col-sm-9">
                        <label class="mr-3" title="Séconde">
                            <input type="checkbox" id="2nd" name="2nd" value="1" checked>
                            <label for="2nd" class="mx-1">2nd</label>
                        </label>
                        <label class="mr-3" title="Première">
                            <input type="checkbox" id="1ere" name="1ere" value="1" checked>
                            <label for="1ere" class="mx-1">1ere</label>
                        </label>
                        <label class="mr-2" title="Terminale">
                            <input type="checkbox" id="tle" name="tle" value="1" checked>
                            <label for="tle" class="mx-1">Tle</label>
                        </label>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</button>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
      </div>
    </div>
</div>

<!-- @Modal -->
<div id="myModal" class="modal fade" role="dialog">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header bg-dark py-2">
                <h5 class="modal-title">Modal Header</h5>
                <span id="serieSpan" style="font-size: 17px"></span>
            </div>
            <div class="modal-body">
                <table class="table table-striped table-bordered nowrap" id="serieTable">
                    <tr>
                        <th class="text-center" style="width: 7%">N°</th>
                        <th class="text-center">Série</th>
                        <th class="text-center">Action</th>
                    </tr>
                </table>
            </div>
            <div class="modal-footer">
                <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Fermer</button>
            </div>
        </div>
    </div>
</div>

<!-- @Modal List des matières par niveau -->
<div class="modal fade" id="listModal" tabindex="-1" aria-labelledby="listModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
      <div class="modal-content">
        <div class="modal-header bg-dark py-2">
          <h5 class="modal-title" id="listModalLabel">Liste des matières</h5>
          <span id="libelleSpan" style="font-size: 17px"></span>
        </div>
        <div class="modal-body">
          <table class="table table-striped table-bordered nowrap" id="listTable">
            <tr>
                <th class="text-center" style="width: 7%">N°</th>
                <th class="text-center">Libellé</th>
                <th class="text-center" id="libelle">Coeff</th>
            </tr>
          </table>
        </div>
        <div class="modal-footer">
            <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</button>
        </div>
      </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <!-- data-table js -->
    <script src="<?php echo e(asset('bower_components/datatables.net/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')); ?>"></script>
    <!-- Custom js -->
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/colreorder/js/colreorder-custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pcoded.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vartical-layout.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.mCustomScrollbar.concat.min.js')); ?>"></script>
    <script>
        $(document).ready(function(){
            var currentUrl = window.location.href;
            let debutUrl = currentUrl.split("level");

            if($('#active').data('id') == 'supérieur'){
                $('#superieur').show();
            }
            else{
                $('#superieur').hide();
            }
            if($('#active').data('id') == 'technique'){
                $('#technique').show();
            }
            else{
                $('#technique').hide();
            }

            $('.menuStep').on('click', function(){
                if($(this).data('id') == 'supérieur'){
                    $('#superieur').show();
                }
                else{
                    $('#superieur').hide();
                }
                if($(this).data('id') == 'technique'){
                    $('#technique').show();
                }
                else{
                    $('#technique').hide();
                }
            });

            
            $(document).on('click', '.getEdit', function() {
                var div = $(this).data('div');
                $('#myEditFiliere').attr('action', debutUrl[0]+'level/edit/'+div);
                $.ajax({
                    url: '<?php echo e(route('level.search')); ?>', // La route définie dans web.php
                    method: 'GET',
                    data: { data: div },
                    success: function(response){
                        $('div#editFiliereModal').fadeIn();
                        $("#libLevel").text(response['level']);
                        $('#libelle1').val(response['level']);
                        $('#libelle2').val(response['code']);
                    }
                });
            });


            $(document).on('click', '.getDelet', function() {
                $('#modalUser').remove();
                var div = $(this).data('div'); 
                var val = div.split("_");
                $('#myDelete').attr('action', debutUrl[0]+'level/destroy/'+val[0]); // Add action form Modal
                $('#addVal').append('<h5 class="mb-1 mt-2" id="modalUser">'+val[1]+'</h4>');
            });

            $(document).on('click', '.getList', function() {
                $('.addRow').remove();
                $('#libelle').text($(this).data('div') > 9 ? 'Coef':'Point');
                if($(this).data('div')){
                    $.ajax({
                        url: '<?php echo e(route('level.list')); ?>',
                        method: 'GET',
                        data: {
                            data: $(this).data('div')
                        },
                        success: function(data){
                            $('#libelleSpan').text(data['level']);
                            $('div#listModal').fadeIn();
                            if(data['data'].length){
                                $i = 0;
                                while ($i < data['data'].length) {
                                    $("#listTable tbody").append('<tr class="addRow">'+
                                        '<th scope="row" class="text-center">'+(($i+1) <= 9 ? ('0'+($i+1)):($i+1))+'</th>'+
                                        '<td>'+data['data'][$i]['libelle']+'</td>'+
                                        '<td class="text-center">'+data['data'][$i]['points']+'</td>'+
                                    '</tr>'); $i++;
                                }
                            }
                            else{
                                $('#listTable tbody').append('<tr class="addRow"><th colspan="5" class="text-center">Données introuvables</th></tr>');
                            }
                        }
                    });
                }
            });

            // Get series ajax
            $(document).on('click', '.getSieres', function() {
                $lib = $(this).data('lib');
                $val = $(this).data('div');
                $.ajax({
                    url: '<?php echo e(route('level.series')); ?>', // La route définie dans web.php
                    method: 'GET',
                    data: {
                        val: $val,
                        lib: $lib
                    },
                    success: function(data){
                        $('.addRow').remove();
                        $('#serieSpan').text(data['libelle']);
                        $('div#myModal').fadeIn();
                        if(data['data'].length){
                            $i = 0;
                            while ($i < data['data'].length) {
                                $("#serieTable tbody").append('<tr class="addRow">'+
                                    '<th scope="row" class="text-center">'+(($i+1) <= 9 ? ('0'+($i+1)):($i+1))+'</th>'+
                                    '<td>'+data['data'][$i]['libelle']+'</td>'+
                                    '<td class="text-center">'+
                                        ' <button class="serieBtn btn btn-sm btn-warning text-center px-2 mx-2" data-id="'+data['data'][$i]['id']+'" data-lib="'+$val+'" data-toggle="modal" data-target="#listModal" title="List matière"><i class="far fa fa-list mx-0"></i></button>'+
                                    '</td>'+
                                '</tr>'); $i++;
                            }
                        }
                        else{
                            $('#serieTable tbody').append('<tr class="addRow"><th colspan="5" class="text-center">Données introuvables</th></tr>');
                        }
                    }
                });
            });


            $('#serieTable tbody').on('click', '.serieBtn', function(){
                $('div#myModal').modal('hide');
                $val = $(this).data('lib');
                $vals = $val.split('_');
                $('.addRow').remove();
                $('#libelle').text('Coef');
                $.ajax({
                    url: '<?php echo e(route('level.mattiere')); ?>',
                    method: 'GET',
                    data: {
                        data: $vals[0],
                        serie: $(this).data('id')
                    },
                    success: function(data){
                        $('#libelleSpan').text(data['libelle']);
                        $('div#listModal').fadeIn();
                        if(data['data'].length){
                            $i = 0;
                            while ($i < data['data'].length) {
                                $("#listTable tbody").append('<tr class="addRow">'+
                                    '<th scope="row" class="text-center">'+(($i+1) <= 9 ? ('0'+($i+1)):($i+1))+'</th>'+
                                    '<td>'+data['data'][$i]['libelle']+'</td>'+
                                    '<td class="text-center">'+data['data'][$i]['points']+'</td>'+
                                '</tr>'); $i++;
                            }
                        }
                        else{
                            $('#listTable tbody').append('<tr class="addRow"><th colspan="5" class="text-center">Données introuvables</th></tr>');
                        }
                    }
                });
            })
        })
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\EDUCAS\Desktop\AppS\V4_001\resources\views\pages\level\index.blade.php ENDPATH**/ ?>