<?php $__env->startSection('title', 'Gestion des appels'); ?>
<?php $__env->startSection('link'); ?>
<!-- Data Table Css -->
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/css/buttons.dataTables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/AlertifyJS/1.13.1/css/alertify.min.css">
<style>

</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="pcoded-inner-content">
    <?php echo $__env->make('includes._alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header">
                                <div class="d-flex justify-content-between">
                                    <h4>Appels du <?php echo e(date('d-m-Y', strtotime($today))); ?></h4>
                                    <div class="text-center text-muted" style="font-size: 17px"><?php echo e($class['libelle']); ?> - <?php echo e('semaine '.($weeks <= 9 ? '0'.$weeks:$weeks)); ?></div>
                                    <span>
                                        <a href="<?php echo e(route('appel.primary', $class['id'])); ?>" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mx-3" title="Return Back"><i class="fas fa-reply mx-0"></i></a>
                                    </span>
                                    <input type="hidden" value="<?php echo e($class['id']); ?>" id="classId">
                                    <input type="hidden" value="<?php echo e($today); ?>" id="dteAbsence">
                                    <input type="hidden" value="<?php echo e($period); ?>" id="period">
                                    <input type="hidden" value="<?php echo e($weeks); ?>" id="types">
                                </div>
                            </div>
                            <div class="card-block">
                                <div class="dt-responsive table-responsive px-lg-3">
                                    <table class="table table-striped table-bordered nowrap" style="width: 95%; margin: auto">
                                        <thead>
                                            <tr>
                                                <th class="text-center" style="width: 5%">N°</th>
                                                <th class="text-uppercase text-center" style="width: 35%">Nom et prenoms</th>
                                                <th class="text-uppercase text-center" style="width: 15%">Genre</th>
                                                <th class="text-uppercase text-center" style="width: 15%">Matricule</th>
                                                <th class="text-center"><?php echo e($period == 1 ? 'Matin':'Après midi'); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $t=1 ?>
                                            <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <th class="text-center py-2">
                                                    <div class="mt-2"><?php echo e($t <= 9 ? '0'.$t++:$t++); ?></div>
                                                </th>
                                                <td class="py-2">
                                                    <div class="mt-2"><?php echo e(strtoupper($item['first_name']).' '.ucwords($item['last_name'])); ?></div>
                                                </td>
                                                <td class="py-2"><div class="mt-2"><?php echo e(ucfirst($item['sexe'] == 'F' ? 'Féminin':'Masculin')); ?></div></td>
                                                <td class="py-2"><div class="mt-2"><?php echo e($item['matricule']); ?></div></td>
                                                <th class="py-2 text-center">
                                                    <input type="checkbox" class="mt-2 checkbox" value="<?php echo e($item['id']); ?>">
                                                </th>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <!-- data-table js -->
    <script src="<?php echo e(asset('bower_components/datatables.net/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')); ?>"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/AlertifyJS/1.13.1/alertify.min.js"></script>
    <!-- Custom js -->
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/colreorder/js/colreorder-custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pcoded.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vartical-layout.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.mCustomScrollbar.concat.min.js')); ?>"></script>
    <script>
        $(document).ready(function(){

            $(".checkbox").on('click', function() {
                $checked = $(this).is(':checked') ? true:false;
                if($(this).val()){
                    $.ajax({
                        url: $checked ? '<?php echo e(route('appel.store')); ?>':'<?php echo e(route('appel.notStore')); ?>',
                        method: 'GET',
                        data: {
                            classed : $('#classId').val(),
                            dateAb : $('#dteAbsence').val(),
                            period : $('#period').val(),
                            week : $('#types').val(),
                            valeur : $(this).val(),
                            type : 'primaire',
                        },
                        success: function(data){
                            if(data == 200){
                                alertify.set('notifier','position', 'top-right');
                                $checked ? alertify.success('Absence pointée.'): alertify.success('Absence annulée.');
                            }
                            else{
                                alertify.set('notifier','position', 'top-right');
                                alertify.error('Une erreur est survenue.');
                            }
                        }
                    });
                }
            })

        })
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\EDUCAS\Desktop\AppS\V4_001\resources\views\pages\appels\create_primary.blade.php ENDPATH**/ ?>