@extends('app')
@section('title', 'Gestion des classes')
@section('link')
<!-- Data Table Css -->
<style>
    .blink {
      animation: blinker 1.5s linear infinite;
      color: red;
     }
    @keyframes blinker {  
      50% { opacity: 0; }
    }
</style>
@endsection
@section('content')
<div class="pcoded-inner-content">
    @include('includes._alert')
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header">
                                <div class="d-flex justify-content-between">
                                    <h4 class="m-0">Gestion d'emploi du temps</h4>
                                    <h4 class="m-0"><strong>{{$classe['libelle']}}</strong></h4>
                                    <div class="right">
                                        {{-- <span id="addBtn">Année Scolaire <strong>{{$classe->schoolYear->school_year}}</strong></span> --}}
                                        <span style="float: right">
                                            <a href="{{route('time.index',$classe->id.'_'.$string)}}" class="btn btn-inverse btn-outline-inverse  btn-sm py-1" title="Return Back"><i class="fas fa-reply m-0"></i></a>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <hr class="my-0 mx-3">
                            @if (!count($matter))
                            <strong class="text-center blink">Veuillez faire une bonne configuration.</strong>
                            @endif
                            {{-- <hr class="mx-3"> --}}
                            <form action="{{route('time.store', $classe['id'])}}" method="post">
                                @csrf
                                <div class="card-block">
                                    <div class="dt-responsive table-responsive">
                                        <table id="simpletable" class="table table-striped table-bordered nowrap" style="line-height: 0%">
                                            <thead>
                                                <tr style="background: rgb(237, 236, 236);">
                                                    <th class="text-center py-4" style="width: 100px">Horaires</th>
                                                    @foreach ($days as $day)
                                                    <th class="text-center" style="width: 100px">{{ucfirst($day['day'])}}</th>
                                                    <input type="hidden" name="day[]" value="{{$day['id']}}">
                                                    @endforeach
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach ($morning as $mrg)
                                                <tr>
                                                    <td class="text-center pt-4">{{$mrg['debut']}} - {{$mrg['fin']}}</td>
                                                    @for ($i = 0; $i < count($days); $i++)
                                                    <td class="p-0">
                                                        <select name="matMng[{{$i}}][]" class="form-control w-100" style="background: none;">
                                                            <option value="">---</option>
                                                            @foreach ($matter as $item)
                                                            <option value="{{$mrg['id'].'_'.$item->id}}" title="{{ucfirst($item->libelle)}}" {{afficheMatterEmploiTemps($dtsMrg, $item->id, $i, $days[$i]['id'], $mrg['id'], 1) ? 'selected':null}}>{{ucfirst($item->abbreviated ?? $item->libelle)}}</option>
                                                            @endforeach
                                                        </select>    
                                                    </td>
                                                    @endfor
                                                </tr> 
                                                @endforeach
                                                <tr style="background: rgb(209, 217, 221); letter-spacing: 1rem; font-size: 15px">
                                                    <th colspan="{{count($days)+1}}" class="text-center py-4">APRES - MIDI</th>
                                                </tr>
                                                @foreach ($after as $aft)
                                                <tr>
                                                    <td class="text-center pt-4">{{$aft['debut']}} - {{$aft['fin']}}</td>
                                                    @for ($i = 0; $i < count($days); $i++)
                                                    <td class="p-0">
                                                        @if (!($i == 2 && $classe['type'] != 'superieur'))
                                                            <select name="matAfter[{{$i}}][]" class="form-control w-100" style="background: none;">
                                                                <option value="">---</option>
                                                                @foreach ($matter as $item)
                                                                <option value="{{$aft['id'].'_'.$item->id}}" title="{{ucfirst($item->libelle)}}" {{afficheMatterEmploiTemps($dtsAfter, $item->id, $i, $days[$i]['id'], $aft['id']) ? 'selected':null}}>{{ucfirst($item->abbreviated ?? $item->libelle)}}</option>
                                                                @endforeach
                                                            </select>
                                                        @else
                                                            {{-- Les mercredi soir --}}
                                                            <input type="hidden" name="matAfter[{{$i}}][]">
                                                        @endif
                                                    </td>
                                                    @endfor
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                    <input type="hidden" name="nbreM" value="{{count($morning)}}">
                                    <input type="hidden" name="nbreA" value="{{count($after)}}">
                                    <input type="hidden" name="year" value="{{$classe['school_year_id']}}">
                                    <input type="hidden" name="infoClass" value="{{$classe->id.'_'.$string}}">
                                    <div class="row text-center">
                                        <div class="col-sm-12 invoice-btn-group text-center">
                                            <button type="submit" class="btn btn-inverse btn-outline-inverse py-1" {{count($matter) ? '':'disabled'}}> <i class="fas fa-check-circle"></i> Valider les informations</button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
    <script src="{{asset('assets/js/pcoded.min.js')}}"></script>
    <script src="{{asset('assets/js/vartical-layout.min.js')}}"></script>
    <script src="{{asset('assets/js/jquery.mCustomScrollbar.concat.min.js')}}"></script>
    <script>
        $(document).ready(function(){
           
        })
    </script>
@endsection