<?php

namespace App\Jobs;

use App\Models\StatutStudent;
use App\Models\PyramideStudent;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class StatutPyramideJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $sexe, $year, $level, $serie, $school, $affect, $doublant;
    public function __construct($sexe, $year, $level, $serie = null, $school, $affect, $doublant)
    {
        $this->sexe = $sexe;
        $this->year = $year;
        $this->level = $level;
        $this->serie = $serie;
        $this->school = $school;
        $this->affect = $affect;
        $this->doublant = $doublant;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        // dd($this->sexe.' - '.$this->affect);
        $this->verifyStatut($this->level, $this->school, $this->year) ?
        $this->updateStatut($this->sexe, $this->affect, $this->level, $this->school, $this->year):
        $this->createStatut($this->sexe, $this->affect, $this->level, $this->school, $this->year);
        
        $serie = $this->serie ? $this->serie($this->serie, $this->level):null; // Verifie l'existence de la serie ---------->
        $this->verifyPyramide($this->level, $this->school, $this->year, $serie) ? 
        $this->updatePyramide($this->sexe, $this->doublant, $this->level, $this->school, $this->year, $serie):
        $this->createPyramide($this->sexe, $this->doublant, $this->level, $this->school, $this->year, $serie);
    }


    private function verifyStatut($level, $school, $year){
        $vals = StatutStudent::where('level_id', $level)->where('school_id', $school)->where('school_year_id', $year)->first();
        return $vals ?? null;
    }


    private function verifyPyramide($level, $school, $year, $serie = null){
        $vals = PyramideStudent::where('level_id', $level)->where('serie_id', $serie)->where('school_id', $school)->where('school_year_id', $year)->first();
        return $vals ?? null;
    }

    private function createStatut($sexe, $affect, $level, $school, $year){
        $attribut = $this->getAffect($sexe, $affect);
        StatutStudent::create([
            $attribut => 1,
            'level_id' => $level,
            'school_id' => $school,
            'school_year_id' => $year
        ]);
    }


    private function createPyramide($sexe, $doublant, $level, $school, $year, $serie = null){
        $attribut = $this->getRedouble($sexe, $doublant);
        PyramideStudent::create([
            $attribut => 1,
            'level_id' => $level,
            'serie_id' => $serie,
            'school_id' => $school,
            'school_year_id' => $year
        ]);
    }

    private function serie($serie, $level){
        if(in_array($level, ['15','16'])){ // 15 => 1ere, 16 => Tle
            $serie = in_array($serie, ['2','3']) ? '1':$serie; 
        }
        return $serie;
    }

    private function updateStatut($sexe, $affect, $level, $school, $year){
        $attribut = $this->getAffect($sexe, $affect);
        $vals = $this->verifyStatut($level, $school, $year);
        $vals->update([$attribut => $vals[$attribut]+1]);
    }


    private function updatePyramide($sexe, $doublant, $level, $school, $year, $serie = null){
        $attribut = $this->getRedouble($sexe, $doublant);
        $vals = $this->verifyPyramide($level, $school, $year, $serie);
        $vals->update([$attribut => $vals[$attribut]+1]);
    }


    private function getAffect($sexe, $affect){
        return match (true){
            (ucwords($sexe) == 'F' && strtolower($affect) == 'oui') => 'nbre_affect_fille',
            (ucwords($sexe) == 'F' && strtolower($affect) == 'non') => 'nbre_non_affect_fille',
            (ucwords($sexe) == 'M' && strtolower($affect) == 'oui') => 'nbre_affect_garcon',
            (ucwords($sexe) == 'M' && strtolower($affect) == 'non') => 'nbre_non_affect_garcon',
        };
    }

    private function getRedouble($sexe, $doublant){
        return match (true){
            (ucwords($sexe) == 'F' && strtolower($doublant) == 'oui') => 'nbre_redoublant_fille',
            (ucwords($sexe) == 'F' && strtolower($doublant) == 'non') => 'nbre_non_redoublant_fille',
            (ucwords($sexe) == 'M' && strtolower($doublant) == 'oui') => 'nbre_redoublant_garcon',
            (ucwords($sexe) == 'M' && strtolower($doublant) == 'non') => 'nbre_non_redoublant_garcon',
        };
    }
}
