<?php

namespace App\Http\Controllers;

use App\Models\Setting;
use App\Models\SchoolYear;
use App\Models\Classe;
use App\Models\Inscription;
use App\Models\CuttingSchoolYear;
use App\Models\MotifSanction;
use App\Models\Sanction;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;

class SanctionController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        try{
            $data = Setting::where('school_id',auth()->user()->school_id)->first();
            return view('pages.sanction.index',[
                'data' => $this->typeEnseignement($data)
            ]);
        }
        catch(\Exception $e){
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue !'
            ]);
        }
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(string $id)
    {
        try{
            $type = ['secondaire' => 'general', 'technique' => 'technique', 'superieur' => 'superieur'];
            $inscris = Inscription::find($id);
            $cutting = CuttingSchoolYear::where('type', $type[$inscris->classe->type])->where('school_year_id', $this->yearActif()['id'])->get();
            $motifs = MotifSanction::where('id', '<>', '1')->get(); // 1 est l'id du assiduité et ponctualité
            return view('pages.sanction.create',[
                'data' => $this->getCutting($cutting, $inscris['id']),
                'inscris' => $inscris,
                'motifs' => $motifs
            ]);
        }
        catch(\Exception $e){
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue !'
            ]);
        }
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        try{
            $val = $request->validate([
                'student' => 'required|integer',
                'cutting' => 'required|integer',
                'type' => 'required|integer',
                'motif' => 'required|string',
            ]);
            if(!($val['type'] == 5)){
                $this->saveSanction($val['motif'],$val['student'],$val['type'],$val['cutting']);
            }
            else{
                $verify = Sanction::where('inscription_id', $val['student'])->where('cutting_school_year_id', $val['cutting'])->where('discipline', '1')->first();
                if(!$verify){
                    $val['type'] == 5 ? $this->deleteGetSanction($val['student'],$val['cutting']):null;
                    $this->saveSanction($val['motif'],$val['student'],$val['type'],$val['cutting']);
                }
                else{
                    return back()->with([
                        'str' => 'info',
                        'msg' => 'Sanction déjà appliquée !'
                    ]);
                }
            }
            return back()->with([
                'str' => 'success',
                'msg' => 'Sanction appliquée !'
            ]);
        }
        catch(\Exception $e){
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue !'
            ]);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        try{
            $class = Classe::find($id);
            return view('pages.sanction.detail',[
                'data' => $this->getStudent($id),
                'classe' => $class
            ]);
        }
        catch(\Exception $e){
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue !'
            ]);
        }
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Request $val)
    {
        try{
            $cutting = CuttingSchoolYear::where('id', $val['cutting'])->first();
            $data = Sanction::where('inscription_id', $val['student'])->where('cutting_school_year_id', $val['cutting'])->where('motif_sanction_id', $val['sanction'])->get();
            return response()->json([
                'cutting' => ucfirst($cutting->cutting->libelle),
                'data' => $data
            ]);
        }
        catch(\Exception $e){
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue !'
            ]);
        }
    }

    /**
     * Update the specified resource in storage.
     */
    public function search(Request $request)
    {
        try{
            $data = Sanction::where('id', $request['id'])->first();
            $tab = [
                'sanction' => ucfirst($data->motifSanction->motif),
                'motif' => ucfirst($data['motif']),
                'date' => date('d/m/Y', strtotime($data['created_at']))
            ];
            return $tab;
        }
        catch(\Exception $e){
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue !'
            ]);
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Request $request)
    {
        try{
            $val = $request->validate([
                'sanction' => 'required|integer',
                'student' => 'required|integer'
            ]);
            $dts = Sanction::where('id', $val['sanction'])->where('inscription_id', $val['student'])->first();
            if($dts){
                $dts->delete();
                return back()->with([
                    'str' => 'success',
                    'msg' => 'Sanction annulée !'
                ]);
            }
        }
        catch(\Exception $e){
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue !'
            ]);
        }
    }



    /**
     * Get data class the specified resource from storage.
     */
    protected function typeEnseignement($dts)
    {
        $tab = []; $i = 0;  $cycle = 0; // $primaire = 0;
        $school = auth()->user()->school_id;
        $data = [1 => 'realtime-reorder', 2 => 'basic-col-reorder', 3 => 'saving-reorder', 4 => 'predefine-reorder', 5 => null];
        foreach ($dts->school->typeEnseignements as $item) {
            if($item['type_enseignement'] != 'primaire'){
                if(!$cycle && ($item['id'] == 3 || $item['id'] == 4)){
                    $tab[] = [
                        'nbre' => $i+=1,
                        'tab' => $data[$i], 
                        'libelle' => verifySeconde($dts->school->typeEnseignements),
                        'data' => Classe::where('type', 'secondaire')->where('school_year_id', $this->yearActif()['id'])->where('status', '1')->where('school_id', $school)->get(),
                    ];$cycle++;
                }
                elseif($item['id'] == 5){
                    $val = $item['type_enseignement'];
                    $tab[] =[
                        'nbre' => $i+=1, 
                        'tab' => $data[$i], 
                        'libelle' => ucfirst($val),
                        'data' => Classe::where('type', 'technique')->where('school_year_id', $this->yearActif()['id'])->where('status', '1')->where('school_id', $school)->get(),
                    ];
                }
                elseif($item['id'] == 6){
                    $val = $item['type_enseignement'];
                    $tab[] =[
                        'nbre' => $i+=1, 
                        'tab' => $data[$i], 
                        'libelle' => $val,
                        'data' => Classe::where('type', 'superieur')->where('school_year_id', $this->yearActif()['id'])->where('status', '1')->where('school_id', $school)->get(),
                    ];
                }
            }
        }
        return $tab;

        // if(!$primaire && ($item['id'] == 1 || $item['id'] == 2)){
        //     $tab[] = [
        //         'nbre' => $i+=1, 
        //         'tab' => $data[$i], 
        //         'libelle' => verifyPrimaire($dts->school->typeEnseignements),
        //         'data' => Classe::where('type', 'primaire')->where('school_year_id', $this->yearActif()['id'])->where('status', '1')->where('school_id', $school)->get()
        //     ];$primaire++;
        // }
    }

    /**
     * Get student the specified resource from storage.
     */
    protected function getStudent($classId)
    {
        $data = DB::table('inscriptions')
            ->join('students', 'students.id', '=', 'inscriptions.student_id')
            ->select('inscriptions.id', 'students.first_name', 'students.last_name', 'students.matricule', 'students.sexe')
            ->where('inscriptions.classe_id', '=', $classId)
            ->orderBy('students.first_name')->orderBy('students.last_name')->get();

        return json_decode($data, true);
    }


    /**
     * Gestion the cutting school year the specified resource from storage.
     */
    protected function getCutting($cutting, $student)
    {
        $tabs = [];
        foreach($cutting as $item){
            $verify = Sanction::where('inscription_id', $student)->where('cutting_school_year_id', $item->id)->where('discipline', '1')->first();
            $tabs[] = [
                'id' => $item->id,
                'libelle' => $item->cutting['libelle'],
                'actif' => $item->status,
                'conseil' => $verify ? 1:0,
                'total' => $verify ? 05:20,
                'val' => $this->calculSanction($student, $item->id),
                'data' => $this->getSanction($student, $item->id)
            ];
        }
        return $tabs;
    }

    protected function getSanction($student, $cutting)
    {
        $motifs = MotifSanction::where('id', '<>', '5')->get(); // 5 est l'id du conseil de discipline
        $table = [];
        foreach($motifs as $motif){
            $count = Sanction::where('inscription_id', $student)->where('motif_sanction_id', $motif['id'])->where('cutting_school_year_id', $cutting)->count();
            $table[] = [
                'id' => $motif['id'],
                'motif' => $motif['motif'],
                'valeur' => $motif['valeur'],
                'nbres' => $count,
                'total' => $motif['total'],
            ];
        }
        return $table;
    }

    /**
     * Supprimer toute les sanction qui lui ont été appliquées dans cette période.
     */
    protected function deleteGetSanction($student, $cutting)
    {
        Sanction::where('inscription_id', $student)->where('cutting_school_year_id', $cutting)->delete();
    }

     /**
     * Calcul la valeur des sanction qui lui ont été appliquées dans cette période.
     */
    protected function calculSanction($student, $cutting)
    {
        $dts = Sanction::where('inscription_id', $student)->where('cutting_school_year_id', $cutting)->where('discipline', '0')->get();
        $val = 0;
        foreach($dts as $item){
            $val += $item->motifSanction->valeur;
        }
        return $val;
    }


    protected function saveSanction($motif, $student, $type, $cutting)
    {
        Sanction::create([
            'motif' => $motif,
            'inscription_id' => $student,
            'motif_sanction_id' => $type,
            'cutting_school_year_id' => $cutting,
            'discipline' => $type == 5 ? '1':'0'
        ]);
    }

    /**
     * Get school year actif the specified resource from storage.
     */
    protected function yearActif(){
        $dts = SchoolYear::where('status', '1')->first();
        return $dts;
    }
}
