<?php

namespace App\Http\Controllers;

use App\Models\Classe;
use App\Models\Devoir;
use App\Models\SchoolYear;
use App\Models\CuttingSchoolYear;
use Illuminate\Support\Facades\DB;
use Barryvdh\DomPDF\Facade\Pdf;


class GetDevoirController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(string $id)
    {
        try{
            $class = Classe::find($id);
            $cutting = CuttingSchoolYear::where('type', 'general')->where('status', '1')->where('school_year_id', $this->yaerActif())->first();
            return view('pages.devoirs.detail',[
                'classe' => $class,
                'cutting' => $cutting,
                'matters' => $this->globalData($class, $cutting['id'])
            ]);
        }
        catch(\Exception $e){
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue !'
            ]);
        }
    }

    /**
     * Show the form for creating a new resource.
     */
    public function imprim(string $str)
    {
        try{
            $str = explode('_', $str);
            $class = Classe::find($str[0]);
            $cutting = CuttingSchoolYear::find($str[1]);
            $pdf = PDF::loadView('pdf.program_devoir',[
                'classe' => $class,
                'cutting' => $cutting,
            ]);
            $pdf->setPaper('A3', 'portrait'); // ou 'A4', 'A3', etc.
            return $pdf->stream('program_devoir'.$str[0].'.pdf');
        }
        catch(\Exception $e){
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue !'
            ]);
        }
    }

    /**
     * Display the specified resource.
     */
    protected function globalData($class, $cutting)
    {
        $dts = $this->matterClasse($class);
        $table = [];
        foreach($dts as $item){
            $table[] = [
                'libelle' => $item['abbreviated'],
                'martins' => Devoir::where('classe_id', $class['id'])->where('matter_id', $item['id'])->where('cutting_school_year_id', $cutting)->where('period', '1')->get(),
                'soirs' => Devoir::where('classe_id', $class['id'])->where('matter_id', $item['id'])->where('cutting_school_year_id', $cutting)->where('period', '2')->get()    
            ];
        }
        return $table;
    }

    /**
     * Show the form for editing the specified resource.
     */
    protected function matterClasse($class){

        return array_merge($this->getMatieres($class, 1), $this->getMatieres($class, 2), $this->getMatieres($class, 3));
    }

    /**
     * Update the specified resource in storage.
     */
    protected function getMatieres($class, $bilan){
        if($class['additif']){
            $additif = $class['additif'] == 'AP' ? 'Mus':'AP';
            $matters =  DB::table('matters')
            ->join('level_matter', 'matters.id', '=', 'level_matter.matter_id')
            ->join('libelle_bilan_matter', 'matters.id', '=', 'libelle_bilan_matter.matter_id')
            ->select('matters.id', 'matters.libelle', 'matters.abbreviated', DB::raw("IF(abbreviated = 'All/Esp', 'LV2', abbreviated) as abbreviated"))
            ->where('level_matter.school_id', '=', auth()->user()->school_id)
            ->where('level_matter.level_id', '=', $class['level_id'])
            ->where('level_matter.type', '=', $class['type'])
            ->where('level_matter.serie_id', '=', $class['serie_id'])
            ->where('matters.libelle', '!=', 'Allemand') // Les classes mixte
            ->where('matters.libelle', '!=', 'Espagnol') // Les classes mixte
            ->where('matters.id', '!=', '15') // Les classes mixte
            ->where('matters.id', '!=', '7') // Les classes mixte
            ->where('abbreviated', '!=', $additif)
            ->where('libelle_bilan_matter.libelle_bilan_id', '=', $bilan)
            ->orderBy('libelle_bilan_matter.bilan')->get();
        }
        else{
            $matters =  DB::table('matters')
            ->join('level_matter', 'matters.id', '=', 'level_matter.matter_id')
            ->join('libelle_bilan_matter', 'matters.id', '=', 'libelle_bilan_matter.matter_id')
            ->select('matters.id', 'matters.libelle', 'matters.abbreviated', DB::raw("IF(abbreviated = 'All/Esp', 'LV2', abbreviated) as abbreviated"))
            ->where('level_matter.school_id', '=', auth()->user()->school_id)
            ->where('level_matter.level_id', '=', $class['level_id'])
            ->where('level_matter.type', '=', $class['type'])
            ->where('level_matter.serie_id', '=', $class['serie_id'])
            ->where('matters.libelle', '!=', 'Allemand') // Les classes mixte
            ->where('matters.libelle', '!=', 'Espagnol') // Les classes mixte
            ->where('matters.id', '!=', '15') // Les classes mixte
            ->where('matters.id', '!=', '7') // Les classes mixte
            ->where('libelle', '!=','Arts plastique')->where('libelle', '!=','Musique')
            ->where('libelle_bilan_matter.libelle_bilan_id', '=', $bilan)
            ->orderBy('libelle_bilan_matter.bilan')->get();
        }
        return json_decode($matters, true);
    }

    /**
     * Remove the specified resource from storage.
     */
    private function yaerActif(){
        $year = SchoolYear::where('status', '1')->first();
        return $year->id;
    }
}
