<?php

namespace App\Exports;

use App\Models\Classe;
use Maatwebsite\Excel\Concerns\FromCollection;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;

class StudentClasseExport implements FromView
{
    protected $class;

    public function __construct($class)
    {
        $this->classe_id = $class;
    }


    /**
    * @return \Illuminate\Support\Collection
    */
    public function view(): View
    {
        return view('pages.inscriptions.create',[
            'classe' => $this->classe()
        ]);
    }


    private function classe()
    {
        $class = Classe::where('id', $this->classe_id)->first();
        return $class;
    }
}
