@extends('app')
@section('title','List student')
@section('link')
    <!-- Data Table Css -->
    <link rel="stylesheet" href="{{asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/pages/data-table/css/buttons.dataTables.min.css')}}">
    <link rel="stylesheet" href="{{asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/pages/data-table/extensions/autofill/css/autoFill.dataTables.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/pages/data-table/extensions/autofill/css/select.dataTables.min.css')}}">
    <style>
        .dataTables_length label{
            display: none;
        }
    </style>
@endsection
@section('content')
<div class="pcoded-inner-content">
    @include('includes._alert')
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header mb-0 pb-0">
                                <div class="d-flex justify-content-between mb-2">
                                    <h4>Student - {{count($students) <= 9 ? '0'.count($students):count($students)}}</h4>
                                    <span>
                                        <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-1" data-toggle="modal" data-target="#upload" title="Import File"> <i class="fas fa-ellipsis-h m-0"></i></button>
                                        <a href="{{route('parent.index')}}" class="btn btn-inverse btn-outline-inverse  btn-sm mx-1 py-1" title="Parent List"> <i class="fab fa-cloudsmith m-0"></i></a>
                                        <a href="{{route('student.index1')}}" class="btn btn-inverse btn-outline-inverse  btn-sm mx-1 py-1" title="Disabled Student"> <i class="fas fa-underline m-0"></i></a>
                                    </span>
                                </div>
                            </div>
                            <hr class="mx-3 my-0">
                            <div class="card-block my-0">
                                <div class="row">
                                    @foreach ($statistics as $statistic)
                                    <div class="col-xl-3 col-md-6">
                                        <div class="card my-0">
                                            <div class="card-header py-1 d-flex justify-content-between">
                                                <span style="font-size: 17px; text-decoration: underline;">{{ucwords($statistic['libelle'])}}</span>
                                                <strong class="mt-2" style="font-size: 15px">{{$statistic['total']}}</strong>
                                            </div>
                                            <div class="card-block pt-3 pb-0">
                                                <div class="row align-items-center bg-dark">
                                                    <div class="col-6">
                                                        <div class="text-left" title="Male">
                                                            <span><i class="fa fa-male" aria-hidden="true"></i> : {{$statistic['nbreM']}}</span>
                                                            <span class="mx-1">&asymp;</span>{{$statistic['nbreM'] != 0 ? round((($statistic['nbreM']/$statistic['total'])*100), 2):'00'}}%
                                                        </div>
                                                    </div>
                                                    <div class="col-6">
                                                        <div class="text-right" title="Female">
                                                            <span><i class="fa fa-female" aria-hidden="true"></i> : {{$statistic['nbreF']}}</span>
                                                            <span class="mx-1">&asymp;</span>{{$statistic['nbreF'] != 0 ? round((($statistic['nbreF']/$statistic['total'])*100), 2):'00'}}%
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                </div>
                                <div class="dt-responsive table-responsive">
                                    <div class="tab-content card-block">
                                        <table id="autofill" class="table table-striped table-bordered nowrap mt-3">
                                            <thead>
                                                <tr>
                                                    <th class="text-center" style="width:15px">N°</th>
                                                    <th>Matricule</th>
                                                    <th>Nom</th>
                                                    <th>Prénoms</th>
                                                    <th>Genre</th>
                                                    <th>Date de nais...</th>
                                                    <th>Lieu de nais...</th>
                                                    <th>Résidence</th>
                                                    <th>Photo</th>
                                                    <th class="text-center">Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @php $i = 1; @endphp
                                                @foreach ($students as $student)
                                                <tr>
                                                    <th class="text-center">{{$i <= 9 ? '0'.$i++:$i++}}</th>
                                                    <td>{{$student->matricule}}</td>
                                                    <td>{{strtoupper($student->first_name)}}</td>
                                                    <td>{{ucwords($student->last_name)}}</td>
                                                    <td>{{ucfirst($student->sexe == 'F' ? 'Féminin':'Masculin')}}</td>
                                                    <td>{{$student->date_birth}}</td>
                                                    <td>{{ucwords($student->place_birth)}}</td>
                                                    <td>{{ucwords($student->place_residence)}}</td>
                                                    <td class="text-center">
                                                        @if ($student->photo)
                                                        <img src="{{asset($student->urlStudent())}}" class="img-radius mx-0" alt="User-Profile-Image" style="height:40px; width:40px">
                                                        @else
                                                        <img src="{{asset($student->sexe == 'F' ? 'assets/images/stdt_w.png':'assets/images/stdt_m.png')}}" class="img-radius mx-0" alt="User-Profile-Image" style="height:40px; width:40px">
                                                        @endif
                                                    </td>
                                                    <td>
                                                        <div class="card-block remove-label m-0 p-0 text-center">
                                                            <a href="{{route('student.show',$student->id)}}" class="btn btn-sm btn-primary text-center px-2" title="Detail"><i class="fas fa-ellipsis-h m-0"></i></a>
                                                            <a href="{{route('student.edit',$student->id)}}" class="btn btn-sm btn-info text-center px-2" title="Edit"><i class="fas fa-edit m-0"></i></a>
                                                            {{-- <button class="getIdStudent btn btn-sm btn-danger text-white text-center px-2" title="Delete" data-id="{{$student->id}}" data-toggle="modal" data-target="#exampleModalCenter"><i class="far fa-trash-alt m-0"></i></button> --}}
                                                        </div>
                                                    </td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div> 
                                </div> 
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="upload" tabindex="-1" role="dialog" aria-labelledby="uploadLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header bg-dark py-2">
          <h5 class="modal-title" id="uploadLabel">Import File Student</h5>
        </div>
        <form action="{{route('student.file')}}" method="post" enctype="multipart/form-data">
            @csrf
            <div class="modal-body px-3 py-4">
                <div class="form-group mt-2">
                    <span class="d-flex justify-content-between mb-2">
                        <label for="firstNameUser">Charger la fiche<span class="text-danger">*</span> : </label>
                        <a href="{{route('student.download')}}" class="btn btn-inverse btn-outline-inverse btn-sm py-1" title="DownLoad File Example"><i class="fas fa-download mx-0"></i></a>
                    </span>
                    <input type="file" name="files" id="firstNameUser" class="form-control" placeholder="Charger le fichier de format Excel">
                </div>
            </div>
            <div class="modal-footer">
                <a href="#" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</a>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
      </div>
    </div>
</div>
@endsection
@section('script')
    <!-- data-table js -->
    <script src="{{asset('bower_components/datatables.net/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/js/jszip.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/js/pdfmake.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/js/vfs_fonts.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/extensions/autofill/js/dataTables.select.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')}}"></script>

    <!-- Custom js -->
    <script src="{{asset('assets/pages/data-table/extensions/autofill/js/extensions-custom.js')}}"></script>
    <script src="{{asset('assets/js/pcoded.min.js')}}"></script>
    <script src="{{asset('assets/js/vartical-layout.min.js')}}"></script>
    <script src="{{asset('assets/js/jquery.mCustomScrollbar.concat.min.js')}}"></script>
    <script>
        $(document).ready(function(){

        })
    </script>
@endsection