@extends('app')
@section('title', 'Detail eleve')
@section('content')
<div class="pcoded-inner-content">
    <div class="main-body">
        @include('includes._alert')
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-body mb-0 pb-0">
                                <div class="card-header pb-2">
                                    <div class="d-flex justify-content-between">
                                        <h4>Détail élève</h4>
                                        <span>
                                            <a href="{{route('student.index')}}" class="btn btn-inverse btn-outline-inverse  btn-sm py-1" title="Return Back"><i class="fas fa-reply mx-0"></i></a>
                                        </span>
                                    </div>
                                </div>
                                <hr class="my-0 mx-3">
                                <div class="row py-3">
                                    <div class="col-sm-5 text-center pt-md-5">
                                        @if ($data->photo)
                                        <img src="{{asset($data->urlStudent())}}" class="img-radius mx-0 w-25" alt="User-Profile-Image">
                                        @else
                                        <img src="{{asset($data->sexe == 'F' ? 'assets/images/stdt_w.png':'assets/images/stdt_m.png')}}" class="img-radius mx-0" alt="User-Profile-Image" style="width:40px">
                                        @endif
                                        <h4 class="mb-1 mt-2">{{ucfirst($data->first_name).' '.ucfirst($data->last_name)}}</h4>
                                        <p class="text-muted"><strong>{{ucfirst($data->matricule)}}</strong></p>
                                        <p>
                                            {{mb_strtoupper($data->parentEleve->first_name).' '.ucfirst($data->parentEleve->last_name.' / '.$data->parentEleve->profession)}} <br>
                                            <strong>[{{$data->parentEleve->telephon1}} {{$data->parentEleve->telephon2 ? ' / '.$data->parentEleve->telephon2:null}}]</strong>
                                        </p>
                                        <a href="{{route('student.edit',$data->id)}}" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 my-1"><i class="fas fa-edit"></i> Editer</a>
                                    </div>
                                    <div class="col-sm-7">
                                        <div class="text-start mt-3">
                                            <table class="table table-bordered mt-0">
                                                <tbody>
                                                    <tr>
                                                        <td style="width: 250px"><span style="font-size: 14px">Matricule</span></td>
                                                        <td><strong>{{$data->matricule}}</strong></td>
                                                    </tr>
                                                    <tr>
                                                        <td style="width: 250px"><span style="font-size: 14px">Nom</span></td>
                                                        <td><strong>{{mb_strtoupper($data->first_name)}}</strong></td>
                                                    </tr>
                                                    <tr>
                                                        <td style="width: 250px"><span style="font-size: 14px">Prénoms</span></td>
                                                        <td><strong>{{ucfirst($data->last_name)}}</strong></td>
                                                    </tr>
                                                    <tr>
                                                        <td style="width: 250px"><span style="font-size: 14px">Genre</span></td>
                                                        <td><strong>{{ucfirst($data->sexe == 'F' ? 'Féminin':'Masculin')}}</strong></td>
                                                    </tr>
                                                    <tr>
                                                        <td style="width: 250px"><span style="font-size: 14px">Date et lieu de naissance</span></td>
                                                        <td>Né{{$data->sexe == 'F' ? 'e':''}} le <strong>{{$data->date_birth}}</strong> à <strong>{{ucfirst($data->place_birth)}}</strong></td>
                                                    </tr>
                                                    <tr>
                                                        <td style="width: 250px"><span style="font-size: 14px">Nationalité</span></td>
                                                        <td><strong>{{ucfirst($data->nationalitie->libelle)}}</strong></td>
                                                    </tr>
                                                    <tr>
                                                        <td style="width: 250px"><span style="font-size: 14px">Père biologique</span></td>
                                                        <td><strong>{{mb_strtoupper($data->first_name_father).' '.ucfirst($data->last_name_father.' / '.$data->profession_father)}}</strong></td>
                                                    </tr>
                                                    <tr>
                                                        <td style="width: 250px"><span style="font-size: 14px">Mère biologique</span></td>
                                                        <td>
                                                            <strong>
                                                                {{mb_strtoupper($data->first_name_mother).' '.ucfirst($data->last_name_mother.' / '.$data->profession_mother)}}
                                                            </strong>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td style="width: 250px"><span style="font-size: 14px">Type d'enseignement </span></td>
                                                        <td><strong>{{ucfirst($data->type)}}</strong</td>
                                                    </tr>
                                                    <tr>
                                                        <td style="width: 250px"><span style="font-size: 14px">Disponibilité </span></td>
                                                        <td><strong>{{ucfirst($data->status ? 'Oui':'Non')}}</strong</td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-10 offset-md-1">
                                        <h5 class="fs-10 text-uppercase mb-1">Parcours scolaire</h5>
                                        <table class="table table-bordered mt-0">
                                            <thead>
                                                <tr>
                                                    <th class="text-center" style="width:25px">N°</th>
                                                    <th style="width:100px">Année scolaire</th>
                                                    <th style="width:100px">Niveau</th>
                                                    <th style="width:100px">Classe</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @php $i = 1; @endphp
                                                @foreach ($data->inscriptions as $item)
                                                <tr>
                                                    <th class="text-center">{{$i <= 9 ? '0'.$i++:$i++}}</th>
                                                    <td>{{$item->schoolYear->school_year}}<strong class="text-danger">{{$item->schoolYear->id == $year->id ? '*':null}}</strong></td>
                                                    <td>{{ucwords($item->level->code)}}</td>
                                                    <td>{{ucwords($item->classe->libelle)}}</td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
<script src="{{asset('assets/js/pcoded.min.js')}}"></script>
<script src="{{asset('assets/js/vartical-layout.min.js')}}"></script>
<script src="{{asset('assets/js/jquery.mCustomScrollbar.concat.min.js')}}"></script>
@endsection