@extends('app')
@section('title', 'List note')
@section('link')
<!-- Data Table Css -->
<link rel="stylesheet" href="{{asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')}}">
<link rel="stylesheet" href="{{asset('assets/pages/data-table/css/buttons.dataTables.min.css')}}">
<link rel="stylesheet" href="{{asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')}}">
<style>
    .dataTables_length label{
        display: none;
    }
</style>
@endsection
@section('content')
<div class="pcoded-inner-content">
    @include('includes._alert')
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header">
                                <div class="d-flex justify-content-between">
                                    <h4>Liste des notes - 
                                        <strong style="font-size: 19px">{{ucfirst($class->libelle)}}</strong>
                                    </h4>
                                    <span class="form-control-variant" style="font-size: 17px">
                                        <strong class="mr-2">{{ucfirst($decoup->cutting->libelle.' [ '.($matter->matter->abbreviated ?? $matter->matter->libelle).' ]')}}</strong>
                                    </span>
                                    <span>
                                        <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" title="Approuvez les moyennes" data-toggle="modal" data-target="#ModalConfirm" style="display: {{$approved ? 'none':''}}"><i class="fa fa-thumbs-up m-0"></i></button>
                                        @if (!$approved)
                                        <a href="{{route('evaluation.bonnus', $string)}}" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mx-1" title="Bonnus moyenne"><i class="fa fa-qrcode mx-0"></i></a>
                                        @endif
                                        <a href="{{route('evaluation.pdf', $string)}}" target="_blank" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mx-1" title="Télécharger la fiche"><i class="fa fa-download mx-0"></i></a>
                                        <a href="{{route('evaluation.return', $class->id.'_'.$matter->id)}}" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mx-1" title="Return Back"><i class="fas fa-reply mx-0"></i></a>
                                    </span>
                                </div>
                            </div>
                            <hr class="mx-3 my-0">
                            <div class="card-block">
                                <div class="dt-responsive table-responsive px-lg-3">
                                    <table id="saving-reorder" class="table table-stripeds table-bordered">
                                        <thead>
                                            <tr>
                                                <th class="text-center" style="width: 3%">N°</th>
                                                <th class="text-uppercase" style="width: 100px">Nom et prénoms</th>
                                                <th class="text-uppercase" style="width: 10px">Genre</th>
                                                <th class="text-uppercase" style="width: 20px">Matricule</th>
                                                <th class="text-center text-uppercase" style="width: 30px" title="Composition Française">CF</th>
                                                <th class="text-center text-uppercase" style="width: 30px" title="Orthographe-Grammaire">OG</th>
                                                <th class="text-center text-uppercase" style="width: 30px" title="Expression Orale">EO</th>
                                                <th class="text-uppercase text-center" style="width: 7%">Moyenne</th>
                                                <th class="text-uppercase text-center" style="width: 5%">Rang</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php $i = 1 @endphp
                                            @foreach ($datas as $item)
                                            <tr>
                                                <th class="text-center py-2">
                                                    <div class="mt-2">{{$i <= 9 ? '0'.$i++:$i++}}</div>
                                                </th>
                                                <td class="py-2">
                                                    <div class="mt-2">{{$item['name']}}</div>
                                                </td>
                                                <td class="py-2"><div class="mt-2">{{ucfirst($item['sexe'] == 'F' ? 'Féminin':'Masculin')}}</div></td>
                                                <td class="py-2"><div class="mt-2">{{$item['matricule']}}</div></td>
                                                <td class="p-0">
                                                    <table class="table p-0 m-0">
                                                        <tr class="m-0 p-0">
                                                            @foreach ($item['notes']['CF']['notes'] as $item1)
                                                            <td class="text-center m-0 py-1">{{$item1['note'] ?? 'nc'}}</td>
                                                            @endforeach
                                                        </tr>
                                                        <tr class="m-0 p-0">
                                                            <td colspan="4" class="py-0 text-center">Moy : {{$item['notes']['CF']['moyenne']}}</td>
                                                        </tr>
                                                    </table>
                                                </td>
                                                <td class="p-0">
                                                    <table class="table p-0 m-0">
                                                        <tr class="m-0 p-0">
                                                            @foreach ($item['notes']['OG']['notes'] as $item3)
                                                            <td class="text-center m-0 py-1">{{$item3['note'] ?? 'nc'}}</td>
                                                            @endforeach
                                                        </tr>
                                                        <tr class="m-0 p-0">
                                                            <td colspan="4" class="py-0 text-center">Moy : {{$item['notes']['OG']['moyenne']}}</td>
                                                        </tr>
                                                    </table>
                                                </td>
                                                <td class="p-0">
                                                    <table class="table p-0 m-0">
                                                        <tr class="m-0 p-0">
                                                            @foreach ($item['notes']['EO']['notes'] as $item2)
                                                            <td class="text-center m-0 py-1">{{$item2['note'] ?? 'nc'}}</td>
                                                            @endforeach
                                                        </tr>
                                                        <tr class="m-0 p-0">
                                                            <td colspan="4" class="py-0 text-center">Moy : {{$item['notes']['EO']['moyenne']}}</td>
                                                        </tr>
                                                    </table>
                                                </td>
                                                <th class="py-2 text-center">
                                                    <div class="mt-2">{{$item['moyen'] ? $item['moyen']['moyenne']:'--'}}</div>
                                                </th>
                                                <td class="py-2 text-center">
                                                    <div class="mt-2">{{$item['moyen'] ? $item['moyen']['rang']:'--'}}</div>
                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
{{-- Modal --}}
<div class="modal fade" id="ModalConfirm" tabindex="-1" role="dialog" aria-labelledby="ModalConfirmTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header bg-dark py-2">
          <h5 class="modal-title" id="ModalConfirmLongTitle">Confirmation</h5>
          <span style="font-size: 17px">{{ucfirst($decoup->cutting->libelle)}}</span>
        </div>
        <div class="modal-body py-3 text-center">
            <p class="mt-2">
                <strong style="font-size: 19px">Confirmation des moyenne !</strong>
            </p>
            " Apres cette action plus de modification <br> ou de suppression à votre niveau "
        </div>
        <div class="modal-footer">
            <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</button>
            <a href="{{route('evaluation.approved', $string)}}" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</a>
        </div>
      </div>
    </div>
</div>
@endsection
@section('script')
    <!-- data-table js -->
    <script src="{{asset('bower_components/datatables.net/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')}}"></script>
    <!-- Custom js -->
    <script src="{{asset('assets/pages/data-table/extensions/colreorder/js/colreorder-custom.js')}}"></script>
    <script src="{{asset('assets/js/pcoded.min.js')}}"></script>
    <script src="{{asset('assets/js/vartical-layout.min.js')}}"></script>
    <script src="{{asset('assets/js/jquery.mCustomScrollbar.concat.min.js')}}"></script>
    <script>
        $(document).ready(function(){

        })
    </script>
@endsection