@extends('app')
@section('title', 'Gestion des classes')
@section('link')
<!-- Data Table Css -->
<link rel="stylesheet" href="{{asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')}}">
<link rel="stylesheet" href="{{asset('assets/pages/data-table/css/buttons.dataTables.min.css')}}">
<link rel="stylesheet" href="{{asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')}}">
<style>
    .dataTables_length label{
        display: none;
    }
</style>
@endsection
@section('content')
<div class="pcoded-inner-content">
    @include('includes._alert')
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header mb-0 pb-0">
                                <div class="d-flex justify-content-between pb-2">
                                    <div>
                                        <h4 class="m-0">Liste de classe {{$classe['libelle']}}</h4>
                                        <p class="m-0">Effecif : {{(count($incrits)<= 9) ? '0'.count($incrits):count($incrits)}} - F : {{$fille}} - M : {{$garcon}}</p>
                                    </div>
                                    <p class="m-0" style="font-size: 15px">
                                        {{$teacher ? ($teacher->user->sexe == 'F' ? ('Mde '.strtoupper($teacher->user->first_name).' '.ucwords($teacher->user->last_name)):('Mr. '.strtoupper($teacher->user->first_name).' '.ucwords($teacher->user->last_name))):'Non encore défini' }}
                                        {{-- <span class="p-0 my-0">{{$teacher ? 'Enseignant pricinpal':null}}</span> --}}
                                    </p>
                                    <div class="right">
                                        {{-- <span id="addBtn" style="font-size: 15px">Année Scolaire <strong>{{$classe->schoolYear->school_year}}</strong></span> --}}
                                        <span style="float: right">
                                            @if ($classe['type'] == 'primaire')
                                            <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mr-2"  data-toggle="modal" data-target="#addModal" title="Add Teacher"><i class="fas fa-user m-0"></i></button>
                                            @endif
                                            @if (count($incrits))
                                            <a href="{{route('classe.pdf',$classe->id)}}" target="_blank" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mr-2" title="Télécharger la liste"> <i class="fas fa-download mx-0"></i></a>
                                            @endif
                                            <a href="{{route('classe.index')}}" class="btn btn-inverse btn-outline-inverse  btn-sm py-1" title="Return Back"><i class="fas fa-reply mx-0"></i></a>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <hr class="mx-3 my-0">
                            <div class="card-block">
                                <div class="dt-responsive table-responsive">
                                    <table id="simpletable"
                                        class="table table-striped table-bordered nowrap">
                                        <thead>
                                            <tr>
                                                <th style="width: 3%"></th>
                                                <th style="width: 22%">Nom et Prenoms</th>
                                                <th style="width: 12%">Genre</th>
                                                <th style="width: 12%">Date de nais...</th>
                                                <th style="width: 12%">Matricule</th>
                                                @if (!($classe['type'] == 'primaire'))
                                                <th style="width: 12%">Affecté</th>
                                                @endif
                                                <th style="width: 12%">Redoublant</th>
                                                @if (!($classe['type'] == 'primaire'))
                                                <th style="width: 12%">Boursier</th>
                                                @endif
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php $i = 1; @endphp
                                            @foreach ($incrits as $item)
                                            <tr>
                                                <th class="text-center">{{$i <= 9 ? '0'.$i++:$i++}}</th>
                                                <td>{{mb_strtoupper($item->first_name).' '.ucfirst($item->last_name)}}</td>
                                                <td>{{ucfirst($item->sexe == 'F' ? 'Féminin':'Masculin')}}</td>
                                                <td>{{$item->date_birth.' à '.ucfirst($item->place_birth)}}</td>
                                                <td>{{$item->matricule}}</td>
                                                @if (!($classe['type'] == 'primaire'))
                                                <td>{{ucfirst($item->affecte)}}</td>
                                                @endif
                                                <td>{{ucfirst($item->redoublant)}}</td>
                                                @if (!($classe['type'] == 'primaire'))
                                                <td>{{ucfirst($item->boursier)}}</td>
                                                @endif
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- @Modal -->
<div class="modal fade" id="addModal" tabindex="-1" role="dialog" aria-labelledby="addModalTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header bg-dark py-2">
          <h5 class="modal-title" id="addModalTitle">Teacher management</h5>
          <span id="libelle" style="font-size: 18px"></span>
        </div>
        <form action="{{route('classe.teacher')}}" method="post">
            @csrf
            <div class="modal-body">
                <input type="hidden" name="classe" value="{{$classe['id']}}">
                <div class="form-group mb-2">
                    <label class="col-form-label" for="teacher">Select Teacher<span class="text-danger">*</span> :</label>
                    <select name="teacher" id="teacher" class="form-control">
                        <option value="{{$teacher ? $teacher->user_id:null}}">{{$teacher ? (($teacher->user->sexe == "F" ? 'Mde. ':'Mr. ').strtoupper($teacher->user->first_name).' '.ucwords($teacher->user->last_name)):'Select One option' }}</option>
                        @foreach ($users as $user)
                        <option value="{{$user->id}}">{{($user->sexe == "F" ? 'Mde. ':'Mr. ').strtoupper($user->first_name).' '.ucwords($user->last_name)}}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="modal-footer">
              <button type="button" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</button>
              <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" id="formUrl">Valider</button>
            </div>
        </form>
      </div>
    </div>
</div>
@endsection
@section('script')
    <!-- data-table js -->
    <script src="{{asset('bower_components/datatables.net/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')}}"></script>
    <!-- Custom js -->
    <script src="{{asset('assets/pages/data-table/js/data-table-custom.js')}}"></script>
    <script src="{{asset('assets/js/pcoded.min.js')}}"></script>
    <script src="{{asset('assets/js/vartical-layout.min.js')}}"></script>
    <script src="{{asset('assets/js/jquery.mCustomScrollbar.concat.min.js')}}"></script>
    <script>
        $(document).ready(function(){
           
        })
    </script>
@endsection