<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('personnel_schools', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name_directeur');
            $table->string('phon_directeur');
            $table->string('name_adjoint')->nullable();
            $table->string('phon_adjoint')->nullable();
            $table->string('name_secretaire')->nullable();
            $table->string('phon_secretaire')->nullable();
            $table->string('name_fichier')->nullable();
            $table->string('phon_fichier')->nullable();
            $table->string('name_comptable')->nullable();
            $table->string('phon_comptable')->nullable();
            $table->date('homologation_1')->nullable();
            $table->date('homologation_2')->nullable();
            $table->unsignedBigInteger('school_id');
            $table->unsignedBigInteger('school_year_id');
            $table->foreign('school_id')->references('id')->on('schools')->onDelete('cascade');
            $table->foreign('school_year_id')->references('id')->on('school_years')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('personnel_schools');
    }
};
