<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sanctions', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->enum('discipline',[0,1])->default(0);
            $table->string('motif')->nullable();
            $table->unsignedBigInteger('inscription_id');
            $table->unsignedBigInteger('motif_sanction_id');
            $table->unsignedBigInteger('cutting_school_year_id');
            $table->foreign('inscription_id')->references('id')->on('inscriptions')->onDelete('cascade');
            $table->foreign('motif_sanction_id')->references('id')->on('motif_sanctions')->onDelete('cascade');
            $table->foreign('cutting_school_year_id')->references('id')->on('cutting_school_year')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sanctions');
    }
};
