<?php

namespace App\Listeners;

use App\Events\MoyenneSubMatiereEvent;
use App\Models\MoyenneAnnuelleSubMatter;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;

class MoyenneSubMatiereListener
{
    public function handle(MoyenneSubMatiereEvent $event): void
    {
        $resut = MoyenneAnnuelleSubMatter::where('inscription_id', $event->student)->where('sub_matter_id', $event->matiere)->where('school_year_id', $event->year)->first();
        if($resut){
            $val = explode(' ', $event->libelle);
            $resut->update([
                'rang_trim' => $event->rang,
                'coefficient' => $event->ceoff,
                'moyenne_'.$val[1] => $event->moyenne
            ]);
        }
        else{
            MoyenneAnnuelleSubMatter::create([
                'school_id' => $event->school,
                'moyenne_1' => $event->moyenne,
                'school_year_id' => $event->year,
                'sub_matter_id' => $event->matiere,
                'inscription_id' => $event->student
            ]); 
        }
    }
}
