
<?php $__env->startSection('title', 'Resultat '.$classe['libelle']); ?>
<?php $__env->startSection('link'); ?>
<!-- Data Table Css -->
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/css/buttons.dataTables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')); ?>">
<style>
    .dataTables_length label{
        display: none;
    }

    .highcharts-credits{
        display: none;
    }
    .fa-exclamation-triangle {
        animation: blink 1s infinite;
        color: rgb(33, 33, 99)
    }

    @keyframes blink {
        0%, 100% {
            opacity: 1;
        }
        50% {
            opacity: 0;
        }
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="pcoded-inner-content">
    <?php echo $__env->make('includes._alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header mb-0 pb-0">
                                <div class="d-flex justify-content-between mb-0 pb-0">
                                    <h4 class="mb-0">Résultat - <?php echo e($classe['libelle']); ?></h4>
                                    <span class="form-control-variant" style="font-size: 15px">
                                        <strong class="mr-2" style="font-size: 20px"><?php echo e(ucwords($evaluated->evaluated->libelle)); ?></strong>
                                    </span>
                                    <span>
                                      <a href="<?php echo e(route('resultat.compo',$classe->id.'_'.$evaluated->id)); ?>" id="btnLink" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mx-1" title="Vus d'ensemble"><i class="far fa-eye m-0"></i></a>
                                      <a href="<?php echo e(route('resultat.index')); ?>" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mx-1" title="Return Back"><i class="fas fa-reply mx-0"></i></a>
                                    </span>
                                </div>
                            </div>
                            <hr class="mx-3 mt-0">
                            <div class="card-block pb-0">
                                <div class="card card-border-<?php echo e($resultat ? ($resultat['moyenne'] >= 5 ? 'success':'danger'):'info'); ?> p-0 mb-0">
                                  <div class="row m-0">
                                    <?php if($resultat): ?>
                                    <div class="col-xl-6 col-md-12 m-0 p-0">
                                      <div class="card m-0" style="height: 450px">
                                        <div class="card-header">
                                          <div class="d-flex justify-content-between">
                                            <strong style="font-size: 17px">Les Trois Meilleurs</strong>
                                            <i class="fas fa-users m-0" style="font-size: 18px"></i>
                                          </div>
                                          <hr class="my-1">
                                        </div>
                                        <div class="card-block" style="height: 230px">
                                          <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                          <div class="row m-b-25">
                                              <div class="col-auto p-r-0">
                                                  <?php if($student['photo']): ?>
                                                  <img src="<?php echo e(asset('storage/'.$student['photo'])); ?>" alt="Photo" alt="" class="img-fluid img-50">
                                                  <?php else: ?>
                                                  <img src="<?php echo e(asset($student['sexe'] == 'F' ? 'assets/images/stdt1_woman.png':'assets/images/stdt1_man.png')); ?>" alt="" class="img-fluid img-50" style="height: 40px; width: 40px; border: 1px solid grey">
                                                  <?php endif; ?>
                                              </div>
                                              <div class="col">
                                                  <h6 class="m-b-5" style="font-weight: bold;"><?php echo e(strtoupper($student['first_name']).' '.ucwords($student['last_name'])); ?></h6>
                                                  <p class="text-muted m-b-0"><strong><?php echo e($student['rang']); ?></strong> - <strong><?php echo e($student['moyenne']); ?></strong> de moyenne.</p>
                                              </div>
                                          </div>
                                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                        <div class="card-footer">
                                            <div class="row text-center b-t-default">
                                                <div class="col-6 b-r-default m-t-15">
                                                    <h5>
                                                        <strong class="label label-<?php echo e($resultat['moyenne'] >= 5 ? 'success':'danger'); ?>">
                                                          <?php echo e($resultat['moyenne'] ? $resultat['moyenne'].'/10':null); ?>

                                                        </strong>
                                                    </h5>
                                                    <p class="text-muted m-b-0">Moyenne de Classe</p>
                                                </div>
                                                <div class="col-6 m-t-15">
                                                    <h5>
                                                        <strong class="label label-info"><?php echo e($plus  ? $plus:'00'); ?>%</strong>
                                                    </h5>
                                                    <p class="text-muted m-b-0">Taux De Réussite</p>
                                                </div>
                                            </div>
                                            
                                        </div>
                                      </div>
                                    </div>
                                    <div class="col-xl-6 col-md-12 m-0 p-0">
                                      <div class="card" style="height: 450px">
                                        <div class="card-block" style="height: 230px">
                                          <div id="myData" data-ttls="<?php echo e($classe['inscrits'] <= 9 ? '0'.$classe['inscrits']:$classe['inscrits']); ?>" data-sup="<?php echo e($resultat['nbre_superieur'] ? round(($resultat['nbre_superieur'] / $classe['inscrits'])*100):'0'); ?>" data-ent="<?php echo e($resultat['nbre_entre'] ? round(( $resultat['nbre_entre'] / $classe['inscrits'])*100):'0'); ?>" data-inf="<?php echo e($resultat['nbre_inferieur'] ? round(($resultat['nbre_inferieur'] / $classe['inscrits'])*100):'0'); ?>"  class="my-0"></div>
                                        </div>
                                      </div>
                                    </div>
                                    <?php else: ?>
                                      <div class="col-12 p-0 text-center">
                                        <div class="card m-0">
                                          <div class="card-header py-3">
                                            <i class="fas fa-exclamation-triangle" style="font-size: 35px"></i> <br>
                                            <h5 class="card-title my-3">Résultat non disponible.</h5>
                                          </div>
                                        </div>
                                      </div>
                                    <?php endif; ?>
                                  </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <!-- data-table js -->
    <script src="<?php echo e(asset('bower_components/datatables.net/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')); ?>"></script>

    <!-- Chart js -->
    <script src="https://code.highcharts.com/highcharts.js"></script>

    <!-- Custom js -->
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/colreorder/js/colreorder-custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pcoded.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vartical-layout.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.mCustomScrollbar.concat.min.js')); ?>"></script>

    <script>
      $(document).ready(function(){
        
        $sups = $('#myData').data('sup'); $infs = $('#myData').data('inf'); $tls = $('#myData').data('ttls');
        charts('myData', $tls, $sups, $infs);


        // ------------------------------------------------------------------------------------
        // Data retrieved from https://netmarketshare.com/   ||||   https://www.highcharts.com/demo/highcharts/pie-chart
        function charts($id, $tls, $sup, $inf){
          Highcharts.chart($id, {
            chart: {
              type: 'pie',
              custom: {},
              events: {
                render() {
                    const chart = this,
                    series = chart.series[0];
                    let customLabel = chart.options.chart.custom.label;

                    if (!customLabel) {
                      customLabel = chart.options.chart.custom.label =
                      chart.renderer.label('Total : <br/>' + '<strong>'+$tls+'</strong>')
                      .css({
                        color: 'var(--highcharts-neutral-color-100, #000)',
                        textAnchor: 'middle'
                      })
                      .add();
                    }

                    const x = series.center[0] + chart.plotLeft,
                      y = series.center[1] + chart.plotTop -
                      (customLabel.attr('height') / 2);
                      customLabel.attr({
                        x,
                        y
                    });
                    // Set font size based on chart diameter
                    customLabel.css({
                      fontSize: `${series.center[2] / 12}px`
                    });
                }
              }
            },
            accessibility: {
              point: {
                valueSuffix: '%'
              }
            },
            title: {
              text: 'Statistique De La Classe'
            },
            subtitle: {
              text: 'Pourcentage Des Marges'
            },
            tooltip: {
              pointFormat: '{series.name}: <b>{point.percentage:.0f}%</b>'
            },
            legend: {
              enabled: false
            },
            plotOptions: {
              series: {
                allowPointSelect: true,
                cursor: 'pointer',
                borderRadius: 8,
                dataLabels: [{
                  enabled: true,
                  distance: 20,
                  format: '{point.name}'
                }, {
                  enabled: true,
                  distance: -15,
                  format: '{point.percentage:.0f}%',
                  style: {
                    fontSize: '0.9em'
                  }
                }],
                showInLegend: true
              }
            },
            series: [{
              name: 'Résultat ',
              colorByPoint: true,
              innerSize: '60%',
              data: [
                {
                  name: 'Supérieur ou egale à 5',
                  y: $sup,
                  color: '#42dfb7'
                },
                {
                  name: 'Inférieur à 5',
                  y: $inf,
                  color: '#fa7945'
                }
              ]
            }]
          });
        }

      })
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/educasnsa/public_html/neuroschool/resources/views/pages/resultats/primaire.blade.php ENDPATH**/ ?>