<?php $__env->startSection('title', 'Gestion des appels'); ?>
<?php $__env->startSection('link'); ?>
<!-- Data Table Css -->
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/css/buttons.dataTables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')); ?>">
<style>
    .btn.btn-icons {
        border-radius: 50%;
        width: 30px;
        line-height: 20px;
        height: 30px;
        padding: 3px;
        text-align: center;
    }
    .dataTables_length label{
        display: none;
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="pcoded-inner-content">
    <?php echo $__env->make('includes._alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header mb-0 pb-0">
                                <div class="d-flex justify-content-between pb-0">
                                    <h4>Transport</h4>
                                    <span>
                                        <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-toggle="modal" data-target="#addModal" title="Add New scolarity Fee"><i class="fas fa-exchange-alt m-0"></i></button>
                                        <a href="<?php echo e(route('transport.create')); ?>" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" title="Gestion des zones"><i class="fas fa-border-all m-0"></i></a>
                                    </span>                                
                                </div>
                            </div>
                            <hr class="my-0 mx-3">
                            <div class="card-block">
                                <div class="dt-responsive table-responsive">
                                    <ul class="nav nav-tabs md-tabs" role="tablist">
                                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="nav-item" style="width: 18%">
                                            <a class="nav-link text-left <?php echo e(session('lib') ? (session('lib') == $item['libelle'] ? 'active':'' ):($item['nbre'] == 1 ? 'active':'')); ?> menuStep" id="<?php echo e(session('lib') ? (session('lib') == $item['libelle'] ? 'active':'' ):($item['nbre'] == 1 ? 'active':'')); ?>" data-lib="<?php echo e($item['libelle']); ?>" data-toggle="tab" href="#home<?php echo e($item['nbre']); ?>" role="tab" aria-selected="true">
                                                <i class="icofont icofont-home"></i><?php echo e(ucfirst(changeVal($item['libelle']))); ?>

                                            </a>
                                            <div class="slide" style="width: 16%"></div>
                                        </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                    <!-- Tab panes -->
                                    <div class="tab-content card-block">
                                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="tab-pane <?php echo e(session('lib') ? (session('lib') == $item['libelle'] ? 'active':'' ):($item['nbre'] == 1 ? 'active':'')); ?>" id="home<?php echo e($item['nbre']); ?>" role="tabpanel">
                                            <table id="<?php echo e($item['tab']); ?>" class="table table-striped table-bordered nowrap">
                                                <thead>
                                                    <tr>
                                                        <th class="text-center">N°</th>
                                                        <th class="text-center">Libelle</th>
                                                        <th class="text-center">Lieux</th>
                                                        <th class="text-center">Montant</th>
                                                        <th class="text-center" style="width: 20%">Actions</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $i = 1; ?>
                                                    <?php $__currentLoopData = $item['data']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <th class="text-center"><?php echo e($i <= 9 ? '0'.$i++:$i++); ?></th>
                                                        <td><?php echo e(ucwords($val->libelle)); ?></td>
                                                        <td class="text-left pl-3"><?php echo e(ucwords($val->zone)); ?></td>
                                                        <td class="text-center"><?php echo e(formatMontant($val->montant)); ?> FR CFA</td>
                                                        <td style="width: 20%" class="py-0">
                                                            <div class="card-block remove-label m-0 py-2 text-center">
                                                                <button class="getEdit btn btn-inverse btn-outline-inverse btn-icons mr-1" title="Edit" data-id="<?php echo e($val->id); ?>" data-amount="<?php echo e($val->montant); ?>" data-lib="<?php echo e(ucwords($val->zone)); ?>" data-toggle="modal" data-target="#editModal"><i class="far fa-edit"></i></button>
                                                                <button class="getDelet btn btn-inverse btn-outline-inverse btn-icons" title="Delete" data-id="<?php echo e($val->id); ?>" data-zone="<?php echo e(ucwords($val->libelle)); ?>" data-lib="<?php echo e(ucwords($val->zone)); ?>" data-toggle="modal" data-target="#deleteModal"><i class="far fa-trash-alt"></i></button>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                            </table>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div> 
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- @Modal Add -->
<div class="modal fade" id="addModal" tabindex="-1" role="dialog" aria-labelledby="addModalTitle" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
        <div class="modal-header bg-dark py-2">
            <h5 class="modal-title" id="addModalLongTitle">Add Zone</h5>
            <span style="font-size: 17px" id="vals"></span>
        </div>
        <form action="<?php echo e(route('transport.store')); ?>" method="post">
            <?php echo csrf_field(); ?>
            <div class="modal-body py-3">
                <input type="hidden" name="type" id="type">
                <input type="hidden" name="year" value="<?php echo e($year['id']); ?>">
                <div class="form-group pt-2">
                    <label for="zone" class="form-label">Select zone<span class="text-danger">*</span> :</label>
                    <select class="form-control" name="zone" id="zone" aria-label="Default select example">
                        <option selected>Select ...</option>
                        <?php $__currentLoopData = $zones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $zone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($zone->id); ?>"><?php echo e(ucwords($zone->zone->libelle)); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
               <div class="form-group pt-2">
                    <label for="amount" class="form-label">Montant<span class="text-danger">*</span> :</label>
                    <input type="text" id="amount" name="amount" class="form-control" placeholder="Entrez le montant ..." required>
                    <span style="font-size: 11px; color: rgba(94, 94, 94, 0.815)">Ce montant conserne pour un trimestre ou Semestre.</span>
                </div>
            </div>
            <div class="modal-footer">
                <a href="#" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</a>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
    </div>
  </div>
</div>
<!-- @Modal Add -->
<div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="editModalTitle" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
        <div class="modal-header bg-dark py-2">
            <h5 class="modal-title" id="editModalLongTitle">Edit</h5>
            <span style="font-size: 17px" id="valEdit"></span>
        </div>
        <form action="<?php echo e(route('transport.edit')); ?>" method="post">
            <?php echo csrf_field(); ?>
            <div class="modal-body py-3">
                <input type="hidden" name="id" id="id">
                <div class="form-group pt-2">
                    <label for="zone" class="form-label">Zone concernée<span class="text-danger">*</span> :</label>
                    <input class="form-control" id="libEdit" disabled>
                </div>
               <div class="form-group pt-2">
                    <label for="montant" class="form-label">Montant<span class="text-danger">*</span> :</label>
                    <input type="text" id="montant" name="amount" class="form-control" placeholder="Entrez le montant ..." required>
                </div>
            </div>
            <div class="modal-footer">
                <a href="#" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</a>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
    </div>
  </div>
</div>
<!-- @Modal Add -->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalTitle" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
        <div class="modal-header bg-dark py-2">
            <h5 class="modal-title" id="deleteModalLongTitle">Delete</h5>
            <span style="font-size: 17px" id="valDelete"></span>
        </div>
        <form action="<?php echo e(route('transport.destroy')); ?>" method="post">
            <?php echo csrf_field(); ?>
            <div class="modal-body py-3 text-center">
                <strong id="delete"></strong>
                <p id="libDelete"></p>
                <p>Confirmez le supression.</p>
                <input type="hidden" id="idDelete" name="id">
            </div>
            <div class="modal-footer">
                <a href="#" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</a>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <!-- data-table js -->
    <script src="<?php echo e(asset('bower_components/datatables.net/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')); ?>"></script>
    <!-- Custom js -->
    <!-- Select2 JS -->
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/colreorder/js/colreorder-custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pcoded.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vartical-layout.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.mCustomScrollbar.concat.min.js')); ?>"></script>
    <script>
        $(document).ready(function(){

            $('#amount, #montant').on('input', function () {
                let value = $(this).val().replace(/\s/g, '');
                value = value.replace(/\D/g, '');
                let formatted = value.replace(/\B(?=(\d{3})+(?!\d))/g, ' ');
                $(this).val(formatted);
            });


            $('#type').val($("#active").data('lib'));
            $('#vals, #valEdit, #valDelete').text($("#active").data('lib'));
            $('.nav-link').on('click', function() {
                $('#type').val($(this).data('lib'));
                $('#vals, #valEdit, #valDelete').text($(this).data('lib'));
            });


            $('.getEdit').on('click', function() {
                $('#libEdit').val($(this).data('lib'));
                $('#montant').val(formatVal($(this).data('amount')));
                $('#id').val($(this).data('id'));
            });


            $('.getDelet').on('click', function() {
                $('#delete').text($(this).data('zone'));
                $('#libDelete').text($(this).data('lib'));
                $('#idDelete').val($(this).data('id'));
            });


            function formatVal($val){
                return $val.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ' ');
            }
        })
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/educasnsa/public_html/neuroschool/resources/views/pages/transport/index.blade.php ENDPATH**/ ?>