<?php $__env->startSection('title','payement'); ?>
<?php $__env->startSection('link'); ?>
    <!-- Data Table Css -->
    <link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/css/buttons.dataTables.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/extensions/autofill/css/autoFill.dataTables.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/extensions/autofill/css/select.dataTables.min.css')); ?>">
    <style>
        .dataTables_length label{
            display: none;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="pcoded-inner-content">
    <?php echo $__env->make('includes._alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header mb-0 pb-0">
                                <div class="d-flex justify-content-between pb-0">
                                    <h4>Détail Payement</h4>
                                    <span>
                                        <a href="<?php echo e(route('payment.index')); ?>" class="btn btn-inverse btn-outline-inverse  btn-sm py-1" title="Return Back"><i class="fas fa-reply mx-0"></i></a>
                                    </span> 
                                </div>
                                <hr class="mb-1 my-0">
                                <div class="row mb-0 mt-2 pb-0">
                                    <div class="col-md-6 col-lg-3">
                                        <div class="card widget-statstic-card">
                                            <div class="card-header py-2">
                                                <div class="card-header-left">
                                                    <u style="font-size: 17px">Scolarité</u>
                                                    <p class="p-t-10 m-b-0">Montant Total à present</p>
                                                </div>
                                            </div>
                                            <div class="card-block">
                                                <i class="fas fa-sliders-h st-icon" style="background: #4d4d4d"></i>
                                                <div class="text-left">
                                                    <h4 class="d-inline-block" style="font-size: 17px"><?php echo e(formatMontant($payerScolarity) ?? '00'); ?> FR</h4>
                                                    <i class="fas <?php echo e($scolarity >= 60 ? 'fa-arrow-up':'fa-arrow-down'); ?>  f-10" style="color: <?php echo e($scolarity >= 60 ? 'rgb(41, 173, 41)':'red'); ?>"></i>
                                                    <span class="f-right text-white px-2 py-0" style="background: #2a2d31"><?php echo e($scolarity ?? '00'); ?>%</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6 col-lg-3 my-0">
                                        <div class="card widget-statstic-card my-0">
                                            <div class="card-header py-2">
                                                <div class="card-header-left">
                                                    <u style="font-size: 17px">Frais Annexe</u>
                                                    <p class="p-t-10 m-b-0">Montant Total à present</p>
                                                </div>
                                            </div>
                                            <div class="card-block">
                                                <i class="fas fa-sliders-h st-icon" style="background: #4d4d4d"></i>
                                                <div class="text-left">
                                                    <h4 class="d-inline-block" style="font-size: 17px"><?php echo e(formatMontant($payerFeeAnnex) ?? '00'); ?> FR</h4>
                                                    <i class="fas <?php echo e($annexFee >= 60 ? 'fa-arrow-up':'fa-arrow-down'); ?>  f-10" style="color: <?php echo e($annexFee >= 60 ? 'rgb(41, 173, 41)':'red'); ?>"></i>
                                                    <span class="f-right text-white px-2 py-0" style="background: #2a2d31"><?php echo e($annexFee ?? '00'); ?>%</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php if(VerifyBox(auth()->user()->school->setting, 'transport')): ?>
                                    <div class="col-md-6 col-lg-3 my-0">
                                        <div class="card widget-statstic-card my-0">
                                            <div class="card-header py-2">
                                                <div class="card-header-left">
                                                    <u style="font-size: 17px">Bus</u>
                                                    <p class="p-t-10 m-b-0">Montant Total à present</p>
                                                </div>
                                            </div>
                                            <div class="card-block">
                                                <i class="fas fa-sliders-h st-icon" style="background: #4d4d4d"></i>
                                                <div class="text-left">
                                                    <h4 class="d-inline-block" style="font-size: 17px"><?php echo e(formatMontant($transport) ?? '00'); ?> Fr</h4>
                                                    <i class="fas fa-arrow-left f-10" style="color: rgb(38, 147, 219)"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endif; ?>
                                    <?php if(VerifyBox(auth()->user()->school->setting, 'canteen')): ?>
                                    <div class="col-md-6 col-lg-3 my-0">
                                        <div class="card widget-statstic-card my-0">
                                            <div class="card-header py-2">
                                                <div class="card-header-left">
                                                    <u style="font-size: 17px">Cantine</u>
                                                    <p class="p-t-10 m-b-0">Montant Total à present</p>
                                                </div>
                                            </div>
                                            <div class="card-block">
                                                <i class="fas fa-sliders-h st-icon" style="background: #4d4d4d"></i>
                                                <div class="text-left">
                                                    <h4 class="d-inline-block" style="font-size: 17px"><?php echo e(formatMontant($canteen) ?? '00'); ?> FR</h4>
                                                    <i class="fas fa-arrow-left f-10" style="color: rgb(38, 147, 219)"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="card-block pt-0 mx-3">
                                <div class="dt-responsive table-responsive">
                                    <ul class="nav nav-tabs md-tabs mx-3" role="tablist">
                                        <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="nav-item" style="width: 18%">
                                            <a class="nav-link text-left <?php echo e(session('lib') ? (session('lib') == $item['libelle'] ? 'active':'' ):($item['nbre'] == 1 ? 'active':'')); ?> menuStep" id="<?php echo e(session('lib') ? (session('lib') == $item['libelle'] ? 'active':'' ):($item['nbre'] == 1 ? 'active':'')); ?>" data-lib="<?php echo e($item['libelle']); ?>" data-toggle="tab" href="#home<?php echo e($item['nbre']); ?>" role="tab" aria-selected="true">
                                                <i class="icofont icofont-home"></i><?php echo e(ucfirst(changeVal($item['libelle']))); ?> [<?php echo e(count($item['data']) <= 9 ? '0'.count($item['data']):count($item['data'])); ?>]
                                            </a>
                                            <div class="slide" style="width: 16%"></div>
                                        </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                    <!-- Tab panes -->
                                    <div class="tab-content card-block">
                                        <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="tab-pane <?php echo e(session('lib') ? (session('lib') == $item['libelle'] ? 'active':'' ):($item['nbre'] == 1 ? 'active':'')); ?>" id="home<?php echo e($item['nbre']); ?>" role="tabpanel">
                                            <table id="<?php echo e($item['tab']); ?>" class="table table-striped table-bordered nowrap">
                                                <thead>
                                                    <tr>
                                                        <th class="text-center"></th>
                                                        <th class="text-center">Level</th>
                                                        <th class="text-center">Scolarités</th>
                                                        <th class="text-center">Frais Annexe</th>
                                                        <?php if(VerifyBox(auth()->user()->school->setting, 'transport')): ?>
                                                        <th class="text-center">Bus</th>
                                                        <?php endif; ?>
                                                        <?php if(VerifyBox(auth()->user()->school->setting, 'canteen')): ?>
                                                        <th class="text-center">Cantine</th>
                                                        <?php endif; ?>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $i = 1; ?>
                                                    <?php $__currentLoopData = $item['data']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr class="py-0">
                                                        <th class="text-center"><?php echo e($i <= 9 ? '0'.$i++:$i++); ?></th>
                                                        <th class="ml-2 py-4"><?php echo e($val['libelle']); ?> [<?php echo e($val['effectif'] <= 9 ? '0'.$val['effectif']:$val['effectif']); ?>]</th>
                                                        <td class="my-0 py-0 text-center">
                                                            <p class="my-1">
                                                                <i class="fas fa-caret-up text-success"></i> <b title="Payé"><?php echo e(formatMontant($val['payerS']) ?? '00'); ?></b> FR CFA ||
                                                                <i class="fas fas fa-caret-down text-danger"></i> <b title="A payer"><?php echo e(CalculResteAmount($val['totalS'], $val['payerS']) ?? '00'); ?></b> FR CFA
                                                            </p>
                                                            <p class="my-1"><i class="fas fas fa-caret-right text-info"></i> <b title="Total"><?php echo e(formatMontant($val['totalS']) ?? '00'); ?></b> FR CFA</p>
                                                        </td>
                                                        <td class="my-0 py-0 text-center">
                                                            <p class="my-1">
                                                                <i class="fas fa-caret-up text-success"></i> <b title="Payé"><?php echo e(formatMontant($val['payerF']) ?? '00'); ?></b> FR CFA ||
                                                                <i class="fas fas fa-caret-down text-danger"></i> <b title="A payer"><?php echo e(CalculResteAmount($val['totalF'], $val['payerF']) ?? '00'); ?></b> FR CFA
                                                            </p>
                                                            <p class="my-1"><i class="fas fas fa-caret-right text-info"></i> <b title="Total"><?php echo e(formatMontant($val['totalF']) ?? '00'); ?></b> FR CFA</p>
                                                        </td>
                                                        <?php if(VerifyBox(auth()->user()->school->setting, 'transport')): ?>
                                                        <td class="text-center my-0 py-4"><b title="Total payé"><?php echo e(formatMontant($val['transport']) ?? '00'); ?></b> FR CFA</td>
                                                        <?php endif; ?>
                                                        <?php if(VerifyBox(auth()->user()->school->setting, 'canteen')): ?>
                                                        <td class="text-center my-0 py-4"><b title="Total payé"><?php echo e(formatMontant($val['canteen']) ?? '00'); ?></b> FR CFA</td>
                                                        <?php endif; ?>
                                                    </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                            </table>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div> 
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- @Modal -->

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <!-- data-table js -->
    <script src="<?php echo e(asset('bower_components/datatables.net/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')); ?>"></script>
    <!-- Custom js -->
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/colreorder/js/colreorder-custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pcoded.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vartical-layout.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.mCustomScrollbar.concat.min.js')); ?>"></script>
    <script>
        $(document).ready(function(){
      

        })
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/educasnsa/public_html/neuroschool/resources/views/pages/payment/show.blade.php ENDPATH**/ ?>