<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="description" content="Educas est une application de gestion d'ecole dans son ensemble">
    <meta name="author" content="Jean-Marius Yao">
    <title>Liste des notes <?php echo e(($matter->matter->abbreviated ?? $matter->matter->libelle)); ?> <?php echo e($class->libelle); ?></title>
</head>
<style>
    @page {
        margin: 1cm 0.5cm 1cm 0.5cm; /* haut droite bas gauche */
    }
    
    body {
        font-size: .875em;
        overflow-x: hidden;
        color: #353c4e;
        font-family: "Open Sans", sans-serif;
    }

    /* applies border to the table */
    #tabled,th,td {
        border: 1px solid #dee2e6;
        padding: 10px;
        text-align: center
    }

    #tabled {
        width: 100%;
        border: 1px solid #dee2e6;
        border-collapse: collapse;
        table-layout: auto;
        border-spacing: 2px;
    }

    th, td {
        white-space: nowrap;
    }
</style>
<body>
    <header style="margin: 5px auto; border-bottom: 1px solid #dee2e6; height: 100px; padding-bottom: 15px">
        <div style="display: flex; flex-direction: row; justify-content: space-between;">
            <table style="width: 100%">
                <tbody>
                    <tr style="margin-bottom: 0%">
                        <td style="width: 50%; border:none">
                            <div style="text-align: center; font-size: 8px">Ministère de l'Education Nationale, de l'Enseignement <br> Technique et de la   Formation Professionnelle</div>
                        </td>
                        <td style="width: 50%; border:none">
                            <div style="text-align: center; font-size: 8px;">
                                <b >REPUBLIQUEDE COTE D'IVOIRE</b><br>
                                <i>Union - Discipline - Travail</i>
                            </div>
                        </td>
                    </tr>
                    <tr style="margin-bottom: 0%">
                        <td style="width: 40%; border:none">
                            <img src="<?php echo e(public_path($school->logoUrl())); ?>" class="m-b-10 w-100" alt="Logo établissement" style="height: 55px;">
                        </td>
                        <td style="width: 60%; border:none">
                            <div style="text-align: center">
                                <div style="text-align: center;">
                                    <b style="font-size: 15px;"><?php echo e(mb_strtoupper($school->school->name_school)); ?></b><br>
                                    <i style="font-size: 9px"><?php echo e($school->address_email); ?> / <?php echo e($school->phon_school); ?></i><br>
                                    <i style="font-size: 11px;">Année Scolaire : <b><?php echo e($class->schoolYear->school_year); ?></i>
                                </div>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </header>
    
    <section style="margin: 5px auto;">
        <div style="margin-top: 20px">
            <div style="margin-top: 35px; text-align: center; font-size:21px; text-decoration: underline;">
                <b>LISTE NOTES <?php echo e(strtoupper($decoup->cutting->libelle)); ?> <?php echo e(strtoupper($matter->matter->abbreviated ?? $matter->matter->libelle)); ?> <?php echo e($class->libelle); ?></b>
            </div>
            <table id="tabled" style="margin-top: 25px">
                <thead>
                    <tr>
                        <th style="width: 5px; text-align: center">N°</th>
                        <th class="text-uppercase" style="width: 100px">Nom et prénoms</th>
                        
                        <th class="text-uppercase" style="width: 20px">Matricule</th>
                        <?php for($i = 0; $i < $nbres; $i++): ?>
                        <th class="text-center text-uppercase" style="width: 30px">N<?php echo e($i+1); ?></th>
                        <?php endfor; ?>
                        <th class="text-uppercase text-center" style="width: 15p">Moyenne</th>
                        <th class="text-uppercase text-center" style="width: 5%">Rang</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $j = 1 ?>
                    <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <th class="text-center py-2">
                            <div class="mt-2"><?php echo e($j <= 9 ? '0'.$j++:$j++); ?></div>
                        </th>
                        <td class="py-2" style="text-align:left">
                            <div class="mt-2"><?php echo e($item['name']); ?></div>
                        </td>
                        
                        <td class="py-2" style="text-align:left">
                            <div class="mt-2"><?php echo e($item['matricule']); ?></div>
                        </td>
                        <?php for($i = 0; $i < $nbres; $i++): ?>
                        <td class="text-center p-0">
                            <div class="mt-2"><?php echo e($item['notes'][$i]['note'] ?? 'nc'); ?></div>
                        </td>
                        <?php endfor; ?>
                        <th class="py-2 text-center">
                            <div class="mt-2"><?php echo e($item['moyen'] ? $item['moyen']['moyenne']:calculMoyenneMatter($item['notes'])); ?></div>
                        </th>
                        <td class="py-2 text-center">
                            <div class="mt-2"><?php echo e($item['moyen'] ? $item['moyen']['rang']:'--'); ?></div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </section>
</body>
</html><?php /**PATH /home/educasnsa/public_html/neuroschool/resources/views/pdf/list_note.blade.php ENDPATH**/ ?>