<?php $__env->startSection('title', 'Gestion des appels'); ?>
<?php $__env->startSection('link'); ?>
<!-- Data Table Css -->
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/css/buttons.dataTables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')); ?>">
<style>
    .btn.btn-icons {
        border-radius: 50%;
        width: 30px;
        line-height: 20px;
        height: 30px;
        padding: 3px;
        text-align: center;
    }
    .dataTables_length label{
        display: none;
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="pcoded-inner-content">
    <?php echo $__env->make('includes._alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header mb-0 pb-0">
                                <div class="d-flex justify-content-between pb-0">
                                    <h4>Cantine</h4>
                                    <span>
                                        <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-toggle="modal" data-target="#addModal" title="Add New scolarity Fee"><i class="fas fa-exchange-alt m-0"></i></button>
                                        <a href="#" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" title="Menu Canteen"><i class="fas fa-project-diagram m-0"></i></a>
                                    </span>                                
                                </div>
                            </div>
                            <hr class="my-0 mx-3">
                            <div class="card-block">
                                <div class="dt-responsive table-responsive">
                                    <table id="realtime-reorder" class="table table-striped table-bordered nowrap">
                                        <thead>
                                            <tr>
                                                <th class="text-center">N°</th>
                                                <th class="text-center">Libelle</th>
                                                <th class="text-center">Montant</th>
                                                <th class="text-center" style="width: 20%">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $i = 1; ?>
                                            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <th class="text-center"><?php echo e($i <= 9 ? '0'.$i++:$i++); ?></th>
                                                <td><?php echo e(typeCenserneCanteen($item->primaire, $item->secondaire, $item->technique, $item->superieur)); ?></td>
                                                <td class="text-center"><?php echo e(formatMontant($item->amount->montant)); ?> FR CFA</td>
                                                <td style="width: 20%" class="py-0">
                                                    <div class="card-block remove-label m-0 py-2 text-center">
                                                        <button class="getDelet btn btn-inverse btn-outline-inverse btn-icons" title="Delete" data-id="<?php echo e($item->id); ?>" data-amount="<?php echo e($item->amount->montant); ?>" data-toggle="modal" data-target="#deleteModal"><i class="far fa-trash-alt"></i></button>
                                                    </div>
                                                </td>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- @Modal Add -->
<div class="modal fade" id="addModal" tabindex="-1" role="dialog" aria-labelledby="addModalTitle" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
        <div class="modal-header bg-dark py-2">
            <h5 class="modal-title" id="addModalLongTitle">Canteen Prices</h5>
            <span style="font-size: 17px" id="vals"><?php echo e($year['school_year']); ?></span>
        </div>
        <form action="<?php echo e(route('canteen.store')); ?>" method="post">
            <?php echo csrf_field(); ?>
            <div class="modal-body py-3">
                <input type="hidden" name="year" value="<?php echo e($year['id']); ?>">
               <div class="form-group pt-2">
                    <label for="amount" class="form-label">Montant par mois<span class="text-danger">*</span> :</label>
                    <input type="text" id="amount" name="amount" class="form-control" placeholder="Entrez le montant ..." required>
                </div>

                <div class="form-group pt-2">
                    <label class="form-label">Type conserné :</label><br>
                     <?php $__currentLoopData = $valeurs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <span class="mx-2">
                        <input type="checkbox" name="type[]" id="<?php echo e(changeVal($item['libelle'])); ?>" value="<?php echo e(changeVal($item['libelle']) == 'supérieur' ? 'superieur':changeVal($item['libelle'])); ?>" checked>
                        <label for="<?php echo e(changeVal($item['libelle'])); ?>" class="form-label"><?php echo e(ucwords(changeVal($item['libelle']))); ?></label>
                    </span>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

            </div>
            <div class="modal-footer">
                <a href="#" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</a>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
    </div>
  </div>
</div>
<!-- @Modal Add -->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalTitle" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
        <div class="modal-header bg-dark py-2">
            <h5 class="modal-title" id="deleteModalLongTitle">Delete Price</h5>
            <span style="font-size: 17px" id="valDelete"></span>
        </div>
        <form action="<?php echo e(route('canteen.destroy')); ?>" method="post">
            <?php echo csrf_field(); ?>
            <div class="modal-body py-3 text-center">
                <strong id="delete"></strong> FR CFA
                <p>Confirmez le supression.</p>
                <input type="hidden" id="idDelete" name="id">
            </div>
            <div class="modal-footer">
                <a href="#" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</a>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <!-- data-table js -->
    <script src="<?php echo e(asset('bower_components/datatables.net/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')); ?>"></script>
    <!-- Custom js -->
    <!-- Select2 JS -->
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/colreorder/js/colreorder-custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pcoded.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vartical-layout.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.mCustomScrollbar.concat.min.js')); ?>"></script>
    <script>
        $(document).ready(function(){

            $('#amount').on('input', function () {
                let value = $(this).val().replace(/\s/g, '');
                value = value.replace(/\D/g, '');
                let formatted = value.replace(/\B(?=(\d{3})+(?!\d))/g, ' ');
                $(this).val(formatted);
            });


            $('.getDelet').on('click', function() {
                $('#delete').text(formatVal($(this).data('amount')));
                $('#idDelete').val($(this).data('id'));
            });


            function formatVal($val){
                return $val.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ' ');
            }
        })
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/educasnsa/public_html/neuroschool/resources/views/pages/canteen/index.blade.php ENDPATH**/ ?>