<?php $__env->startSection('title', 'Dashboard'); ?>
<?php $__env->startSection('link'); ?>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/component.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/css/buttons.dataTables.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/extensions/autofill/css/autoFill.dataTables.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/extensions/autofill/css/select.dataTables.min.css')); ?>">
    <style>
        .dataTables_length{
            display: none;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="pcoded-inner-content">
    <?php echo $__env->make('includes._alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        
                        <?php if(auth()->user()->role->role === 'superAdmin'): ?> 
                        <div class="card">
                            <div class="card-header pb-0">
                                <div class="d-flex justify-content-between pb-2">
                                    <h4>Etablissements Disponibles - <?php echo e(count($schools) <= 9 ? '0'.count($schools):count($schools)); ?></h4>
                                    <span>
                                        <a href="<?php echo e(route('school.create')); ?>" class="btn btn-inverse btn-outline-inverse  btn-sm mx-1 py-1" title="Add School"><i class="fas fa-plus mx-0"></i></a>
                                        <a href="<?php echo e(route('school.index')); ?>" class="btn btn-inverse btn-outline-inverse  btn-sm mx-1 py-1" title="Disabled School"> <i class="fas fa-underline m-0"></i></a>
                                    </span>
                                </div>
                            </div>
                            <hr class="my-0 mx-3">
                            <div class="card-block tab-content">
                                <div class="table-responsive dt-responsive">
                                    <table id="autofill" class="table table-striped table-bordered nowrap" style="width:100%">
                                        <thead>
                                            <tr>
                                                <th class="text-center" style="width: 5%">N°</th>
                                                <th style="width: 35%">Etablissement</th>
                                                <th style="width: 20%">Numéro Autorisation</th>
                                                <th style="width: 20%">Code Etablissement</th>
                                                <th class="text-center" style="width: 20%">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $i = 1 ?>
                                            <?php $__currentLoopData = $schools; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $school): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <th class="text-center"><?php echo e($i <= 9 ? '0'.$i++:$i++); ?></th>
                                                <td><?php echo e(ucfirst($school->name_school)); ?></td>
                                                <td><?php echo e(ucfirst($school->num_autorisation)); ?></td>
                                                <td><?php echo e(ucfirst($school->code_school)); ?></td>
                                                <td class="py-1">
                                                    <div class="card-block remove-label m-0 p-0 text-center">
                                                        <a href="<?php echo e(route('school.edit',$school->id)); ?>" class="btn btn-sm btn-info text-center px-2"><i class="far fa-edit"></i></a>
                                                        
                                                    </div>
                                                </td>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                                                    
                        <?php else: ?>
                            <div class="page-body">
                                <div class="row">
                                    <!--  -->
                                    <?php $__empty_1 = true; $__currentLoopData = $effetifs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <div class="col-md-6 col-xl-3">
                                            <div class="card widget-card-1">
                                                <div class="card-block-small">
                                                    <i class="fas fa-chart-pie bg-c-blue card1-icon"></i>
                                                    <span class="text-c-blue f-w-600">Effectif</span>
                                                    <h5><?php echo e(preg_replace('/\B(?=(\d{3})+(?!\d))/', ' ', ($val['effectif'] <= 9 ? '0'.$val['effectif']:$val['effectif']))); ?></h5>
                                                    <div>
                                                        <span class="f-left m-t-10 text-muted">
                                                            <i class="text-c-blue f-16 fa fa-home m-r-10"></i> <?php echo e(ucwords(changeVal($val['libelle']))); ?>

                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <div class="col-12 text-center">
                                            <div class="card" style="width: 50%; margin: 1px auto">
                                                <div class="card-body">
                                                    <h4>Faites les parametrages pour commencer</h4>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Modal -->
<?php echo $__env->make('includes._modal_simple', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <!-- data-table js -->
    <script src="<?php echo e(asset('bower_components/datatables.net/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/dataTables.select.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')); ?>"></script>    

    <script src="<?php echo e(asset('assets/js/modalEffects.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/classie.js')); ?>"></script>

    <script src="<?php echo e(asset('bower_components/chart.js/dist/Chart.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/widget/amchart/amcharts.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/widget/amchart/serial.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/widget/amchart/light.js')); ?>"></script>
    <!-- Custom js -->
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/extensions-custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/SmoothScroll.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pcoded.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.mCustomScrollbar.concat.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vartical-layout.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/dashboard/analytic-dashboard.min.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/educasnsa/public_html/neuroschool/resources/views/dashboard.blade.php ENDPATH**/ ?>