<?php $__env->startSection('title', 'Gestion des classes'); ?>
<?php $__env->startSection('link'); ?>
<!-- Data Table Css -->
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/css/buttons.dataTables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')); ?>">
<style>
    .btn.btn-icons {
        border-radius: 50%;
        width: 30px;
        line-height: 20px;
        height: 30px;
        padding: 3px;
        text-align: center;
    }
    .dataTables_length label{
        display: none;
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="pcoded-inner-content">
    <?php echo $__env->make('includes._alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header mb-0 pb-0">
                                <div class="d-flex justify-content-between mb-0 pb-0">
                                    <h4>Liste de classe</h4>
                                    <strong style="font-size: 17px"><?php echo e($classe['libelle']); ?> [Effectif : <?php echo e(count($data) <= 9 ? '0'.count($data):count($data)); ?>]</strong>
                                    <div class="right">
                                        <span style="float: right">
                                            <?php if(in_array($classe['type'], ['secondaire', 'technique'])): ?>
                                                <a href="<?php echo e(route('conduite.index',$classe['id'])); ?>" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mr-2" title="Generate Conduite"><i class="fas fa-align-center m-0"></i></a>
                                            <?php endif; ?>
                                            <a href="<?php echo e(route('sanction.index')); ?>" class="btn btn-inverse btn-outline-inverse btn-sm py-1" title="Return Back"><i class="fas fa-reply mx-0"></i></a>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <hr class="mx-3 mt-0">
                            <div class="card-block">
                                <div class="dt-responsive table-responsive">
                                    <table id="simpletable"
                                        class="table table-striped table-bordered nowrap">
                                        <thead>
                                            <tr>
                                                <th style="width: 5%"></th>
                                                <th style="width: 10%">Matricule</th>
                                                <th style="width: 22%">Nom et Prenoms</th>
                                                <th style="width: 12%">Genre</th>
                                                <th style="width: 12%">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <th class="text-center py-1">
                                                    <img src="<?php echo e(asset($item['sexe'] == 'F' ? 'assets/images/stdt1_woman.png':'assets/images/stdt1_man.png')); ?>" class="img-radius m-0 p-0" alt="Photo Stuedent" style="height: 40px; width: 40px; border: 1px solid grey">
                                                </th>
                                                <td><?php echo e($item['matricule']); ?></td>
                                                <td><?php echo e(mb_strtoupper($item['first_name']).' '.ucfirst($item['last_name'])); ?></td>
                                                <td><?php echo e(ucfirst($item['sexe'] == 'F' ? 'Féminin':'Masculin')); ?></td>
                                                <td class="py-0">
                                                    <div class="card-block remove-label m-0 py-2 text-center">
                                                        <a href="<?php echo e(route('sanction.create', $item['id'])); ?>" class="btn btn-inverse btn-outline-inverse btn-icons" title="Détail sanctions"><i class="fas fa-align-left m-0"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <!-- data-table js -->
    <script src="<?php echo e(asset('bower_components/datatables.net/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')); ?>"></script>
    <!-- Custom js -->
    <script src="<?php echo e(asset('assets/pages/data-table/js/data-table-custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pcoded.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vartical-layout.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.mCustomScrollbar.concat.min.js')); ?>"></script>
    <script>
        $(document).ready(function(){
           
        })
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/educasnsa/public_html/neuroschool/resources/views/pages/sanction/detail.blade.php ENDPATH**/ ?>