<?php $__env->startSection('title', 'Add note'); ?>
<?php $__env->startSection('link'); ?>
<!-- Data Table Css -->
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/css/buttons.dataTables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')); ?>">
<style>
    .dataTables_length label{
        display: none;
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="pcoded-inner-content">
    <?php echo $__env->make('includes._alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <form action="<?php echo e(route('evaluation.bonnus_update', $string)); ?>" method="post" id="myForm">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('put'); ?>
                            <div class="card">
                                <div class="card-header mb-0 pb-0">
                                    <div class="d-flex justify-content-between mb-0 pb-0">
                                        <h4>Bonnus - <strong style="font-size: 19px"><?php echo e(ucfirst($class->libelle)); ?></strong></h4>
                                        <span class="form-control-variant" style="font-size: 17px">
                                            <strong class="mr-2"><?php echo e(ucfirst($decoup->cutting->libelle.' [ '.($matter->matter->abbreviated ?? $matter->matter->libelle).' ]')); ?></strong>
                                        </span>
                                        <span>
                                            <button id="btnValids" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-1" title="Valider" data-toggle="modal" data-target="#validModal"><i class="fas fa-check mx-0"></i></button>
                                            <a href="<?php echo e(route('evaluation.list', $string)); ?>" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 ml-1" title="Return Back"><i class="fas fa-reply mx-0"></i></a>
                                        </span>
                                    </div>
                                </div>
                                <hr class="mx-3 mt-0">
                                <div class="card-block">
                                    <div class="dt-responsive table-responsive px-lg-3">
                                        <table id="saving-reorder" class="table table-bordered">
                                            <thead>
                                                <tr>
                                                    <th class="text-center" style="width: 6%"></th>
                                                    <th class="text-uppercase text-center" style="width: 20px">Matricule</th>
                                                    <th class="text-uppercase" style="width: 80px">Nom et prénoms</th>
                                                    <th class="text-uppercase text-center" style="width: 10px">sexe</th>
                                                    <th class="text-center text-uppercase" style="width: 30px">Moyenne</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $i = 1; ?>
                                                <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr class="py-0">
                                                    <th class="text-center py-1">
                                                        <img src="<?php echo e(asset($item['sexe'] == 'F' ? 'assets/images/stdt1_woman.png':'assets/images/stdt1_man.png')); ?>" class="img-radius m-0 p-0" alt="Photo Stuedent" style="height: 40px; width: 40px; border: 1px solid grey">
                                                        <?php $i++; ?>
                                                    </th>
                                                    <td class="py-2 text-center"><div class="mt-2"><?php echo e($item['matricule']); ?></div></td>
                                                    <td class="py-2" title="<?php echo e($item['name']); ?>">
                                                        <div class="mt-2"><?php echo e(Str::limit($item['name'], '27', '...')); ?></div>
                                                    </td>
                                                    <td class="py-2 text-center"><div class="mt-2"><?php echo e(ucfirst($item['sexe'] == 'F' ? 'Féminin':'Masculin')); ?></div></td>
                                                    <td class="text-center p-0">
                                                        <span class="d-flex m-0 pb-0 px-0 pt-2">
                                                            <input type="hidden" name="student[]" id="student_<?php echo e($i-1); ?>" value="<?php echo e($item['id'].'_'.$item['sexe']); ?>">
                                                            <input type="text" name="moyen[]" id="moyen_<?php echo e($i-1); ?>" class="form-control m-0 text-center myInput" value="<?php echo e($item['moyen']['moyenne']); ?>" maxlength="5" style="width: 50%; font-weight: 900; border: 1px #000 dashed">
                                                            <strong class="mx-0 mt-2" style="font-size: 17px; font-weight: 700;">/ 20</strong>
                                                        </span>
                                                    </td>
                                                </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Modal Delete Evaluation-->
<div class="modal fade" id="validModal" tabindex="-1" role="dialog" aria-labelledby="validModalTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header bg-dark py-2">
                <h5 class="modal-title" id="validModalLongTitle">Confirmed</h5>
                <h5 style="font-style: 17px"><?php echo e(ucfirst($decoup->cutting->libelle)); ?></h5>
            </div>
            <div class="modal-body py-3 text-center">
                <strong style="font-size: 16px">Bonnus Moyenne </br> <?php echo e($matter->matter->libelle); ?></strong>
                <p class="text-center">Voulez-vous vraiment Valider ?</p>
            </div>
            <div class="modal-footer mt-1">
                <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</button>
                <button type="submit" id="submit1" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <!-- data-table js -->
    <script src="<?php echo e(asset('bower_components/datatables.net/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')); ?>"></script>
    <!-- Custom js -->
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/colreorder/js/colreorder-custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pcoded.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vartical-layout.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.mCustomScrollbar.concat.min.js')); ?>"></script>
    <script>
        $(document).ready(function(){
            let table = $('#saving-reorder').DataTable();

            $('.myInput').keyup(function() {
                if($(this).val() > 20){
                    $(this).val(null);
                }
            });

            // Autoriser les touches numériques (0-9) et la touche backspace (code 8)
            $('.myInput').on('keypress', function(e) {
                var key = e.which || e.keyCode;
                if ((key >= 48 && key <= 57) || key === 8 || key === 46 || key === 127) {
                    return true;
                } else {
                    e.preventDefault();
                }
            });


            $('#btnValids').on('click', function(e) {
                e.preventDefault(); // Empêche l'envoi par défaut
            });

            $('#submit1').click(function(){
                // Rendre tous les éléments visibles temporairement pour que les champs soient inclus dans le formulaire
                table.rows().every(function(rowIdx, tableLoop, rowLoop) {
                    var row = this.node();
                    if (!$(row).is(':visible')) {
                        $(row).find('input, select, textarea').each(function() {
                            var name = $(this).attr('name');
                            var value = $(this).val();
                            $('<input>').attr({
                                type: 'hidden',
                                name: name,
                                value: value
                            }).appendTo('#myForm');
                        });
                    }
                });

                // Soumet le formulaire
                $('#myForm').submit();
            })

        })
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/educasnsa/public_html/neuroschool/resources/views/pages/evaluations/bonnus.blade.php ENDPATH**/ ?>