<?php $__env->startSection('title', 'Gestion des appels'); ?>
<?php $__env->startSection('link'); ?>
<!-- Data Table Css -->
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/css/buttons.dataTables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')); ?>">
<style>
    .btn.btn-icons {
        border-radius: 50%;
        width: 30px;
        line-height: 20px;
        height: 30px;
        padding: 3px;
        text-align: center;
    }
    .dataTables_length label{
        display: none;
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="pcoded-inner-content">
    <?php echo $__env->make('includes._alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header mb-0 pb-0">
                                <div class="d-flex justify-content-between pb-0 mb-0">
                                    <h4>Détail des Appels</h4>
                                    <div class="text-center text-muted" style="font-size: 17px"><?php echo e($class['libelle']); ?> - <?php echo e('semaine '.($weekNumber <= 9 ? '0'.$weekNumber:$weekNumber)); ?></div>
                                    <span>
                                        <button class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mx-3" id="getAdd" title="Nouvel Appel" data-toggle="modal" data-target="#addAppelModal"><i class="fas fa-plus m-0"></i></button>
                                        <a href="<?php echo e(route('appel.index')); ?>" class="btn btn-inverse btn-outline-inverse  btn-sm py-1" title="Return Back"><i class="fas fa-reply mx-0"></i></a>
                                    </span>
                                    <input type="hidden" id="weeks" value="<?php echo e($weekNumber); ?>">
                                </div>
                            </div>
                            <hr class="mx-3 my-0">
                            <div class="card-block">
                                <div class="dt-responsive table-responsive">
                                    <!-- Tab panes -->
                                    <div class="tab-content card-block">
                                        <table id="realtime-reorder" class="table table-striped table-bordered nowrap">
                                            <thead>
                                                <tr>
                                                    <th class="text-center" style="width: 5%"></th>
                                                    <th class="text-center" style="width: 10%">Matricule</th>
                                                    <th class="text-center" style="width: 35%">Nom & Prenoms</th>
                                                    <th class="text-center" style="width: 12%">Sexe</th>
                                                    <th class="text-center" style="width: 10%">Matin</th>
                                                    <th class="text-center" style="width: 10%">Après midi</th>
                                                    <th class="text-center">Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <th class="text-center py-1">
                                                        <img src="<?php echo e(asset($item['sexe'] == 'F' ? 'assets/images/stdt1_woman.png':'assets/images/stdt1_man.png')); ?>" class="img-radius m-0 p-0" alt="Photo Stuedent" style="height: 40px; width: 40px; border: 1px solid grey">
                                                    </th>
                                                    <td class="text-center"><?php echo e($item['matricule']); ?></td>
                                                    <td class="text-left"><?php echo e(Str::limit($item['name'], '27', '...')); ?></td>
                                                    <td class="text-center"><?php echo e(ucfirst($item['sexe'] == 'F' ? 'Féminin':'Masculin')); ?></td>
                                                    <td class="text-center"><?php echo e($item['nbre_mtn'] <= 9 ? '0'.$item['nbre_mtn']:$item['nbre_mtn']); ?>Jrs</td>
                                                    <td class="text-center"><?php echo e($item['nbre_midi'] <= 9 ? '0'.$item['nbre_midi']:$item['nbre_midi']); ?>Jrs</td>
                                                    <td style="width: 15%" class="py-0">
                                                        <div class="card-block remove-label m-0 py-2 text-center">
                                                            <button type="button" class="btn btn-inverse btn-outline-inverse btn-icons" data-id="<?php echo e($item['id']); ?>" data-toggle="modal" data-target="#listModal"><i class="fas fa-align-justify m-0"></i></button>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div> 
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Modal Add New Appel -->
<div class="modal fade" id="addAppelModal" tabindex="-1" role="dialog" aria-labelledby="addAppelModalTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header bg-dark py-2">
          <h5 class="modal-title" id="addAppelModalLongTitle">Nouvel Appel</h5>
        </div>
        <form action="<?php echo e(route('appel.primary_create',$class->id)); ?>" method="post">
            <?php echo csrf_field(); ?>
            <?php echo method_field('get'); ?>
            <input type="hidden" name="weeks" value="<?php echo e($weekNumber); ?>">
            <input type="hidden" name="classed" value="<?php echo e($class->id); ?>">
            <div class="modal-body">
                <div class="m-b-30 mt-3">
                    <label for="date">Date d'appel<span class="text-danger">*</span> : </label>
                    <input type="date" name="date" class="form-control" id="date">
                </div>

                <div class="m-b-30 mt-3">
                    
                    <span class="mx-3">
                        <input type="radio" name="period" id="monning" value="1">
                        <label for="monning">Matin</label>
                    </span>
                    <span class="mx-3">
                        <input type="radio" name="period" id="afternoow" value="2">
                        <label for="afternoow">Après midi</label>
                    </span>
                </div>
            </div>
            <div class="modal-footer">
                <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</button>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
      </div>
    </div>
</div>
<!-- @Modal List Absences-->
<div class="modal fade" id="listModal" tabindex="-1" role="dialog" aria-labelledby="listModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
      <div class="modal-content">
        <div class="modal-header bg-dark py-2">
          <h5 class="modal-title" id="listModalLabel">Liste d'absence</h5>
          <span style="font-size: 17px"><?php echo e('Semaine '.($weekNumber <= 9 ? '0'.$weekNumber:$weekNumber)); ?></span>
        </div>
        <div class="modal-body">
          <div class="m-2" style="font-size: 17px" id="student"></div>
          <table class="table table-bordered" id="table">
            <thead>
              <tr>
                <th scope="col" class="text-center">N°</th>
                <th scope="col" class="text-center">Date d'absence</th>
                <th scope="col" class="text-center">Matin</th>
                <th scope="col" class="text-center">Après midi</th>
              </tr>
            </thead>
            <tbody>
              
            </tbody>
          </table>
        </div>
        <div class="modal-footer">
            <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</button>
        </div>
      </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <!-- data-table js -->
    <script src="<?php echo e(asset('bower_components/datatables.net/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')); ?>"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.4/moment-with-locales.min.js"></script>
    <!-- Custom js -->
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/colreorder/js/colreorder-custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pcoded.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vartical-layout.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.mCustomScrollbar.concat.min.js')); ?>"></script>
    <script>
        $(document).ready(function(){

            moment.locale('fr'); // Active la langue française

            // Date du jour
            $('#date').val(new Date().toISOString().split('T')[0]);
            $('#date').attr('max', new Date().toISOString().split('T')[0]); // Limiter la date à celle d'aujourd'hui
            let heure = new Date().getHours().toString().padStart(2, '0');
            if(heure <= 12){
                $('#monning').prop('checked', true);
            }
            else{
                $('#afternoow').prop('checked', true);
            }

            $('#realtime-reorder').on('click', '.btn-primary', function(){
                $('.addRow').remove();
                if($(this).data('id')){
                    $.ajax({
                        url: '<?php echo e(route('appel.search')); ?>',
                        method: 'GET',
                        data: {
                            student : $(this).data('id'),
                            weeks : $('#weeks').val()
                        },
                        success: function(data){
                            $('#student').text(data['student']);
                            if(data['datas'].length){
                                $i = 0;
                                while($i < data['datas'].length){
                                    $row = $i <= 9 ? '0'+($i+1):$i+1;
                                    $('#table tbody').append('<tr class="addRow">'+
                                    '<th class="text-center">'+$row+'</th>'+
                                    '<td>'+(moment(data['datas'][$i].dateAbsence)).format("dddd D MMMM YYYY")+'</td>'+
                                    '<td class="text-center">'+
                                        '<span class="pcoded-badge label label-'+(data['datas'][$i].period == 1 ? 'success':'danger')+'">'+(data['datas'][$i].period == 1 ? 'Oui':'Non')+'</span>'
                                    +'</td>'+
                                    '<td class="text-center">'+
                                        '<span class="pcoded-badge label label-'+(data['datas'][$i].period == 2 ? 'success':'danger')+'">'+(data['datas'][$i].period == 2 ? 'Oui':'Non')+'</span>'
                                    +'</td>'+
                                    '</tr>');
                                    $i++;
                                }
                            }
                            else{
                                $('#table tbody').append('<tr class="addRow">'+
                                    '<td colspan="4" class="text-center" style="font-size: 15px">'+
                                        '<span class="my-3">Pas d\'absence pour cette semaine.</span>'
                                    +'</td>'
                                +'</tr>');
                            }
                        }
                    });
                }
            })
        })
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/educasnsa/public_html/neuroschool/resources/views/pages/appels/detail_primary.blade.php ENDPATH**/ ?>