<?php $__env->startSection('title','inscriptions'); ?>
<?php $__env->startSection('link'); ?>
    <!-- Data Table Css -->
    <link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/css/buttons.dataTables.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/extensions/autofill/css/autoFill.dataTables.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/extensions/autofill/css/select.dataTables.min.css')); ?>">
    <style>
        .btn.btn-icons {
        border-radius: 50%;
        width: 30px;
        line-height: 20px;
        height: 30px;
        padding: 3px;
        text-align: center;
    }
        .dataTables_length label, .select-info{
            display: none;
        }

        .clignote {
            animation: clignoter 1s infinite;
        }
        @keyframes clignoter {
            0% { opacity: 1; }
            50% { opacity: 0; }
            100% { opacity: 1; }
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="pcoded-inner-content">
    <?php echo $__env->make('includes._alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header pb-0">
                                <div class="d-flex justify-content-between mb-0 pb-0">
                                    <h4>Inscription - [<?php echo e($inscris <= 9 ? '0'.$inscris:$inscris); ?>]</h4>
                                    <span>
                                        <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-1" data-toggle="modal" data-target="#matriculeModal" title="New Register"><i class="far fa-edit m-0"></i></button>
                                        <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-1" data-toggle="modal" data-target="#import" title="Import File"> <i class="fas fa-ellipsis-h m-0"></i></button>
                                        <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-1" data-toggle="modal" data-target="#upload" title="Export File"> <i class="fas fa-download m-0"></i></button>
                                    </span>
                                </div>
                                <hr class="mb-0 mt-0">
                                <div class="row justify-content-end">
                                    <?php $__currentLoopData = $statistics; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $statistic): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-xl-3 col-md-6">
                                        <div class="card my-0">
                                            <div class="card-footer py-2" style="background: #545557">
                                                <div class="row align-items-center">
                                                    <div class="col-12 d-flex justify-content-between">
                                                        <b class="text-white m-b-0" style="text-decoration: underline"><?php echo e(substr(ucwords($statistic['libelle']), 0, 15)); ?> :</b>
                                                        <i class="text-white m-b-0"><b><?php echo e($statistic['inscris']); ?></b></i>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                            
                            <div class="card-block pt-0">
                                <div class="dt-responsive table-responsive">
                                    <!-- Tab panes -->
                                    <div class="tab-content card-block">
                                        <div class="tab-pane active" id="home7" role="tabpanel">
                                            <table class="table table-striped table-bordered nowrap" id="myTable">
                                                <thead>
                                                    <tr>
                                                        <th class="text-center" style="width: 5%"></th>
                                                        <th class="text-center py-2" style="width: 10%">Matricule</th>
                                                        <th class="text-center" style="width: 15%">Nom</th>
                                                        <th class="text-center" style="width: 25%">Prénoms</th>
                                                        <th class="text-center" style="width: 10%">Genre</th>
                                                        <th class="text-center" style="width: 10%">Classe</th>
                                                        <th class="text-center" style="width: 10%">Date inscrit</th>
                                                        <th class="text-center" style="width: 15%">Actions</th>
                                                    </tr>
                                                </thead>
                                                <!-- Content -->
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Modal -->
<div class="modal fade" id="matriculeModal" tabindex="-1" role="dialog" aria-labelledby="matriculeModalTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header bg-dark py-2">
          <h5 class="modal-title" id="matriculeModalLongTitle">Nouvelle Inscription</h5>
        </div>
        <form action="<?php echo e(route('inscription.create')); ?>" method="post">
            <?php echo csrf_field(); ?>
            <div class="modal-body py-2">
                <div class="form-group pt-3">
                    <label for="matricule" class="form-label">Entrez le matricule de l'apprenant<span class="text-danger">*</span> :</label>
                    <input type="text" id="matricule" name="mat" class="form-control" placeholder="Entrez le matricule de l'apprenant ici ...">
                </div>
            </div>
            <div class="modal-footer">
                <a href="#" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</a>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" id="valider" data-dismiss="modal">Valider</button>
            </div>
        </form>
      </div>
    </div>
</div>
<!-- Modal Form Inscription -->
<div class="modal fade" id="formModal" tabindex="-1" role="dialog" aria-labelledby="formModalTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header bg-dark py-2 d-flex">
          <h5 class="modal-title" id="formModalLongTitle">Inscription</h5>
          <span style="font-size: 15px"><?php echo e($year->school_year); ?></span>
        </div>
        
        <form action="<?php echo e(route('inscription.store')); ?>" method="post">
            <?php echo csrf_field(); ?>
            <div class="modal-body py-3">
                <div id="dataExiste" style="display: none;">
                    <div class="row">
                        <div class="col-auto p-r-0">
                            <img src="#" id="imgStudent" class="img-radius profile-img" style="height:100px; width:100px; background:rgb(188, 188, 188)">
                        </div>
                        <div class="col">
                            <h6 class="m-b-5"><?php echo e(session('student') ? ucfirst(session('student')['first_name'].' '.session('student')['last_name']):null); ?></h6>
                            <p class="text-muted m-b-0" id="nameStudent"></p>
                            <p class="text-muted m-b-0" id="infoStudent"></p>
                            <p class="text-muted m-b-0" id="matStudent"></p>
                        </div>
                        <div class="my-2 mx-2" id="typeStud" style="display: none;">
                            <span class="text-muted">Type d'apprenant au sien de l'établissement</span><br>
                            <span class="mr-2">
                                <input type="radio" name="typeStud" id="ancient" value="1" checked> 
                                <label for="ancient" class="text-muted">Ancien</label>
                            </span>
                            <span class="mr-2">
                                <input type="radio" name="typeStud" id="new" value="0">
                                <label for="new" class="text-muted">Nouvel</label>
                            </span>
                        </div>
                    </div>
                    <hr class="mt-2">
                    
                    <div id="contentFom" style="display: none">
                        <input type="hidden" name="getType" value="" id="getType">
                        <input type="hidden" name="student" value="" id="studentId">
                        <div class="row my-2">
                            <div class="col-12 col-md-4 mb-3" id="affecter">
                                <label class="text-muted">Affecté(e)</label><br>
                                <span class="mr-2">
                                    <input type="radio" name="affecte" id="oui" value="oui" checked>
                                    <label for="oui" class="text-muted">Oui</label>
                                </span>
                                <span class="mr-2">
                                    <input type="radio" name="affecte" id="non" value="non">
                                    <label for="non" class="text-muted">Non</label>
                                </span>
                            </div>
                            <div class="col-12 col-md-4 mb-3" id="redoublant">
                                <label class="text-muted">Redoublant(e)</label><br>
                                <span class="mr-2">
                                    <input type="radio" name="redoublant" id="oui" value="oui">
                                    <label for="oui" class="text-muted">Oui</label>
                                </span>
                                <span class="mr-2">
                                    <input type="radio" name="redoublant" id="non" value="non" checked>
                                    <label for="non" class="text-muted">Non</label>
                                </span>
                            </div>
                            <div class="col-12 col-md-4 mb-3" id="boursier">
                                <label class="text-muted">Boursier(e)</label><br>
                                <span class="mr-2">
                                    <input type="radio" name="boursier" id="oui" value="oui">
                                    <label for="oui" class="text-muted">Oui</label>
                                </span>
                                <span class="mr-2">
                                    <input type="radio" name="boursier" id="non" value="non" checked>
                                    <label for="non" class="text-muted">Non</label>
                                </span>
                            </div>
                        </div>
                        <div class="form-group mb-3">
                            <label for="addLevel" class="form-label text-muted">Niveau actuel<span class="text-danger">*</span> :</label>
                            <select name="level" id="addLevel" class="form-control select2 bg-white">
                                <option value="" class="text-muted">Selection one option</option>
                            </select>    
                        </div>
                    
                        <div class="form-group mb-3" id="divSerie" style="display: none">
                            <label for="serieAdd" class="form-label text-muted"><span id="bockSerie"></span><span class="text-danger">*</span> :</label>
                            <select name="serie" id="serieAdd" class="form-control select2 bg-white">
                                <option value="" class="text-muted">Selection one option</option>
                            </select>    
                        </div>
                    
                        <div class="form-group mb-3" id="divLv2" style="display: none">
                            <label class="text-muted mr-3">LV2 (Langue Vivante 2) :</label>
                            <span class="mx-2" title="Allemand">
                                <input type="radio" class="lv2" name="lv2" value="allemand" id="lv2All">
                                <label for="lv2All">All</label>
                            </span>
                            <span class="mx-2" title="Espagnol">
                                <input type="radio" class="lv2" name="lv2" value="espagnol" id="lv2Esp">
                                <label for="lv2Esp">Esp</label>
                            </span>
                        </div>
                    
                        <div class="form-group mb-3"  id="divClass" style="display: none">
                            <label for="classe" class="form-label text-muted">Classe actuelle<span class="text-danger">*</span> :</label>
                            <select name="classe" id="classe" class="form-control select2 bg-white my-0">
                                <!--  -->
                            </select>
                        </div>
                    </div>

                    <div class="my-2 text-center" id="effInscrit" style="display: none">
                        <p class="my-0 clignote">
                            <i class="fa fa-check text-success" style="font-size: 30px"></i>
                        </p>
                        <h5>Inscription effectée, classe <span id="monClass"></span></h5>
                        <p class="my-2" id="dateHeur"></p>
                    </div>

                </div>
        
                <div class="text-center py-3" id="dataInconnu" style="display: none">
                    <p class="my-0 clignote">
                        <i class="fas fa-times text-danger" style="font-size: 30px"></i>
                    </p>
                    <h5 class="mb-2">Matricule inconnu</h5>
                    <span id="getMat"></span>
                </div>
            </div>
            <div class="modal-footer">
                <a href="#" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</a>
                <a href="<?php echo e(route('parent.create')); ?>" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" id="btnNew" title="Nouvel élève" style="display: none">Nouvel</a>
                <a href="#" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" title="Imprimer le reçu d'entrer" id="btnImprim" style="display: none">Imprim</a>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" id="btnVal" style="display: none">Valider</button>
            </div>
        </form>

      </div>
    </div>
</div>

<!-- Modal Export User -->
<div class="modal fade" id="upload" tabindex="-1" role="dialog" aria-labelledby="uploadLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header bg-dark py-2">
          <h5 class="modal-title" id="uploadLabel">DownLoad File</h5>
        </div>
        <form action="<?php echo e(route('inscription.export')); ?>" method="get">
            <?php echo csrf_field(); ?>
            <div class="modal-body px-3 py-4">
                <?php if(count($cycles)): ?>
                <div class="form-group mt-2 mb-3">
                    <label for="selectCycle">Select choise<span class="text-danger">*</span> : </label>
                    <select name="type" id="selectCycle" class="form-control">
                        <option value="">Select ...</option>
                        <?php $__currentLoopData = $cycles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($item['libelle']); ?>"><?php echo e(ucfirst(changeVal($item['libelle']))); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <?php endif; ?>
                <div class="form-group mb-3" id="divLevel" style="display: <?php echo e(count($level) ? null:'none'); ?>">
                    <label for="level" class="form-label">Niveau<span class="text-danger">*</span> :</label><br>
                    <select name="level" id="level" class="form-control">
                        <option value="">Select ...</option>
                        <?php if(!count($cycles)): ?>
                            <?php $__currentLoopData = $level; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($item['id'].'_'.$item['code']); ?>" class="valLevel"><?php echo e($item['code']); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </select>                                       
                </div>
                <div class="form-group mb-3" id="serieDiv" style="display: none">
                    <label for="serie" class="form-label">One choise<span class="text-danger">*</span> :</label><br>
                    <select name="serie" id="serie" class="form-control select2 bg-white">
                        <option value="">Select ...</option>
                    </select>
                </div>
                <div class="form-group mb-0" id="divClasse" style="display: none">
                    <label for="class" class="form-label">Classe<span class="text-danger">*</span> :</label><br>
                    <select name="classe" id="class" class="form-control select bg-white">
                    </select>
                </div>
            </div>
            <div class="modal-footer">
                <a href="#" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</a>
                <button type="submit" id="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Télécharger</button>
            </div>
        </form>
      </div>
    </div>
</div>

<!-- Modal Import User -->
<div class="modal fade" id="import" tabindex="-1" role="dialog" aria-labelledby="importLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header bg-dark py-2">
          <h5 class="modal-title" id="importLabel">Import File</h5>
        </div>
        <form action="<?php echo e(route('inscription.import')); ?>" method="post" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="modal-body px-3 py-4">
                <div class="form-group mt-2 mb-0">
                    <label for="firstNameUser">Charger la fiche<span class="text-danger">*</span> : </label>
                    <input type="file" name="files" id="firstNameUser" class="form-control" placeholder="Charger le fichier de format Excel">
                </div>
            </div>
            <div class="modal-footer">
                <a href="#" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</a>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
      </div>
    </div>
</div>


<!-- Modal Delete-->
<div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <form action="<?php echo e(route('inscription.delete')); ?>" method="post">
            <?php echo csrf_field(); ?>
            <div class="modal-header bg-dark py-2">
                <h5 class="modal-title" id="deleteModalLabel">Delete Inscription</h5>
                <strong id="created" style="font-size: 17px"></strong>
            </div>
            <div class="modal-body text-center pt-3 mb-0 pb-0">
                <strong id="firstStd" style="font-size: 17px"></strong><br>
                <p class="mt-0" id="lastStd" style="font-size: 17px"></p>
                <b id="getClasse" style="font-size: 15px;"></b><br>
                <p>Confirmez la suppression !</p>
            </div>
            <input type="hidden" name="id" id="idDelete">
            <div class="modal-footer">
                <a href="#" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</a>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
      </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <!-- data-table js -->
    <script src="<?php echo e(asset('bower_components/datatables.net/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/jszip.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/pdfmake.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/vfs_fonts.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/dataTables.select.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')); ?>"></script>

    <!-- Custom js -->
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/extensions-custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pcoded.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vartical-layout.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.mCustomScrollbar.concat.min.js')); ?>"></script>
    <script>
        $(document).ready(function(){

            $('#myTable').DataTable({
                processing: true,
                serverSide: true,
                ajax: '<?php echo e(route('inscription.data')); ?>',
                columns: [
                    { data: 'image', className: "text-center py-1", orderable: false, searchable: false},
                    { data: 'matricule', className: "py-1" },
                    { data: 'firstName', className: "py-1" },
                    { data: 'lastName', className: "py-1" },
                    { data: 'genre', className: "py-1" },
                    { data: 'classe', className: "py-1" },
                    { data: 'created', className: "py-1"},
                    { data: 'action', className: "text-center py-1", orderable: false, searchable: false}
                ],
                pageLength: 10,
                language: {
                    url: "//cdn.datatables.net/plug-ins/1.13.6/i18n/fr-FR.json"
                }
            });


            $('#valider').on('click', function(e){
                e.preventDefault();
                $('.student, #getMatricule, .dateHeur').remove();
                $('#monClass, #dateHeur').empty();
                if($('#matricule').val()){
                    $.ajax({
                        url: '<?php echo e(route('inscription.create')); ?>',
                        method: 'GET',
                        data: {
                            mat: $('#matricule').val()
                        },
                        success: function(data){
                            $('#formModal').modal('toggle');

                            if(data['status'] == 200){
                                data['student']['type'] == 'primaire' ? $('#boursier, #affecter').slideUp():$('#boursier, #affecter').slideDown();
                                $('#imgStudent').attr('src', data.student.sexe == 'F' ? "<?php echo e(asset('assets/images/stdt1_woman.png')); ?>":"<?php echo e(asset('assets/images/stdt1_man.png')); ?>");
                                $sexe = data.student.sexe == 'F' ? 'née':'né';
                                $('#nameStudent').append('<strong class="student">'+data.student.first_name.toUpperCase()+' '+data.student.last_name+'</strong>');
                                $('#infoStudent').append('<span class="student">'+data.student.sexe+', '+$sexe+' le '+data.student.date_birth+' à '+data.student.place_birth+'</span>');
                                $('#matStudent').append('<span class="student">'+data.student.matricule+'</span>');

                                if(data['exist']){
                                    $('#dataExiste, #effInscrit, #btnImprim').slideDown();
                                    $('#dataInconnu, #btnNew, #contentFom, #btnVal, #typeStud').slideUp();
                                    $('#monClass').text(data['exist']['classe']);
                                    $('#dateHeur').text('Le '+data['exist'].date+' à '+data['exist']['heure']);
                                    $('#btnImprim').attr('href', '/inscription/pdf/'+data.student.id); // Add action form Modal
                                }
                                else{

                                    $('#dataExiste, #btnVal, #contentFom, #typeStud').slideDown();
                                    $('#dataInconnu, #btnNew, #effInscrit, #btnImprim').slideUp();
                                    
                                    $('#getType').val(data.student.type);
                                    $('#studentId').val(data.student.id);

                                    $('.valLevel').remove();
                                    $i = 0; $levels = data.level;
                                    while($i < $levels.length){
                                        $('#addLevel').append('<option value="'+$levels[$i].id+'_'+$levels[$i].code+'" class="valLevel">'+$levels[$i].code+'</option>');
                                        $i++;
                                    }
                                }
                            }
                            else{
                                $('#dataInconnu, #btnNew').slideDown();
                                $('#dataExiste, #btnVal, #btnImprim, #typeStud').slideUp();
                                $('#getMat').append('<span id="getMatricule">'+data['matricule'].mat+'</span>');
                            }
                        }
                    });
                }
            });


            // Get Classe
            $('#addLevel').on('change', function() {
                let val = $(this).val().split('_');
                $('.valSerie, .valClasse').remove();
                if(val[0] > 13 && val[0] != 17){
                    $('#divSerie').slideDown();
                    $('select[name="serie"]').removeAttr('disabled');
                    $('#divLv2').slideUp();$('#lv2All').prop("checked", false);
                    $("#libSerie").remove();
                    $("#getType").val() != 'superieur' ? $('#bockSerie').text('Serie actuelle'):$('#bockSerie').text('Niveau actuel');
                    $.ajax({
                        url: '<?php echo e(route('inscription.serie')); ?>',
                        method: 'GET',
                        data: {
                            libelle: val[1],
                            level: $("#getType").val()
                        },
                        success: function(data){
                            $i = 0;
                            while($i < data.length){
                                $('#serieAdd').append('<option value="'+data[$i].id+'_'+data[$i].serie+'" class="valSerie">'+data[$i].serie+'</option>');
                                $i++;
                            }
                        }
                    });
                }
                else if(val[0] > 11 && val[0] != 17){
                    $('#divSerie').slideUp();$('select[name="serie"]').attr('disabled', 'disabled');
                    $('#divLv2').slideDown();$('#lv2All').prop("checked", true);
                    if($("input[name='lv2']:checked").prop("value")){
                        $('.valClasse').remove(); $('#divClass').slideDown();
                        getClasseLv2(val[0], $("input[name='lv2']:checked").prop("value"));
                    }
                }
                else if(val[0] < 12 || val[0] == 17){
                    $('#divClass').slideDown();
                    $('#divSerie').slideUp();$('select[name="serie"]').attr('disabled', 'disabled');
                    $('#divLv2').slideUp();$('#lv2All').prop("checked", false);
                    getClasseNonSerie(val[0]);
                }
            });


            $('#serieAdd').on('change', function() {
                $val = $(this).val().split('_');
                let lvl = $('#addLevel').val().split('_');
                $('#divClass').slideDown();
                if($val[1] == "A" || $val[1] == "A1" || $val[1] == "A2" || (($val[1] == "C") && (lvl[0] == 14))){
                    $('#divLv2').slideDown();$('#lv2All').prop("checked", true);
                    $('.valClasse').remove();
                    getClasseLv2Serie(lvl[0], $("input[name='lv2']:checked").prop("value"),$val[0]);
                }
                else{
                    $('#divLv2').slideUp();$('#lv2All').prop("checked", false);
                    getClasseLv2Serie(lvl[0],null,$val[0]);
                }
            });


            $('.lv2').on('change', function() {
                $('.valClasse').remove();
                $('#divClass').slideDown();
                if($("input[name='lv2']:checked").prop("value")){
                    let val = $('#addLevel').val().split('_');
                    $serie = $('#serieAdd').val();
                    if($serie){
                        $val = $serie.split('_');
                        getClasseLv2Serie(val[0], $("input[name='lv2']:checked").prop("value"),$val[0]);
                    }
                    else{
                        getClasseLv2(val[0], $("input[name='lv2']:checked").prop("value"));
                    }
                }
            });


            // On Click Btn Delete Inscription ................................ 
            $(document).on('click', '.btnDelete', function() {
                $.ajax({
                    url: '<?php echo e(route('inscription.getDelete')); ?>',
                    method: 'GET',
                    data: { 
                        id: $(this).data('id')
                     },
                    success: function(data){
                        if(data){
                            $('#idDelete').val(data.id);
                            $('#created').text(data.created);
                            $('#firstStd').text(data.first);
                            $('#lastStd').text(data.last);
                            $('#getClasse').text(data.classe);

                            $("#deleteModal").modal("show"); // Affiche Modal Delete ....................
                        }
                    }
                });
            });


            $('#selectCycle').on('change', function() {
                if($(this).val()){
                    $("div#upload").fadeIn();
                    $.ajax({
                        url: '<?php echo e(route('inscription.level')); ?>',
                        method: 'GET',
                        data: {
                            libelle: $(this).val()
                        },
                        success: function(data){
                            $('.valLevel').remove();
                            $('#divLevel').fadeIn(1000);
                            $i = 0;
                            while($i < data.length){
                                $('#level').append('<option value="'+data[$i].id+'_'+data[$i].code+'" class="valLevel">'+data[$i].code+'</option>');
                                $i++;
                            }
                        }
                    });
                }
                else{
                    $("div#upload, .modal-backdrop").fadeOut();
                }
            });


            $('#level').change(function() {
                let val = $(this).val().split('_');
                $('.valSerie, .valClas').remove();
                $('#divClasse').slideUp();
                if((val[0] > 13) && (val[0] != 17)){
                    $.ajax({
                        url: '<?php echo e(route('inscription.serie')); ?>',
                        method: 'GET',
                        data: {
                            libelle: val[1],
                            level: $("#selectCycle").val()
                        },
                        success: function(data){
                            $('#serieDiv').fadeIn(1000);
                            $i = 0;
                            while($i < data.length){
                                $('#serie').append('<option value="'+data[$i].id+'_'+data[$i].serie+'" class="valSerie">'+data[$i].serie+'</option>');
                                $i++;
                            }
                        }
                    });
                }
                else{
                    $('#serieDiv').slideUp(1000);
                    getClasse(val[0]);
                }
            });


            $('#serie').on('change', function() {
                $val = $(this).val().split('_');
                $lvl = $('#level').val().split('_');
                getClasse($lvl[0],$val[0]);
            });

            $('#submit').on('click', function() {
                $("div#upload, .modal-backdrop").fadeOut();
            });

            // Function utilisées
            function getClasseNonSerie($id){
                $.ajax({
                    url: '<?php echo e(route('inscription.classe')); ?>',
                    method: 'GET',
                    data: {
                        id: $id,
                        lv2: null,
                        serie: null
                    },
                    success: function(data){
                        $('.valClasse').remove();
                        if(data.length){
                            $i = 0;
                            while($i < data.length){
                                $('#classe').append('<option value="'+data[$i].id+'" class="valClasse">'+data[$i].libelle+'</option>');
                                $i++;
                            }
                        }
                        else{
                            $('#classe').append('<option class="valClasse">Classe non disponible !</option>');
                        }
                        
                    }
                });
            }


            function getClasseLv2($id, $lv2){
                $.ajax({
                    url: '<?php echo e(route('inscription.classe')); ?>',
                    method: 'GET',
                    data: {
                        id: $id,
                        lv2: $lv2,
                        serie: null
                    },
                    success: function(data){
                        $('.valClasse').remove();
                        if(data.length){
                            $i = 0;
                            while($i < data.length){
                                $('#classe').append('<option value="'+data[$i].id+'" class="valClasse">'+data[$i].libelle+'</option>');
                                $i++;
                            }
                        }
                        else{
                            $('#classe').append('<option class="valClasse">Classe non disponible !</option>');
                        }
                        
                    }
                });
            }



            function getClasseLv2Serie($id, $lv2 = null, $serie = null){
                $.ajax({
                    url: '<?php echo e(route('inscription.classe')); ?>',
                    method: 'GET',
                    data: {
                        id: $id,
                        lv2: $lv2 ?? null,
                        serie: $serie ?? null
                    },
                    success: function(data){
                        $('.valClasse').remove();
                        if(data.length){
                            $i = 0;
                            while($i < data.length){
                                $('#classe').append('<option value="'+data[$i].id+'" class="valClasse">'+data[$i].libelle+'</option>');
                                $i++;
                            }
                        }
                        else{
                            $('#classe').append('<option class="valClasse">Classe non disponible !</option>');
                        }
                        
                    }
                });
            }


            function getClasse($id, $serie = null){
                $.ajax({
                    url: '<?php echo e(route('inscription.classe')); ?>',
                    method: 'GET',
                    data: {
                        id: $id,
                        serie: $serie ?? null,
                        lv2: null
                    },
                    success: function(data){
                        $('.valClasse').remove();
                        $('#divClasse').fadeIn(1000);
                        if(data.length){
                            $i = 0;
                            while($i < data.length){
                                $('#class').append('<option value="'+data[$i].id+'" class="valClasse">'+data[$i].libelle+'</option>');
                                $i++;
                            }
                        }
                        else{
                            $('#class').append('<option class="valClasse">Classe non disponible <!option>');
                        }
                        
                    }
                });
            }
        })
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/educasnsa/public_html/neuroschool/resources/views/pages/inscriptions/index.blade.php ENDPATH**/ ?>