<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="description" content="Educas est une application de gestion d'ecole dans son ensemble">
    <meta name="author" content="Jean-Marius Yao">
    <title>{{'liste_moyenne_'.$decoup->cutting->libelle.'_'.$class->libelle}}</title>
</head>
<style>
    @page {
        margin: 0cm; /* Supprime toutes les marges */
    }

    body {
        margin: 0cm;
        padding: 0cm;
        font-size: .875em;
        overflow-x: hidden;
        color: #353c4e;
        font-family: sans-serif;
    }

    /* applies border to the table */
    #tabled,th,td {
        border: 1px solid #dee2e6;
        padding: 10px;
        text-align: center
    }

    #tabled {
        width: 100%;
        border: 1px solid #dee2e6;
        border-collapse: collapse;
        table-layout: auto;
        border-spacing: 2px;
    }

    th, td {
        white-space: nowrap;
    }
</style>
<body>
    <header style="margin: 5px auto; border-bottom: 1px solid #dee2e6; height: 100px; padding-bottom: 15px">
        <div style="display: flex; flex-direction: row; justify-content: space-between;">
            <table style="width: 100%">
                <tbody>
                    <tr style="margin-bottom: 0%">
                        <td style="width: 50%; border:none">
                            <div style="text-align: center; font-size: 8px">Ministère de l'Education Nationale, de l'Enseignement <br> Technique et de la   Formation Professionnelle</div>
                        </td>
                        <td style="width: 50%; border:none">
                            <div style="text-align: center; font-size: 8px;">
                                <b >REPUBLIQUEDE COTE D'IVOIRE</b><br>
                                <i>Union - Discipline - Travail</i>
                            </div>
                        </td>
                    </tr>
                    <tr style="margin-bottom: 0%">
                        <td style="width: 40%; border:none">
                            <img src="{{public_path($school->logoUrl())}}" class="m-b-10 w-100" alt="Logo Etablissement" style="height: 55px;">
                        </td>
                        <td style="width: 60%; border:none">
                            <div style="text-align: center">
                                <div style="text-align: center;">
                                    <b style="font-size: 15px;">{{mb_strtoupper($school->school->name_school)}}</b><br>
                                    <i style="font-size: 9px">{{$school->address_email}} / {{$school->phon_school}}</i><br>
                                    <i style="font-size: 11px;">Année Scolaire : <b>{{$class->schoolYear->school_year}}</i>
                                </div>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </header>
    {{-- <hr> --}}
    <section style="margin: 5px auto;">
        <div style="margin-top: 20px">
            <div style="margin-top: 35px; text-align: center; font-size:21px; text-decoration: underline;">
                <b>Moyenne {{strtoupper($decoup->cutting->libelle)}} {{$class->libelle}}</b>
            </div>
            <table id="tabled" style="margin-top: 25px">
                <thead>
                    <tr>
                        <th class="text-center" style="width: 3%">N°</th>
                        <th class="text-center text-uppercase">Nom & Prénoms</th>
                        <th class="text-center text-uppercase">Sexe</th>
                        {{-- <th class="text-center text-uppercase">Matricule</th> --}}
                        @foreach ($matters as $matter)
                        <th class="text-center text-uppercase">{{$matter['abbreviated'] ?? $matter['libelle']}}</th>
                        @endforeach
                        <th class="text-center text-uppercase">Moy</th>
                        <th class="text-center text-uppercase">Rang</th>
                    </tr>
                </thead>
                <tbody>
                    @php $i = 1; @endphp
                    @foreach ($datas as $data)
                    <tr>
                        <th class="text-center">{{$i <= 9 ? '0'.$i++:$i++}}</th>
                        <td style="text-align: left">{{Str::limit($data['name'], 20, '...')}}</td>
                        <td class="text-center">{{$data['sexe']}}</td>
                        {{-- <td class="text-center">{{$data['matricule']}}</td> --}}
                        @foreach ($data['moyens'] as $moyen)
                        <td class="text-center">{{$moyen ? $moyen['moyenne']:'nc'}}</td>
                        @endforeach
                        <th class="text-center">{{$data['moyen']}}</th>
                        <td class="text-center">{{$data['rang']}}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </section>
</body>
</html>