<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="description" content="Educas est une application de gestion d'ecole dans son ensemble">
    <meta name="author" content="Jean-Marius Yao">
    <title>Emploi du temps {{$class->libelle}}</title>
</head>
<style>
    body {
        font-size: .875em;
        overflow-x: hidden;
        color: #353c4e;
        font-family: "Open Sans", sans-serif;
    }

    /* applies border to the table */
    #tabled,th,td {
        border: 1px solid #dee2e6;
        padding: 10px;
        text-align: center
    }

    #tabled {
        width: 100%;
        border: 1px solid #dee2e6;
        border-collapse: collapse;
        table-layout: auto;
        border-spacing: 2px;
    }

    th, td {
        white-space: nowrap;
    }
</style>
<body>
    <header style="margin: 5px auto; border-bottom: 1px solid #dee2e6; height: 100px; padding-bottom: 15px">
        <div style="display: flex; flex-direction: row; justify-content: space-between;">
            <table style="width: 100%">
                <tbody>
                    <tr style="margin-bottom: 0%">
                        <td style="width: 50%; border:none">
                            <div style="text-align: center; font-size: 8px">Ministère de l'Education Nationale, de l'Enseignement <br> Technique et de la   Formation Professionnelle</div>
                        </td>
                        <td style="width: 50%; border:none">
                            <div style="text-align: center; font-size: 8px;">
                                <b >REPUBLIQUEDE COTE D'IVOIRE</b><br>
                                <i>Union - Discipline - Travail</i>
                            </div>
                        </td>
                    </tr>
                    <tr style="margin-bottom: 0%">
                        <td style="width: 40%; border:none">
                            <img src="{{public_path($school->logoUrl())}}" class="m-b-10 w-100" alt="Logo établissement" style="height: 55px;">
                        </td>
                        <td style="width: 60%; border:none">
                            <div style="text-align: center">
                                <div style="text-align: center;">
                                    <b style="font-size: 15px;">{{mb_strtoupper($school->school->name_school)}}</b><br>
                                    <i style="font-size: 9px">{{$school->address_email}} / {{$school->phon_school}}</i><br>
                                    <i style="font-size: 11px;">Année Scolaire : <b>{{$class->schoolYear->school_year}}</i>
                                </div>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </header>
    {{-- <hr> --}}
    <section style="margin: 5px auto;">
        <div style="margin-top: 20px">
            <div style="margin-top: 35px; text-align: center; font-size:21px; text-decoration: underline;">
                <b>EMPLOI DU TEMPS CLASSE : {{$class->libelle}}</b>
            </div>
            <table id="tabled" style="margin-top: 25px">
                <thead>
                    <tr style="display: table-row; vertical-align: inherit; unicode-bidi: isolate; border-color: inherit;">
                        <th>Horaires</th>
                        @foreach ($days as $day)
                        <th>{{ucfirst($day['day'])}}</th>
                        @endforeach
                    </tr>
                </thead>
                <tbody>
                    @foreach ($morning as $mrg)
                    <tr>
                        <td>{{$mrg['debut']}} - {{$mrg['fin']}}</td>
                        @for ($i = 0; $i < count($days); $i++)
                        <td>
                            @foreach ($dtsMrg as $item)
                                {{$item['ligne'] == $i+1 ? ($item['morning_time_id'] == $mrg['id'] ? $item->matter['abbreviated'] ?? $item->matter['libelle']:null):null}}
                            @endforeach
                        </td>
                        @endfor
                    </tr> 
                    @endforeach
                    <tr style="letter-spacing: 1rem; font-size: 15px">
                        <th colspan="{{count($days)+1}}" class="text-center py-2">APRES - MIDI</th>
                    </tr>
                    @foreach ($after as $atr)
                    <tr>
                        <td>{{$atr['debut']}} - {{$atr['fin']}}</td>
                        @for ($i = 0; $i < count($days); $i++)
                        <td>
                            @foreach ($dtsAfter as $item)
                                {{$item['ligne'] == $i+1 ? ($item['after_noon_time_id'] == $atr['id'] ? $item->matter['abbreviated'] ?? $item->matter['libelle']:null):null}}
                            @endforeach
                        </td>
                        @endfor
                    </tr> 
                    @endforeach
                </tbody>
            </table>
        </div>
    </section>
</body>
</html>