<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="description" content="Educas est une application de gestion d'ecole dans son ensemble">
    <meta name="author" content="Jean-Marius Yao">
    <title>Bulletin De Notes {{$classe['libelle']}}   </title>
</head>
<style>
    @page {
        margin: 0.5cm; /* haut droite bas gauche */
    }
    body {
        margin: 0cm;
        padding: 0cm;
        font-family: sans-serif;
        font-size: 12px
    }

    #head{
        position: relative;
        width: 100%;
        top: 20px;
        border-bottom: 3px solid grey;
        border-radius: 10px;
        display: flex;
        flex-direction: row;
        justify-content: space-between;
        align-items: center;
        height: 90px;
        background: #eee;
        padding-top: 3px;
    }

    footer {
        position: fixed;
        bottom: -50px;
        border-top: 2px solid gray;
        left: 0;
        right: 0;
        height: 50px;
        text-align: center;
        font-size: 12px;
        color: #555;
    }
</style>
<body style="padding: 0%">
    @foreach ($datas as $item)
        {{-- @if (!$loop->last) --}}
        <div style="page-break-after: always; padding:0%; margin:0%">

            <header id="head">
                <table>
                    <tbody>
                        <tr style="width: 100%;">
                            <td style="width: 50px; height: 80px; padding: 3px">
                                <img src="{{public_path($item['school']->logoUrl())}}" class="m-b-10" alt="Logo établissement" style="width: 80px; height: 80px;">
                            </td>
                            <td style="width: 320px; height: 80px; border: 2px solid grey; border-radius: 5px; text-align:center; font-size: 13px; padding: 3px">
                                <table>
                                    <tbody>
                                        <tr>
                                            <td style="text-align: center"><strong>REPUBLIQUEDE COTE D'IVOIRE</strong></td>
                                        </tr>
                                        <tr>
                                            <td style="text-align: center">
                                                Ministère de l'Education Nationale et de l'Alphabétisation
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="text-align: center; width: 100%; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;">
                                                <strong style="text-transform: uppercase; margin-top: 3px;">{{$item['school']->school->name_school}}</strong>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </td>
                            <td style="width: 310px; height: 80px; border: 2px solid grey; border-radius: 5px; font-size: 13px;  padding: 3px;">
                                <table>
                                    <tbody>
                                        <tr>
                                            <td style="width: 200px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;">
                                                <span>Adresse : <strong>{{$item['school']->addres_postal}}</strong></span>
                                            </td>
                                            <td style="width: 100px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;">
                                                <span>Code : <b>{{$item['school']->school->code_school}}</b></span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="width: 200px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;">
                                                <span>Telephone : <strong>{{$item['school']->phon_school}}</strong></span>
                                            </td>
                                            <td style="width: 100px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;">
                                                <span>Statut : <strong>---</strong></span>
                                            </td>
                                        </tr>
                                        <tr style="white-space: nowrap; overflow: hidden; text-overflow: ellipsis;">
                                            <td colspan="2">Email : <strong>{{$item['school']->address_email}}</strong></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </header>
            <!--  -->

            <section style="padding: 0%; margin-top: 10%">
                <div style="width: 100%; height: 17px; margin-top: 10px; margin-bottom: 30px ;text-align: center">
                    <span style="font-size: 17px; text-decoration: underline; font-weight: 700;">
                        Bulletin De Notes : {{ucfirst($item['cutting']->cutting->libelle)}} - Année Scolaire {{$item['cutting']->schoolYear->school_year}}
                    </span>
                </div>

                <!-- Information sur l'eleve -->
                <section style="width: 100%; background: rgb(228, 226, 226); border: 1px solid gray; margin-top: 20px; padding-bottom: 2px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; ">
                    <header style="padding: 3px; border-bottom: 1px solid rgb(179, 178, 178)">
                        <div style="width: 100%; background: rgb(167, 161, 161); padding-bottom: 0%">
                            <table style="width: 100%; margin: 0%">
                                <tbody>
                                    <tr>
                                        <th style="width: 300px; text-align: left; font-size: 14px;"><strong>{{strtoupper($item['student']->student->first_name.' '.$item['student']->student->last_name)}}</strong></th>
                                        <th style="width: 150px; font-size: 13px; text-align: right">Matricule : <strong>{{$item['student']->student->matricule}}</strong></th>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <table style="width: 100%;">
                            <tbody>
                                <tr>
                                    <td style="width: 350px; font-size: 13px">
                                        <table>
                                            <tbody>
                                                <tr>
                                                    <td style="width: 300px">Classe: <strong>{{$item['student']->classe->libelle}}</strong></td>
                                                    <td style="width: 150px">Effectif: <strong>{{$item['student']->classe->inscrits <= 9 ? '0'.$item['student']->classe->inscrits:$item['student']->classe->inscrits}}</strong></td>
                                                    <td style="width: 100px">Interne: <strong>Non</strong></td>
                                                </tr>
                                                <tr>
                                                    <td style="width: 300px">Sexe: <strong>{{$item['student']->student->sexe == 'F' ? 'Feminin':'Masculin'}}</strong></td>
                                                    <td style="width: 150px">Redoublant{{$item['student']->student->sexe == 'F' ? 'e':''}}: <strong>{{ucfirst($item['student']['redoublant'])}}</strong></td>
                                                    <td style="width: 100px">Affecté{{$item['student']->student->sexe == 'F' ? 'e':''}}: <strong>{{ucfirst($item['student']['affecte'])}}</strong></td>
                                                </tr>
                                                <tr>
                                                    <td style="width: 300px">Nationalité: <strong>{{ucwords($item['student']->student->nationalitie->libelle)}}</strong></td>
                                                    <td style="width: 150px">Régime: ---</td>
                                                    <td></td>
                                                </tr>
                                                <tr>
                                                    <td colspan="2">Né le: <strong>{{date("d/m/Y", strtotime($item['student']->student->date_birth))}}</strong> à <strong>{{ucfirst($item['student']->student->place_birth)}}</strong></td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </td>
                                    <td style="width: 90px; height: 50px; border-left: 1px solid rgb(211, 202, 202); text-align: center">
                                        @if ($item['student']->student->photo)
                                        <img src="{{public_path('storage/'.$item['student']->student->photo)}}" class="img-radius mx-0" alt="photo student" style="height: 80px; width: 80px">
                                        @else
                                        <img src="{{public_path($item['student']->student->sexe == 'F' ? 'assets/images/stdt_w.png':'assets/images/stdt_m.png')}}" class="photo student default" alt="User-Profile-Image" style="height: 50px; width: 80px">
                                        @endif
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </header>

                    <body style="margin: 15px; font-size: 14px">
                        <table style="border: 1px solid rgb(179, 178, 178)">
                            <thead>
                                <tr>
                                    <th style="width: 140px; border: 1px solid rgb(179, 178, 178); font-size: 12px">Matières</th>
                                    <th style="width: 50px; border: 1px solid rgb(179, 178, 178); font-size: 12px">Moy</th>
                                    <th style="width: 50px; border: 1px solid rgb(179, 178, 178); font-size: 12px">Coeff</th>
                                    <th style="width: 60px; border: 1px solid rgb(179, 178, 178); font-size: 12px">M. coeff</th>
                                    <th style="width: 50px; border: 1px solid rgb(179, 178, 178); font-size: 12px">Rang</th>
                                    <th style="width: 160px; border: 1px solid rgb(179, 178, 178); font-size: 12px">Professeur</th>
                                    <th style="width: 180px; border: 1px solid rgb(179, 178, 178); font-size: 12px">Appréciation/Emargement</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($item['infosLts'] as $item1)
                                <tr style="padding-top: 5px; margin-bottom: 5px">
                                    <td style="width: 140px; border: 1px solid rgb(179, 178, 178); font-size: 12px">{{ucfirst($item1['libelle'])}}</td>
                                    <td style="width: 50px; border: 1px solid rgb(179, 178, 178); font-size: 12px; text-align: center">{{$item1['moyenne']}}</td>
                                    <td style="width: 50px; border: 1px solid rgb(179, 178, 178); font-size: 12px; text-align: center">{{$item1['moyenne'] == 'nc' ? 'nc':$item1['coef']}}</td>
                                    <td style="width: 60px; border: 1px solid rgb(179, 178, 178); font-size: 12px; text-align: center">{{calculMoyenneCoefficenter($item1['moyenne'], $item1['coef'])}}</td>
                                    <td style="width: 50px; border: 1px solid rgb(179, 178, 178); font-size: 12px; text-align: center">{{$item1['rang']}}</td>
                                    <td style="width: 160px; border: 1px solid rgb(179, 178, 178); font-size: 12px">{{$item1['prof']}}</td>
                                    <td style="width: 180px; border: 1px solid rgb(179, 178, 178); font-size: 12px">{{$item1['moyenne'] == 'nc' ? '--':appreciation($item1['moyenne'])}}</td>
                                </tr>
                                @endforeach
                                <!-- Bilan Lettres -->
                                <tr style="padding-top: 10px; margin-bottom: 10px; background:rgb(179, 178, 178)">
                                    <th style="width: 140px; border: 1px solid rgb(179, 178, 178); font-size: 12px; text-align: left">Bilan Lettres</th>
                                    <th style="width: 50px; border: 1px solid rgb(179, 178, 178); font-size: 12px; text-align: center">{{$item['bilanLts'] ? $item['bilanLts']['moyenne']:'nc'}}</th>
                                    <th style="width: 50px; border: 1px solid rgb(179, 178, 178); font-size: 12px; text-align: center">{{$item['bilanLts'] ? $item['bilanLts']['coeffs']:'nc'}}</th>
                                    <th style="width: 60px; border: 1px solid rgb(179, 178, 178); font-size: 12px; text-align: center">{{$item['bilanLts'] ? $item['bilanLts']['points']:'nc'}}</th>
                                    <th style="width: 50px; border: 1px solid rgb(179, 178, 178); font-size: 12px; text-align: center">{{$item['bilanLts'] ? $item['bilanLts']['rang']:'nc'}}</th>
                                    <th colspan="2" style="width: 300px; border: 1px solid rgb(179, 178, 178); font-size: 12px"></th>
                                </tr>

                                @foreach ($item['infosSns'] as $item2)
                                <tr style="padding-top: 5px; margin-bottom: 5px">
                                    <td style="width: 140px; border: 1px solid rgb(179, 178, 178); font-size: 12px">{{ucfirst($item2['libelle'])}}</td>
                                    <td style="width: 50px; border: 1px solid rgb(179, 178, 178); font-size: 12px; text-align: center">{{$item2['moyenne']}}</td>
                                    <td style="width: 50px; border: 1px solid rgb(179, 178, 178); font-size: 12px; text-align: center">{{$item2['moyenne'] == 'nc' ? 'nc':$item2['coef']}}</td>
                                    <td style="width: 60px; border: 1px solid rgb(179, 178, 178); font-size: 12px; text-align: center">{{calculMoyenneCoefficenter($item2['moyenne'], $item2['coef'])}}</td>
                                    <td style="width: 50px; border: 1px solid rgb(179, 178, 178); font-size: 12px; text-align: center">{{$item2['rang']}}</td>
                                    <td style="width: 160px; border: 1px solid rgb(179, 178, 178); font-size: 12px">{{$item2['prof']}}</td>
                                    <td style="width: 180px; border: 1px solid rgb(179, 178, 178); font-size: 12px">{{$item2['moyenne'] == 'nc' ? '--':appreciation($item2['moyenne'])}}</td>
                                </tr>
                                @endforeach
                                <!-- Bilan Sciences -->
                                <tr style="padding-top: 10px; margin-bottom: 10px; background:rgb(179, 178, 178)">
                                    <th style="width: 140px; border: 1px solid rgb(179, 178, 178); font-size: 12px; text-align: left">Bilan Sciences</th>
                                    <th style="width: 50px; border: 1px solid rgb(179, 178, 178); font-size: 12px; text-align: center">{{$item['bilanSns'] ? $item['bilanSns']['moyenne']:'nc'}}</th>
                                    <th style="width: 50px; border: 1px solid rgb(179, 178, 178); font-size: 12px; text-align: center">{{$item['bilanSns'] ? $item['bilanSns']['coeffs']:'nc'}}</th>
                                    <th style="width: 60px; border: 1px solid rgb(179, 178, 178); font-size: 12px; text-align: center">{{$item['bilanSns'] ? $item['bilanSns']['points']:'nc'}}</th>
                                    <th style="width: 50px; border: 1px solid rgb(179, 178, 178); font-size: 12px; text-align: center">{{$item['bilanSns'] ? $item['bilanSns']['rang']:'nc'}}</th>
                                    <th colspan="2" style="width: 300px; border: 1px solid rgb(179, 178, 178); font-size: 12px"></th>
                                </tr>

                                @foreach ($item['infosAts'] as $item3)
                                <tr style="padding-top: 5px; margin-bottom: 5px">
                                    <td style="width: 140px; border: 1px solid rgb(179, 178, 178); font-size: 12px">{{ucfirst($item3['libelle'])}}</td>
                                    <td style="width: 50px; border: 1px solid rgb(179, 178, 178); font-size: 12px; text-align: center">{{$item3['moyenne']}}</td>
                                    <td style="width: 50px; border: 1px solid rgb(179, 178, 178); font-size: 12px; text-align: center">{{$item3['moyenne'] == 'nc' ? 'nc':$item3['coef']}}</td>
                                    <td style="width: 60px; border: 1px solid rgb(179, 178, 178); font-size: 12px; text-align: center">{{calculMoyenneCoefficenter($item3['moyenne'], $item3['coef'])}}</td>
                                    <td style="width: 50px; border: 1px solid rgb(179, 178, 178); font-size: 12px; text-align: center">{{$item3['rang']}}</td>
                                    <td style="width: 160px; border: 1px solid rgb(179, 178, 178); font-size: 12px">{{$item3['prof']}}</td>
                                    <td style="width: 180px; border: 1px solid rgb(179, 178, 178); font-size: 12px">{{$item3['moyenne'] == 'nc' ? '--':appreciation($item3['moyenne'])}}</td>
                                </tr>
                                @endforeach
                                <!-- Bilan Autres -->
                                <tr style="padding-top: 10px; margin-bottom: 10px; background:rgb(179, 178, 178)">
                                    <th style="width: 140px; border: 1px solid rgb(179, 178, 178); font-size: 12px; text-align: left">Bilan Autres</th>
                                    <th style="width: 50px; border: 1px solid rgb(179, 178, 178); font-size: 12px; text-align: center">{{$item['bilanAts'] ? $item['bilanAts']['moyenne']:'nc'}}</th>
                                    <th style="width: 50px; border: 1px solid rgb(179, 178, 178); font-size: 12px; text-align: center">{{$item['bilanAts'] ? $item['bilanAts']['coeffs']:'nc'}}</th>
                                    <th style="width: 60px; border: 1px solid rgb(179, 178, 178); font-size: 12px; text-align: center">{{$item['bilanAts'] ? $item['bilanAts']['points']:'nc'}}</th>
                                    <th style="width: 50px; border: 1px solid rgb(179, 178, 178); font-size: 12px; text-align: center">{{$item['bilanAts'] ? $item['bilanAts']['rang']:'nc'}}</th>
                                    <th colspan="2" style="width: 300px; border: 1px solid rgb(179, 178, 178); font-size: 12px"></th>
                                </tr>
                                <!-- Resultat de fin trimestre -->
                                <tr style="padding-top: 17px; margin-bottom: 17px;">
                                    <th colspan="2" style="width: 190px; border: 1px solid rgb(179, 178, 178); font-size: 13px; text-align: left">Totaux</th>
                                    <th style="width: 50px; border: 1px solid rgb(179, 178, 178); font-size: 13px; text-align: center">{{$item['resultat']->coeffs}}</th>
                                    <th style="width: 60px; border: 1px solid rgb(179, 178, 178); font-size: 13px; text-align: center">{{$item['resultat']->points}}</th>
                                    <th colspan="2" style="width: 300px; border: 1px solid rgb(179, 178, 178); font-size: 13px;">Moyenne: {{$item['resultat']->moyenne}} / 20</th>
                                    <th style="width: 50px; border: 1px solid rgb(179, 178, 178); font-size: 13px;">Rang: {{$item['resultat']->rang}} / {{$item['student']->classe->inscrits <= 9 ? '0'.$item['student']->classe->inscrits:$item['student']->classe->inscrits}}</th>
                                </tr>
                            </tbody>
                        </table>
                        <div style="margin-top: 10px;">
                            <table style="margin: auto">
                                <tbody>
                                    <tr>
                                        <td style="width: 200px; font-size: 13px; text-align:left;">Absences justifiées : {{$item['absence_justified']}} Heure{{$item['absence_justified'] > '1' ? 's':'' }}</td>
                                        <td style="width: 200px; font-size: 13px; text-align:left; padding-right: 20px">Absences non justifiées : {{$item['absence_no_justified']}} Heure{{$item['absence_no_justified'] > '1' ? 's':'' }}</td>
                                        <td style="width: 230px; font-size: 13px; text-align:left">Appréciation : ---</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>

                        <div style="margin-top: 10px; ">
                            <table style="margin: auto">
                                <tbody>
                                    <tr>
                                        <td>
                                            <div style="width: 230px; height: 100px; border: 1px solid">
                                                <div style="width: 100%; border-bottom: 1px solid; background: rgb(159, 159, 160); text-align: center; margin-bottom: 15px">
                                                    <strong style="font-size: 13px">Statistique de la classe</strong>
                                                </div>
                                                <table>
                                                    <tbody>
                                                        <tr>
                                                            <td style="width: 60%; font-size: 12px">Plus forte moyenne :</td>
                                                            <td style="font-size: 12px">
                                                                <strong>{{$item['result_classe']->moyenne_elevee_classe}} / 20</strong>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td style="width: 35%; font-size: 12px">Plus faible moyenne :</td>
                                                            <td style="font-size: 12px">
                                                                <strong>{{$item['result_classe']->moyenne_moins_classe}} / 20</strong>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td style="width: 35%; font-size: 12px">Moyenne de la classe :</td>
                                                            <td style="font-size: 12px">
                                                                <strong>{{$item['result_classe']->moyenne}} / 20</strong>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </td>
                                        <td>
                                            <div style="width: 230px; height: 100px; border: 1px solid">
                                                <div style="width: 100%; border-bottom: 1px solid; background: rgb(159, 159, 160); text-align: center">
                                                    <strong style="font-size: 13px">Distintions</strong>
                                                </div>
                                                <table>
                                                    <tbody>
                                                        <tr>
                                                            <td style="font-size: 12px; display: flex;">
                                                                <label style="display: flex; align-items: center;">
                                                                    <input type="checkbox" style="width: 15px; height: 15px; background: none; transform: scale(0.8);" {{distinction($item['resultat']->moyenne, 14, 15) ? 'checked':''}}>
                                                                    <span>Tableau d'honneur</span>
                                                                </label>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td style="font-size: 12px; display: flex;">
                                                                <label style="display: flex; align-items: center;">
                                                                    <input type="checkbox" style="width: 15px; height: 15px; background: none; transform: scale(0.8);" {{distinction($item['resultat']->moyenne, 15, 16) ? 'checked':''}}>
                                                                    <span>Tableau d'honneur + Encouragement</span>
                                                                </label>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td style="font-size: 12px; display: flex;">
                                                                <label style="display: flex; align-items: center;">
                                                                    <input type="checkbox" style="width: 15px; height: 15px; background: none; transform: scale(0.8);" {{distinction($item['resultat']->moyenne, 16, 20) ? 'checked':''}}>
                                                                    <span>Tableau d'honneur + Félicitation</span>
                                                                </label>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td style="font-size: 12px; display: flex;">
                                                                <label style="display: flex; align-items: center;">
                                                                    <input type="checkbox" style="width: 15px; height: 15px; background: none; transform: scale(0.8);">
                                                                    <span>Réfusé</span>
                                                                </label>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </td>
                                        <td>
                                            <div style="width: 230px; height: 100px; border: 1px solid">
                                                <div style="width: 100%; border-bottom: 1px solid; background: rgb(159, 159, 160); text-align: center">
                                                    <strong style="font-size: 13px">Sanctions</strong>
                                                </div>
                                                <table>
                                                    <tbody>
                                                        <tr style=" width:100%">
                                                            <td style="font-size: 12px; width:100%">
                                                                <label style="display: flex; align-items: center;">
                                                                    <input type="checkbox" style="width: 15px; height: 15px; background: none; transform: scale(0.8);">
                                                                    <span>Avertissement pour travail insuffisant</span>
                                                                </label>
                                                            </td>
                                                        </tr>
                                                        <tr style=" width:100%">
                                                            <td style="font-size: 12px; width:100%">
                                                                <label style="display: flex; align-items: center;">
                                                                    <input type="checkbox" style="width: 15px; height: 15px; background: none; transform: scale(0.8);">
                                                                    <span>Blâme pour travail insuffisant</span>
                                                                </label>
                                                            </td>
                                                        </tr>
                                                        <tr style=" width:100%">
                                                            <td  style="font-size: 12px; width:100%">
                                                                <label style="display: flex; align-items: center;">
                                                                    <input type="checkbox" style="width: 15px; height: 15px; background: none; transform: scale(0.8);">
                                                                    <span>Avertissement pour mauvaise conduite</span>
                                                                </label>
                                                            </td>
                                                        </tr>
                                                        <tr style=" width:100%">
                                                            <td style="font-size: 12px; width:100%">
                                                                <label style="display: flex; align-items: center;">
                                                                    <input type="checkbox" style="width: 15px; height: 15px; background: none; transform: scale(0.8);">
                                                                    <span>Blâme pour mauvaise conduite</span>
                                                                </label>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>

                        <div>
                            <table style="margin: auto">
                                <tbody>
                                    <tr>
                                        <td>
                                            <div style="width: 230px; height: 100px; border: 1px solid;">
                                                <div style="width: 100%; border-bottom: 1px solid; background: rgb(159, 159, 160); text-align: center">
                                                    <strong style="font-size: 13px">Rappel</strong>
                                                </div>
                                                <div style="margin: 0; padding-top: 10px">
                                                  <p style="margin: 7px; font-size: 13px">
                                                    @if ($item['trim1'])
                                                      {{ $item['libelle'] }} 1 : <strong>{{ $item['trim1']->moyenne }}</strong>
                                                      Rang : <strong>{{ $item['trim1']->rang.' / '.($item['student']->classe->inscrits <= 9 ? '0'.$item['student']->classe->inscrits:$item['student']->classe->inscrits) }}</strong>
                                                    @endif
                                                  </p>
                                                  <p style="margin: 7px; font-size: 13px">
                                                    @if ($item['trim2'])
                                                      {{ $item['libelle'] }} 2 : <strong>{{ $item['trim2']->moyenne }}</strong>
                                                      Rang : <strong>{{ $item['trim2']->rang.' / '.($item['student']->classe->inscrits <= 9 ? '0'.$item['student']->classe->inscrits:$item['student']->classe->inscrits) }}</strong>
                                                    @endif
                                                  </p>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <div style="width: 230px; height: 100px; border: 1px solid">
                                                <div style="width: 100%; border-bottom: 1px solid; background: rgb(159, 159, 160); text-align: center; margin-bottom: 5px">
                                                    <strong style="font-size: 13px">Appréciation du conseil de classe</strong>
                                                </div>
                                                <p style="text-align: center; margin:0%; font-size: 13px">
                                                    <i><b>{{$item['student']->classe->type == 'technique' ? appreciationTechnique($item['resultat']->moyenne):appreciationGeneral($item['resultat']->moyenne)}}</b></i>
                                                </p>
                                                <p style="text-align: center;margin-top:0%; margin-bottom: 10px; font-size: 13px">Professeur Principal</p>
                                                <p style="text-align: center; margin-top: 20px; margin-bottom: 0%; font-size: 13px">{{$item['profs']}}</p>
                                            </div>
                                        </td>
                                        <td>
                                            <div style="width: 230px; height: 100px; border: 1px solid">
                                                <div style="width: 100%; border-bottom: 1px solid; background: rgb(159, 159, 160); text-align: center; margin-bottom: 5px">
                                                    <strong style="font-size: 13px">Visa du Chef d'Etablissement</strong>
                                                </div>
                                                <p style="text-align: center; margin:0%; font-size: 13px">{{ucfirst($item['school']->school_city)}}, le <strong>{{date('d/m/Y', strtotime($item['result_classe']->created_at))}}</strong></p>
                                                <p style="text-align: center;margin-top:0%; margin-bottom: 10px; font-size: 13px">Directeur des Etudes</p>
                                                <p style="text-align: center; margin-top: 20px; margin-bottom: 0%; font-size: 13px">{{$item['directeur']}}</p>
                                            </div>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>

                    </body>
                </section>
            </section>


            <!-- Footer -->
            <footer>
                <i style="text-align: right; float:left; font-size: 10px; margin:0%">{{$item['school']->school->name_school}}</i>
                <i style="text-align: center;font-size: 10px; margin:0%">{{$item['school']->address_email.' | '. $item['school']->phon_school}}</i>
                <i style="text-align: right; float:right; font-size: 10px; margin:0%">Imprimé le {{date('Y-m-d H:i:s')}}</i>
            </footer>
        </div>
        {{-- @endif --}}
    @endforeach
</body>
</html>