@extends('app')
@section('title', 'Add teacher')
@section('link')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" />
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" />
<style>
    .blink {
        color: red !important;
        font-size: 15px;
        animation: blinker 1.5s linear infinite;
    }
    @keyframes blinker {  
      50% { opacity: 0; }
    }
    .form-filed{
        background-color: red !important; 
    }
</style>
@endsection
@section('content')
<div class="pcoded-inner-content">
    @include('includes._alert')
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header mb-0 pb-0">
                                <div class="d-flex justify-content-between pb-2">
                                    <h4 class="m-0">Ajout d'Enseignant</h4>
                                    <h4 class="m-0"><strong>{{$classe['libelle']}}</strong></h4>
                                    <div class="right">
                                        <span style="float: right">
                                            <a href="{{route('time.index',$classe->id.'_'.$string)}}" class="btn btn-inverse btn-outline-inverse  btn-sm py-1" title="Return Back"><i class="fas fa-reply m-0"></i></a>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <hr class="mx-3 my-0">
                            <form action="{{route('time.add_store')}}" method="post">
                                @csrf
                                <div class="card-block mt-3" style="width: 100%; margin: 1px auto">
                                    @if (!(count($matter) && count($profs)))
                                        <div class="text-center my-3">
                                            <strong class="blink">Configuration Incomplète ...</strong>
                                        </div>
                                    @endif
                                    <div class="dt-responsive table-responsive">
                                        <table id="autofill" class="table table-bordered" style="line-height: 0%">
                                            <thead>
                                                <tr>
                                                    <th class="text-center py-4" style="width: 10%">N°</th>
                                                    <th class="text-center py-4" style="width: 30%">Dsicpline</th>
                                                    <th class="text-center py-4" style="width: 30%">Enseignant</th>
                                                    <th class="text-center py-4" style="width: 10%" title="Professeur Principal">PP</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @if (count($matter) && count($profs))
                                                @php $i = 1; @endphp
                                                @foreach ($matter as $item)
                                                <tr title="{{$item->libelle}}">
                                                    <th class="text-center  pt-4">{{$i <= 9 ? '0'.$i++:$i++}}</th>
                                                    <td class="text-left pt-4" title="{{$item->libelle}}">
                                                        <span class="mx-3">{{ucfirst($item->abbreviated ?? $item->libelle)}}</span>
                                                        <input type="hidden" name="matter[]" value="{{$item->id}}">
                                                    </td>
                                                    <td class="p-0">
                                                        <select name="profs[]" class="form-filed w-100" style="border: none">
                                                            <option value="">Select Teacher</option>
                                                            @foreach ($profs as $prof)
                                                            <option value="{{$prof->id}}" {{verifyteacherClass($exists,$item->id, $prof->id) ? 'selected':null}}>{{($prof->sexe == "F" ? 'Mde. ':'Mr. ').strtoupper($prof->first_name).' '.ucwords($prof->last_name)}}</option>
                                                            @endforeach
                                                        </select>   
                                                    </td>
                                                    <td class="text-center">
                                                        <input type="radio" name="pp" value="{{$i-1}}" {{verifyteacherClass($exists,$item->id, $prof->id, 1) ? 'checked':null}}>
                                                    </td>
                                                </tr>
                                                @endforeach
                                                @else
                                                    <tr>
                                                        <td colspan="5" class="py-4 text-center">
                                                            <strong style="font-size: 14px">Veuillez faire une bonne configuration.</strong>
                                                        </td>
                                                    </tr>
                                                @endif
                                            </tbody>
                                        </table>
                                    </div>
                                    <input type="hidden" name="class" value="{{$classe['id']}}">
                                    <input type="hidden" name="infoClass" value="{{$classe->id.'_'.$string}}">
                                    <div class="row text-center">
                                        <div class="col-sm-12 invoice-btn-group text-center my-3">
                                            <button type="submit" class="btn btn-inverse btn-outline-inverse py-1" {{(count($matter) && count($profs)) ? null:'disabled' }}> <i class="fas fa-check-circle" ></i> Valider les informations</button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script src="{{asset('assets/js/pcoded.min.js')}}"></script>
<script src="{{asset('assets/js/vartical-layout.min.js')}}"></script>
<script src="{{asset('assets/js/jquery.mCustomScrollbar.concat.min.js')}}"></script>
    <script>
        $(document).ready(function(){
            $('.form-filed').select2({
                theme: 'bootstrap-5'
            });
        })
    </script>
@endsection